<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/cx/v3/agent.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\Cx\V3\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\Cx\V3\Agent;
use Google\Cloud\Dialogflow\Cx\V3\AgentValidationResult;
use Google\Cloud\Dialogflow\Cx\V3\CreateAgentRequest;
use Google\Cloud\Dialogflow\Cx\V3\DeleteAgentRequest;
use Google\Cloud\Dialogflow\Cx\V3\ExportAgentRequest;
use Google\Cloud\Dialogflow\Cx\V3\ExportAgentResponse;
use Google\Cloud\Dialogflow\Cx\V3\GenerativeSettings;
use Google\Cloud\Dialogflow\Cx\V3\GetAgentRequest;
use Google\Cloud\Dialogflow\Cx\V3\GetAgentValidationResultRequest;
use Google\Cloud\Dialogflow\Cx\V3\GetGenerativeSettingsRequest;
use Google\Cloud\Dialogflow\Cx\V3\ListAgentsRequest;
use Google\Cloud\Dialogflow\Cx\V3\RestoreAgentRequest;
use Google\Cloud\Dialogflow\Cx\V3\UpdateAgentRequest;
use Google\Cloud\Dialogflow\Cx\V3\UpdateGenerativeSettingsRequest;
use Google\Cloud\Dialogflow\Cx\V3\ValidateAgentRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use Google\Protobuf\Struct;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service for managing [Agents][google.cloud.dialogflow.cx.v3.Agent].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Agent> createAgentAsync(CreateAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAgentAsync(DeleteAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportAgentAsync(ExportAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Agent> getAgentAsync(GetAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AgentValidationResult> getAgentValidationResultAsync(GetAgentValidationResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GenerativeSettings> getGenerativeSettingsAsync(GetGenerativeSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAgentsAsync(ListAgentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> restoreAgentAsync(RestoreAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Agent> updateAgentAsync(UpdateAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GenerativeSettings> updateGenerativeSettingsAsync(UpdateGenerativeSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AgentValidationResult> validateAgentAsync(ValidateAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class AgentsClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dialogflow.cx.v3.Agents';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dialogflow.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/agents_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/agents_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/agents_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/agents_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     *
     * @return string The formatted agent resource.
     */
    public static function agentName(string $project, string $location, string $agent): string
    {
        return self::getPathTemplate('agent')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * agent_generative_settings resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     *
     * @return string The formatted agent_generative_settings resource.
     */
    public static function agentGenerativeSettingsName(string $project, string $location, string $agent): string
    {
        return self::getPathTemplate('agentGenerativeSettings')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * agent_validation_result resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     *
     * @return string The formatted agent_validation_result resource.
     */
    public static function agentValidationResultName(string $project, string $location, string $agent): string
    {
        return self::getPathTemplate('agentValidationResult')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a environment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $environment
     *
     * @return string The formatted environment resource.
     */
    public static function environmentName(
        string $project,
        string $location,
        string $agent,
        string $environment
    ): string {
        return self::getPathTemplate('environment')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'environment' => $environment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a flow
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     *
     * @return string The formatted flow resource.
     */
    public static function flowName(string $project, string $location, string $agent, string $flow): string
    {
        return self::getPathTemplate('flow')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $version
     *
     * @return string The formatted secret_version resource.
     */
    public static function secretVersionName(string $project, string $secret, string $version): string
    {
        return self::getPathTemplate('secretVersion')->render([
            'project' => $project,
            'secret' => $secret,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_settings resource.
     *
     * @param string $project
     * @param string $location
     * @param string $securitySettings
     *
     * @return string The formatted security_settings resource.
     */
    public static function securitySettingsName(string $project, string $location, string $securitySettings): string
    {
        return self::getPathTemplate('securitySettings')->render([
            'project' => $project,
            'location' => $location,
            'security_settings' => $securitySettings,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/locations/{location}/agents/{agent}
     * - agentGenerativeSettings: projects/{project}/locations/{location}/agents/{agent}/generativeSettings
     * - agentValidationResult: projects/{project}/locations/{location}/agents/{agent}/validationResult
     * - environment: projects/{project}/locations/{location}/agents/{agent}/environments/{environment}
     * - flow: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}
     * - location: projects/{project}/locations/{location}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{version}
     * - securitySettings: projects/{project}/locations/{location}/securitySettings/{security_settings}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an agent in the specified location.
     *
     * Note: You should always train flows prior to sending them queries. See the
     * [training
     * documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
     *
     * The async variant is {@see AgentsClient::createAgentAsync()} .
     *
     * @example samples/V3/AgentsClient/create_agent.php
     *
     * @param CreateAgentRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Agent
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAgent(CreateAgentRequest $request, array $callOptions = []): Agent
    {
        return $this->startApiCall('CreateAgent', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified agent.
     *
     * The async variant is {@see AgentsClient::deleteAgentAsync()} .
     *
     * @example samples/V3/AgentsClient/delete_agent.php
     *
     * @param DeleteAgentRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAgent(DeleteAgentRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAgent', $request, $callOptions)->wait();
    }

    /**
     * Exports the specified agent to a binary file.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: An empty [Struct
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
     * - `response`:
     * [ExportAgentResponse][google.cloud.dialogflow.cx.v3.ExportAgentResponse]
     *
     * The async variant is {@see AgentsClient::exportAgentAsync()} .
     *
     * @example samples/V3/AgentsClient/export_agent.php
     *
     * @param ExportAgentRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportAgent(ExportAgentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportAgent', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the specified agent.
     *
     * The async variant is {@see AgentsClient::getAgentAsync()} .
     *
     * @example samples/V3/AgentsClient/get_agent.php
     *
     * @param GetAgentRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Agent
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAgent(GetAgentRequest $request, array $callOptions = []): Agent
    {
        return $this->startApiCall('GetAgent', $request, $callOptions)->wait();
    }

    /**
     * Gets the latest agent validation result. Agent validation is performed
     * when ValidateAgent is called.
     *
     * The async variant is {@see AgentsClient::getAgentValidationResultAsync()} .
     *
     * @example samples/V3/AgentsClient/get_agent_validation_result.php
     *
     * @param GetAgentValidationResultRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AgentValidationResult
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAgentValidationResult(
        GetAgentValidationResultRequest $request,
        array $callOptions = []
    ): AgentValidationResult {
        return $this->startApiCall('GetAgentValidationResult', $request, $callOptions)->wait();
    }

    /**
     * Gets the generative settings for the agent.
     *
     * The async variant is {@see AgentsClient::getGenerativeSettingsAsync()} .
     *
     * @example samples/V3/AgentsClient/get_generative_settings.php
     *
     * @param GetGenerativeSettingsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerativeSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGenerativeSettings(
        GetGenerativeSettingsRequest $request,
        array $callOptions = []
    ): GenerativeSettings {
        return $this->startApiCall('GetGenerativeSettings', $request, $callOptions)->wait();
    }

    /**
     * Returns the list of all agents in the specified location.
     *
     * The async variant is {@see AgentsClient::listAgentsAsync()} .
     *
     * @example samples/V3/AgentsClient/list_agents.php
     *
     * @param ListAgentsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAgents(ListAgentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAgents', $request, $callOptions);
    }

    /**
     * Restores the specified agent from a binary file.
     *
     * Replaces the current agent with a new one. Note that all existing resources
     * in agent (e.g. intents, entity types, flows) will be removed.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: An empty [Struct
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
     * - `response`: An [Empty
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
     *
     * Note: You should always train flows prior to sending them queries. See the
     * [training
     * documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
     *
     * The async variant is {@see AgentsClient::restoreAgentAsync()} .
     *
     * @example samples/V3/AgentsClient/restore_agent.php
     *
     * @param RestoreAgentRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreAgent(RestoreAgentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreAgent', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified agent.
     *
     * Note: You should always train flows prior to sending them queries. See the
     * [training
     * documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
     *
     * The async variant is {@see AgentsClient::updateAgentAsync()} .
     *
     * @example samples/V3/AgentsClient/update_agent.php
     *
     * @param UpdateAgentRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Agent
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAgent(UpdateAgentRequest $request, array $callOptions = []): Agent
    {
        return $this->startApiCall('UpdateAgent', $request, $callOptions)->wait();
    }

    /**
     * Updates the generative settings for the agent.
     *
     * The async variant is {@see AgentsClient::updateGenerativeSettingsAsync()} .
     *
     * @example samples/V3/AgentsClient/update_generative_settings.php
     *
     * @param UpdateGenerativeSettingsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerativeSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGenerativeSettings(
        UpdateGenerativeSettingsRequest $request,
        array $callOptions = []
    ): GenerativeSettings {
        return $this->startApiCall('UpdateGenerativeSettings', $request, $callOptions)->wait();
    }

    /**
     * Validates the specified agent and creates or updates validation results.
     * The agent in draft version is validated. Please call this API after the
     * training is completed to get the complete validation results.
     *
     * The async variant is {@see AgentsClient::validateAgentAsync()} .
     *
     * @example samples/V3/AgentsClient/validate_agent.php
     *
     * @param ValidateAgentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AgentValidationResult
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function validateAgent(ValidateAgentRequest $request, array $callOptions = []): AgentValidationResult
    {
        return $this->startApiCall('ValidateAgent', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see AgentsClient::getLocationAsync()} .
     *
     * @example samples/V3/AgentsClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see AgentsClient::listLocationsAsync()} .
     *
     * @example samples/V3/AgentsClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
