<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/notebook_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\AssignNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\CreateNotebookExecutionJobRequest;
use Google\Cloud\AIPlatform\V1\CreateNotebookRuntimeTemplateRequest;
use Google\Cloud\AIPlatform\V1\DeleteNotebookExecutionJobRequest;
use Google\Cloud\AIPlatform\V1\DeleteNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\DeleteNotebookRuntimeTemplateRequest;
use Google\Cloud\AIPlatform\V1\GetNotebookExecutionJobRequest;
use Google\Cloud\AIPlatform\V1\GetNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\GetNotebookRuntimeTemplateRequest;
use Google\Cloud\AIPlatform\V1\ListNotebookExecutionJobsRequest;
use Google\Cloud\AIPlatform\V1\ListNotebookRuntimeTemplatesRequest;
use Google\Cloud\AIPlatform\V1\ListNotebookRuntimesRequest;
use Google\Cloud\AIPlatform\V1\NotebookExecutionJob;
use Google\Cloud\AIPlatform\V1\NotebookRuntime;
use Google\Cloud\AIPlatform\V1\NotebookRuntimeTemplate;
use Google\Cloud\AIPlatform\V1\StartNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\StopNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\UpdateNotebookRuntimeTemplateRequest;
use Google\Cloud\AIPlatform\V1\UpgradeNotebookRuntimeRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The interface for Vertex Notebook service (a.k.a. Colab on Workbench).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> assignNotebookRuntimeAsync(AssignNotebookRuntimeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createNotebookExecutionJobAsync(CreateNotebookExecutionJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createNotebookRuntimeTemplateAsync(CreateNotebookRuntimeTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteNotebookExecutionJobAsync(DeleteNotebookExecutionJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteNotebookRuntimeAsync(DeleteNotebookRuntimeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteNotebookRuntimeTemplateAsync(DeleteNotebookRuntimeTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NotebookExecutionJob> getNotebookExecutionJobAsync(GetNotebookExecutionJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NotebookRuntime> getNotebookRuntimeAsync(GetNotebookRuntimeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NotebookRuntimeTemplate> getNotebookRuntimeTemplateAsync(GetNotebookRuntimeTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listNotebookExecutionJobsAsync(ListNotebookExecutionJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listNotebookRuntimeTemplatesAsync(ListNotebookRuntimeTemplatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listNotebookRuntimesAsync(ListNotebookRuntimesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> startNotebookRuntimeAsync(StartNotebookRuntimeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> stopNotebookRuntimeAsync(StopNotebookRuntimeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NotebookRuntimeTemplate> updateNotebookRuntimeTemplateAsync(UpdateNotebookRuntimeTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> upgradeNotebookRuntimeAsync(UpgradeNotebookRuntimeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class NotebookServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.aiplatform.v1.NotebookService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'aiplatform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/notebook_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/notebook_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/notebook_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/notebook_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notebook_execution_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $notebookExecutionJob
     *
     * @return string The formatted notebook_execution_job resource.
     */
    public static function notebookExecutionJobName(
        string $project,
        string $location,
        string $notebookExecutionJob
    ): string {
        return self::getPathTemplate('notebookExecutionJob')->render([
            'project' => $project,
            'location' => $location,
            'notebook_execution_job' => $notebookExecutionJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notebook_runtime resource.
     *
     * @param string $project
     * @param string $location
     * @param string $notebookRuntime
     *
     * @return string The formatted notebook_runtime resource.
     */
    public static function notebookRuntimeName(string $project, string $location, string $notebookRuntime): string
    {
        return self::getPathTemplate('notebookRuntime')->render([
            'project' => $project,
            'location' => $location,
            'notebook_runtime' => $notebookRuntime,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notebook_runtime_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $notebookRuntimeTemplate
     *
     * @return string The formatted notebook_runtime_template resource.
     */
    public static function notebookRuntimeTemplateName(
        string $project,
        string $location,
        string $notebookRuntimeTemplate
    ): string {
        return self::getPathTemplate('notebookRuntimeTemplate')->render([
            'project' => $project,
            'location' => $location,
            'notebook_runtime_template' => $notebookRuntimeTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a reservation
     * resource.
     *
     * @param string $projectIdOrNumber
     * @param string $zone
     * @param string $reservationName
     *
     * @return string The formatted reservation resource.
     */
    public static function reservationName(string $projectIdOrNumber, string $zone, string $reservationName): string
    {
        return self::getPathTemplate('reservation')->render([
            'project_id_or_number' => $projectIdOrNumber,
            'zone' => $zone,
            'reservation_name' => $reservationName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a schedule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schedule
     *
     * @return string The formatted schedule resource.
     */
    public static function scheduleName(string $project, string $location, string $schedule): string
    {
        return self::getPathTemplate('schedule')->render([
            'project' => $project,
            'location' => $location,
            'schedule' => $schedule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subnetwork
     * resource.
     *
     * @param string $project
     * @param string $region
     * @param string $subnetwork
     *
     * @return string The formatted subnetwork resource.
     */
    public static function subnetworkName(string $project, string $region, string $subnetwork): string
    {
        return self::getPathTemplate('subnetwork')->render([
            'project' => $project,
            'region' => $region,
            'subnetwork' => $subnetwork,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{network}
     * - notebookExecutionJob: projects/{project}/locations/{location}/notebookExecutionJobs/{notebook_execution_job}
     * - notebookRuntime: projects/{project}/locations/{location}/notebookRuntimes/{notebook_runtime}
     * - notebookRuntimeTemplate: projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}
     * - reservation: projects/{project_id_or_number}/zones/{zone}/reservations/{reservation_name}
     * - schedule: projects/{project}/locations/{location}/schedules/{schedule}
     * - subnetwork: projects/{project}/regions/{region}/subnetworks/{subnetwork}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Assigns a NotebookRuntime to a user for a particular Notebook file. This
     * method will either returns an existing assignment or generates a new one.
     *
     * The async variant is {@see NotebookServiceClient::assignNotebookRuntimeAsync()}
     * .
     *
     * @example samples/V1/NotebookServiceClient/assign_notebook_runtime.php
     *
     * @param AssignNotebookRuntimeRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function assignNotebookRuntime(
        AssignNotebookRuntimeRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('AssignNotebookRuntime', $request, $callOptions)->wait();
    }

    /**
     * Creates a NotebookExecutionJob.
     *
     * The async variant is
     * {@see NotebookServiceClient::createNotebookExecutionJobAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/create_notebook_execution_job.php
     *
     * @param CreateNotebookExecutionJobRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNotebookExecutionJob(
        CreateNotebookExecutionJobRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateNotebookExecutionJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a NotebookRuntimeTemplate.
     *
     * The async variant is
     * {@see NotebookServiceClient::createNotebookRuntimeTemplateAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/create_notebook_runtime_template.php
     *
     * @param CreateNotebookRuntimeTemplateRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNotebookRuntimeTemplate(
        CreateNotebookRuntimeTemplateRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateNotebookRuntimeTemplate', $request, $callOptions)->wait();
    }

    /**
     * Deletes a NotebookExecutionJob.
     *
     * The async variant is
     * {@see NotebookServiceClient::deleteNotebookExecutionJobAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/delete_notebook_execution_job.php
     *
     * @param DeleteNotebookExecutionJobRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNotebookExecutionJob(
        DeleteNotebookExecutionJobRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteNotebookExecutionJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a NotebookRuntime.
     *
     * The async variant is {@see NotebookServiceClient::deleteNotebookRuntimeAsync()}
     * .
     *
     * @example samples/V1/NotebookServiceClient/delete_notebook_runtime.php
     *
     * @param DeleteNotebookRuntimeRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNotebookRuntime(
        DeleteNotebookRuntimeRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteNotebookRuntime', $request, $callOptions)->wait();
    }

    /**
     * Deletes a NotebookRuntimeTemplate.
     *
     * The async variant is
     * {@see NotebookServiceClient::deleteNotebookRuntimeTemplateAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/delete_notebook_runtime_template.php
     *
     * @param DeleteNotebookRuntimeTemplateRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNotebookRuntimeTemplate(
        DeleteNotebookRuntimeTemplateRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteNotebookRuntimeTemplate', $request, $callOptions)->wait();
    }

    /**
     * Gets a NotebookExecutionJob.
     *
     * The async variant is
     * {@see NotebookServiceClient::getNotebookExecutionJobAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_notebook_execution_job.php
     *
     * @param GetNotebookExecutionJobRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotebookExecutionJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNotebookExecutionJob(
        GetNotebookExecutionJobRequest $request,
        array $callOptions = []
    ): NotebookExecutionJob {
        return $this->startApiCall('GetNotebookExecutionJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a NotebookRuntime.
     *
     * The async variant is {@see NotebookServiceClient::getNotebookRuntimeAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_notebook_runtime.php
     *
     * @param GetNotebookRuntimeRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotebookRuntime
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNotebookRuntime(GetNotebookRuntimeRequest $request, array $callOptions = []): NotebookRuntime
    {
        return $this->startApiCall('GetNotebookRuntime', $request, $callOptions)->wait();
    }

    /**
     * Gets a NotebookRuntimeTemplate.
     *
     * The async variant is
     * {@see NotebookServiceClient::getNotebookRuntimeTemplateAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_notebook_runtime_template.php
     *
     * @param GetNotebookRuntimeTemplateRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotebookRuntimeTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNotebookRuntimeTemplate(
        GetNotebookRuntimeTemplateRequest $request,
        array $callOptions = []
    ): NotebookRuntimeTemplate {
        return $this->startApiCall('GetNotebookRuntimeTemplate', $request, $callOptions)->wait();
    }

    /**
     * Lists NotebookExecutionJobs in a Location.
     *
     * The async variant is
     * {@see NotebookServiceClient::listNotebookExecutionJobsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_notebook_execution_jobs.php
     *
     * @param ListNotebookExecutionJobsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNotebookExecutionJobs(
        ListNotebookExecutionJobsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListNotebookExecutionJobs', $request, $callOptions);
    }

    /**
     * Lists NotebookRuntimeTemplates in a Location.
     *
     * The async variant is
     * {@see NotebookServiceClient::listNotebookRuntimeTemplatesAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_notebook_runtime_templates.php
     *
     * @param ListNotebookRuntimeTemplatesRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNotebookRuntimeTemplates(
        ListNotebookRuntimeTemplatesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListNotebookRuntimeTemplates', $request, $callOptions);
    }

    /**
     * Lists NotebookRuntimes in a Location.
     *
     * The async variant is {@see NotebookServiceClient::listNotebookRuntimesAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_notebook_runtimes.php
     *
     * @param ListNotebookRuntimesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNotebookRuntimes(
        ListNotebookRuntimesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListNotebookRuntimes', $request, $callOptions);
    }

    /**
     * Starts a NotebookRuntime.
     *
     * The async variant is {@see NotebookServiceClient::startNotebookRuntimeAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/start_notebook_runtime.php
     *
     * @param StartNotebookRuntimeRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startNotebookRuntime(
        StartNotebookRuntimeRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('StartNotebookRuntime', $request, $callOptions)->wait();
    }

    /**
     * Stops a NotebookRuntime.
     *
     * The async variant is {@see NotebookServiceClient::stopNotebookRuntimeAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/stop_notebook_runtime.php
     *
     * @param StopNotebookRuntimeRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopNotebookRuntime(StopNotebookRuntimeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StopNotebookRuntime', $request, $callOptions)->wait();
    }

    /**
     * Updates a NotebookRuntimeTemplate.
     *
     * The async variant is
     * {@see NotebookServiceClient::updateNotebookRuntimeTemplateAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/update_notebook_runtime_template.php
     *
     * @param UpdateNotebookRuntimeTemplateRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotebookRuntimeTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNotebookRuntimeTemplate(
        UpdateNotebookRuntimeTemplateRequest $request,
        array $callOptions = []
    ): NotebookRuntimeTemplate {
        return $this->startApiCall('UpdateNotebookRuntimeTemplate', $request, $callOptions)->wait();
    }

    /**
     * Upgrades a NotebookRuntime.
     *
     * The async variant is {@see NotebookServiceClient::upgradeNotebookRuntimeAsync()}
     * .
     *
     * @example samples/V1/NotebookServiceClient/upgrade_notebook_runtime.php
     *
     * @param UpgradeNotebookRuntimeRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function upgradeNotebookRuntime(
        UpgradeNotebookRuntimeRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpgradeNotebookRuntime', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see NotebookServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see NotebookServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see NotebookServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see NotebookServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see NotebookServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
