<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v2/kernel_rootkit.proto

namespace Google\Cloud\SecurityCenter\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Kernel mode rootkit signatures.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v2.KernelRootkit</code>
 */
class KernelRootkit extends \Google\Protobuf\Internal\Message
{
    /**
     * Rootkit name, when available.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * True if unexpected modifications of kernel code memory are present.
     *
     * Generated from protobuf field <code>bool unexpected_code_modification = 2;</code>
     */
    private $unexpected_code_modification = false;
    /**
     * True if unexpected modifications of kernel read-only data memory are
     * present.
     *
     * Generated from protobuf field <code>bool unexpected_read_only_data_modification = 3;</code>
     */
    private $unexpected_read_only_data_modification = false;
    /**
     * True if `ftrace` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     *
     * Generated from protobuf field <code>bool unexpected_ftrace_handler = 4;</code>
     */
    private $unexpected_ftrace_handler = false;
    /**
     * True if `kprobe` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     *
     * Generated from protobuf field <code>bool unexpected_kprobe_handler = 5;</code>
     */
    private $unexpected_kprobe_handler = false;
    /**
     * True if kernel code pages that are not in the expected kernel or module
     * code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_kernel_code_pages = 6;</code>
     */
    private $unexpected_kernel_code_pages = false;
    /**
     * True if system call handlers that are are not in the expected kernel or
     * module code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_system_call_handler = 7;</code>
     */
    private $unexpected_system_call_handler = false;
    /**
     * True if interrupt handlers that are are not in the expected kernel or
     * module code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_interrupt_handler = 8;</code>
     */
    private $unexpected_interrupt_handler = false;
    /**
     * True if unexpected processes in the scheduler run queue are present. Such
     * processes are in the run queue, but not in the process task list.
     *
     * Generated from protobuf field <code>bool unexpected_processes_in_runqueue = 9;</code>
     */
    private $unexpected_processes_in_runqueue = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Rootkit name, when available.
     *     @type bool $unexpected_code_modification
     *           True if unexpected modifications of kernel code memory are present.
     *     @type bool $unexpected_read_only_data_modification
     *           True if unexpected modifications of kernel read-only data memory are
     *           present.
     *     @type bool $unexpected_ftrace_handler
     *           True if `ftrace` points are present with callbacks pointing to regions
     *           that are not in the expected kernel or module code range.
     *     @type bool $unexpected_kprobe_handler
     *           True if `kprobe` points are present with callbacks pointing to regions
     *           that are not in the expected kernel or module code range.
     *     @type bool $unexpected_kernel_code_pages
     *           True if kernel code pages that are not in the expected kernel or module
     *           code regions are present.
     *     @type bool $unexpected_system_call_handler
     *           True if system call handlers that are are not in the expected kernel or
     *           module code regions are present.
     *     @type bool $unexpected_interrupt_handler
     *           True if interrupt handlers that are are not in the expected kernel or
     *           module code regions are present.
     *     @type bool $unexpected_processes_in_runqueue
     *           True if unexpected processes in the scheduler run queue are present. Such
     *           processes are in the run queue, but not in the process task list.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V2\KernelRootkit::initOnce();
        parent::__construct($data);
    }

    /**
     * Rootkit name, when available.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Rootkit name, when available.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * True if unexpected modifications of kernel code memory are present.
     *
     * Generated from protobuf field <code>bool unexpected_code_modification = 2;</code>
     * @return bool
     */
    public function getUnexpectedCodeModification()
    {
        return $this->unexpected_code_modification;
    }

    /**
     * True if unexpected modifications of kernel code memory are present.
     *
     * Generated from protobuf field <code>bool unexpected_code_modification = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setUnexpectedCodeModification($var)
    {
        GPBUtil::checkBool($var);
        $this->unexpected_code_modification = $var;

        return $this;
    }

    /**
     * True if unexpected modifications of kernel read-only data memory are
     * present.
     *
     * Generated from protobuf field <code>bool unexpected_read_only_data_modification = 3;</code>
     * @return bool
     */
    public function getUnexpectedReadOnlyDataModification()
    {
        return $this->unexpected_read_only_data_modification;
    }

    /**
     * True if unexpected modifications of kernel read-only data memory are
     * present.
     *
     * Generated from protobuf field <code>bool unexpected_read_only_data_modification = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setUnexpectedReadOnlyDataModification($var)
    {
        GPBUtil::checkBool($var);
        $this->unexpected_read_only_data_modification = $var;

        return $this;
    }

    /**
     * True if `ftrace` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     *
     * Generated from protobuf field <code>bool unexpected_ftrace_handler = 4;</code>
     * @return bool
     */
    public function getUnexpectedFtraceHandler()
    {
        return $this->unexpected_ftrace_handler;
    }

    /**
     * True if `ftrace` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     *
     * Generated from protobuf field <code>bool unexpected_ftrace_handler = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setUnexpectedFtraceHandler($var)
    {
        GPBUtil::checkBool($var);
        $this->unexpected_ftrace_handler = $var;

        return $this;
    }

    /**
     * True if `kprobe` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     *
     * Generated from protobuf field <code>bool unexpected_kprobe_handler = 5;</code>
     * @return bool
     */
    public function getUnexpectedKprobeHandler()
    {
        return $this->unexpected_kprobe_handler;
    }

    /**
     * True if `kprobe` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     *
     * Generated from protobuf field <code>bool unexpected_kprobe_handler = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setUnexpectedKprobeHandler($var)
    {
        GPBUtil::checkBool($var);
        $this->unexpected_kprobe_handler = $var;

        return $this;
    }

    /**
     * True if kernel code pages that are not in the expected kernel or module
     * code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_kernel_code_pages = 6;</code>
     * @return bool
     */
    public function getUnexpectedKernelCodePages()
    {
        return $this->unexpected_kernel_code_pages;
    }

    /**
     * True if kernel code pages that are not in the expected kernel or module
     * code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_kernel_code_pages = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setUnexpectedKernelCodePages($var)
    {
        GPBUtil::checkBool($var);
        $this->unexpected_kernel_code_pages = $var;

        return $this;
    }

    /**
     * True if system call handlers that are are not in the expected kernel or
     * module code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_system_call_handler = 7;</code>
     * @return bool
     */
    public function getUnexpectedSystemCallHandler()
    {
        return $this->unexpected_system_call_handler;
    }

    /**
     * True if system call handlers that are are not in the expected kernel or
     * module code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_system_call_handler = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setUnexpectedSystemCallHandler($var)
    {
        GPBUtil::checkBool($var);
        $this->unexpected_system_call_handler = $var;

        return $this;
    }

    /**
     * True if interrupt handlers that are are not in the expected kernel or
     * module code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_interrupt_handler = 8;</code>
     * @return bool
     */
    public function getUnexpectedInterruptHandler()
    {
        return $this->unexpected_interrupt_handler;
    }

    /**
     * True if interrupt handlers that are are not in the expected kernel or
     * module code regions are present.
     *
     * Generated from protobuf field <code>bool unexpected_interrupt_handler = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setUnexpectedInterruptHandler($var)
    {
        GPBUtil::checkBool($var);
        $this->unexpected_interrupt_handler = $var;

        return $this;
    }

    /**
     * True if unexpected processes in the scheduler run queue are present. Such
     * processes are in the run queue, but not in the process task list.
     *
     * Generated from protobuf field <code>bool unexpected_processes_in_runqueue = 9;</code>
     * @return bool
     */
    public function getUnexpectedProcessesInRunqueue()
    {
        return $this->unexpected_processes_in_runqueue;
    }

    /**
     * True if unexpected processes in the scheduler run queue are present. Such
     * processes are in the run queue, but not in the process task list.
     *
     * Generated from protobuf field <code>bool unexpected_processes_in_runqueue = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setUnexpectedProcessesInRunqueue($var)
    {
        GPBUtil::checkBool($var);
        $this->unexpected_processes_in_runqueue = $var;

        return $this;
    }

}

