<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/securitycenter/v1/securitycenter_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\SecurityCenter\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\SecurityCenter\V1\BatchCreateResourceValueConfigsRequest;
use Google\Cloud\SecurityCenter\V1\BatchCreateResourceValueConfigsResponse;
use Google\Cloud\SecurityCenter\V1\BigQueryExport;
use Google\Cloud\SecurityCenter\V1\BulkMuteFindingsRequest;
use Google\Cloud\SecurityCenter\V1\CreateBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\CreateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\CreateFindingRequest;
use Google\Cloud\SecurityCenter\V1\CreateMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\CreateNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\CreateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\CreateSourceRequest;
use Google\Cloud\SecurityCenter\V1\DeleteBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\DeleteEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\DeleteMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\DeleteNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\DeleteResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V1\DeleteSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\EffectiveEventThreatDetectionCustomModule;
use Google\Cloud\SecurityCenter\V1\EffectiveSecurityHealthAnalyticsCustomModule;
use Google\Cloud\SecurityCenter\V1\EventThreatDetectionCustomModule;
use Google\Cloud\SecurityCenter\V1\ExternalSystem;
use Google\Cloud\SecurityCenter\V1\Finding;
use Google\Cloud\SecurityCenter\V1\GetBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\GetEffectiveEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetEffectiveSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\GetNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\GetOrganizationSettingsRequest;
use Google\Cloud\SecurityCenter\V1\GetResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V1\GetSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetSimulationRequest;
use Google\Cloud\SecurityCenter\V1\GetSourceRequest;
use Google\Cloud\SecurityCenter\V1\GetValuedResourceRequest;
use Google\Cloud\SecurityCenter\V1\GroupAssetsRequest;
use Google\Cloud\SecurityCenter\V1\GroupFindingsRequest;
use Google\Cloud\SecurityCenter\V1\ListAssetsRequest;
use Google\Cloud\SecurityCenter\V1\ListAttackPathsRequest;
use Google\Cloud\SecurityCenter\V1\ListBigQueryExportsRequest;
use Google\Cloud\SecurityCenter\V1\ListDescendantEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListDescendantSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListEffectiveEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListEffectiveSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListFindingsRequest;
use Google\Cloud\SecurityCenter\V1\ListMuteConfigsRequest;
use Google\Cloud\SecurityCenter\V1\ListNotificationConfigsRequest;
use Google\Cloud\SecurityCenter\V1\ListResourceValueConfigsRequest;
use Google\Cloud\SecurityCenter\V1\ListSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListSourcesRequest;
use Google\Cloud\SecurityCenter\V1\ListValuedResourcesRequest;
use Google\Cloud\SecurityCenter\V1\MuteConfig;
use Google\Cloud\SecurityCenter\V1\NotificationConfig;
use Google\Cloud\SecurityCenter\V1\OrganizationSettings;
use Google\Cloud\SecurityCenter\V1\ResourceValueConfig;
use Google\Cloud\SecurityCenter\V1\RunAssetDiscoveryRequest;
use Google\Cloud\SecurityCenter\V1\SecurityHealthAnalyticsCustomModule;
use Google\Cloud\SecurityCenter\V1\SecurityMarks;
use Google\Cloud\SecurityCenter\V1\SetFindingStateRequest;
use Google\Cloud\SecurityCenter\V1\SetMuteRequest;
use Google\Cloud\SecurityCenter\V1\SimulateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\SimulateSecurityHealthAnalyticsCustomModuleResponse;
use Google\Cloud\SecurityCenter\V1\Simulation;
use Google\Cloud\SecurityCenter\V1\Source;
use Google\Cloud\SecurityCenter\V1\UpdateBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\UpdateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\UpdateExternalSystemRequest;
use Google\Cloud\SecurityCenter\V1\UpdateFindingRequest;
use Google\Cloud\SecurityCenter\V1\UpdateMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\UpdateNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\UpdateOrganizationSettingsRequest;
use Google\Cloud\SecurityCenter\V1\UpdateResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSecurityMarksRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSourceRequest;
use Google\Cloud\SecurityCenter\V1\ValidateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\ValidateEventThreatDetectionCustomModuleResponse;
use Google\Cloud\SecurityCenter\V1\ValuedResource;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: V1 APIs for Security Center service.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface batchCreateResourceValueConfigsAsync(BatchCreateResourceValueConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface bulkMuteFindingsAsync(BulkMuteFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBigQueryExportAsync(CreateBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createEventThreatDetectionCustomModuleAsync(CreateEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createFindingAsync(CreateFindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createMuteConfigAsync(CreateMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createNotificationConfigAsync(CreateNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSecurityHealthAnalyticsCustomModuleAsync(CreateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSourceAsync(CreateSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBigQueryExportAsync(DeleteBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteEventThreatDetectionCustomModuleAsync(DeleteEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteMuteConfigAsync(DeleteMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteNotificationConfigAsync(DeleteNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteResourceValueConfigAsync(DeleteResourceValueConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSecurityHealthAnalyticsCustomModuleAsync(DeleteSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBigQueryExportAsync(GetBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEffectiveEventThreatDetectionCustomModuleAsync(GetEffectiveEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEffectiveSecurityHealthAnalyticsCustomModuleAsync(GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEventThreatDetectionCustomModuleAsync(GetEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getMuteConfigAsync(GetMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNotificationConfigAsync(GetNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getOrganizationSettingsAsync(GetOrganizationSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getResourceValueConfigAsync(GetResourceValueConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSecurityHealthAnalyticsCustomModuleAsync(GetSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSimulationAsync(GetSimulationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSourceAsync(GetSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getValuedResourceAsync(GetValuedResourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface groupAssetsAsync(GroupAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface groupFindingsAsync(GroupFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAssetsAsync(ListAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAttackPathsAsync(ListAttackPathsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBigQueryExportsAsync(ListBigQueryExportsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDescendantEventThreatDetectionCustomModulesAsync(ListDescendantEventThreatDetectionCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDescendantSecurityHealthAnalyticsCustomModulesAsync(ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEffectiveEventThreatDetectionCustomModulesAsync(ListEffectiveEventThreatDetectionCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEffectiveSecurityHealthAnalyticsCustomModulesAsync(ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEventThreatDetectionCustomModulesAsync(ListEventThreatDetectionCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listFindingsAsync(ListFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMuteConfigsAsync(ListMuteConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNotificationConfigsAsync(ListNotificationConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listResourceValueConfigsAsync(ListResourceValueConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSecurityHealthAnalyticsCustomModulesAsync(ListSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSourcesAsync(ListSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listValuedResourcesAsync(ListValuedResourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface runAssetDiscoveryAsync(RunAssetDiscoveryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setFindingStateAsync(SetFindingStateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMuteAsync(SetMuteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface simulateSecurityHealthAnalyticsCustomModuleAsync(SimulateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBigQueryExportAsync(UpdateBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateEventThreatDetectionCustomModuleAsync(UpdateEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateExternalSystemAsync(UpdateExternalSystemRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateFindingAsync(UpdateFindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateMuteConfigAsync(UpdateMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateNotificationConfigAsync(UpdateNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateOrganizationSettingsAsync(UpdateOrganizationSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateResourceValueConfigAsync(UpdateResourceValueConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSecurityHealthAnalyticsCustomModuleAsync(UpdateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSecurityMarksAsync(UpdateSecurityMarksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSourceAsync(UpdateSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface validateEventThreatDetectionCustomModuleAsync(ValidateEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 */
final class SecurityCenterClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.securitycenter.v1.SecurityCenter';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'securitycenter.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'securitycenter.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/security_center_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/security_center_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/security_center_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/security_center_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * big_query_export resource.
     *
     * @param string $organization
     * @param string $export
     *
     * @return string The formatted big_query_export resource.
     */
    public static function bigQueryExportName(string $organization, string $export): string
    {
        return self::getPathTemplate('bigQueryExport')->render([
            'organization' => $organization,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dlp_job
     * resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted dlp_job resource.
     */
    public static function dlpJobName(string $project, string $dlpJob): string
    {
        return self::getPathTemplate('dlpJob')->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * effective_event_threat_detection_custom_module resource.
     *
     * @param string $organization
     * @param string $module
     *
     * @return string The formatted effective_event_threat_detection_custom_module resource.
     */
    public static function effectiveEventThreatDetectionCustomModuleName(string $organization, string $module): string
    {
        return self::getPathTemplate('effectiveEventThreatDetectionCustomModule')->render([
            'organization' => $organization,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * effective_security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $effectiveCustomModule
     *
     * @return string The formatted effective_security_health_analytics_custom_module resource.
     */
    public static function effectiveSecurityHealthAnalyticsCustomModuleName(string $organization, string $effectiveCustomModule): string
    {
        return self::getPathTemplate('effectiveSecurityHealthAnalyticsCustomModule')->render([
            'organization' => $organization,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * event_threat_detection_custom_module resource.
     *
     * @param string $organization
     * @param string $module
     *
     * @return string The formatted event_threat_detection_custom_module resource.
     */
    public static function eventThreatDetectionCustomModuleName(string $organization, string $module): string
    {
        return self::getPathTemplate('eventThreatDetectionCustomModule')->render([
            'organization' => $organization,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * event_threat_detection_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted event_threat_detection_settings resource.
     */
    public static function eventThreatDetectionSettingsName(string $organization): string
    {
        return self::getPathTemplate('eventThreatDetectionSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * external_system resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted external_system resource.
     */
    public static function externalSystemName(string $organization, string $source, string $finding, string $externalsystem): string
    {
        return self::getPathTemplate('externalSystem')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a finding
     * resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted finding resource.
     */
    public static function findingName(string $organization, string $source, string $finding): string
    {
        return self::getPathTemplate('finding')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_asset_securityMarks resource.
     *
     * @param string $folder
     * @param string $asset
     *
     * @return string The formatted folder_asset_securityMarks resource.
     */
    public static function folderAssetSecurityMarksName(string $folder, string $asset): string
    {
        return self::getPathTemplate('folderAssetSecurityMarks')->render([
            'folder' => $folder,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_constraint_name resource.
     *
     * @param string $folder
     * @param string $constraintName
     *
     * @return string The formatted folder_constraint_name resource.
     */
    public static function folderConstraintNameName(string $folder, string $constraintName): string
    {
        return self::getPathTemplate('folderConstraintName')->render([
            'folder' => $folder,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_custom_module resource.
     *
     * @param string $folder
     * @param string $customModule
     *
     * @return string The formatted folder_custom_module resource.
     */
    public static function folderCustomModuleName(string $folder, string $customModule): string
    {
        return self::getPathTemplate('folderCustomModule')->render([
            'folder' => $folder,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_effective_custom_module resource.
     *
     * @param string $folder
     * @param string $effectiveCustomModule
     *
     * @return string The formatted folder_effective_custom_module resource.
     */
    public static function folderEffectiveCustomModuleName(string $folder, string $effectiveCustomModule): string
    {
        return self::getPathTemplate('folderEffectiveCustomModule')->render([
            'folder' => $folder,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_eventThreatDetectionSettings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_eventThreatDetectionSettings resource.
     */
    public static function folderEventThreatDetectionSettingsName(string $folder): string
    {
        return self::getPathTemplate('folderEventThreatDetectionSettings')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_export resource.
     *
     * @param string $folder
     * @param string $export
     *
     * @return string The formatted folder_export resource.
     */
    public static function folderExportName(string $folder, string $export): string
    {
        return self::getPathTemplate('folderExport')->render([
            'folder' => $folder,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName(string $folder, string $location): string
    {
        return self::getPathTemplate('folderLocation')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_mute_config resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted folder_location_mute_config resource.
     */
    public static function folderLocationMuteConfigName(string $folder, string $location, string $muteConfig): string
    {
        return self::getPathTemplate('folderLocationMuteConfig')->render([
            'folder' => $folder,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_module resource.
     *
     * @param string $folder
     * @param string $module
     *
     * @return string The formatted folder_module resource.
     */
    public static function folderModuleName(string $folder, string $module): string
    {
        return self::getPathTemplate('folderModule')->render([
            'folder' => $folder,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_mute_config resource.
     *
     * @param string $folder
     * @param string $muteConfig
     *
     * @return string The formatted folder_mute_config resource.
     */
    public static function folderMuteConfigName(string $folder, string $muteConfig): string
    {
        return self::getPathTemplate('folderMuteConfig')->render([
            'folder' => $folder,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_notification_config resource.
     *
     * @param string $folder
     * @param string $notificationConfig
     *
     * @return string The formatted folder_notification_config resource.
     */
    public static function folderNotificationConfigName(string $folder, string $notificationConfig): string
    {
        return self::getPathTemplate('folderNotificationConfig')->render([
            'folder' => $folder,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_securityHealthAnalyticsSettings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_securityHealthAnalyticsSettings resource.
     */
    public static function folderSecurityHealthAnalyticsSettingsName(string $folder): string
    {
        return self::getPathTemplate('folderSecurityHealthAnalyticsSettings')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source resource.
     *
     * @param string $folder
     * @param string $source
     *
     * @return string The formatted folder_source resource.
     */
    public static function folderSourceName(string $folder, string $source): string
    {
        return self::getPathTemplate('folderSource')->render([
            'folder' => $folder,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted folder_source_finding resource.
     */
    public static function folderSourceFindingName(string $folder, string $source, string $finding): string
    {
        return self::getPathTemplate('folderSourceFinding')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding_externalsystem resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted folder_source_finding_externalsystem resource.
     */
    public static function folderSourceFindingExternalsystemName(string $folder, string $source, string $finding, string $externalsystem): string
    {
        return self::getPathTemplate('folderSourceFindingExternalsystem')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding_securityMarks resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted folder_source_finding_securityMarks resource.
     */
    public static function folderSourceFindingSecurityMarksName(string $folder, string $source, string $finding): string
    {
        return self::getPathTemplate('folderSourceFindingSecurityMarks')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a mute_config
     * resource.
     *
     * @param string $organization
     * @param string $muteConfig
     *
     * @return string The formatted mute_config resource.
     */
    public static function muteConfigName(string $organization, string $muteConfig): string
    {
        return self::getPathTemplate('muteConfig')->render([
            'organization' => $organization,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notification_config resource.
     *
     * @param string $organization
     * @param string $notificationConfig
     *
     * @return string The formatted notification_config resource.
     */
    public static function notificationConfigName(string $organization, string $notificationConfig): string
    {
        return self::getPathTemplate('notificationConfig')->render([
            'organization' => $organization,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_asset_securityMarks resource.
     *
     * @param string $organization
     * @param string $asset
     *
     * @return string The formatted organization_asset_securityMarks resource.
     */
    public static function organizationAssetSecurityMarksName(string $organization, string $asset): string
    {
        return self::getPathTemplate('organizationAssetSecurityMarks')->render([
            'organization' => $organization,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_constraint_name resource.
     *
     * @param string $organization
     * @param string $constraintName
     *
     * @return string The formatted organization_constraint_name resource.
     */
    public static function organizationConstraintNameName(string $organization, string $constraintName): string
    {
        return self::getPathTemplate('organizationConstraintName')->render([
            'organization' => $organization,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_custom_module resource.
     *
     * @param string $organization
     * @param string $customModule
     *
     * @return string The formatted organization_custom_module resource.
     */
    public static function organizationCustomModuleName(string $organization, string $customModule): string
    {
        return self::getPathTemplate('organizationCustomModule')->render([
            'organization' => $organization,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_effective_custom_module resource.
     *
     * @param string $organization
     * @param string $effectiveCustomModule
     *
     * @return string The formatted organization_effective_custom_module resource.
     */
    public static function organizationEffectiveCustomModuleName(string $organization, string $effectiveCustomModule): string
    {
        return self::getPathTemplate('organizationEffectiveCustomModule')->render([
            'organization' => $organization,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_eventThreatDetectionSettings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_eventThreatDetectionSettings resource.
     */
    public static function organizationEventThreatDetectionSettingsName(string $organization): string
    {
        return self::getPathTemplate('organizationEventThreatDetectionSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_export resource.
     *
     * @param string $organization
     * @param string $export
     *
     * @return string The formatted organization_export resource.
     */
    public static function organizationExportName(string $organization, string $export): string
    {
        return self::getPathTemplate('organizationExport')->render([
            'organization' => $organization,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_mute_config resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted organization_location_mute_config resource.
     */
    public static function organizationLocationMuteConfigName(string $organization, string $location, string $muteConfig): string
    {
        return self::getPathTemplate('organizationLocationMuteConfig')->render([
            'organization' => $organization,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_module resource.
     *
     * @param string $organization
     * @param string $module
     *
     * @return string The formatted organization_module resource.
     */
    public static function organizationModuleName(string $organization, string $module): string
    {
        return self::getPathTemplate('organizationModule')->render([
            'organization' => $organization,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_mute_config resource.
     *
     * @param string $organization
     * @param string $muteConfig
     *
     * @return string The formatted organization_mute_config resource.
     */
    public static function organizationMuteConfigName(string $organization, string $muteConfig): string
    {
        return self::getPathTemplate('organizationMuteConfig')->render([
            'organization' => $organization,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_notification_config resource.
     *
     * @param string $organization
     * @param string $notificationConfig
     *
     * @return string The formatted organization_notification_config resource.
     */
    public static function organizationNotificationConfigName(string $organization, string $notificationConfig): string
    {
        return self::getPathTemplate('organizationNotificationConfig')->render([
            'organization' => $organization,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_securityHealthAnalyticsSettings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_securityHealthAnalyticsSettings resource.
     */
    public static function organizationSecurityHealthAnalyticsSettingsName(string $organization): string
    {
        return self::getPathTemplate('organizationSecurityHealthAnalyticsSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_settings resource.
     */
    public static function organizationSettingsName(string $organization): string
    {
        return self::getPathTemplate('organizationSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source resource.
     *
     * @param string $organization
     * @param string $source
     *
     * @return string The formatted organization_source resource.
     */
    public static function organizationSourceName(string $organization, string $source): string
    {
        return self::getPathTemplate('organizationSource')->render([
            'organization' => $organization,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted organization_source_finding resource.
     */
    public static function organizationSourceFindingName(string $organization, string $source, string $finding): string
    {
        return self::getPathTemplate('organizationSourceFinding')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding_externalsystem resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted organization_source_finding_externalsystem resource.
     */
    public static function organizationSourceFindingExternalsystemName(string $organization, string $source, string $finding, string $externalsystem): string
    {
        return self::getPathTemplate('organizationSourceFindingExternalsystem')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding_securityMarks resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted organization_source_finding_securityMarks resource.
     */
    public static function organizationSourceFindingSecurityMarksName(string $organization, string $source, string $finding): string
    {
        return self::getPathTemplate('organizationSourceFindingSecurityMarks')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a policy
     * resource.
     *
     * @param string $organization
     * @param string $constraintName
     *
     * @return string The formatted policy resource.
     */
    public static function policyName(string $organization, string $constraintName): string
    {
        return self::getPathTemplate('policy')->render([
            'organization' => $organization,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_asset_securityMarks resource.
     *
     * @param string $project
     * @param string $asset
     *
     * @return string The formatted project_asset_securityMarks resource.
     */
    public static function projectAssetSecurityMarksName(string $project, string $asset): string
    {
        return self::getPathTemplate('projectAssetSecurityMarks')->render([
            'project' => $project,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_constraint_name resource.
     *
     * @param string $project
     * @param string $constraintName
     *
     * @return string The formatted project_constraint_name resource.
     */
    public static function projectConstraintNameName(string $project, string $constraintName): string
    {
        return self::getPathTemplate('projectConstraintName')->render([
            'project' => $project,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_custom_module resource.
     *
     * @param string $project
     * @param string $customModule
     *
     * @return string The formatted project_custom_module resource.
     */
    public static function projectCustomModuleName(string $project, string $customModule): string
    {
        return self::getPathTemplate('projectCustomModule')->render([
            'project' => $project,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_dlp_job resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted project_dlp_job resource.
     */
    public static function projectDlpJobName(string $project, string $dlpJob): string
    {
        return self::getPathTemplate('projectDlpJob')->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_effective_custom_module resource.
     *
     * @param string $project
     * @param string $effectiveCustomModule
     *
     * @return string The formatted project_effective_custom_module resource.
     */
    public static function projectEffectiveCustomModuleName(string $project, string $effectiveCustomModule): string
    {
        return self::getPathTemplate('projectEffectiveCustomModule')->render([
            'project' => $project,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_eventThreatDetectionSettings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_eventThreatDetectionSettings resource.
     */
    public static function projectEventThreatDetectionSettingsName(string $project): string
    {
        return self::getPathTemplate('projectEventThreatDetectionSettings')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_export resource.
     *
     * @param string $project
     * @param string $export
     *
     * @return string The formatted project_export resource.
     */
    public static function projectExportName(string $project, string $export): string
    {
        return self::getPathTemplate('projectExport')->render([
            'project' => $project,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_dlp_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dlpJob
     *
     * @return string The formatted project_location_dlp_job resource.
     */
    public static function projectLocationDlpJobName(string $project, string $location, string $dlpJob): string
    {
        return self::getPathTemplate('projectLocationDlpJob')->render([
            'project' => $project,
            'location' => $location,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_mute_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted project_location_mute_config resource.
     */
    public static function projectLocationMuteConfigName(string $project, string $location, string $muteConfig): string
    {
        return self::getPathTemplate('projectLocationMuteConfig')->render([
            'project' => $project,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_table_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tableProfile
     *
     * @return string The formatted project_location_table_profile resource.
     */
    public static function projectLocationTableProfileName(string $project, string $location, string $tableProfile): string
    {
        return self::getPathTemplate('projectLocationTableProfile')->render([
            'project' => $project,
            'location' => $location,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_module resource.
     *
     * @param string $project
     * @param string $module
     *
     * @return string The formatted project_module resource.
     */
    public static function projectModuleName(string $project, string $module): string
    {
        return self::getPathTemplate('projectModule')->render([
            'project' => $project,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_mute_config resource.
     *
     * @param string $project
     * @param string $muteConfig
     *
     * @return string The formatted project_mute_config resource.
     */
    public static function projectMuteConfigName(string $project, string $muteConfig): string
    {
        return self::getPathTemplate('projectMuteConfig')->render([
            'project' => $project,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_notification_config resource.
     *
     * @param string $project
     * @param string $notificationConfig
     *
     * @return string The formatted project_notification_config resource.
     */
    public static function projectNotificationConfigName(string $project, string $notificationConfig): string
    {
        return self::getPathTemplate('projectNotificationConfig')->render([
            'project' => $project,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_securityHealthAnalyticsSettings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_securityHealthAnalyticsSettings resource.
     */
    public static function projectSecurityHealthAnalyticsSettingsName(string $project): string
    {
        return self::getPathTemplate('projectSecurityHealthAnalyticsSettings')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source resource.
     *
     * @param string $project
     * @param string $source
     *
     * @return string The formatted project_source resource.
     */
    public static function projectSourceName(string $project, string $source): string
    {
        return self::getPathTemplate('projectSource')->render([
            'project' => $project,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted project_source_finding resource.
     */
    public static function projectSourceFindingName(string $project, string $source, string $finding): string
    {
        return self::getPathTemplate('projectSourceFinding')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding_externalsystem resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted project_source_finding_externalsystem resource.
     */
    public static function projectSourceFindingExternalsystemName(string $project, string $source, string $finding, string $externalsystem): string
    {
        return self::getPathTemplate('projectSourceFindingExternalsystem')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding_securityMarks resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted project_source_finding_securityMarks resource.
     */
    public static function projectSourceFindingSecurityMarksName(string $project, string $source, string $finding): string
    {
        return self::getPathTemplate('projectSourceFindingSecurityMarks')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_table_profile resource.
     *
     * @param string $project
     * @param string $tableProfile
     *
     * @return string The formatted project_table_profile resource.
     */
    public static function projectTableProfileName(string $project, string $tableProfile): string
    {
        return self::getPathTemplate('projectTableProfile')->render([
            'project' => $project,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * resource_value_config resource.
     *
     * @param string $organization
     * @param string $resourceValueConfig
     *
     * @return string The formatted resource_value_config resource.
     */
    public static function resourceValueConfigName(string $organization, string $resourceValueConfig): string
    {
        return self::getPathTemplate('resourceValueConfig')->render([
            'organization' => $organization,
            'resource_value_config' => $resourceValueConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $customModule
     *
     * @return string The formatted security_health_analytics_custom_module resource.
     */
    public static function securityHealthAnalyticsCustomModuleName(string $organization, string $customModule): string
    {
        return self::getPathTemplate('securityHealthAnalyticsCustomModule')->render([
            'organization' => $organization,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_health_analytics_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted security_health_analytics_settings resource.
     */
    public static function securityHealthAnalyticsSettingsName(string $organization): string
    {
        return self::getPathTemplate('securityHealthAnalyticsSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_marks resource.
     *
     * @param string $organization
     * @param string $asset
     *
     * @return string The formatted security_marks resource.
     */
    public static function securityMarksName(string $organization, string $asset): string
    {
        return self::getPathTemplate('securityMarks')->render([
            'organization' => $organization,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a simulation
     * resource.
     *
     * @param string $organization
     * @param string $simulation
     *
     * @return string The formatted simulation resource.
     */
    public static function simulationName(string $organization, string $simulation): string
    {
        return self::getPathTemplate('simulation')->render([
            'organization' => $organization,
            'simulation' => $simulation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a source
     * resource.
     *
     * @param string $organization
     * @param string $source
     *
     * @return string The formatted source resource.
     */
    public static function sourceName(string $organization, string $source): string
    {
        return self::getPathTemplate('source')->render([
            'organization' => $organization,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * table_data_profile resource.
     *
     * @param string $project
     * @param string $tableProfile
     *
     * @return string The formatted table_data_profile resource.
     */
    public static function tableDataProfileName(string $project, string $tableProfile): string
    {
        return self::getPathTemplate('tableDataProfile')->render([
            'project' => $project,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName(string $project, string $topic): string
    {
        return self::getPathTemplate('topic')->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * valued_resource resource.
     *
     * @param string $organization
     * @param string $simulation
     * @param string $valuedResource
     *
     * @return string The formatted valued_resource resource.
     */
    public static function valuedResourceName(string $organization, string $simulation, string $valuedResource): string
    {
        return self::getPathTemplate('valuedResource')->render([
            'organization' => $organization,
            'simulation' => $simulation,
            'valued_resource' => $valuedResource,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - bigQueryExport: organizations/{organization}/bigQueryExports/{export}
     * - dlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - effectiveEventThreatDetectionCustomModule: organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}
     * - effectiveSecurityHealthAnalyticsCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - eventThreatDetectionCustomModule: organizations/{organization}/eventThreatDetectionSettings/customModules/{module}
     * - eventThreatDetectionSettings: organizations/{organization}/eventThreatDetectionSettings
     * - externalSystem: organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - finding: organizations/{organization}/sources/{source}/findings/{finding}
     * - folder: folders/{folder}
     * - folderAssetSecurityMarks: folders/{folder}/assets/{asset}/securityMarks
     * - folderConstraintName: folders/{folder}/policies/{constraint_name}
     * - folderCustomModule: folders/{folder}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - folderEffectiveCustomModule: folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - folderEventThreatDetectionSettings: folders/{folder}/eventThreatDetectionSettings
     * - folderExport: folders/{folder}/bigQueryExports/{export}
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationMuteConfig: folders/{folder}/locations/{location}/muteConfigs/{mute_config}
     * - folderModule: folders/{folder}/eventThreatDetectionSettings/customModules/{module}
     * - folderMuteConfig: folders/{folder}/muteConfigs/{mute_config}
     * - folderNotificationConfig: folders/{folder}/notificationConfigs/{notification_config}
     * - folderSecurityHealthAnalyticsSettings: folders/{folder}/securityHealthAnalyticsSettings
     * - folderSource: folders/{folder}/sources/{source}
     * - folderSourceFinding: folders/{folder}/sources/{source}/findings/{finding}
     * - folderSourceFindingExternalsystem: folders/{folder}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - folderSourceFindingSecurityMarks: folders/{folder}/sources/{source}/findings/{finding}/securityMarks
     * - location: projects/{project}/locations/{location}
     * - muteConfig: organizations/{organization}/muteConfigs/{mute_config}
     * - notificationConfig: organizations/{organization}/notificationConfigs/{notification_config}
     * - organization: organizations/{organization}
     * - organizationAssetSecurityMarks: organizations/{organization}/assets/{asset}/securityMarks
     * - organizationConstraintName: organizations/{organization}/policies/{constraint_name}
     * - organizationCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - organizationEffectiveCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - organizationEventThreatDetectionSettings: organizations/{organization}/eventThreatDetectionSettings
     * - organizationExport: organizations/{organization}/bigQueryExports/{export}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationMuteConfig: organizations/{organization}/locations/{location}/muteConfigs/{mute_config}
     * - organizationModule: organizations/{organization}/eventThreatDetectionSettings/customModules/{module}
     * - organizationMuteConfig: organizations/{organization}/muteConfigs/{mute_config}
     * - organizationNotificationConfig: organizations/{organization}/notificationConfigs/{notification_config}
     * - organizationSecurityHealthAnalyticsSettings: organizations/{organization}/securityHealthAnalyticsSettings
     * - organizationSettings: organizations/{organization}/organizationSettings
     * - organizationSource: organizations/{organization}/sources/{source}
     * - organizationSourceFinding: organizations/{organization}/sources/{source}/findings/{finding}
     * - organizationSourceFindingExternalsystem: organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - organizationSourceFindingSecurityMarks: organizations/{organization}/sources/{source}/findings/{finding}/securityMarks
     * - policy: organizations/{organization}/policies/{constraint_name}
     * - project: projects/{project}
     * - projectAssetSecurityMarks: projects/{project}/assets/{asset}/securityMarks
     * - projectConstraintName: projects/{project}/policies/{constraint_name}
     * - projectCustomModule: projects/{project}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - projectDlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - projectEffectiveCustomModule: projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - projectEventThreatDetectionSettings: projects/{project}/eventThreatDetectionSettings
     * - projectExport: projects/{project}/bigQueryExports/{export}
     * - projectLocationDlpJob: projects/{project}/locations/{location}/dlpJobs/{dlp_job}
     * - projectLocationMuteConfig: projects/{project}/locations/{location}/muteConfigs/{mute_config}
     * - projectLocationTableProfile: projects/{project}/locations/{location}/tableProfiles/{table_profile}
     * - projectModule: projects/{project}/eventThreatDetectionSettings/customModules/{module}
     * - projectMuteConfig: projects/{project}/muteConfigs/{mute_config}
     * - projectNotificationConfig: projects/{project}/notificationConfigs/{notification_config}
     * - projectSecurityHealthAnalyticsSettings: projects/{project}/securityHealthAnalyticsSettings
     * - projectSource: projects/{project}/sources/{source}
     * - projectSourceFinding: projects/{project}/sources/{source}/findings/{finding}
     * - projectSourceFindingExternalsystem: projects/{project}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - projectSourceFindingSecurityMarks: projects/{project}/sources/{source}/findings/{finding}/securityMarks
     * - projectTableProfile: projects/{project}/tableProfiles/{table_profile}
     * - resourceValueConfig: organizations/{organization}/resourceValueConfigs/{resource_value_config}
     * - securityHealthAnalyticsCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - securityHealthAnalyticsSettings: organizations/{organization}/securityHealthAnalyticsSettings
     * - securityMarks: organizations/{organization}/assets/{asset}/securityMarks
     * - simulation: organizations/{organization}/simulations/{simulation}
     * - source: organizations/{organization}/sources/{source}
     * - tableDataProfile: projects/{project}/tableProfiles/{table_profile}
     * - topic: projects/{project}/topics/{topic}
     * - valuedResource: organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'securitycenter.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a ResourceValueConfig for an organization. Maps user's tags to
     * difference resource values for use by the attack path simulation.
     *
     * The async variant is
     * {@see SecurityCenterClient::batchCreateResourceValueConfigsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/batch_create_resource_value_configs.php
     *
     * @param BatchCreateResourceValueConfigsRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchCreateResourceValueConfigsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchCreateResourceValueConfigs(BatchCreateResourceValueConfigsRequest $request, array $callOptions = []): BatchCreateResourceValueConfigsResponse
    {
        return $this->startApiCall('BatchCreateResourceValueConfigs', $request, $callOptions)->wait();
    }

    /**
     * Kicks off an LRO to bulk mute findings for a parent based on a filter. The
     * parent can be either an organization, folder or project. The findings
     * matched by the filter will be muted after the LRO is done.
     *
     * The async variant is {@see SecurityCenterClient::bulkMuteFindingsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/bulk_mute_findings.php
     *
     * @param BulkMuteFindingsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function bulkMuteFindings(BulkMuteFindingsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BulkMuteFindings', $request, $callOptions)->wait();
    }

    /**
     * Creates a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::createBigQueryExportAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/create_big_query_export.php
     *
     * @param CreateBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBigQueryExport(CreateBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('CreateBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Creates a resident Event Threat Detection custom module at the scope of the
     * given Resource Manager parent, and also creates inherited custom modules
     * for all descendants of the given parent. These modules are enabled by
     * default.
     *
     * The async variant is
     * {@see SecurityCenterClient::createEventThreatDetectionCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/create_event_threat_detection_custom_module.php
     *
     * @param CreateEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventThreatDetectionCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEventThreatDetectionCustomModule(CreateEventThreatDetectionCustomModuleRequest $request, array $callOptions = []): EventThreatDetectionCustomModule
    {
        return $this->startApiCall('CreateEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Creates a finding. The corresponding source must exist for finding creation
     * to succeed.
     *
     * The async variant is {@see SecurityCenterClient::createFindingAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/create_finding.php
     *
     * @param CreateFindingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFinding(CreateFindingRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('CreateFinding', $request, $callOptions)->wait();
    }

    /**
     * Creates a mute config.
     *
     * The async variant is {@see SecurityCenterClient::createMuteConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/create_mute_config.php
     *
     * @param CreateMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMuteConfig(CreateMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('CreateMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a notification config.
     *
     * The async variant is
     * {@see SecurityCenterClient::createNotificationConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/create_notification_config.php
     *
     * @param CreateNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNotificationConfig(CreateNotificationConfigRequest $request, array $callOptions = []): NotificationConfig
    {
        return $this->startApiCall('CreateNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
     * given CRM parent, and also creates inherited
     * SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
     * parent. These modules are enabled by default.
     *
     * The async variant is
     * {@see SecurityCenterClient::createSecurityHealthAnalyticsCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/create_security_health_analytics_custom_module.php
     *
     * @param CreateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSecurityHealthAnalyticsCustomModule(CreateSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): SecurityHealthAnalyticsCustomModule
    {
        return $this->startApiCall('CreateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Creates a source.
     *
     * The async variant is {@see SecurityCenterClient::createSourceAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/create_source.php
     *
     * @param CreateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSource(CreateSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('CreateSource', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::deleteBigQueryExportAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/delete_big_query_export.php
     *
     * @param DeleteBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBigQueryExport(DeleteBigQueryExportRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified Event Threat Detection custom module and all of its
     * descendants in the Resource Manager hierarchy. This method is only
     * supported for resident custom modules.
     *
     * The async variant is
     * {@see SecurityCenterClient::deleteEventThreatDetectionCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/delete_event_threat_detection_custom_module.php
     *
     * @param DeleteEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEventThreatDetectionCustomModule(DeleteEventThreatDetectionCustomModuleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing mute config.
     *
     * The async variant is {@see SecurityCenterClient::deleteMuteConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/delete_mute_config.php
     *
     * @param DeleteMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMuteConfig(DeleteMuteConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a notification config.
     *
     * The async variant is
     * {@see SecurityCenterClient::deleteNotificationConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/delete_notification_config.php
     *
     * @param DeleteNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNotificationConfig(DeleteNotificationConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a ResourceValueConfig.
     *
     * The async variant is
     * {@see SecurityCenterClient::deleteResourceValueConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/delete_resource_value_config.php
     *
     * @param DeleteResourceValueConfigRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteResourceValueConfig(DeleteResourceValueConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteResourceValueConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
     * descendants in the CRM hierarchy. This method is only supported for
     * resident custom modules.
     *
     * The async variant is
     * {@see SecurityCenterClient::deleteSecurityHealthAnalyticsCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/delete_security_health_analytics_custom_module.php
     *
     * @param DeleteSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSecurityHealthAnalyticsCustomModule(DeleteSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::getBigQueryExportAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_big_query_export.php
     *
     * @param GetBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBigQueryExport(GetBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('GetBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Gets an effective Event Threat Detection custom module at the given level.
     *
     * The async variant is
     * {@see SecurityCenterClient::getEffectiveEventThreatDetectionCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/get_effective_event_threat_detection_custom_module.php
     *
     * @param GetEffectiveEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EffectiveEventThreatDetectionCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEffectiveEventThreatDetectionCustomModule(GetEffectiveEventThreatDetectionCustomModuleRequest $request, array $callOptions = []): EffectiveEventThreatDetectionCustomModule
    {
        return $this->startApiCall('GetEffectiveEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
     *
     * The async variant is
     * {@see SecurityCenterClient::getEffectiveSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/get_effective_security_health_analytics_custom_module.php
     *
     * @param GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EffectiveSecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEffectiveSecurityHealthAnalyticsCustomModule(GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): EffectiveSecurityHealthAnalyticsCustomModule
    {
        return $this->startApiCall('GetEffectiveSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets an Event Threat Detection custom module.
     *
     * The async variant is
     * {@see SecurityCenterClient::getEventThreatDetectionCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_event_threat_detection_custom_module.php
     *
     * @param GetEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventThreatDetectionCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEventThreatDetectionCustomModule(GetEventThreatDetectionCustomModuleRequest $request, array $callOptions = []): EventThreatDetectionCustomModule
    {
        return $this->startApiCall('GetEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy on the specified Source.
     *
     * The async variant is {@see SecurityCenterClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets a mute config.
     *
     * The async variant is {@see SecurityCenterClient::getMuteConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_mute_config.php
     *
     * @param GetMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMuteConfig(GetMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('GetMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a notification config.
     *
     * The async variant is {@see SecurityCenterClient::getNotificationConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_notification_config.php
     *
     * @param GetNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNotificationConfig(GetNotificationConfigRequest $request, array $callOptions = []): NotificationConfig
    {
        return $this->startApiCall('GetNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets the settings for an organization.
     *
     * The async variant is {@see SecurityCenterClient::getOrganizationSettingsAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/get_organization_settings.php
     *
     * @param GetOrganizationSettingsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OrganizationSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getOrganizationSettings(GetOrganizationSettingsRequest $request, array $callOptions = []): OrganizationSettings
    {
        return $this->startApiCall('GetOrganizationSettings', $request, $callOptions)->wait();
    }

    /**
     * Gets a ResourceValueConfig.
     *
     * The async variant is {@see SecurityCenterClient::getResourceValueConfigAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/get_resource_value_config.php
     *
     * @param GetResourceValueConfigRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ResourceValueConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getResourceValueConfig(GetResourceValueConfigRequest $request, array $callOptions = []): ResourceValueConfig
    {
        return $this->startApiCall('GetResourceValueConfig', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a SecurityHealthAnalyticsCustomModule.
     *
     * The async variant is
     * {@see SecurityCenterClient::getSecurityHealthAnalyticsCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_security_health_analytics_custom_module.php
     *
     * @param GetSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSecurityHealthAnalyticsCustomModule(GetSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): SecurityHealthAnalyticsCustomModule
    {
        return $this->startApiCall('GetSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Get the simulation by name or the latest simulation for the given
     * organization.
     *
     * The async variant is {@see SecurityCenterClient::getSimulationAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_simulation.php
     *
     * @param GetSimulationRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Simulation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSimulation(GetSimulationRequest $request, array $callOptions = []): Simulation
    {
        return $this->startApiCall('GetSimulation', $request, $callOptions)->wait();
    }

    /**
     * Gets a source.
     *
     * The async variant is {@see SecurityCenterClient::getSourceAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_source.php
     *
     * @param GetSourceRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSource(GetSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('GetSource', $request, $callOptions)->wait();
    }

    /**
     * Get the valued resource by name
     *
     * The async variant is {@see SecurityCenterClient::getValuedResourceAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/get_valued_resource.php
     *
     * @param GetValuedResourceRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ValuedResource
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getValuedResource(GetValuedResourceRequest $request, array $callOptions = []): ValuedResource
    {
        return $this->startApiCall('GetValuedResource', $request, $callOptions)->wait();
    }

    /**
     * Filters an organization's assets and  groups them by their specified
     * properties.
     *
     * The async variant is {@see SecurityCenterClient::groupAssetsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/group_assets.php
     *
     * @param GroupAssetsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function groupAssets(GroupAssetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('GroupAssets', $request, $callOptions);
    }

    /**
     * Filters an organization or source's findings and  groups them by their
     * specified properties.
     *
     * To group across all sources provide a `-` as the source id.
     * Example: /v1/organizations/{organization_id}/sources/-/findings,
     * /v1/folders/{folder_id}/sources/-/findings,
     * /v1/projects/{project_id}/sources/-/findings
     *
     * The async variant is {@see SecurityCenterClient::groupFindingsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/group_findings.php
     *
     * @param GroupFindingsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function groupFindings(GroupFindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('GroupFindings', $request, $callOptions);
    }

    /**
     * Lists an organization's assets.
     *
     * The async variant is {@see SecurityCenterClient::listAssetsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_assets.php
     *
     * @param ListAssetsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function listAssets(ListAssetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAssets', $request, $callOptions);
    }

    /**
     * Lists the attack paths for a set of simulation results or valued resources
     * and filter.
     *
     * The async variant is {@see SecurityCenterClient::listAttackPathsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_attack_paths.php
     *
     * @param ListAttackPathsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAttackPaths(ListAttackPathsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAttackPaths', $request, $callOptions);
    }

    /**
     * Lists BigQuery exports. Note that when requesting BigQuery exports at a
     * given level all exports under that level are also returned e.g. if
     * requesting BigQuery exports under a folder, then all BigQuery exports
     * immediately under the folder plus the ones created under the projects
     * within the folder are returned.
     *
     * The async variant is {@see SecurityCenterClient::listBigQueryExportsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_big_query_exports.php
     *
     * @param ListBigQueryExportsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBigQueryExports(ListBigQueryExportsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBigQueryExports', $request, $callOptions);
    }

    /**
     * Lists all resident Event Threat Detection custom modules under the
     * given Resource Manager parent and its descendants.
     *
     * The async variant is
     * {@see SecurityCenterClient::listDescendantEventThreatDetectionCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/list_descendant_event_threat_detection_custom_modules.php
     *
     * @param ListDescendantEventThreatDetectionCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDescendantEventThreatDetectionCustomModules(ListDescendantEventThreatDetectionCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDescendantEventThreatDetectionCustomModules', $request, $callOptions);
    }

    /**
     * Returns a list of all resident SecurityHealthAnalyticsCustomModules under
     * the given CRM parent and all of the parent’s CRM descendants.
     *
     * The async variant is
     * {@see SecurityCenterClient::listDescendantSecurityHealthAnalyticsCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/list_descendant_security_health_analytics_custom_modules.php
     *
     * @param ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDescendantSecurityHealthAnalyticsCustomModules(ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDescendantSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Lists all effective Event Threat Detection custom modules for the
     * given parent. This includes resident modules defined at the scope of the
     * parent along with modules inherited from its ancestors.
     *
     * The async variant is
     * {@see SecurityCenterClient::listEffectiveEventThreatDetectionCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/list_effective_event_threat_detection_custom_modules.php
     *
     * @param ListEffectiveEventThreatDetectionCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEffectiveEventThreatDetectionCustomModules(ListEffectiveEventThreatDetectionCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEffectiveEventThreatDetectionCustomModules', $request, $callOptions);
    }

    /**
     * Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
     * given parent. This includes resident modules defined at the scope of the
     * parent, and inherited modules, inherited from CRM ancestors.
     *
     * The async variant is
     * {@see SecurityCenterClient::listEffectiveSecurityHealthAnalyticsCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/list_effective_security_health_analytics_custom_modules.php
     *
     * @param ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEffectiveSecurityHealthAnalyticsCustomModules(ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEffectiveSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Lists all Event Threat Detection custom modules for the given
     * Resource Manager parent. This includes resident modules defined at the
     * scope of the parent along with modules inherited from ancestors.
     *
     * The async variant is
     * {@see SecurityCenterClient::listEventThreatDetectionCustomModulesAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_event_threat_detection_custom_modules.php
     *
     * @param ListEventThreatDetectionCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEventThreatDetectionCustomModules(ListEventThreatDetectionCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEventThreatDetectionCustomModules', $request, $callOptions);
    }

    /**
     * Lists an organization or source's findings.
     *
     * To list across all sources provide a `-` as the source id.
     * Example: /v1/organizations/{organization_id}/sources/-/findings
     *
     * The async variant is {@see SecurityCenterClient::listFindingsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_findings.php
     *
     * @param ListFindingsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFindings(ListFindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFindings', $request, $callOptions);
    }

    /**
     * Lists mute configs.
     *
     * The async variant is {@see SecurityCenterClient::listMuteConfigsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_mute_configs.php
     *
     * @param ListMuteConfigsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMuteConfigs(ListMuteConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMuteConfigs', $request, $callOptions);
    }

    /**
     * Lists notification configs.
     *
     * The async variant is {@see SecurityCenterClient::listNotificationConfigsAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/list_notification_configs.php
     *
     * @param ListNotificationConfigsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNotificationConfigs(ListNotificationConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNotificationConfigs', $request, $callOptions);
    }

    /**
     * Lists all ResourceValueConfigs.
     *
     * The async variant is
     * {@see SecurityCenterClient::listResourceValueConfigsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_resource_value_configs.php
     *
     * @param ListResourceValueConfigsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listResourceValueConfigs(ListResourceValueConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListResourceValueConfigs', $request, $callOptions);
    }

    /**
     * Returns a list of all SecurityHealthAnalyticsCustomModules for the given
     * parent. This includes resident modules defined at the scope of the parent,
     * and inherited modules, inherited from CRM ancestors.
     *
     * The async variant is
     * {@see SecurityCenterClient::listSecurityHealthAnalyticsCustomModulesAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_security_health_analytics_custom_modules.php
     *
     * @param ListSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSecurityHealthAnalyticsCustomModules(ListSecurityHealthAnalyticsCustomModulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Lists all sources belonging to an organization.
     *
     * The async variant is {@see SecurityCenterClient::listSourcesAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_sources.php
     *
     * @param ListSourcesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSources(ListSourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSources', $request, $callOptions);
    }

    /**
     * Lists the valued resources for a set of simulation results and filter.
     *
     * The async variant is {@see SecurityCenterClient::listValuedResourcesAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/list_valued_resources.php
     *
     * @param ListValuedResourcesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listValuedResources(ListValuedResourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListValuedResources', $request, $callOptions);
    }

    /**
     * Runs asset discovery. The discovery is tracked with a long-running
     * operation.
     *
     * This API can only be called with limited frequency for an organization. If
     * it is called too frequently the caller will receive a TOO_MANY_REQUESTS
     * error.
     *
     * The async variant is {@see SecurityCenterClient::runAssetDiscoveryAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/run_asset_discovery.php
     *
     * @param RunAssetDiscoveryRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function runAssetDiscovery(RunAssetDiscoveryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RunAssetDiscovery', $request, $callOptions)->wait();
    }

    /**
     * Updates the state of a finding.
     *
     * The async variant is {@see SecurityCenterClient::setFindingStateAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/set_finding_state.php
     *
     * @param SetFindingStateRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setFindingState(SetFindingStateRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('SetFindingState', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified Source.
     *
     * The async variant is {@see SecurityCenterClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates the mute state of a finding.
     *
     * The async variant is {@see SecurityCenterClient::setMuteAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/set_mute.php
     *
     * @param SetMuteRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMute(SetMuteRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('SetMute', $request, $callOptions)->wait();
    }

    /**
     * Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
     *
     * The async variant is
     * {@see SecurityCenterClient::simulateSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterClient/simulate_security_health_analytics_custom_module.php
     *
     * @param SimulateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SimulateSecurityHealthAnalyticsCustomModuleResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function simulateSecurityHealthAnalyticsCustomModule(SimulateSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): SimulateSecurityHealthAnalyticsCustomModuleResponse
    {
        return $this->startApiCall('SimulateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Returns the permissions that a caller has on the specified source.
     *
     * The async variant is {@see SecurityCenterClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::updateBigQueryExportAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_big_query_export.php
     *
     * @param UpdateBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBigQueryExport(UpdateBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('UpdateBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Updates the Event Threat Detection custom module with the given name based
     * on the given update mask. Updating the enablement state is supported for
     * both resident and inherited modules (though resident modules cannot have an
     * enablement state of "inherited"). Updating the display name or
     * configuration of a module is supported for resident modules only. The type
     * of a module cannot be changed.
     *
     * The async variant is
     * {@see SecurityCenterClient::updateEventThreatDetectionCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_event_threat_detection_custom_module.php
     *
     * @param UpdateEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventThreatDetectionCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEventThreatDetectionCustomModule(UpdateEventThreatDetectionCustomModuleRequest $request, array $callOptions = []): EventThreatDetectionCustomModule
    {
        return $this->startApiCall('UpdateEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Updates external system. This is for a given finding.
     *
     * The async variant is {@see SecurityCenterClient::updateExternalSystemAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_external_system.php
     *
     * @param UpdateExternalSystemRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExternalSystem
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExternalSystem(UpdateExternalSystemRequest $request, array $callOptions = []): ExternalSystem
    {
        return $this->startApiCall('UpdateExternalSystem', $request, $callOptions)->wait();
    }

    /**
     * Creates or updates a finding. The corresponding source must exist for a
     * finding creation to succeed.
     *
     * The async variant is {@see SecurityCenterClient::updateFindingAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_finding.php
     *
     * @param UpdateFindingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFinding(UpdateFindingRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('UpdateFinding', $request, $callOptions)->wait();
    }

    /**
     * Updates a mute config.
     *
     * The async variant is {@see SecurityCenterClient::updateMuteConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_mute_config.php
     *
     * @param UpdateMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMuteConfig(UpdateMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('UpdateMuteConfig', $request, $callOptions)->wait();
    }

    /**
     *
     * Updates a notification config. The following update
     * fields are allowed: description, pubsub_topic, streaming_config.filter
     *
     * The async variant is
     * {@see SecurityCenterClient::updateNotificationConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_notification_config.php
     *
     * @param UpdateNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNotificationConfig(UpdateNotificationConfigRequest $request, array $callOptions = []): NotificationConfig
    {
        return $this->startApiCall('UpdateNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates an organization's settings.
     *
     * The async variant is
     * {@see SecurityCenterClient::updateOrganizationSettingsAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_organization_settings.php
     *
     * @param UpdateOrganizationSettingsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OrganizationSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateOrganizationSettings(UpdateOrganizationSettingsRequest $request, array $callOptions = []): OrganizationSettings
    {
        return $this->startApiCall('UpdateOrganizationSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing ResourceValueConfigs with new rules.
     *
     * The async variant is
     * {@see SecurityCenterClient::updateResourceValueConfigAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_resource_value_config.php
     *
     * @param UpdateResourceValueConfigRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ResourceValueConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateResourceValueConfig(UpdateResourceValueConfigRequest $request, array $callOptions = []): ResourceValueConfig
    {
        return $this->startApiCall('UpdateResourceValueConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the SecurityHealthAnalyticsCustomModule under the given name based
     * on the given update mask. Updating the enablement state is supported on
     * both resident and inherited modules (though resident modules cannot have an
     * enablement state of "inherited"). Updating the display name and custom
     * config of a module is supported on resident modules only.
     *
     * The async variant is
     * {@see SecurityCenterClient::updateSecurityHealthAnalyticsCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_security_health_analytics_custom_module.php
     *
     * @param UpdateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSecurityHealthAnalyticsCustomModule(UpdateSecurityHealthAnalyticsCustomModuleRequest $request, array $callOptions = []): SecurityHealthAnalyticsCustomModule
    {
        return $this->startApiCall('UpdateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Updates security marks.
     *
     * The async variant is {@see SecurityCenterClient::updateSecurityMarksAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_security_marks.php
     *
     * @param UpdateSecurityMarksRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityMarks
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSecurityMarks(UpdateSecurityMarksRequest $request, array $callOptions = []): SecurityMarks
    {
        return $this->startApiCall('UpdateSecurityMarks', $request, $callOptions)->wait();
    }

    /**
     * Updates a source.
     *
     * The async variant is {@see SecurityCenterClient::updateSourceAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/update_source.php
     *
     * @param UpdateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSource(UpdateSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('UpdateSource', $request, $callOptions)->wait();
    }

    /**
     * Validates the given Event Threat Detection custom module.
     *
     * The async variant is
     * {@see SecurityCenterClient::validateEventThreatDetectionCustomModuleAsync()} .
     *
     * @example samples/V1/SecurityCenterClient/validate_event_threat_detection_custom_module.php
     *
     * @param ValidateEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ValidateEventThreatDetectionCustomModuleResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function validateEventThreatDetectionCustomModule(ValidateEventThreatDetectionCustomModuleRequest $request, array $callOptions = []): ValidateEventThreatDetectionCustomModuleResponse
    {
        return $this->startApiCall('ValidateEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }
}
