<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/routeoptimization/v1/route_optimization_service.proto

namespace Google\Maps\RouteOptimization\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Models a vehicle in a shipment problem. Solving a shipment problem will
 * build a route starting from `start_location` and ending at `end_location`
 * for this vehicle. A route is a sequence of visits (see `ShipmentRoute`).
 *
 * Generated from protobuf message <code>google.maps.routeoptimization.v1.Vehicle</code>
 */
class Vehicle extends \Google\Protobuf\Internal\Message
{
    /**
     * The user-defined display name of the vehicle.
     * It can be up to 63 characters long and may use UTF-8 characters.
     *
     * Generated from protobuf field <code>string display_name = 32;</code>
     */
    protected $display_name = '';
    /**
     * The travel mode which affects the roads usable by the vehicle and its
     * speed. See also `travel_duration_multiple`.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
     */
    protected $travel_mode = 0;
    /**
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.type.LatLng start_location = 3;</code>
     */
    protected $start_location = null;
    /**
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Waypoint start_waypoint = 4;</code>
     */
    protected $start_waypoint = null;
    /**
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.type.LatLng end_location = 5;</code>
     */
    protected $end_location = null;
    /**
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Waypoint end_waypoint = 6;</code>
     */
    protected $end_waypoint = null;
    /**
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     *
     * Generated from protobuf field <code>repeated string start_tags = 7;</code>
     */
    private $start_tags;
    /**
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     *
     * Generated from protobuf field <code>repeated string end_tags = 8;</code>
     */
    private $end_tags;
    /**
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.maps.routeoptimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    private $start_time_windows;
    /**
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.maps.routeoptimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    private $end_time_windows;
    /**
     * Specifies a multiplicative factor that can be used to increase or decrease
     * travel times of this vehicle. For example, setting this to 2.0 means
     * that this vehicle is slower and has travel times that are twice what they
     * are for standard vehicles. This multiple does not affect visit durations.
     * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
     * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
     * is standard, and this multiple is considered 1.0.
     * WARNING: Travel times will be rounded to the nearest second after this
     * multiple is applied but before performing any numerical operations, thus,
     * a small multiple may result in a loss of precision.
     * See also `extra_visit_duration_for_visit_type` below.
     *
     * Generated from protobuf field <code>optional double travel_duration_multiple = 11;</code>
     */
    protected $travel_duration_multiple = null;
    /**
     * Unloading policy enforced on the vehicle.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
     */
    protected $unloading_policy = 0;
    /**
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.maps.routeoptimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     *
     * Generated from protobuf field <code>map<string, .google.maps.routeoptimization.v1.Vehicle.LoadLimit> load_limits = 30;</code>
     */
    private $load_limits;
    /**
     * Vehicle costs: all costs add up and must be in the same unit as
     * [Shipment.penalty_cost][google.maps.routeoptimization.v1.Shipment.penalty_cost].
     * Cost per hour of the vehicle route. This cost is applied to the total time
     * taken by the route, and includes travel time, waiting time, and visit time.
     * Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
     * in additional latency.
     *
     * Generated from protobuf field <code>double cost_per_hour = 16;</code>
     */
    protected $cost_per_hour = 0.0;
    /**
     * Cost per traveled hour of the vehicle route. This cost is applied only to
     * travel time taken by the route (i.e., that reported in
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions]),
     * and excludes waiting time and visit time.
     *
     * Generated from protobuf field <code>double cost_per_traveled_hour = 17;</code>
     */
    protected $cost_per_traveled_hour = 0.0;
    /**
     * Cost per kilometer of the vehicle route. This cost is applied to the
     * distance reported in the
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions]
     * and does not apply to any distance implicitly traveled from the
     * `arrival_location` to the `departure_location` of a single `VisitRequest`.
     *
     * Generated from protobuf field <code>double cost_per_kilometer = 18;</code>
     */
    protected $cost_per_kilometer = 0.0;
    /**
     * Fixed cost applied if this vehicle is used to handle a shipment.
     *
     * Generated from protobuf field <code>double fixed_cost = 19;</code>
     */
    protected $fixed_cost = 0.0;
    /**
     * This field only applies to vehicles when their route does not serve any
     * shipments. It indicates if the vehicle should be considered as used or not
     * in this case.
     * If true, the vehicle goes from its start to its end location even if it
     * doesn't serve any shipments, and time and distance costs resulting from its
     * start --> end travel are taken into account.
     * Otherwise, it doesn't travel from its start to its end location, and no
     * `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
     * vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
     * information except for the vehicle index and label.
     *
     * Generated from protobuf field <code>bool used_if_route_is_empty = 20;</code>
     */
    protected $used_if_route_is_empty = false;
    /**
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     */
    protected $route_duration_limit = null;
    /**
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_duration].
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     */
    protected $travel_duration_limit = null;
    /**
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.DistanceLimit route_distance_limit = 23;</code>
     */
    protected $route_distance_limit = null;
    /**
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.maps.routeoptimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Duration> extra_visit_duration_for_visit_type = 24;</code>
     */
    private $extra_visit_duration_for_visit_type;
    /**
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.BreakRule break_rule = 25;</code>
     */
    protected $break_rule = null;
    /**
     * Specifies a label for this vehicle. This label is reported in the response
     * as the `vehicle_label` of the corresponding
     * [ShipmentRoute][google.maps.routeoptimization.v1.ShipmentRoute].
     *
     * Generated from protobuf field <code>string label = 27;</code>
     */
    protected $label = '';
    /**
     * If true, `used_if_route_is_empty` must be false, and this vehicle will
     * remain unused.
     * If a shipment is performed by an ignored vehicle in
     * `injected_first_solution_routes`, it is skipped in the first solution but
     * is free to be performed in the response.
     * If a shipment is performed by an ignored vehicle in
     * `injected_solution_constraint` and any related pickup/delivery is
     * constrained to remain on the vehicle (i.e., not relaxed to level
     * `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
     * If a shipment has a non-empty `allowed_vehicle_indices` field and all of
     * the allowed vehicles are ignored, it is skipped in the response.
     *
     * Generated from protobuf field <code>bool ignore = 28;</code>
     */
    protected $ignore = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $display_name
     *           The user-defined display name of the vehicle.
     *           It can be up to 63 characters long and may use UTF-8 characters.
     *     @type int $travel_mode
     *           The travel mode which affects the roads usable by the vehicle and its
     *           speed. See also `travel_duration_multiple`.
     *     @type \Google\Type\LatLng $start_location
     *           Geographic location where the vehicle starts before picking up any
     *           shipments. If not specified, the vehicle starts at its first pickup.
     *           If the shipment model has duration and distance matrices, `start_location`
     *           must not be specified.
     *     @type \Google\Maps\RouteOptimization\V1\Waypoint $start_waypoint
     *           Waypoint representing a geographic location where the vehicle starts before
     *           picking up any shipments. If neither `start_waypoint` nor `start_location`
     *           is specified, the vehicle starts at its first pickup.
     *           If the shipment model has duration and distance matrices, `start_waypoint`
     *           must not be specified.
     *     @type \Google\Type\LatLng $end_location
     *           Geographic location where the vehicle ends after it has completed its last
     *           `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     *           immediately when it completes its last `VisitRequest`.
     *           If the shipment model has duration and distance matrices, `end_location`
     *           must not be specified.
     *     @type \Google\Maps\RouteOptimization\V1\Waypoint $end_waypoint
     *           Waypoint representing a geographic location where the vehicle ends after
     *           it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     *           `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     *           when it completes its last `VisitRequest`.
     *           If the shipment model has duration and distance matrices, `end_waypoint`
     *           must not be specified.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $start_tags
     *           Specifies tags attached to the start of the vehicle's route.
     *           Empty or duplicate strings are not allowed.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $end_tags
     *           Specifies tags attached to the end of the vehicle's route.
     *           Empty or duplicate strings are not allowed.
     *     @type array<\Google\Maps\RouteOptimization\V1\TimeWindow>|\Google\Protobuf\Internal\RepeatedField $start_time_windows
     *           Time windows during which the vehicle may depart its start location.
     *           They must be within the global time limits (see
     *           [ShipmentModel.global_*][google.maps.routeoptimization.v1.ShipmentModel.global_start_time]
     *           fields). If unspecified, there is no limitation besides those global time
     *           limits.
     *           Time windows belonging to the same repeated field must be disjoint, i.e. no
     *           time window can overlap with or be adjacent to another, and they must be in
     *           chronological order.
     *           `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     *           there is a single time window.
     *     @type array<\Google\Maps\RouteOptimization\V1\TimeWindow>|\Google\Protobuf\Internal\RepeatedField $end_time_windows
     *           Time windows during which the vehicle may arrive at its end location.
     *           They must be within the global time limits (see
     *           [ShipmentModel.global_*][google.maps.routeoptimization.v1.ShipmentModel.global_start_time]
     *           fields). If unspecified, there is no limitation besides those global time
     *           limits.
     *           Time windows belonging to the same repeated field must be disjoint, i.e. no
     *           time window can overlap with or be adjacent to another, and they must be in
     *           chronological order.
     *           `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     *           there is a single time window.
     *     @type float $travel_duration_multiple
     *           Specifies a multiplicative factor that can be used to increase or decrease
     *           travel times of this vehicle. For example, setting this to 2.0 means
     *           that this vehicle is slower and has travel times that are twice what they
     *           are for standard vehicles. This multiple does not affect visit durations.
     *           It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
     *           specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
     *           is standard, and this multiple is considered 1.0.
     *           WARNING: Travel times will be rounded to the nearest second after this
     *           multiple is applied but before performing any numerical operations, thus,
     *           a small multiple may result in a loss of precision.
     *           See also `extra_visit_duration_for_visit_type` below.
     *     @type int $unloading_policy
     *           Unloading policy enforced on the vehicle.
     *     @type array|\Google\Protobuf\Internal\MapField $load_limits
     *           Capacities of the vehicle (weight, volume, # of pallets for example).
     *           The keys in the map are the identifiers of the type of load, consistent
     *           with the keys of the
     *           [Shipment.load_demands][google.maps.routeoptimization.v1.Shipment.load_demands]
     *           field. If a given key is absent from this map, the corresponding capacity
     *           is considered to be limitless.
     *     @type float $cost_per_hour
     *           Vehicle costs: all costs add up and must be in the same unit as
     *           [Shipment.penalty_cost][google.maps.routeoptimization.v1.Shipment.penalty_cost].
     *           Cost per hour of the vehicle route. This cost is applied to the total time
     *           taken by the route, and includes travel time, waiting time, and visit time.
     *           Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
     *           in additional latency.
     *     @type float $cost_per_traveled_hour
     *           Cost per traveled hour of the vehicle route. This cost is applied only to
     *           travel time taken by the route (i.e., that reported in
     *           [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions]),
     *           and excludes waiting time and visit time.
     *     @type float $cost_per_kilometer
     *           Cost per kilometer of the vehicle route. This cost is applied to the
     *           distance reported in the
     *           [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions]
     *           and does not apply to any distance implicitly traveled from the
     *           `arrival_location` to the `departure_location` of a single `VisitRequest`.
     *     @type float $fixed_cost
     *           Fixed cost applied if this vehicle is used to handle a shipment.
     *     @type bool $used_if_route_is_empty
     *           This field only applies to vehicles when their route does not serve any
     *           shipments. It indicates if the vehicle should be considered as used or not
     *           in this case.
     *           If true, the vehicle goes from its start to its end location even if it
     *           doesn't serve any shipments, and time and distance costs resulting from its
     *           start --> end travel are taken into account.
     *           Otherwise, it doesn't travel from its start to its end location, and no
     *           `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
     *           vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
     *           information except for the vehicle index and label.
     *     @type \Google\Maps\RouteOptimization\V1\Vehicle\DurationLimit $route_duration_limit
     *           Limit applied to the total duration of the vehicle's route. In a given
     *           `OptimizeToursResponse`, the route duration of a vehicle is the
     *           difference between its `vehicle_end_time` and `vehicle_start_time`.
     *     @type \Google\Maps\RouteOptimization\V1\Vehicle\DurationLimit $travel_duration_limit
     *           Limit applied to the travel duration of the vehicle's route. In a given
     *           `OptimizeToursResponse`, the route travel duration is the sum of all its
     *           [transitions.travel_duration][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_duration].
     *     @type \Google\Maps\RouteOptimization\V1\DistanceLimit $route_distance_limit
     *           Limit applied to the total distance of the vehicle's route. In a given
     *           `OptimizeToursResponse`, the route distance is the sum of all its
     *           [transitions.travel_distance_meters][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     *     @type array|\Google\Protobuf\Internal\MapField $extra_visit_duration_for_visit_type
     *           Specifies a map from visit_types strings to durations. The duration is time
     *           in addition to
     *           [VisitRequest.duration][google.maps.routeoptimization.v1.Shipment.VisitRequest.duration]
     *           to be taken at visits with the specified `visit_types`. This extra visit
     *           duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     *           `visit_types`) cannot be empty strings.
     *           If a visit request has multiple types, a duration will be added for each
     *           type in the map.
     *     @type \Google\Maps\RouteOptimization\V1\BreakRule $break_rule
     *           Describes the break schedule to be enforced on this vehicle.
     *           If empty, no breaks will be scheduled for this vehicle.
     *     @type string $label
     *           Specifies a label for this vehicle. This label is reported in the response
     *           as the `vehicle_label` of the corresponding
     *           [ShipmentRoute][google.maps.routeoptimization.v1.ShipmentRoute].
     *     @type bool $ignore
     *           If true, `used_if_route_is_empty` must be false, and this vehicle will
     *           remain unused.
     *           If a shipment is performed by an ignored vehicle in
     *           `injected_first_solution_routes`, it is skipped in the first solution but
     *           is free to be performed in the response.
     *           If a shipment is performed by an ignored vehicle in
     *           `injected_solution_constraint` and any related pickup/delivery is
     *           constrained to remain on the vehicle (i.e., not relaxed to level
     *           `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
     *           If a shipment has a non-empty `allowed_vehicle_indices` field and all of
     *           the allowed vehicles are ignored, it is skipped in the response.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Routeoptimization\V1\RouteOptimizationService::initOnce();
        parent::__construct($data);
    }

    /**
     * The user-defined display name of the vehicle.
     * It can be up to 63 characters long and may use UTF-8 characters.
     *
     * Generated from protobuf field <code>string display_name = 32;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The user-defined display name of the vehicle.
     * It can be up to 63 characters long and may use UTF-8 characters.
     *
     * Generated from protobuf field <code>string display_name = 32;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The travel mode which affects the roads usable by the vehicle and its
     * speed. See also `travel_duration_multiple`.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
     * @return int
     */
    public function getTravelMode()
    {
        return $this->travel_mode;
    }

    /**
     * The travel mode which affects the roads usable by the vehicle and its
     * speed. See also `travel_duration_multiple`.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setTravelMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\RouteOptimization\V1\Vehicle\TravelMode::class);
        $this->travel_mode = $var;

        return $this;
    }

    /**
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.type.LatLng start_location = 3;</code>
     * @return \Google\Type\LatLng|null
     */
    public function getStartLocation()
    {
        return $this->start_location;
    }

    public function hasStartLocation()
    {
        return isset($this->start_location);
    }

    public function clearStartLocation()
    {
        unset($this->start_location);
    }

    /**
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.type.LatLng start_location = 3;</code>
     * @param \Google\Type\LatLng $var
     * @return $this
     */
    public function setStartLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\LatLng::class);
        $this->start_location = $var;

        return $this;
    }

    /**
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Waypoint start_waypoint = 4;</code>
     * @return \Google\Maps\RouteOptimization\V1\Waypoint|null
     */
    public function getStartWaypoint()
    {
        return $this->start_waypoint;
    }

    public function hasStartWaypoint()
    {
        return isset($this->start_waypoint);
    }

    public function clearStartWaypoint()
    {
        unset($this->start_waypoint);
    }

    /**
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Waypoint start_waypoint = 4;</code>
     * @param \Google\Maps\RouteOptimization\V1\Waypoint $var
     * @return $this
     */
    public function setStartWaypoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\RouteOptimization\V1\Waypoint::class);
        $this->start_waypoint = $var;

        return $this;
    }

    /**
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.type.LatLng end_location = 5;</code>
     * @return \Google\Type\LatLng|null
     */
    public function getEndLocation()
    {
        return $this->end_location;
    }

    public function hasEndLocation()
    {
        return isset($this->end_location);
    }

    public function clearEndLocation()
    {
        unset($this->end_location);
    }

    /**
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.type.LatLng end_location = 5;</code>
     * @param \Google\Type\LatLng $var
     * @return $this
     */
    public function setEndLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\LatLng::class);
        $this->end_location = $var;

        return $this;
    }

    /**
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Waypoint end_waypoint = 6;</code>
     * @return \Google\Maps\RouteOptimization\V1\Waypoint|null
     */
    public function getEndWaypoint()
    {
        return $this->end_waypoint;
    }

    public function hasEndWaypoint()
    {
        return isset($this->end_waypoint);
    }

    public function clearEndWaypoint()
    {
        unset($this->end_waypoint);
    }

    /**
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Waypoint end_waypoint = 6;</code>
     * @param \Google\Maps\RouteOptimization\V1\Waypoint $var
     * @return $this
     */
    public function setEndWaypoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\RouteOptimization\V1\Waypoint::class);
        $this->end_waypoint = $var;

        return $this;
    }

    /**
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     *
     * Generated from protobuf field <code>repeated string start_tags = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStartTags()
    {
        return $this->start_tags;
    }

    /**
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     *
     * Generated from protobuf field <code>repeated string start_tags = 7;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStartTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->start_tags = $arr;

        return $this;
    }

    /**
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     *
     * Generated from protobuf field <code>repeated string end_tags = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEndTags()
    {
        return $this->end_tags;
    }

    /**
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     *
     * Generated from protobuf field <code>repeated string end_tags = 8;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEndTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->end_tags = $arr;

        return $this;
    }

    /**
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.maps.routeoptimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TimeWindow start_time_windows = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStartTimeWindows()
    {
        return $this->start_time_windows;
    }

    /**
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.maps.routeoptimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TimeWindow start_time_windows = 9;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\TimeWindow>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStartTimeWindows($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\TimeWindow::class);
        $this->start_time_windows = $arr;

        return $this;
    }

    /**
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.maps.routeoptimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TimeWindow end_time_windows = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEndTimeWindows()
    {
        return $this->end_time_windows;
    }

    /**
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.maps.routeoptimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TimeWindow end_time_windows = 10;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\TimeWindow>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEndTimeWindows($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\TimeWindow::class);
        $this->end_time_windows = $arr;

        return $this;
    }

    /**
     * Specifies a multiplicative factor that can be used to increase or decrease
     * travel times of this vehicle. For example, setting this to 2.0 means
     * that this vehicle is slower and has travel times that are twice what they
     * are for standard vehicles. This multiple does not affect visit durations.
     * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
     * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
     * is standard, and this multiple is considered 1.0.
     * WARNING: Travel times will be rounded to the nearest second after this
     * multiple is applied but before performing any numerical operations, thus,
     * a small multiple may result in a loss of precision.
     * See also `extra_visit_duration_for_visit_type` below.
     *
     * Generated from protobuf field <code>optional double travel_duration_multiple = 11;</code>
     * @return float
     */
    public function getTravelDurationMultiple()
    {
        return isset($this->travel_duration_multiple) ? $this->travel_duration_multiple : 0.0;
    }

    public function hasTravelDurationMultiple()
    {
        return isset($this->travel_duration_multiple);
    }

    public function clearTravelDurationMultiple()
    {
        unset($this->travel_duration_multiple);
    }

    /**
     * Specifies a multiplicative factor that can be used to increase or decrease
     * travel times of this vehicle. For example, setting this to 2.0 means
     * that this vehicle is slower and has travel times that are twice what they
     * are for standard vehicles. This multiple does not affect visit durations.
     * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
     * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
     * is standard, and this multiple is considered 1.0.
     * WARNING: Travel times will be rounded to the nearest second after this
     * multiple is applied but before performing any numerical operations, thus,
     * a small multiple may result in a loss of precision.
     * See also `extra_visit_duration_for_visit_type` below.
     *
     * Generated from protobuf field <code>optional double travel_duration_multiple = 11;</code>
     * @param float $var
     * @return $this
     */
    public function setTravelDurationMultiple($var)
    {
        GPBUtil::checkDouble($var);
        $this->travel_duration_multiple = $var;

        return $this;
    }

    /**
     * Unloading policy enforced on the vehicle.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
     * @return int
     */
    public function getUnloadingPolicy()
    {
        return $this->unloading_policy;
    }

    /**
     * Unloading policy enforced on the vehicle.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setUnloadingPolicy($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\RouteOptimization\V1\Vehicle\UnloadingPolicy::class);
        $this->unloading_policy = $var;

        return $this;
    }

    /**
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.maps.routeoptimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     *
     * Generated from protobuf field <code>map<string, .google.maps.routeoptimization.v1.Vehicle.LoadLimit> load_limits = 30;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLoadLimits()
    {
        return $this->load_limits;
    }

    /**
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.maps.routeoptimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     *
     * Generated from protobuf field <code>map<string, .google.maps.routeoptimization.v1.Vehicle.LoadLimit> load_limits = 30;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLoadLimits($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\Vehicle\LoadLimit::class);
        $this->load_limits = $arr;

        return $this;
    }

    /**
     * Vehicle costs: all costs add up and must be in the same unit as
     * [Shipment.penalty_cost][google.maps.routeoptimization.v1.Shipment.penalty_cost].
     * Cost per hour of the vehicle route. This cost is applied to the total time
     * taken by the route, and includes travel time, waiting time, and visit time.
     * Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
     * in additional latency.
     *
     * Generated from protobuf field <code>double cost_per_hour = 16;</code>
     * @return float
     */
    public function getCostPerHour()
    {
        return $this->cost_per_hour;
    }

    /**
     * Vehicle costs: all costs add up and must be in the same unit as
     * [Shipment.penalty_cost][google.maps.routeoptimization.v1.Shipment.penalty_cost].
     * Cost per hour of the vehicle route. This cost is applied to the total time
     * taken by the route, and includes travel time, waiting time, and visit time.
     * Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
     * in additional latency.
     *
     * Generated from protobuf field <code>double cost_per_hour = 16;</code>
     * @param float $var
     * @return $this
     */
    public function setCostPerHour($var)
    {
        GPBUtil::checkDouble($var);
        $this->cost_per_hour = $var;

        return $this;
    }

    /**
     * Cost per traveled hour of the vehicle route. This cost is applied only to
     * travel time taken by the route (i.e., that reported in
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions]),
     * and excludes waiting time and visit time.
     *
     * Generated from protobuf field <code>double cost_per_traveled_hour = 17;</code>
     * @return float
     */
    public function getCostPerTraveledHour()
    {
        return $this->cost_per_traveled_hour;
    }

    /**
     * Cost per traveled hour of the vehicle route. This cost is applied only to
     * travel time taken by the route (i.e., that reported in
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions]),
     * and excludes waiting time and visit time.
     *
     * Generated from protobuf field <code>double cost_per_traveled_hour = 17;</code>
     * @param float $var
     * @return $this
     */
    public function setCostPerTraveledHour($var)
    {
        GPBUtil::checkDouble($var);
        $this->cost_per_traveled_hour = $var;

        return $this;
    }

    /**
     * Cost per kilometer of the vehicle route. This cost is applied to the
     * distance reported in the
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions]
     * and does not apply to any distance implicitly traveled from the
     * `arrival_location` to the `departure_location` of a single `VisitRequest`.
     *
     * Generated from protobuf field <code>double cost_per_kilometer = 18;</code>
     * @return float
     */
    public function getCostPerKilometer()
    {
        return $this->cost_per_kilometer;
    }

    /**
     * Cost per kilometer of the vehicle route. This cost is applied to the
     * distance reported in the
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions]
     * and does not apply to any distance implicitly traveled from the
     * `arrival_location` to the `departure_location` of a single `VisitRequest`.
     *
     * Generated from protobuf field <code>double cost_per_kilometer = 18;</code>
     * @param float $var
     * @return $this
     */
    public function setCostPerKilometer($var)
    {
        GPBUtil::checkDouble($var);
        $this->cost_per_kilometer = $var;

        return $this;
    }

    /**
     * Fixed cost applied if this vehicle is used to handle a shipment.
     *
     * Generated from protobuf field <code>double fixed_cost = 19;</code>
     * @return float
     */
    public function getFixedCost()
    {
        return $this->fixed_cost;
    }

    /**
     * Fixed cost applied if this vehicle is used to handle a shipment.
     *
     * Generated from protobuf field <code>double fixed_cost = 19;</code>
     * @param float $var
     * @return $this
     */
    public function setFixedCost($var)
    {
        GPBUtil::checkDouble($var);
        $this->fixed_cost = $var;

        return $this;
    }

    /**
     * This field only applies to vehicles when their route does not serve any
     * shipments. It indicates if the vehicle should be considered as used or not
     * in this case.
     * If true, the vehicle goes from its start to its end location even if it
     * doesn't serve any shipments, and time and distance costs resulting from its
     * start --> end travel are taken into account.
     * Otherwise, it doesn't travel from its start to its end location, and no
     * `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
     * vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
     * information except for the vehicle index and label.
     *
     * Generated from protobuf field <code>bool used_if_route_is_empty = 20;</code>
     * @return bool
     */
    public function getUsedIfRouteIsEmpty()
    {
        return $this->used_if_route_is_empty;
    }

    /**
     * This field only applies to vehicles when their route does not serve any
     * shipments. It indicates if the vehicle should be considered as used or not
     * in this case.
     * If true, the vehicle goes from its start to its end location even if it
     * doesn't serve any shipments, and time and distance costs resulting from its
     * start --> end travel are taken into account.
     * Otherwise, it doesn't travel from its start to its end location, and no
     * `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
     * vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
     * information except for the vehicle index and label.
     *
     * Generated from protobuf field <code>bool used_if_route_is_empty = 20;</code>
     * @param bool $var
     * @return $this
     */
    public function setUsedIfRouteIsEmpty($var)
    {
        GPBUtil::checkBool($var);
        $this->used_if_route_is_empty = $var;

        return $this;
    }

    /**
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     * @return \Google\Maps\RouteOptimization\V1\Vehicle\DurationLimit|null
     */
    public function getRouteDurationLimit()
    {
        return $this->route_duration_limit;
    }

    public function hasRouteDurationLimit()
    {
        return isset($this->route_duration_limit);
    }

    public function clearRouteDurationLimit()
    {
        unset($this->route_duration_limit);
    }

    /**
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     * @param \Google\Maps\RouteOptimization\V1\Vehicle\DurationLimit $var
     * @return $this
     */
    public function setRouteDurationLimit($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\RouteOptimization\V1\Vehicle\DurationLimit::class);
        $this->route_duration_limit = $var;

        return $this;
    }

    /**
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_duration].
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     * @return \Google\Maps\RouteOptimization\V1\Vehicle\DurationLimit|null
     */
    public function getTravelDurationLimit()
    {
        return $this->travel_duration_limit;
    }

    public function hasTravelDurationLimit()
    {
        return isset($this->travel_duration_limit);
    }

    public function clearTravelDurationLimit()
    {
        unset($this->travel_duration_limit);
    }

    /**
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_duration].
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     * @param \Google\Maps\RouteOptimization\V1\Vehicle\DurationLimit $var
     * @return $this
     */
    public function setTravelDurationLimit($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\RouteOptimization\V1\Vehicle\DurationLimit::class);
        $this->travel_duration_limit = $var;

        return $this;
    }

    /**
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.DistanceLimit route_distance_limit = 23;</code>
     * @return \Google\Maps\RouteOptimization\V1\DistanceLimit|null
     */
    public function getRouteDistanceLimit()
    {
        return $this->route_distance_limit;
    }

    public function hasRouteDistanceLimit()
    {
        return isset($this->route_distance_limit);
    }

    public function clearRouteDistanceLimit()
    {
        unset($this->route_distance_limit);
    }

    /**
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.DistanceLimit route_distance_limit = 23;</code>
     * @param \Google\Maps\RouteOptimization\V1\DistanceLimit $var
     * @return $this
     */
    public function setRouteDistanceLimit($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\RouteOptimization\V1\DistanceLimit::class);
        $this->route_distance_limit = $var;

        return $this;
    }

    /**
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.maps.routeoptimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Duration> extra_visit_duration_for_visit_type = 24;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getExtraVisitDurationForVisitType()
    {
        return $this->extra_visit_duration_for_visit_type;
    }

    /**
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.maps.routeoptimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Duration> extra_visit_duration_for_visit_type = 24;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setExtraVisitDurationForVisitType($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Duration::class);
        $this->extra_visit_duration_for_visit_type = $arr;

        return $this;
    }

    /**
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.BreakRule break_rule = 25;</code>
     * @return \Google\Maps\RouteOptimization\V1\BreakRule|null
     */
    public function getBreakRule()
    {
        return $this->break_rule;
    }

    public function hasBreakRule()
    {
        return isset($this->break_rule);
    }

    public function clearBreakRule()
    {
        unset($this->break_rule);
    }

    /**
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.BreakRule break_rule = 25;</code>
     * @param \Google\Maps\RouteOptimization\V1\BreakRule $var
     * @return $this
     */
    public function setBreakRule($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\RouteOptimization\V1\BreakRule::class);
        $this->break_rule = $var;

        return $this;
    }

    /**
     * Specifies a label for this vehicle. This label is reported in the response
     * as the `vehicle_label` of the corresponding
     * [ShipmentRoute][google.maps.routeoptimization.v1.ShipmentRoute].
     *
     * Generated from protobuf field <code>string label = 27;</code>
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Specifies a label for this vehicle. This label is reported in the response
     * as the `vehicle_label` of the corresponding
     * [ShipmentRoute][google.maps.routeoptimization.v1.ShipmentRoute].
     *
     * Generated from protobuf field <code>string label = 27;</code>
     * @param string $var
     * @return $this
     */
    public function setLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->label = $var;

        return $this;
    }

    /**
     * If true, `used_if_route_is_empty` must be false, and this vehicle will
     * remain unused.
     * If a shipment is performed by an ignored vehicle in
     * `injected_first_solution_routes`, it is skipped in the first solution but
     * is free to be performed in the response.
     * If a shipment is performed by an ignored vehicle in
     * `injected_solution_constraint` and any related pickup/delivery is
     * constrained to remain on the vehicle (i.e., not relaxed to level
     * `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
     * If a shipment has a non-empty `allowed_vehicle_indices` field and all of
     * the allowed vehicles are ignored, it is skipped in the response.
     *
     * Generated from protobuf field <code>bool ignore = 28;</code>
     * @return bool
     */
    public function getIgnore()
    {
        return $this->ignore;
    }

    /**
     * If true, `used_if_route_is_empty` must be false, and this vehicle will
     * remain unused.
     * If a shipment is performed by an ignored vehicle in
     * `injected_first_solution_routes`, it is skipped in the first solution but
     * is free to be performed in the response.
     * If a shipment is performed by an ignored vehicle in
     * `injected_solution_constraint` and any related pickup/delivery is
     * constrained to remain on the vehicle (i.e., not relaxed to level
     * `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
     * If a shipment has a non-empty `allowed_vehicle_indices` field and all of
     * the allowed vehicles are ignored, it is skipped in the response.
     *
     * Generated from protobuf field <code>bool ignore = 28;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnore($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore = $var;

        return $this;
    }

}

