<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/billing/v1/cloud_billing.proto

namespace Google\Cloud\Billing\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for `CreateBillingAccount`.
 *
 * Generated from protobuf message <code>google.cloud.billing.v1.CreateBillingAccountRequest</code>
 */
class CreateBillingAccountRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The billing account resource to create.
     * Currently CreateBillingAccount only supports subaccount creation, so
     * any created billing accounts must be under a provided parent billing
     * account.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.BillingAccount billing_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $billing_account = null;
    /**
     * Optional. The parent to create a billing account from.
     * Format:
     *   - `billingAccounts/{billing_account_id}`, for example,
     *      `billingAccounts/012345-567890-ABCDEF`
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $parent = '';

    /**
     * @param \Google\Cloud\Billing\V1\BillingAccount $billingAccount Required. The billing account resource to create.
     *                                                                Currently CreateBillingAccount only supports subaccount creation, so
     *                                                                any created billing accounts must be under a provided parent billing
     *                                                                account.
     *
     * @return \Google\Cloud\Billing\V1\CreateBillingAccountRequest
     *
     * @experimental
     */
    public static function build(\Google\Cloud\Billing\V1\BillingAccount $billingAccount): self
    {
        return (new self())
            ->setBillingAccount($billingAccount);
    }

    /**
     * @param \Google\Cloud\Billing\V1\BillingAccount $billingAccount Required. The billing account resource to create.
     *                                                                Currently CreateBillingAccount only supports subaccount creation, so
     *                                                                any created billing accounts must be under a provided parent billing
     *                                                                account.
     * @param string                                  $parent         Optional. The parent to create a billing account from.
     *                                                                Format:
     *                                                                - `billingAccounts/{billing_account_id}`, for example,
     *                                                                `billingAccounts/012345-567890-ABCDEF`
     *
     * @return \Google\Cloud\Billing\V1\CreateBillingAccountRequest
     *
     * @experimental
     */
    public static function buildFromBillingAccountParent(\Google\Cloud\Billing\V1\BillingAccount $billingAccount, string $parent): self
    {
        return (new self())
            ->setBillingAccount($billingAccount)
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Billing\V1\BillingAccount $billing_account
     *           Required. The billing account resource to create.
     *           Currently CreateBillingAccount only supports subaccount creation, so
     *           any created billing accounts must be under a provided parent billing
     *           account.
     *     @type string $parent
     *           Optional. The parent to create a billing account from.
     *           Format:
     *             - `billingAccounts/{billing_account_id}`, for example,
     *                `billingAccounts/012345-567890-ABCDEF`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Billing\V1\CloudBilling::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The billing account resource to create.
     * Currently CreateBillingAccount only supports subaccount creation, so
     * any created billing accounts must be under a provided parent billing
     * account.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.BillingAccount billing_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Billing\V1\BillingAccount|null
     */
    public function getBillingAccount()
    {
        return $this->billing_account;
    }

    public function hasBillingAccount()
    {
        return isset($this->billing_account);
    }

    public function clearBillingAccount()
    {
        unset($this->billing_account);
    }

    /**
     * Required. The billing account resource to create.
     * Currently CreateBillingAccount only supports subaccount creation, so
     * any created billing accounts must be under a provided parent billing
     * account.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.BillingAccount billing_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Billing\V1\BillingAccount $var
     * @return $this
     */
    public function setBillingAccount($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Billing\V1\BillingAccount::class);
        $this->billing_account = $var;

        return $this;
    }

    /**
     * Optional. The parent to create a billing account from.
     * Format:
     *   - `billingAccounts/{billing_account_id}`, for example,
     *      `billingAccounts/012345-567890-ABCDEF`
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Optional. The parent to create a billing account from.
     * Format:
     *   - `billingAccounts/{billing_account_id}`, for example,
     *      `billingAccounts/012345-567890-ABCDEF`
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

}

