<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/videointelligence/v1/video_intelligence.proto

namespace Google\Cloud\VideoIntelligence\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Annotations corresponding to one tracked object.
 *
 * Generated from protobuf message <code>google.cloud.videointelligence.v1.ObjectTrackingAnnotation</code>
 */
class ObjectTrackingAnnotation extends \Google\Protobuf\Internal\Message
{
    /**
     * Entity to specify the object category that this track is labeled as.
     *
     * Generated from protobuf field <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     */
    private $entity = null;
    /**
     * Object category's labeling confidence of this track.
     *
     * Generated from protobuf field <code>float confidence = 4;</code>
     */
    private $confidence = 0.0;
    /**
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     *
     * Generated from protobuf field <code>repeated .google.cloud.videointelligence.v1.ObjectTrackingFrame frames = 2;</code>
     */
    private $frames;
    protected $track_info;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\VideoIntelligence\V1\VideoSegment $segment
     *           Non-streaming batch mode ONLY.
     *           Each object track corresponds to one video segment where it appears.
     *     @type int|string $track_id
     *           Streaming mode ONLY.
     *           In streaming mode, we do not know the end time of a tracked object
     *           before it is completed. Hence, there is no VideoSegment info returned.
     *           Instead, we provide a unique identifiable integer track_id so that
     *           the customers can correlate the results of the ongoing
     *           ObjectTrackAnnotation of the same track_id over time.
     *     @type \Google\Cloud\VideoIntelligence\V1\Entity $entity
     *           Entity to specify the object category that this track is labeled as.
     *     @type float $confidence
     *           Object category's labeling confidence of this track.
     *     @type \Google\Cloud\VideoIntelligence\V1\ObjectTrackingFrame[]|\Google\Protobuf\Internal\RepeatedField $frames
     *           Information corresponding to all frames where this object track appears.
     *           Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     *           messages in frames.
     *           Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Videointelligence\V1\VideoIntelligence::initOnce();
        parent::__construct($data);
    }

    /**
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     *
     * Generated from protobuf field <code>.google.cloud.videointelligence.v1.VideoSegment segment = 3;</code>
     * @return \Google\Cloud\VideoIntelligence\V1\VideoSegment
     */
    public function getSegment()
    {
        return $this->readOneof(3);
    }

    public function hasSegment()
    {
        return $this->hasOneof(3);
    }

    /**
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     *
     * Generated from protobuf field <code>.google.cloud.videointelligence.v1.VideoSegment segment = 3;</code>
     * @param \Google\Cloud\VideoIntelligence\V1\VideoSegment $var
     * @return $this
     */
    public function setSegment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VideoIntelligence\V1\VideoSegment::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Streaming mode ONLY.
     * In streaming mode, we do not know the end time of a tracked object
     * before it is completed. Hence, there is no VideoSegment info returned.
     * Instead, we provide a unique identifiable integer track_id so that
     * the customers can correlate the results of the ongoing
     * ObjectTrackAnnotation of the same track_id over time.
     *
     * Generated from protobuf field <code>int64 track_id = 5;</code>
     * @return int|string
     */
    public function getTrackId()
    {
        return $this->readOneof(5);
    }

    public function hasTrackId()
    {
        return $this->hasOneof(5);
    }

    /**
     * Streaming mode ONLY.
     * In streaming mode, we do not know the end time of a tracked object
     * before it is completed. Hence, there is no VideoSegment info returned.
     * Instead, we provide a unique identifiable integer track_id so that
     * the customers can correlate the results of the ongoing
     * ObjectTrackAnnotation of the same track_id over time.
     *
     * Generated from protobuf field <code>int64 track_id = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTrackId($var)
    {
        GPBUtil::checkInt64($var);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Entity to specify the object category that this track is labeled as.
     *
     * Generated from protobuf field <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     * @return \Google\Cloud\VideoIntelligence\V1\Entity
     */
    public function getEntity()
    {
        return isset($this->entity) ? $this->entity : null;
    }

    public function hasEntity()
    {
        return isset($this->entity);
    }

    public function clearEntity()
    {
        unset($this->entity);
    }

    /**
     * Entity to specify the object category that this track is labeled as.
     *
     * Generated from protobuf field <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     * @param \Google\Cloud\VideoIntelligence\V1\Entity $var
     * @return $this
     */
    public function setEntity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VideoIntelligence\V1\Entity::class);
        $this->entity = $var;

        return $this;
    }

    /**
     * Object category's labeling confidence of this track.
     *
     * Generated from protobuf field <code>float confidence = 4;</code>
     * @return float
     */
    public function getConfidence()
    {
        return $this->confidence;
    }

    /**
     * Object category's labeling confidence of this track.
     *
     * Generated from protobuf field <code>float confidence = 4;</code>
     * @param float $var
     * @return $this
     */
    public function setConfidence($var)
    {
        GPBUtil::checkFloat($var);
        $this->confidence = $var;

        return $this;
    }

    /**
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     *
     * Generated from protobuf field <code>repeated .google.cloud.videointelligence.v1.ObjectTrackingFrame frames = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFrames()
    {
        return $this->frames;
    }

    /**
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     *
     * Generated from protobuf field <code>repeated .google.cloud.videointelligence.v1.ObjectTrackingFrame frames = 2;</code>
     * @param \Google\Cloud\VideoIntelligence\V1\ObjectTrackingFrame[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFrames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VideoIntelligence\V1\ObjectTrackingFrame::class);
        $this->frames = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getTrackInfo()
    {
        return $this->whichOneof("track_info");
    }

}

