<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/support/v2beta/comment_service.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Support\V2beta\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Support\V2beta\Comment;
use Google\Cloud\Support\V2beta\CreateCommentRequest;
use Google\Cloud\Support\V2beta\GetCommentRequest;
use Google\Cloud\Support\V2beta\ListCommentsRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: A service to manage comments on cases.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @method PromiseInterface<Comment> createCommentAsync(CreateCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Comment> getCommentAsync(GetCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCommentsAsync(ListCommentsRequest $request, array $optionalArgs = [])
 */
final class CommentServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.support.v2beta.CommentService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'cloudsupport.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'cloudsupport.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/comment_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/comment_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/comment_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/comment_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a case
     * resource.
     *
     * @param string $organization
     * @param string $case
     *
     * @return string The formatted case resource.
     *
     * @experimental
     */
    public static function caseName(string $organization, string $case): string
    {
        return self::getPathTemplate('case')->render([
            'organization' => $organization,
            'case' => $case,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a comment
     * resource.
     *
     * @param string $organization
     * @param string $case
     * @param string $comment
     *
     * @return string The formatted comment resource.
     *
     * @experimental
     */
    public static function commentName(string $organization, string $case, string $comment): string
    {
        return self::getPathTemplate('comment')->render([
            'organization' => $organization,
            'case' => $case,
            'comment' => $comment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_case resource.
     *
     * @param string $organization
     * @param string $case
     *
     * @return string The formatted organization_case resource.
     *
     * @experimental
     */
    public static function organizationCaseName(string $organization, string $case): string
    {
        return self::getPathTemplate('organizationCase')->render([
            'organization' => $organization,
            'case' => $case,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_case_comment resource.
     *
     * @param string $organization
     * @param string $case
     * @param string $comment
     *
     * @return string The formatted organization_case_comment resource.
     *
     * @experimental
     */
    public static function organizationCaseCommentName(string $organization, string $case, string $comment): string
    {
        return self::getPathTemplate('organizationCaseComment')->render([
            'organization' => $organization,
            'case' => $case,
            'comment' => $comment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project_case
     * resource.
     *
     * @param string $project
     * @param string $case
     *
     * @return string The formatted project_case resource.
     *
     * @experimental
     */
    public static function projectCaseName(string $project, string $case): string
    {
        return self::getPathTemplate('projectCase')->render([
            'project' => $project,
            'case' => $case,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_case_comment resource.
     *
     * @param string $project
     * @param string $case
     * @param string $comment
     *
     * @return string The formatted project_case_comment resource.
     *
     * @experimental
     */
    public static function projectCaseCommentName(string $project, string $case, string $comment): string
    {
        return self::getPathTemplate('projectCaseComment')->render([
            'project' => $project,
            'case' => $case,
            'comment' => $comment,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - case: organizations/{organization}/cases/{case}
     * - comment: organizations/{organization}/cases/{case}/comments/{comment}
     * - organizationCase: organizations/{organization}/cases/{case}
     * - organizationCaseComment: organizations/{organization}/cases/{case}/comments/{comment}
     * - projectCase: projects/{project}/cases/{case}
     * - projectCaseComment: projects/{project}/cases/{case}/comments/{comment}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudsupport.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Support\V2beta\CommentServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new CommentServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Add a new comment to a case.
     *
     * The comment must have the following fields set: `body`.
     *
     * The async variant is {@see CommentServiceClient::createCommentAsync()} .
     *
     * @example samples/V2beta/CommentServiceClient/create_comment.php
     *
     * @param CreateCommentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Comment
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createComment(CreateCommentRequest $request, array $callOptions = []): Comment
    {
        return $this->startApiCall('CreateComment', $request, $callOptions)->wait();
    }

    /**
     * Retrieve a comment.
     *
     * The async variant is {@see CommentServiceClient::getCommentAsync()} .
     *
     * @example samples/V2beta/CommentServiceClient/get_comment.php
     *
     * @param GetCommentRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Comment
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getComment(GetCommentRequest $request, array $callOptions = []): Comment
    {
        return $this->startApiCall('GetComment', $request, $callOptions)->wait();
    }

    /**
     * List all the comments associated with a case.
     *
     * The async variant is {@see CommentServiceClient::listCommentsAsync()} .
     *
     * @example samples/V2beta/CommentServiceClient/list_comments.php
     *
     * @param ListCommentsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listComments(ListCommentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListComments', $request, $callOptions);
    }
}
