<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1/cloud_sql_resources.proto

namespace Google\Cloud\Sql\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The read pool auto-scale configuration.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1.ReadPoolAutoScaleConfig</code>
 */
class ReadPoolAutoScaleConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Indicates whether read pool auto scaling is enabled.
     *
     * Generated from protobuf field <code>optional bool enabled = 1;</code>
     */
    protected $enabled = null;
    /**
     * Minimum number of read pool nodes to be maintained.
     *
     * Generated from protobuf field <code>optional int32 min_node_count = 2;</code>
     */
    protected $min_node_count = null;
    /**
     * Maximum number of read pool nodes to be maintained.
     *
     * Generated from protobuf field <code>optional int32 max_node_count = 3;</code>
     */
    protected $max_node_count = null;
    /**
     * Optional. Target metrics for read pool auto scaling.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.ReadPoolAutoScaleConfig.TargetMetric target_metrics = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $target_metrics;
    /**
     * Indicates whether read pool auto scaling supports scale in operations
     * (removing nodes).
     *
     * Generated from protobuf field <code>optional bool disable_scale_in = 5;</code>
     */
    protected $disable_scale_in = null;
    /**
     * The cooldown period for scale-in operations.
     *
     * Generated from protobuf field <code>optional int32 scale_in_cooldown_seconds = 6;</code>
     */
    protected $scale_in_cooldown_seconds = null;
    /**
     * The cooldown period for scale-out operations.
     *
     * Generated from protobuf field <code>optional int32 scale_out_cooldown_seconds = 7;</code>
     */
    protected $scale_out_cooldown_seconds = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enabled
     *           Indicates whether read pool auto scaling is enabled.
     *     @type int $min_node_count
     *           Minimum number of read pool nodes to be maintained.
     *     @type int $max_node_count
     *           Maximum number of read pool nodes to be maintained.
     *     @type array<\Google\Cloud\Sql\V1\ReadPoolAutoScaleConfig\TargetMetric>|\Google\Protobuf\Internal\RepeatedField $target_metrics
     *           Optional. Target metrics for read pool auto scaling.
     *     @type bool $disable_scale_in
     *           Indicates whether read pool auto scaling supports scale in operations
     *           (removing nodes).
     *     @type int $scale_in_cooldown_seconds
     *           The cooldown period for scale-in operations.
     *     @type int $scale_out_cooldown_seconds
     *           The cooldown period for scale-out operations.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1\CloudSqlResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Indicates whether read pool auto scaling is enabled.
     *
     * Generated from protobuf field <code>optional bool enabled = 1;</code>
     * @return bool
     */
    public function getEnabled()
    {
        return isset($this->enabled) ? $this->enabled : false;
    }

    public function hasEnabled()
    {
        return isset($this->enabled);
    }

    public function clearEnabled()
    {
        unset($this->enabled);
    }

    /**
     * Indicates whether read pool auto scaling is enabled.
     *
     * Generated from protobuf field <code>optional bool enabled = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->enabled = $var;

        return $this;
    }

    /**
     * Minimum number of read pool nodes to be maintained.
     *
     * Generated from protobuf field <code>optional int32 min_node_count = 2;</code>
     * @return int
     */
    public function getMinNodeCount()
    {
        return isset($this->min_node_count) ? $this->min_node_count : 0;
    }

    public function hasMinNodeCount()
    {
        return isset($this->min_node_count);
    }

    public function clearMinNodeCount()
    {
        unset($this->min_node_count);
    }

    /**
     * Minimum number of read pool nodes to be maintained.
     *
     * Generated from protobuf field <code>optional int32 min_node_count = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setMinNodeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->min_node_count = $var;

        return $this;
    }

    /**
     * Maximum number of read pool nodes to be maintained.
     *
     * Generated from protobuf field <code>optional int32 max_node_count = 3;</code>
     * @return int
     */
    public function getMaxNodeCount()
    {
        return isset($this->max_node_count) ? $this->max_node_count : 0;
    }

    public function hasMaxNodeCount()
    {
        return isset($this->max_node_count);
    }

    public function clearMaxNodeCount()
    {
        unset($this->max_node_count);
    }

    /**
     * Maximum number of read pool nodes to be maintained.
     *
     * Generated from protobuf field <code>optional int32 max_node_count = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxNodeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_node_count = $var;

        return $this;
    }

    /**
     * Optional. Target metrics for read pool auto scaling.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.ReadPoolAutoScaleConfig.TargetMetric target_metrics = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTargetMetrics()
    {
        return $this->target_metrics;
    }

    /**
     * Optional. Target metrics for read pool auto scaling.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.ReadPoolAutoScaleConfig.TargetMetric target_metrics = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Sql\V1\ReadPoolAutoScaleConfig\TargetMetric>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTargetMetrics($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Sql\V1\ReadPoolAutoScaleConfig\TargetMetric::class);
        $this->target_metrics = $arr;

        return $this;
    }

    /**
     * Indicates whether read pool auto scaling supports scale in operations
     * (removing nodes).
     *
     * Generated from protobuf field <code>optional bool disable_scale_in = 5;</code>
     * @return bool
     */
    public function getDisableScaleIn()
    {
        return isset($this->disable_scale_in) ? $this->disable_scale_in : false;
    }

    public function hasDisableScaleIn()
    {
        return isset($this->disable_scale_in);
    }

    public function clearDisableScaleIn()
    {
        unset($this->disable_scale_in);
    }

    /**
     * Indicates whether read pool auto scaling supports scale in operations
     * (removing nodes).
     *
     * Generated from protobuf field <code>optional bool disable_scale_in = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableScaleIn($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_scale_in = $var;

        return $this;
    }

    /**
     * The cooldown period for scale-in operations.
     *
     * Generated from protobuf field <code>optional int32 scale_in_cooldown_seconds = 6;</code>
     * @return int
     */
    public function getScaleInCooldownSeconds()
    {
        return isset($this->scale_in_cooldown_seconds) ? $this->scale_in_cooldown_seconds : 0;
    }

    public function hasScaleInCooldownSeconds()
    {
        return isset($this->scale_in_cooldown_seconds);
    }

    public function clearScaleInCooldownSeconds()
    {
        unset($this->scale_in_cooldown_seconds);
    }

    /**
     * The cooldown period for scale-in operations.
     *
     * Generated from protobuf field <code>optional int32 scale_in_cooldown_seconds = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setScaleInCooldownSeconds($var)
    {
        GPBUtil::checkInt32($var);
        $this->scale_in_cooldown_seconds = $var;

        return $this;
    }

    /**
     * The cooldown period for scale-out operations.
     *
     * Generated from protobuf field <code>optional int32 scale_out_cooldown_seconds = 7;</code>
     * @return int
     */
    public function getScaleOutCooldownSeconds()
    {
        return isset($this->scale_out_cooldown_seconds) ? $this->scale_out_cooldown_seconds : 0;
    }

    public function hasScaleOutCooldownSeconds()
    {
        return isset($this->scale_out_cooldown_seconds);
    }

    public function clearScaleOutCooldownSeconds()
    {
        unset($this->scale_out_cooldown_seconds);
    }

    /**
     * The cooldown period for scale-out operations.
     *
     * Generated from protobuf field <code>optional int32 scale_out_cooldown_seconds = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setScaleOutCooldownSeconds($var)
    {
        GPBUtil::checkInt32($var);
        $this->scale_out_cooldown_seconds = $var;

        return $this;
    }

}

