<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1/cloud_sql_backups.proto

namespace Google\Cloud\Sql\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A backup resource.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1.Backup</code>
 */
class Backup extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the backup.
     * Format: projects/{project}/backups/{backup}.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. This is always `sql#backup`.
     *
     * Generated from protobuf field <code>string kind = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $kind = '';
    /**
     * Output only. The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $self_link = '';
    /**
     * Output only. The type of this backup. The type can be "AUTOMATED",
     * "ON_DEMAND" or “FINAL”.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Backup.SqlBackupType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $type = 0;
    /**
     * The description of this backup.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     */
    protected $description = '';
    /**
     * The name of the source database instance.
     *
     * Generated from protobuf field <code>string instance = 6;</code>
     */
    protected $instance = '';
    /**
     * The storage location of the backups. The location can be multi-regional.
     *
     * Generated from protobuf field <code>string location = 7;</code>
     */
    protected $location = '';
    /**
     * Output only. This output contains the following values:
     * start_time: All database writes up to this time are available.
     * end_time: Any database writes after this time aren't available.
     *
     * Generated from protobuf field <code>.google.type.Interval backup_interval = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $backup_interval = null;
    /**
     * Output only. The status of this backup.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Backup.SqlBackupState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. Information about why the backup operation fails (for example,
     * when the backup state fails).
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.OperationError error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $error = null;
    /**
     * Output only. This output contains the encryption configuration for a backup
     * and the resource name of the KMS key for disk encryption.
     *
     * Generated from protobuf field <code>string kms_key = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $kms_key = '';
    /**
     * Output only. This output contains the encryption status for a backup and
     * the version of the KMS key that's used to encrypt the Cloud SQL instance.
     *
     * Generated from protobuf field <code>string kms_key_version = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $kms_key_version = '';
    /**
     * Output only. Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlBackupKind backup_kind = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $backup_kind = 0;
    /**
     * Output only. This output contains a backup time zone. If a Cloud SQL for
     * SQL Server instance has a different time zone from the backup's time zone,
     * then the restore to the instance doesn't happen.
     *
     * Generated from protobuf field <code>string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $time_zone = '';
    /**
     * Output only. The database version of the instance of at the time this
     * backup was made.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDatabaseVersion database_version = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $database_version = 0;
    /**
     * Output only. The maximum chargeable bytes for the backup.
     *
     * Generated from protobuf field <code>optional int64 max_chargeable_bytes = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $max_chargeable_bytes = null;
    /**
     * Optional. Output only. Timestamp in UTC of when the instance associated
     * with this backup is deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp instance_deletion_time = 24 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $instance_deletion_time = null;
    /**
     * Optional. Output only. The instance setting of the source instance that's
     * associated with this backup.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance instance_settings = 25 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $instance_settings = null;
    /**
     * Output only. The mapping to backup run resource used for IAM validations.
     *
     * Generated from protobuf field <code>string backup_run = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $backup_run = '';
    /**
     * Output only. This status indicates whether the backup satisfies PZS.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = null;
    /**
     * Output only. This status indicates whether the backup satisfies PZI.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzi = null;
    protected $expiration;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the backup.
     *           Format: projects/{project}/backups/{backup}.
     *     @type string $kind
     *           Output only. This is always `sql#backup`.
     *     @type string $self_link
     *           Output only. The URI of this resource.
     *     @type int $type
     *           Output only. The type of this backup. The type can be "AUTOMATED",
     *           "ON_DEMAND" or “FINAL”.
     *     @type string $description
     *           The description of this backup.
     *     @type string $instance
     *           The name of the source database instance.
     *     @type string $location
     *           The storage location of the backups. The location can be multi-regional.
     *     @type \Google\Type\Interval $backup_interval
     *           Output only. This output contains the following values:
     *           start_time: All database writes up to this time are available.
     *           end_time: Any database writes after this time aren't available.
     *     @type int $state
     *           Output only. The status of this backup.
     *     @type \Google\Cloud\Sql\V1\OperationError $error
     *           Output only. Information about why the backup operation fails (for example,
     *           when the backup state fails).
     *     @type string $kms_key
     *           Output only. This output contains the encryption configuration for a backup
     *           and the resource name of the KMS key for disk encryption.
     *     @type string $kms_key_version
     *           Output only. This output contains the encryption status for a backup and
     *           the version of the KMS key that's used to encrypt the Cloud SQL instance.
     *     @type int $backup_kind
     *           Output only. Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
     *     @type string $time_zone
     *           Output only. This output contains a backup time zone. If a Cloud SQL for
     *           SQL Server instance has a different time zone from the backup's time zone,
     *           then the restore to the instance doesn't happen.
     *     @type int|string $ttl_days
     *           Input only. The time-to-live (TTL) interval for this resource (in days).
     *           For example: ttlDays:7, means 7 days from the current time. The
     *           expiration time can't exceed 365 days from the time that the backup is
     *           created.
     *     @type \Google\Protobuf\Timestamp $expiry_time
     *           Backup expiration time.
     *           A UTC timestamp of when this backup expired.
     *     @type int $database_version
     *           Output only. The database version of the instance of at the time this
     *           backup was made.
     *     @type int|string $max_chargeable_bytes
     *           Output only. The maximum chargeable bytes for the backup.
     *     @type \Google\Protobuf\Timestamp $instance_deletion_time
     *           Optional. Output only. Timestamp in UTC of when the instance associated
     *           with this backup is deleted.
     *     @type \Google\Cloud\Sql\V1\DatabaseInstance $instance_settings
     *           Optional. Output only. The instance setting of the source instance that's
     *           associated with this backup.
     *     @type string $backup_run
     *           Output only. The mapping to backup run resource used for IAM validations.
     *     @type \Google\Protobuf\BoolValue $satisfies_pzs
     *           Output only. This status indicates whether the backup satisfies PZS.
     *           The status is reserved for future use.
     *     @type \Google\Protobuf\BoolValue $satisfies_pzi
     *           Output only. This status indicates whether the backup satisfies PZI.
     *           The status is reserved for future use.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1\CloudSqlBackups::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the backup.
     * Format: projects/{project}/backups/{backup}.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the backup.
     * Format: projects/{project}/backups/{backup}.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. This is always `sql#backup`.
     *
     * Generated from protobuf field <code>string kind = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * Output only. This is always `sql#backup`.
     *
     * Generated from protobuf field <code>string kind = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Output only. The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * Output only. The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Output only. The type of this backup. The type can be "AUTOMATED",
     * "ON_DEMAND" or “FINAL”.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Backup.SqlBackupType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Output only. The type of this backup. The type can be "AUTOMATED",
     * "ON_DEMAND" or “FINAL”.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Backup.SqlBackupType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\Backup\SqlBackupType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * The description of this backup.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * The description of this backup.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * The name of the source database instance.
     *
     * Generated from protobuf field <code>string instance = 6;</code>
     * @return string
     */
    public function getInstance()
    {
        return $this->instance;
    }

    /**
     * The name of the source database instance.
     *
     * Generated from protobuf field <code>string instance = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance = $var;

        return $this;
    }

    /**
     * The storage location of the backups. The location can be multi-regional.
     *
     * Generated from protobuf field <code>string location = 7;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * The storage location of the backups. The location can be multi-regional.
     *
     * Generated from protobuf field <code>string location = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * Output only. This output contains the following values:
     * start_time: All database writes up to this time are available.
     * end_time: Any database writes after this time aren't available.
     *
     * Generated from protobuf field <code>.google.type.Interval backup_interval = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Type\Interval|null
     */
    public function getBackupInterval()
    {
        return $this->backup_interval;
    }

    public function hasBackupInterval()
    {
        return isset($this->backup_interval);
    }

    public function clearBackupInterval()
    {
        unset($this->backup_interval);
    }

    /**
     * Output only. This output contains the following values:
     * start_time: All database writes up to this time are available.
     * end_time: Any database writes after this time aren't available.
     *
     * Generated from protobuf field <code>.google.type.Interval backup_interval = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setBackupInterval($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->backup_interval = $var;

        return $this;
    }

    /**
     * Output only. The status of this backup.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Backup.SqlBackupState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The status of this backup.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Backup.SqlBackupState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\Backup\SqlBackupState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Information about why the backup operation fails (for example,
     * when the backup state fails).
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.OperationError error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Sql\V1\OperationError|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * Output only. Information about why the backup operation fails (for example,
     * when the backup state fails).
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.OperationError error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Sql\V1\OperationError $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\OperationError::class);
        $this->error = $var;

        return $this;
    }

    /**
     * Output only. This output contains the encryption configuration for a backup
     * and the resource name of the KMS key for disk encryption.
     *
     * Generated from protobuf field <code>string kms_key = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getKmsKey()
    {
        return $this->kms_key;
    }

    /**
     * Output only. This output contains the encryption configuration for a backup
     * and the resource name of the KMS key for disk encryption.
     *
     * Generated from protobuf field <code>string kms_key = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key = $var;

        return $this;
    }

    /**
     * Output only. This output contains the encryption status for a backup and
     * the version of the KMS key that's used to encrypt the Cloud SQL instance.
     *
     * Generated from protobuf field <code>string kms_key_version = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getKmsKeyVersion()
    {
        return $this->kms_key_version;
    }

    /**
     * Output only. This output contains the encryption status for a backup and
     * the version of the KMS key that's used to encrypt the Cloud SQL instance.
     *
     * Generated from protobuf field <code>string kms_key_version = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_version = $var;

        return $this;
    }

    /**
     * Output only. Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlBackupKind backup_kind = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getBackupKind()
    {
        return $this->backup_kind;
    }

    /**
     * Output only. Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlBackupKind backup_kind = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setBackupKind($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlBackupKind::class);
        $this->backup_kind = $var;

        return $this;
    }

    /**
     * Output only. This output contains a backup time zone. If a Cloud SQL for
     * SQL Server instance has a different time zone from the backup's time zone,
     * then the restore to the instance doesn't happen.
     *
     * Generated from protobuf field <code>string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * Output only. This output contains a backup time zone. If a Cloud SQL for
     * SQL Server instance has a different time zone from the backup's time zone,
     * then the restore to the instance doesn't happen.
     *
     * Generated from protobuf field <code>string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * Input only. The time-to-live (TTL) interval for this resource (in days).
     * For example: ttlDays:7, means 7 days from the current time. The
     * expiration time can't exceed 365 days from the time that the backup is
     * created.
     *
     * Generated from protobuf field <code>int64 ttl_days = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int|string
     */
    public function getTtlDays()
    {
        return $this->readOneof(16);
    }

    public function hasTtlDays()
    {
        return $this->hasOneof(16);
    }

    /**
     * Input only. The time-to-live (TTL) interval for this resource (in days).
     * For example: ttlDays:7, means 7 days from the current time. The
     * expiration time can't exceed 365 days from the time that the backup is
     * created.
     *
     * Generated from protobuf field <code>int64 ttl_days = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setTtlDays($var)
    {
        GPBUtil::checkInt64($var);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * Backup expiration time.
     * A UTC timestamp of when this backup expired.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expiry_time = 17;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpiryTime()
    {
        return $this->readOneof(17);
    }

    public function hasExpiryTime()
    {
        return $this->hasOneof(17);
    }

    /**
     * Backup expiration time.
     * A UTC timestamp of when this backup expired.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expiry_time = 17;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpiryTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * Output only. The database version of the instance of at the time this
     * backup was made.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDatabaseVersion database_version = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getDatabaseVersion()
    {
        return $this->database_version;
    }

    /**
     * Output only. The database version of the instance of at the time this
     * backup was made.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDatabaseVersion database_version = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDatabaseVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlDatabaseVersion::class);
        $this->database_version = $var;

        return $this;
    }

    /**
     * Output only. The maximum chargeable bytes for the backup.
     *
     * Generated from protobuf field <code>optional int64 max_chargeable_bytes = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getMaxChargeableBytes()
    {
        return isset($this->max_chargeable_bytes) ? $this->max_chargeable_bytes : 0;
    }

    public function hasMaxChargeableBytes()
    {
        return isset($this->max_chargeable_bytes);
    }

    public function clearMaxChargeableBytes()
    {
        unset($this->max_chargeable_bytes);
    }

    /**
     * Output only. The maximum chargeable bytes for the backup.
     *
     * Generated from protobuf field <code>optional int64 max_chargeable_bytes = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMaxChargeableBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->max_chargeable_bytes = $var;

        return $this;
    }

    /**
     * Optional. Output only. Timestamp in UTC of when the instance associated
     * with this backup is deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp instance_deletion_time = 24 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getInstanceDeletionTime()
    {
        return $this->instance_deletion_time;
    }

    public function hasInstanceDeletionTime()
    {
        return isset($this->instance_deletion_time);
    }

    public function clearInstanceDeletionTime()
    {
        unset($this->instance_deletion_time);
    }

    /**
     * Optional. Output only. Timestamp in UTC of when the instance associated
     * with this backup is deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp instance_deletion_time = 24 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setInstanceDeletionTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->instance_deletion_time = $var;

        return $this;
    }

    /**
     * Optional. Output only. The instance setting of the source instance that's
     * associated with this backup.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance instance_settings = 25 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Sql\V1\DatabaseInstance|null
     */
    public function getInstanceSettings()
    {
        return $this->instance_settings;
    }

    public function hasInstanceSettings()
    {
        return isset($this->instance_settings);
    }

    public function clearInstanceSettings()
    {
        unset($this->instance_settings);
    }

    /**
     * Optional. Output only. The instance setting of the source instance that's
     * associated with this backup.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance instance_settings = 25 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Sql\V1\DatabaseInstance $var
     * @return $this
     */
    public function setInstanceSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\DatabaseInstance::class);
        $this->instance_settings = $var;

        return $this;
    }

    /**
     * Output only. The mapping to backup run resource used for IAM validations.
     *
     * Generated from protobuf field <code>string backup_run = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getBackupRun()
    {
        return $this->backup_run;
    }

    /**
     * Output only. The mapping to backup run resource used for IAM validations.
     *
     * Generated from protobuf field <code>string backup_run = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setBackupRun($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_run = $var;

        return $this;
    }

    /**
     * Output only. This status indicates whether the backup satisfies PZS.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * Returns the unboxed value from <code>getSatisfiesPzs()</code>

     * Output only. This status indicates whether the backup satisfies PZS.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool|null
     */
    public function getSatisfiesPzsUnwrapped()
    {
        return $this->readWrapperValue("satisfies_pzs");
    }

    /**
     * Output only. This status indicates whether the backup satisfies PZS.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Output only. This status indicates whether the backup satisfies PZS.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool|null $var
     * @return $this
     */
    public function setSatisfiesPzsUnwrapped($var)
    {
        $this->writeWrapperValue("satisfies_pzs", $var);
        return $this;}

    /**
     * Output only. This status indicates whether the backup satisfies PZI.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getSatisfiesPzi()
    {
        return $this->satisfies_pzi;
    }

    public function hasSatisfiesPzi()
    {
        return isset($this->satisfies_pzi);
    }

    public function clearSatisfiesPzi()
    {
        unset($this->satisfies_pzi);
    }

    /**
     * Returns the unboxed value from <code>getSatisfiesPzi()</code>

     * Output only. This status indicates whether the backup satisfies PZI.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool|null
     */
    public function getSatisfiesPziUnwrapped()
    {
        return $this->readWrapperValue("satisfies_pzi");
    }

    /**
     * Output only. This status indicates whether the backup satisfies PZI.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Output only. This status indicates whether the backup satisfies PZI.
     * The status is reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool|null $var
     * @return $this
     */
    public function setSatisfiesPziUnwrapped($var)
    {
        $this->writeWrapperValue("satisfies_pzi", $var);
        return $this;}

    /**
     * @return string
     */
    public function getExpiration()
    {
        return $this->whichOneof("expiration");
    }

}

