<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/catalog.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Catalog level autocomplete config for customers to customize autocomplete
 * feature's settings.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.CompletionConfig</code>
 */
class CompletionConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $name = '';
    /**
     * Specifies the matching order for autocomplete suggestions, e.g., a query
     * consisting of 'sh' with 'out-of-order' specified would suggest "women's
     * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     * suggest "red shoes". Currently supported values:
     * * 'out-of-order'
     * * 'exact-prefix'
     * Default value: 'exact-prefix'.
     *
     * Generated from protobuf field <code>string matching_order = 2;</code>
     */
    protected $matching_order = '';
    /**
     * The maximum number of autocomplete suggestions returned per term. Default
     * value is 20. If left unset or set to 0, then will fallback to default
     * value.
     * Value range is 1 to 20.
     *
     * Generated from protobuf field <code>int32 max_suggestions = 3;</code>
     */
    protected $max_suggestions = 0;
    /**
     * The minimum number of characters needed to be typed in order to get
     * suggestions. Default value is 2. If left unset or set to 0, then will
     * fallback to default value.
     * Value range is 1 to 20.
     *
     * Generated from protobuf field <code>int32 min_prefix_length = 4;</code>
     */
    protected $min_prefix_length = 0;
    /**
     * If set to true, the auto learning function is enabled. Auto learning uses
     * user data to generate suggestions using ML techniques. Default value is
     * false. Only after enabling auto learning can users use `cloud-retail`
     * data in
     * [CompleteQueryRequest][google.cloud.retail.v2.CompleteQueryRequest].
     *
     * Generated from protobuf field <code>bool auto_learning = 11;</code>
     */
    protected $auto_learning = false;
    /**
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $suggestions_input_config = null;
    /**
     * Output only. Name of the LRO corresponding to the latest suggestion terms
     * list import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     * method to retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_suggestions_import_operation = '';
    /**
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $denylist_input_config = null;
    /**
     * Output only. Name of the LRO corresponding to the latest denylist import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_denylist_import_operation = '';
    /**
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $allowlist_input_config = null;
    /**
     * Output only. Name of the LRO corresponding to the latest allowlist import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_allowlist_import_operation = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Immutable. Fully qualified name
     *           `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     *     @type string $matching_order
     *           Specifies the matching order for autocomplete suggestions, e.g., a query
     *           consisting of 'sh' with 'out-of-order' specified would suggest "women's
     *           shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     *           suggest "red shoes". Currently supported values:
     *           * 'out-of-order'
     *           * 'exact-prefix'
     *           Default value: 'exact-prefix'.
     *     @type int $max_suggestions
     *           The maximum number of autocomplete suggestions returned per term. Default
     *           value is 20. If left unset or set to 0, then will fallback to default
     *           value.
     *           Value range is 1 to 20.
     *     @type int $min_prefix_length
     *           The minimum number of characters needed to be typed in order to get
     *           suggestions. Default value is 2. If left unset or set to 0, then will
     *           fallback to default value.
     *           Value range is 1 to 20.
     *     @type bool $auto_learning
     *           If set to true, the auto learning function is enabled. Auto learning uses
     *           user data to generate suggestions using ML techniques. Default value is
     *           false. Only after enabling auto learning can users use `cloud-retail`
     *           data in
     *           [CompleteQueryRequest][google.cloud.retail.v2.CompleteQueryRequest].
     *     @type \Google\Cloud\Retail\V2\CompletionDataInputConfig $suggestions_input_config
     *           Output only. The source data for the latest import of the autocomplete
     *           suggestion phrases.
     *     @type string $last_suggestions_import_operation
     *           Output only. Name of the LRO corresponding to the latest suggestion terms
     *           list import.
     *           Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     *           method to retrieve the latest state of the Long Running Operation.
     *     @type \Google\Cloud\Retail\V2\CompletionDataInputConfig $denylist_input_config
     *           Output only. The source data for the latest import of the autocomplete
     *           denylist phrases.
     *     @type string $last_denylist_import_operation
     *           Output only. Name of the LRO corresponding to the latest denylist import.
     *           Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     *           retrieve the latest state of the Long Running Operation.
     *     @type \Google\Cloud\Retail\V2\CompletionDataInputConfig $allowlist_input_config
     *           Output only. The source data for the latest import of the autocomplete
     *           allowlist phrases.
     *     @type string $last_allowlist_import_operation
     *           Output only. Name of the LRO corresponding to the latest allowlist import.
     *           Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     *           retrieve the latest state of the Long Running Operation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\Catalog::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Specifies the matching order for autocomplete suggestions, e.g., a query
     * consisting of 'sh' with 'out-of-order' specified would suggest "women's
     * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     * suggest "red shoes". Currently supported values:
     * * 'out-of-order'
     * * 'exact-prefix'
     * Default value: 'exact-prefix'.
     *
     * Generated from protobuf field <code>string matching_order = 2;</code>
     * @return string
     */
    public function getMatchingOrder()
    {
        return $this->matching_order;
    }

    /**
     * Specifies the matching order for autocomplete suggestions, e.g., a query
     * consisting of 'sh' with 'out-of-order' specified would suggest "women's
     * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     * suggest "red shoes". Currently supported values:
     * * 'out-of-order'
     * * 'exact-prefix'
     * Default value: 'exact-prefix'.
     *
     * Generated from protobuf field <code>string matching_order = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setMatchingOrder($var)
    {
        GPBUtil::checkString($var, True);
        $this->matching_order = $var;

        return $this;
    }

    /**
     * The maximum number of autocomplete suggestions returned per term. Default
     * value is 20. If left unset or set to 0, then will fallback to default
     * value.
     * Value range is 1 to 20.
     *
     * Generated from protobuf field <code>int32 max_suggestions = 3;</code>
     * @return int
     */
    public function getMaxSuggestions()
    {
        return $this->max_suggestions;
    }

    /**
     * The maximum number of autocomplete suggestions returned per term. Default
     * value is 20. If left unset or set to 0, then will fallback to default
     * value.
     * Value range is 1 to 20.
     *
     * Generated from protobuf field <code>int32 max_suggestions = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxSuggestions($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_suggestions = $var;

        return $this;
    }

    /**
     * The minimum number of characters needed to be typed in order to get
     * suggestions. Default value is 2. If left unset or set to 0, then will
     * fallback to default value.
     * Value range is 1 to 20.
     *
     * Generated from protobuf field <code>int32 min_prefix_length = 4;</code>
     * @return int
     */
    public function getMinPrefixLength()
    {
        return $this->min_prefix_length;
    }

    /**
     * The minimum number of characters needed to be typed in order to get
     * suggestions. Default value is 2. If left unset or set to 0, then will
     * fallback to default value.
     * Value range is 1 to 20.
     *
     * Generated from protobuf field <code>int32 min_prefix_length = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setMinPrefixLength($var)
    {
        GPBUtil::checkInt32($var);
        $this->min_prefix_length = $var;

        return $this;
    }

    /**
     * If set to true, the auto learning function is enabled. Auto learning uses
     * user data to generate suggestions using ML techniques. Default value is
     * false. Only after enabling auto learning can users use `cloud-retail`
     * data in
     * [CompleteQueryRequest][google.cloud.retail.v2.CompleteQueryRequest].
     *
     * Generated from protobuf field <code>bool auto_learning = 11;</code>
     * @return bool
     */
    public function getAutoLearning()
    {
        return $this->auto_learning;
    }

    /**
     * If set to true, the auto learning function is enabled. Auto learning uses
     * user data to generate suggestions using ML techniques. Default value is
     * false. Only after enabling auto learning can users use `cloud-retail`
     * data in
     * [CompleteQueryRequest][google.cloud.retail.v2.CompleteQueryRequest].
     *
     * Generated from protobuf field <code>bool auto_learning = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoLearning($var)
    {
        GPBUtil::checkBool($var);
        $this->auto_learning = $var;

        return $this;
    }

    /**
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Retail\V2\CompletionDataInputConfig|null
     */
    public function getSuggestionsInputConfig()
    {
        return $this->suggestions_input_config;
    }

    public function hasSuggestionsInputConfig()
    {
        return isset($this->suggestions_input_config);
    }

    public function clearSuggestionsInputConfig()
    {
        unset($this->suggestions_input_config);
    }

    /**
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Retail\V2\CompletionDataInputConfig $var
     * @return $this
     */
    public function setSuggestionsInputConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\CompletionDataInputConfig::class);
        $this->suggestions_input_config = $var;

        return $this;
    }

    /**
     * Output only. Name of the LRO corresponding to the latest suggestion terms
     * list import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     * method to retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastSuggestionsImportOperation()
    {
        return $this->last_suggestions_import_operation;
    }

    /**
     * Output only. Name of the LRO corresponding to the latest suggestion terms
     * list import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     * method to retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastSuggestionsImportOperation($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_suggestions_import_operation = $var;

        return $this;
    }

    /**
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Retail\V2\CompletionDataInputConfig|null
     */
    public function getDenylistInputConfig()
    {
        return $this->denylist_input_config;
    }

    public function hasDenylistInputConfig()
    {
        return isset($this->denylist_input_config);
    }

    public function clearDenylistInputConfig()
    {
        unset($this->denylist_input_config);
    }

    /**
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Retail\V2\CompletionDataInputConfig $var
     * @return $this
     */
    public function setDenylistInputConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\CompletionDataInputConfig::class);
        $this->denylist_input_config = $var;

        return $this;
    }

    /**
     * Output only. Name of the LRO corresponding to the latest denylist import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastDenylistImportOperation()
    {
        return $this->last_denylist_import_operation;
    }

    /**
     * Output only. Name of the LRO corresponding to the latest denylist import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastDenylistImportOperation($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_denylist_import_operation = $var;

        return $this;
    }

    /**
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Retail\V2\CompletionDataInputConfig|null
     */
    public function getAllowlistInputConfig()
    {
        return $this->allowlist_input_config;
    }

    public function hasAllowlistInputConfig()
    {
        return isset($this->allowlist_input_config);
    }

    public function clearAllowlistInputConfig()
    {
        unset($this->allowlist_input_config);
    }

    /**
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Retail\V2\CompletionDataInputConfig $var
     * @return $this
     */
    public function setAllowlistInputConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\CompletionDataInputConfig::class);
        $this->allowlist_input_config = $var;

        return $this;
    }

    /**
     * Output only. Name of the LRO corresponding to the latest allowlist import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastAllowlistImportOperation()
    {
        return $this->last_allowlist_import_operation;
    }

    /**
     * Output only. Name of the LRO corresponding to the latest allowlist import.
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     *
     * Generated from protobuf field <code>string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastAllowlistImportOperation($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_allowlist_import_operation = $var;

        return $this;
    }

}

