<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/os_policy_assignment_reports.proto

namespace Google\Cloud\OsConfig\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A report of the OS policy assignment status for a given instance.
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.OSPolicyAssignmentReport</code>
 */
class OSPolicyAssignmentReport extends \Google\Protobuf\Internal\Message
{
    /**
     * The `OSPolicyAssignmentReport` API resource name.
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The Compute Engine VM instance name.
     *
     * Generated from protobuf field <code>string instance = 2;</code>
     */
    protected $instance = '';
    /**
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     *
     * Generated from protobuf field <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = {</code>
     */
    protected $os_policy_assignment = '';
    /**
     * Compliance data for each `OSPolicy` that is applied to the VM.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;</code>
     */
    private $os_policy_compliances;
    /**
     * Timestamp for when the report was last generated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    protected $update_time = null;
    /**
     * Unique identifier of the last attempted run to apply the OS policies
     * associated with this assignment on the VM.
     * This ID is logged by the OS Config agent while applying the OS
     * policies associated with this assignment on the VM.
     * NOTE: If the service is unable to successfully connect to the agent for
     * this run, then this id will not be available in the agent logs.
     *
     * Generated from protobuf field <code>string last_run_id = 6;</code>
     */
    protected $last_run_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The `OSPolicyAssignmentReport` API resource name.
     *           Format:
     *           `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     *     @type string $instance
     *           The Compute Engine VM instance name.
     *     @type string $os_policy_assignment
     *           Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     *           belongs to.
     *           Format:
     *           `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     *     @type array<\Google\Cloud\OsConfig\V1\OSPolicyAssignmentReport\OSPolicyCompliance>|\Google\Protobuf\Internal\RepeatedField $os_policy_compliances
     *           Compliance data for each `OSPolicy` that is applied to the VM.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Timestamp for when the report was last generated.
     *     @type string $last_run_id
     *           Unique identifier of the last attempted run to apply the OS policies
     *           associated with this assignment on the VM.
     *           This ID is logged by the OS Config agent while applying the OS
     *           policies associated with this assignment on the VM.
     *           NOTE: If the service is unable to successfully connect to the agent for
     *           this run, then this id will not be available in the agent logs.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\OsPolicyAssignmentReports::initOnce();
        parent::__construct($data);
    }

    /**
     * The `OSPolicyAssignmentReport` API resource name.
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The `OSPolicyAssignmentReport` API resource name.
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The Compute Engine VM instance name.
     *
     * Generated from protobuf field <code>string instance = 2;</code>
     * @return string
     */
    public function getInstance()
    {
        return $this->instance;
    }

    /**
     * The Compute Engine VM instance name.
     *
     * Generated from protobuf field <code>string instance = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance = $var;

        return $this;
    }

    /**
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     *
     * Generated from protobuf field <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getOsPolicyAssignment()
    {
        return $this->os_policy_assignment;
    }

    /**
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     *
     * Generated from protobuf field <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setOsPolicyAssignment($var)
    {
        GPBUtil::checkString($var, True);
        $this->os_policy_assignment = $var;

        return $this;
    }

    /**
     * Compliance data for each `OSPolicy` that is applied to the VM.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOsPolicyCompliances()
    {
        return $this->os_policy_compliances;
    }

    /**
     * Compliance data for each `OSPolicy` that is applied to the VM.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;</code>
     * @param array<\Google\Cloud\OsConfig\V1\OSPolicyAssignmentReport\OSPolicyCompliance>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOsPolicyCompliances($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OsConfig\V1\OSPolicyAssignmentReport\OSPolicyCompliance::class);
        $this->os_policy_compliances = $arr;

        return $this;
    }

    /**
     * Timestamp for when the report was last generated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Timestamp for when the report was last generated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Unique identifier of the last attempted run to apply the OS policies
     * associated with this assignment on the VM.
     * This ID is logged by the OS Config agent while applying the OS
     * policies associated with this assignment on the VM.
     * NOTE: If the service is unable to successfully connect to the agent for
     * this run, then this id will not be available in the agent logs.
     *
     * Generated from protobuf field <code>string last_run_id = 6;</code>
     * @return string
     */
    public function getLastRunId()
    {
        return $this->last_run_id;
    }

    /**
     * Unique identifier of the last attempted run to apply the OS policies
     * associated with this assignment on the VM.
     * This ID is logged by the OS Config agent while applying the OS
     * policies associated with this assignment on the VM.
     * NOTE: If the service is unable to successfully connect to the agent for
     * this run, then this id will not be available in the agent logs.
     *
     * Generated from protobuf field <code>string last_run_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setLastRunId($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_run_id = $var;

        return $this;
    }

}

