<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/routeoptimization/v1/route_optimization_service.proto

namespace Google\Maps\RouteOptimization\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A shipment model contains a set of shipments which must be performed by a
 * set of vehicles, while minimizing the overall cost, which is the sum of:
 * * the cost of routing the vehicles (sum of cost per total time, cost per
 *   travel time, and fixed cost over all vehicles).
 * * the unperformed shipment penalties.
 * * the cost of the global duration of the shipments
 *
 * Generated from protobuf message <code>google.maps.routeoptimization.v1.ShipmentModel</code>
 */
class ShipmentModel extends \Google\Protobuf\Internal\Message
{
    /**
     * Set of shipments which must be performed in the model.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.Shipment shipments = 1;</code>
     */
    private $shipments;
    /**
     * Set of vehicles which can be used to perform visits.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.Vehicle vehicles = 2;</code>
     */
    private $vehicles;
    /**
     * The set of objectives for this model, that we will transform into costs.
     * If not empty, the input model has to be costless.
     * To obtain the modified request, please use `solving_mode` =
     * TRANSFORM_AND_RETURN_REQUEST. Note that the request will not
     * be solved in this case. See corresponding documentation.
     * Experimental: See
     * https://developers.google.com/maps/tt/route-optimization/experimental/objectives/make-request
     * for more details.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.Objective objectives = 17;</code>
     */
    private $objectives;
    /**
     * Constrains the maximum number of active vehicles. A vehicle is active if
     * its route performs at least one shipment. This can be used to limit the
     * number of routes in the case where there are fewer drivers than
     * vehicles and that the fleet of vehicles is heterogeneous. The optimization
     * will then select the best subset of vehicles to use.
     * Must be strictly positive.
     *
     * Generated from protobuf field <code>optional int32 max_active_vehicles = 4;</code>
     */
    protected $max_active_vehicles = null;
    /**
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     */
    protected $global_start_time = null;
    /**
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     */
    protected $global_end_time = null;
    /**
     * The "global duration" of the overall plan is the difference between the
     * earliest effective start time and the latest effective end time of
     * all vehicles. Users can assign a cost per hour to that quantity to try
     * and optimize for earliest job completion, for example. This cost must be in
     * the same unit as
     * [Shipment.penalty_cost][google.maps.routeoptimization.v1.Shipment.penalty_cost].
     *
     * Generated from protobuf field <code>double global_duration_cost_per_hour = 7;</code>
     */
    protected $global_duration_cost_per_hour = 0.0;
    /**
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;</code>
     */
    private $duration_distance_matrices;
    /**
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.maps.routeoptimization.v1.Shipment.VisitRequest.tags]
     * or
     * [Vehicle.start_tags][google.maps.routeoptimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     *
     * Generated from protobuf field <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     */
    private $duration_distance_matrix_src_tags;
    /**
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.maps.routeoptimization.v1.Shipment.VisitRequest.tags]
     * or
     * [Vehicle.start_tags][google.maps.routeoptimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     *
     * Generated from protobuf field <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     */
    private $duration_distance_matrix_dst_tags;
    /**
     * Transition attributes added to the model.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TransitionAttributes transition_attributes = 11;</code>
     */
    private $transition_attributes;
    /**
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;</code>
     */
    private $shipment_type_incompatibilities;
    /**
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;</code>
     */
    private $shipment_type_requirements;
    /**
     * Set of precedence rules which must be enforced in the model.
     * *IMPORTANT*: Use of precedence rules limits the size of problem that can be
     * optimized. Requests using precedence rules that include many shipments may
     * be rejected.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;</code>
     */
    private $precedence_rules;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<\Google\Maps\RouteOptimization\V1\Shipment>|\Google\Protobuf\Internal\RepeatedField $shipments
     *           Set of shipments which must be performed in the model.
     *     @type array<\Google\Maps\RouteOptimization\V1\Vehicle>|\Google\Protobuf\Internal\RepeatedField $vehicles
     *           Set of vehicles which can be used to perform visits.
     *     @type array<\Google\Maps\RouteOptimization\V1\ShipmentModel\Objective>|\Google\Protobuf\Internal\RepeatedField $objectives
     *           The set of objectives for this model, that we will transform into costs.
     *           If not empty, the input model has to be costless.
     *           To obtain the modified request, please use `solving_mode` =
     *           TRANSFORM_AND_RETURN_REQUEST. Note that the request will not
     *           be solved in this case. See corresponding documentation.
     *           Experimental: See
     *           https://developers.google.com/maps/tt/route-optimization/experimental/objectives/make-request
     *           for more details.
     *     @type int $max_active_vehicles
     *           Constrains the maximum number of active vehicles. A vehicle is active if
     *           its route performs at least one shipment. This can be used to limit the
     *           number of routes in the case where there are fewer drivers than
     *           vehicles and that the fleet of vehicles is heterogeneous. The optimization
     *           will then select the best subset of vehicles to use.
     *           Must be strictly positive.
     *     @type \Google\Protobuf\Timestamp $global_start_time
     *           Global start and end time of the model: no times outside of this range
     *           can be considered valid.
     *           The model's time span must be less than a year, i.e. the `global_end_time`
     *           and the `global_start_time` must be within 31536000 seconds of each other.
     *           When using `cost_per_*hour` fields, you might want to set this window to a
     *           smaller interval to increase performance (eg. if you model a single day,
     *           you should set the global time limits to that day).
     *           If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     *           as default.
     *     @type \Google\Protobuf\Timestamp $global_end_time
     *           If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     *           is used as default.
     *     @type float $global_duration_cost_per_hour
     *           The "global duration" of the overall plan is the difference between the
     *           earliest effective start time and the latest effective end time of
     *           all vehicles. Users can assign a cost per hour to that quantity to try
     *           and optimize for earliest job completion, for example. This cost must be in
     *           the same unit as
     *           [Shipment.penalty_cost][google.maps.routeoptimization.v1.Shipment.penalty_cost].
     *     @type array<\Google\Maps\RouteOptimization\V1\ShipmentModel\DurationDistanceMatrix>|\Google\Protobuf\Internal\RepeatedField $duration_distance_matrices
     *           Specifies duration and distance matrices used in the model. If this field
     *           is empty, Google Maps or geodesic distances will be used instead, depending
     *           on the value of the `use_geodesic_distances` field. If it is not empty,
     *           `use_geodesic_distances` cannot be true and neither
     *           `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     *           can be empty.
     *           Usage examples:
     *           * There are two locations: locA and locB.
     *           * 1 vehicle starting its route at locA and ending it at locA.
     *           * 1 pickup visit request at locB.
     *           ```
     *           model {
     *             vehicles { start_tags: "locA"  end_tags: "locA" }
     *             shipments { pickups { tags: "locB" } }
     *             duration_distance_matrix_src_tags: "locA"
     *             duration_distance_matrix_src_tags: "locB"
     *             duration_distance_matrix_dst_tags: "locA"
     *             duration_distance_matrix_dst_tags: "locB"
     *             duration_distance_matrices {
     *               rows {  # from: locA
     *                 durations { seconds: 0 }   meters: 0    # to: locA
     *                 durations { seconds: 100 } meters: 1000 # to: locB
     *               }
     *               rows {  # from: locB
     *                 durations { seconds: 102 } meters: 990 # to: locA
     *                 durations { seconds: 0 }   meters: 0   # to: locB
     *               }
     *             }
     *           }
     *           ```
     *           * There are three locations: locA, locB and locC.
     *           * 1 vehicle starting its route at locA and ending it at locB, using
     *             matrix "fast".
     *           * 1 vehicle starting its route at locB and ending it at locB, using
     *             matrix "slow".
     *           * 1 vehicle starting its route at locB and ending it at locB, using
     *             matrix "fast".
     *           * 1 pickup visit request at locC.
     *           ```
     *           model {
     *             vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *             vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *             vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *             shipments { pickups { tags: "locC" } }
     *             duration_distance_matrix_src_tags: "locA"
     *             duration_distance_matrix_src_tags: "locB"
     *             duration_distance_matrix_src_tags: "locC"
     *             duration_distance_matrix_dst_tags: "locB"
     *             duration_distance_matrix_dst_tags: "locC"
     *             duration_distance_matrices {
     *               vehicle_start_tag: "fast"
     *               rows {  # from: locA
     *                 durations { seconds: 1000 } meters: 2000 # to: locB
     *                 durations { seconds: 600 }  meters: 1000 # to: locC
     *               }
     *               rows {  # from: locB
     *                 durations { seconds: 0 }   meters: 0    # to: locB
     *                 durations { seconds: 700 } meters: 1200 # to: locC
     *               }
     *               rows {  # from: locC
     *                 durations { seconds: 702 } meters: 1190 # to: locB
     *                 durations { seconds: 0 }   meters: 0    # to: locC
     *               }
     *             }
     *             duration_distance_matrices {
     *               vehicle_start_tag: "slow"
     *               rows {  # from: locA
     *                 durations { seconds: 1800 } meters: 2001 # to: locB
     *                 durations { seconds: 900 }  meters: 1002 # to: locC
     *               }
     *               rows {  # from: locB
     *                 durations { seconds: 0 }    meters: 0    # to: locB
     *                 durations { seconds: 1000 } meters: 1202 # to: locC
     *               }
     *               rows {  # from: locC
     *                 durations { seconds: 1001 } meters: 1195 # to: locB
     *                 durations { seconds: 0 }    meters: 0    # to: locC
     *               }
     *             }
     *           }
     *           ```
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $duration_distance_matrix_src_tags
     *           Tags defining the sources of the duration and distance matrices;
     *           `duration_distance_matrices(i).rows(j)` defines durations and distances
     *           from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     *           in matrix i.
     *           Tags correspond to
     *           [VisitRequest.tags][google.maps.routeoptimization.v1.Shipment.VisitRequest.tags]
     *           or
     *           [Vehicle.start_tags][google.maps.routeoptimization.v1.Vehicle.start_tags].
     *           A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     *           field. Note that a `Vehicle`'s source, destination and matrix tags may be
     *           the same; similarly a `VisitRequest`'s source and destination tags may be
     *           the same. All tags must be different and cannot be empty strings. If this
     *           field is not empty, then `duration_distance_matrices` must not be empty.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $duration_distance_matrix_dst_tags
     *           Tags defining the destinations of the duration and distance matrices;
     *           `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     *           `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     *           (resp. the distance) of the travel from visits with tag
     *           `duration_distance_matrix_src_tags(j)` to visits with tag
     *           `duration_distance_matrix_dst_tags(k)` in matrix i.
     *           Tags correspond to
     *           [VisitRequest.tags][google.maps.routeoptimization.v1.Shipment.VisitRequest.tags]
     *           or
     *           [Vehicle.start_tags][google.maps.routeoptimization.v1.Vehicle.start_tags].
     *           A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     *           field. Note that a `Vehicle`'s source, destination and matrix tags may be
     *           the same; similarly a `VisitRequest`'s source and destination tags may be
     *           the same. All tags must be different and cannot be empty strings. If this
     *           field is not empty, then `duration_distance_matrices` must not be empty.
     *     @type array<\Google\Maps\RouteOptimization\V1\TransitionAttributes>|\Google\Protobuf\Internal\RepeatedField $transition_attributes
     *           Transition attributes added to the model.
     *     @type array<\Google\Maps\RouteOptimization\V1\ShipmentTypeIncompatibility>|\Google\Protobuf\Internal\RepeatedField $shipment_type_incompatibilities
     *           Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     *     @type array<\Google\Maps\RouteOptimization\V1\ShipmentTypeRequirement>|\Google\Protobuf\Internal\RepeatedField $shipment_type_requirements
     *           Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     *     @type array<\Google\Maps\RouteOptimization\V1\ShipmentModel\PrecedenceRule>|\Google\Protobuf\Internal\RepeatedField $precedence_rules
     *           Set of precedence rules which must be enforced in the model.
     *           *IMPORTANT*: Use of precedence rules limits the size of problem that can be
     *           optimized. Requests using precedence rules that include many shipments may
     *           be rejected.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Routeoptimization\V1\RouteOptimizationService::initOnce();
        parent::__construct($data);
    }

    /**
     * Set of shipments which must be performed in the model.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.Shipment shipments = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getShipments()
    {
        return $this->shipments;
    }

    /**
     * Set of shipments which must be performed in the model.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.Shipment shipments = 1;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\Shipment>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setShipments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\Shipment::class);
        $this->shipments = $arr;

        return $this;
    }

    /**
     * Set of vehicles which can be used to perform visits.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.Vehicle vehicles = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVehicles()
    {
        return $this->vehicles;
    }

    /**
     * Set of vehicles which can be used to perform visits.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.Vehicle vehicles = 2;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\Vehicle>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVehicles($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\Vehicle::class);
        $this->vehicles = $arr;

        return $this;
    }

    /**
     * The set of objectives for this model, that we will transform into costs.
     * If not empty, the input model has to be costless.
     * To obtain the modified request, please use `solving_mode` =
     * TRANSFORM_AND_RETURN_REQUEST. Note that the request will not
     * be solved in this case. See corresponding documentation.
     * Experimental: See
     * https://developers.google.com/maps/tt/route-optimization/experimental/objectives/make-request
     * for more details.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.Objective objectives = 17;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getObjectives()
    {
        return $this->objectives;
    }

    /**
     * The set of objectives for this model, that we will transform into costs.
     * If not empty, the input model has to be costless.
     * To obtain the modified request, please use `solving_mode` =
     * TRANSFORM_AND_RETURN_REQUEST. Note that the request will not
     * be solved in this case. See corresponding documentation.
     * Experimental: See
     * https://developers.google.com/maps/tt/route-optimization/experimental/objectives/make-request
     * for more details.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.Objective objectives = 17;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\ShipmentModel\Objective>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setObjectives($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\ShipmentModel\Objective::class);
        $this->objectives = $arr;

        return $this;
    }

    /**
     * Constrains the maximum number of active vehicles. A vehicle is active if
     * its route performs at least one shipment. This can be used to limit the
     * number of routes in the case where there are fewer drivers than
     * vehicles and that the fleet of vehicles is heterogeneous. The optimization
     * will then select the best subset of vehicles to use.
     * Must be strictly positive.
     *
     * Generated from protobuf field <code>optional int32 max_active_vehicles = 4;</code>
     * @return int
     */
    public function getMaxActiveVehicles()
    {
        return isset($this->max_active_vehicles) ? $this->max_active_vehicles : 0;
    }

    public function hasMaxActiveVehicles()
    {
        return isset($this->max_active_vehicles);
    }

    public function clearMaxActiveVehicles()
    {
        unset($this->max_active_vehicles);
    }

    /**
     * Constrains the maximum number of active vehicles. A vehicle is active if
     * its route performs at least one shipment. This can be used to limit the
     * number of routes in the case where there are fewer drivers than
     * vehicles and that the fleet of vehicles is heterogeneous. The optimization
     * will then select the best subset of vehicles to use.
     * Must be strictly positive.
     *
     * Generated from protobuf field <code>optional int32 max_active_vehicles = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxActiveVehicles($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_active_vehicles = $var;

        return $this;
    }

    /**
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getGlobalStartTime()
    {
        return $this->global_start_time;
    }

    public function hasGlobalStartTime()
    {
        return isset($this->global_start_time);
    }

    public function clearGlobalStartTime()
    {
        unset($this->global_start_time);
    }

    /**
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setGlobalStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->global_start_time = $var;

        return $this;
    }

    /**
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getGlobalEndTime()
    {
        return $this->global_end_time;
    }

    public function hasGlobalEndTime()
    {
        return isset($this->global_end_time);
    }

    public function clearGlobalEndTime()
    {
        unset($this->global_end_time);
    }

    /**
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setGlobalEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->global_end_time = $var;

        return $this;
    }

    /**
     * The "global duration" of the overall plan is the difference between the
     * earliest effective start time and the latest effective end time of
     * all vehicles. Users can assign a cost per hour to that quantity to try
     * and optimize for earliest job completion, for example. This cost must be in
     * the same unit as
     * [Shipment.penalty_cost][google.maps.routeoptimization.v1.Shipment.penalty_cost].
     *
     * Generated from protobuf field <code>double global_duration_cost_per_hour = 7;</code>
     * @return float
     */
    public function getGlobalDurationCostPerHour()
    {
        return $this->global_duration_cost_per_hour;
    }

    /**
     * The "global duration" of the overall plan is the difference between the
     * earliest effective start time and the latest effective end time of
     * all vehicles. Users can assign a cost per hour to that quantity to try
     * and optimize for earliest job completion, for example. This cost must be in
     * the same unit as
     * [Shipment.penalty_cost][google.maps.routeoptimization.v1.Shipment.penalty_cost].
     *
     * Generated from protobuf field <code>double global_duration_cost_per_hour = 7;</code>
     * @param float $var
     * @return $this
     */
    public function setGlobalDurationCostPerHour($var)
    {
        GPBUtil::checkDouble($var);
        $this->global_duration_cost_per_hour = $var;

        return $this;
    }

    /**
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDurationDistanceMatrices()
    {
        return $this->duration_distance_matrices;
    }

    /**
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\ShipmentModel\DurationDistanceMatrix>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDurationDistanceMatrices($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\ShipmentModel\DurationDistanceMatrix::class);
        $this->duration_distance_matrices = $arr;

        return $this;
    }

    /**
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.maps.routeoptimization.v1.Shipment.VisitRequest.tags]
     * or
     * [Vehicle.start_tags][google.maps.routeoptimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     *
     * Generated from protobuf field <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDurationDistanceMatrixSrcTags()
    {
        return $this->duration_distance_matrix_src_tags;
    }

    /**
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.maps.routeoptimization.v1.Shipment.VisitRequest.tags]
     * or
     * [Vehicle.start_tags][google.maps.routeoptimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     *
     * Generated from protobuf field <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDurationDistanceMatrixSrcTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->duration_distance_matrix_src_tags = $arr;

        return $this;
    }

    /**
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.maps.routeoptimization.v1.Shipment.VisitRequest.tags]
     * or
     * [Vehicle.start_tags][google.maps.routeoptimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     *
     * Generated from protobuf field <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDurationDistanceMatrixDstTags()
    {
        return $this->duration_distance_matrix_dst_tags;
    }

    /**
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.maps.routeoptimization.v1.Shipment.VisitRequest.tags]
     * or
     * [Vehicle.start_tags][google.maps.routeoptimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     *
     * Generated from protobuf field <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDurationDistanceMatrixDstTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->duration_distance_matrix_dst_tags = $arr;

        return $this;
    }

    /**
     * Transition attributes added to the model.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TransitionAttributes transition_attributes = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTransitionAttributes()
    {
        return $this->transition_attributes;
    }

    /**
     * Transition attributes added to the model.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.TransitionAttributes transition_attributes = 11;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\TransitionAttributes>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTransitionAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\TransitionAttributes::class);
        $this->transition_attributes = $arr;

        return $this;
    }

    /**
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getShipmentTypeIncompatibilities()
    {
        return $this->shipment_type_incompatibilities;
    }

    /**
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\ShipmentTypeIncompatibility>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setShipmentTypeIncompatibilities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\ShipmentTypeIncompatibility::class);
        $this->shipment_type_incompatibilities = $arr;

        return $this;
    }

    /**
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getShipmentTypeRequirements()
    {
        return $this->shipment_type_requirements;
    }

    /**
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\ShipmentTypeRequirement>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setShipmentTypeRequirements($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\ShipmentTypeRequirement::class);
        $this->shipment_type_requirements = $arr;

        return $this;
    }

    /**
     * Set of precedence rules which must be enforced in the model.
     * *IMPORTANT*: Use of precedence rules limits the size of problem that can be
     * optimized. Requests using precedence rules that include many shipments may
     * be rejected.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPrecedenceRules()
    {
        return $this->precedence_rules;
    }

    /**
     * Set of precedence rules which must be enforced in the model.
     * *IMPORTANT*: Use of precedence rules limits the size of problem that can be
     * optimized. Requests using precedence rules that include many shipments may
     * be rejected.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\ShipmentModel\PrecedenceRule>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPrecedenceRules($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\ShipmentModel\PrecedenceRule::class);
        $this->precedence_rules = $arr;

        return $this;
    }

}

