<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedkafka/schemaregistry/v1/schema_registry.proto

namespace Google\Cloud\ManagedKafka\SchemaRegistry\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for listing subjects.
 *
 * Generated from protobuf message <code>google.cloud.managedkafka.schemaregistry.v1.ListSubjectsRequest</code>
 */
class ListSubjectsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent schema registry/context whose subjects are to be
     * listed. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The context to filter the subjects by, in the format of
     * `:.{context}:`. If unset, all subjects in the registry are returned. Set to
     * empty string or add as
     * '?subjectPrefix=' at the end of this request to list subjects in the
     * default context.
     *
     * Generated from protobuf field <code>optional string subject_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $subject_prefix = null;
    /**
     * Optional. If true, the response will include soft-deleted subjects. The
     * default is false.
     *
     * Generated from protobuf field <code>optional bool deleted = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $deleted = null;

    /**
     * @param string $parent        Required. The parent schema registry/context whose subjects are to be
     *                              listed. Structured like:
     *                              `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
     *                              or
     *                              `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
     * @param string $subjectPrefix Optional. The context to filter the subjects by, in the format of
     *                              `:.{context}:`. If unset, all subjects in the registry are returned. Set to
     *                              empty string or add as
     *                              '?subjectPrefix=' at the end of this request to list subjects in the
     *                              default context.
     * @param bool   $deleted       Optional. If true, the response will include soft-deleted subjects. The
     *                              default is false.
     *
     * @return \Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListSubjectsRequest
     *
     * @experimental
     */
    public static function build(string $parent, string $subjectPrefix, bool $deleted): self
    {
        return (new self())
            ->setParent($parent)
            ->setSubjectPrefix($subjectPrefix)
            ->setDeleted($deleted);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent schema registry/context whose subjects are to be
     *           listed. Structured like:
     *           `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
     *           or
     *           `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
     *     @type string $subject_prefix
     *           Optional. The context to filter the subjects by, in the format of
     *           `:.{context}:`. If unset, all subjects in the registry are returned. Set to
     *           empty string or add as
     *           '?subjectPrefix=' at the end of this request to list subjects in the
     *           default context.
     *     @type bool $deleted
     *           Optional. If true, the response will include soft-deleted subjects. The
     *           default is false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedkafka\Schemaregistry\V1\SchemaRegistry::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent schema registry/context whose subjects are to be
     * listed. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent schema registry/context whose subjects are to be
     * listed. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The context to filter the subjects by, in the format of
     * `:.{context}:`. If unset, all subjects in the registry are returned. Set to
     * empty string or add as
     * '?subjectPrefix=' at the end of this request to list subjects in the
     * default context.
     *
     * Generated from protobuf field <code>optional string subject_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSubjectPrefix()
    {
        return isset($this->subject_prefix) ? $this->subject_prefix : '';
    }

    public function hasSubjectPrefix()
    {
        return isset($this->subject_prefix);
    }

    public function clearSubjectPrefix()
    {
        unset($this->subject_prefix);
    }

    /**
     * Optional. The context to filter the subjects by, in the format of
     * `:.{context}:`. If unset, all subjects in the registry are returned. Set to
     * empty string or add as
     * '?subjectPrefix=' at the end of this request to list subjects in the
     * default context.
     *
     * Generated from protobuf field <code>optional string subject_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSubjectPrefix($var)
    {
        GPBUtil::checkString($var, True);
        $this->subject_prefix = $var;

        return $this;
    }

    /**
     * Optional. If true, the response will include soft-deleted subjects. The
     * default is false.
     *
     * Generated from protobuf field <code>optional bool deleted = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDeleted()
    {
        return isset($this->deleted) ? $this->deleted : false;
    }

    public function hasDeleted()
    {
        return isset($this->deleted);
    }

    public function clearDeleted()
    {
        unset($this->deleted);
    }

    /**
     * Optional. If true, the response will include soft-deleted subjects. The
     * default is false.
     *
     * Generated from protobuf field <code>optional bool deleted = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDeleted($var)
    {
        GPBUtil::checkBool($var);
        $this->deleted = $var;

        return $this;
    }

}

