<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/iam/v3/policy_bindings_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Iam\V3\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V3\CreatePolicyBindingRequest;
use Google\Cloud\Iam\V3\DeletePolicyBindingRequest;
use Google\Cloud\Iam\V3\GetPolicyBindingRequest;
use Google\Cloud\Iam\V3\ListPolicyBindingsRequest;
use Google\Cloud\Iam\V3\PolicyBinding;
use Google\Cloud\Iam\V3\SearchTargetPolicyBindingsRequest;
use Google\Cloud\Iam\V3\UpdatePolicyBindingRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: An interface for managing Identity and Access Management (IAM) policy
 * bindings.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createPolicyBindingAsync(CreatePolicyBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deletePolicyBindingAsync(DeletePolicyBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PolicyBinding> getPolicyBindingAsync(GetPolicyBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPolicyBindingsAsync(ListPolicyBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchTargetPolicyBindingsAsync(SearchTargetPolicyBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updatePolicyBindingAsync(UpdatePolicyBindingRequest $request, array $optionalArgs = [])
 */
final class PolicyBindingsClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.iam.v3.PolicyBindings';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'iam.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'iam.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/policy_bindings_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/policy_bindings_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/policy_bindings_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/policy_bindings_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName(string $folder, string $location): string
    {
        return self::getPathTemplate('folderLocation')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_policy_binding resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $policyBinding
     *
     * @return string The formatted folder_location_policy_binding resource.
     */
    public static function folderLocationPolicyBindingName(
        string $folder,
        string $location,
        string $policyBinding
    ): string {
        return self::getPathTemplate('folderLocationPolicyBinding')->render([
            'folder' => $folder,
            'location' => $location,
            'policy_binding' => $policyBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_policy_binding resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $policyBinding
     *
     * @return string The formatted organization_location_policy_binding resource.
     */
    public static function organizationLocationPolicyBindingName(
        string $organization,
        string $location,
        string $policyBinding
    ): string {
        return self::getPathTemplate('organizationLocationPolicyBinding')->render([
            'organization' => $organization,
            'location' => $location,
            'policy_binding' => $policyBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * policy_binding resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $policyBinding
     *
     * @return string The formatted policy_binding resource.
     */
    public static function policyBindingName(string $organization, string $location, string $policyBinding): string
    {
        return self::getPathTemplate('policyBinding')->render([
            'organization' => $organization,
            'location' => $location,
            'policy_binding' => $policyBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_policy_binding resource.
     *
     * @param string $project
     * @param string $location
     * @param string $policyBinding
     *
     * @return string The formatted project_location_policy_binding resource.
     */
    public static function projectLocationPolicyBindingName(
        string $project,
        string $location,
        string $policyBinding
    ): string {
        return self::getPathTemplate('projectLocationPolicyBinding')->render([
            'project' => $project,
            'location' => $location,
            'policy_binding' => $policyBinding,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationPolicyBinding: folders/{folder}/locations/{location}/policyBindings/{policy_binding}
     * - location: projects/{project}/locations/{location}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationPolicyBinding: organizations/{organization}/locations/{location}/policyBindings/{policy_binding}
     * - policyBinding: organizations/{organization}/locations/{location}/policyBindings/{policy_binding}
     * - projectLocationPolicyBinding: projects/{project}/locations/{location}/policyBindings/{policy_binding}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'iam.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Iam\V3\PolicyBindingsClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new PolicyBindingsClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a policy binding and returns a long-running operation.
     * Callers will need the IAM permissions on both the policy and target.
     * Once the binding is created, the policy is applied to the target.
     *
     * The async variant is {@see PolicyBindingsClient::createPolicyBindingAsync()} .
     *
     * @example samples/V3/PolicyBindingsClient/create_policy_binding.php
     *
     * @param CreatePolicyBindingRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PolicyBinding>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPolicyBinding(CreatePolicyBindingRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePolicyBinding', $request, $callOptions)->wait();
    }

    /**
     * Deletes a policy binding and returns a long-running operation.
     * Callers will need the IAM permissions on both the policy and target.
     * Once the binding is deleted, the policy no longer applies to the target.
     *
     * The async variant is {@see PolicyBindingsClient::deletePolicyBindingAsync()} .
     *
     * @example samples/V3/PolicyBindingsClient/delete_policy_binding.php
     *
     * @param DeletePolicyBindingRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePolicyBinding(DeletePolicyBindingRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePolicyBinding', $request, $callOptions)->wait();
    }

    /**
     * Gets a policy binding.
     *
     * The async variant is {@see PolicyBindingsClient::getPolicyBindingAsync()} .
     *
     * @example samples/V3/PolicyBindingsClient/get_policy_binding.php
     *
     * @param GetPolicyBindingRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PolicyBinding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPolicyBinding(GetPolicyBindingRequest $request, array $callOptions = []): PolicyBinding
    {
        return $this->startApiCall('GetPolicyBinding', $request, $callOptions)->wait();
    }

    /**
     * Lists policy bindings.
     *
     * The async variant is {@see PolicyBindingsClient::listPolicyBindingsAsync()} .
     *
     * @example samples/V3/PolicyBindingsClient/list_policy_bindings.php
     *
     * @param ListPolicyBindingsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPolicyBindings(ListPolicyBindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPolicyBindings', $request, $callOptions);
    }

    /**
     * Search policy bindings by target. Returns all policy binding objects bound
     * directly to target.
     *
     * The async variant is
     * {@see PolicyBindingsClient::searchTargetPolicyBindingsAsync()} .
     *
     * @example samples/V3/PolicyBindingsClient/search_target_policy_bindings.php
     *
     * @param SearchTargetPolicyBindingsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchTargetPolicyBindings(
        SearchTargetPolicyBindingsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('SearchTargetPolicyBindings', $request, $callOptions);
    }

    /**
     * Updates a policy binding and returns a long-running operation.
     * Callers will need the IAM permissions on the policy and target in the
     * binding to update, and the IAM permission to remove the existing policy
     * from the binding. Target is immutable and cannot be updated. Once the
     * binding is updated, the new policy is applied to the target.
     *
     * The async variant is {@see PolicyBindingsClient::updatePolicyBindingAsync()} .
     *
     * @example samples/V3/PolicyBindingsClient/update_policy_binding.php
     *
     * @param UpdatePolicyBindingRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PolicyBinding>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePolicyBinding(UpdatePolicyBindingRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePolicyBinding', $request, $callOptions)->wait();
    }
}
