<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/privacy/dlp/v2/dlp.proto

namespace Google\Cloud\Dlp\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Determines what tables will have profiles generated within an organization
 * or project. Includes the ability to filter by regular expression patterns
 * on project ID, dataset ID, and table ID.
 *
 * Generated from protobuf message <code>google.privacy.dlp.v2.DiscoveryBigQueryFilter</code>
 */
class DiscoveryBigQueryFilter extends \Google\Protobuf\Internal\Message
{
    protected $filter;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Dlp\V2\BigQueryTableCollection $tables
     *           A specific set of tables for this filter to apply to. A table collection
     *           must be specified in only one filter per config.
     *           If a table id or dataset is empty, Cloud DLP assumes all tables in that
     *           collection must be profiled. Must specify a project ID.
     *     @type \Google\Cloud\Dlp\V2\DiscoveryBigQueryFilter\AllOtherBigQueryTables $other_tables
     *           Catch-all. This should always be the last filter in the list because
     *           anything above it will apply first. Should only appear once in a
     *           configuration. If none is specified, a default one will be added
     *           automatically.
     *     @type \Google\Cloud\Dlp\V2\TableReference $table_reference
     *           The table to scan. Discovery configurations including this can only
     *           include one DiscoveryTarget (the DiscoveryTarget with this
     *           TableReference).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Privacy\Dlp\V2\Dlp::initOnce();
        parent::__construct($data);
    }

    /**
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     * @return \Google\Cloud\Dlp\V2\BigQueryTableCollection|null
     */
    public function getTables()
    {
        return $this->readOneof(1);
    }

    public function hasTables()
    {
        return $this->hasOneof(1);
    }

    /**
     * A specific set of tables for this filter to apply to. A table collection
     * must be specified in only one filter per config.
     * If a table id or dataset is empty, Cloud DLP assumes all tables in that
     * collection must be profiled. Must specify a project ID.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.BigQueryTableCollection tables = 1;</code>
     * @param \Google\Cloud\Dlp\V2\BigQueryTableCollection $var
     * @return $this
     */
    public function setTables($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\BigQueryTableCollection::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;</code>
     * @return \Google\Cloud\Dlp\V2\DiscoveryBigQueryFilter\AllOtherBigQueryTables|null
     */
    public function getOtherTables()
    {
        return $this->readOneof(2);
    }

    public function hasOtherTables()
    {
        return $this->hasOneof(2);
    }

    /**
     * Catch-all. This should always be the last filter in the list because
     * anything above it will apply first. Should only appear once in a
     * configuration. If none is specified, a default one will be added
     * automatically.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.DiscoveryBigQueryFilter.AllOtherBigQueryTables other_tables = 2;</code>
     * @param \Google\Cloud\Dlp\V2\DiscoveryBigQueryFilter\AllOtherBigQueryTables $var
     * @return $this
     */
    public function setOtherTables($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\DiscoveryBigQueryFilter\AllOtherBigQueryTables::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The table to scan. Discovery configurations including this can only
     * include one DiscoveryTarget (the DiscoveryTarget with this
     * TableReference).
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TableReference table_reference = 3;</code>
     * @return \Google\Cloud\Dlp\V2\TableReference|null
     */
    public function getTableReference()
    {
        return $this->readOneof(3);
    }

    public function hasTableReference()
    {
        return $this->hasOneof(3);
    }

    /**
     * The table to scan. Discovery configurations including this can only
     * include one DiscoveryTarget (the DiscoveryTarget with this
     * TableReference).
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TableReference table_reference = 3;</code>
     * @param \Google\Cloud\Dlp\V2\TableReference $var
     * @return $this
     */
    public function setTableReference($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\TableReference::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getFilter()
    {
        return $this->whichOneof("filter");
    }

}

