<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/metastore/v1beta/metastore.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Metastore\V1beta\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\Metastore\V1beta\AlterMetadataResourceLocationRequest;
use Google\Cloud\Metastore\V1beta\AlterMetadataResourceLocationResponse;
use Google\Cloud\Metastore\V1beta\Backup;
use Google\Cloud\Metastore\V1beta\CreateBackupRequest;
use Google\Cloud\Metastore\V1beta\CreateMetadataImportRequest;
use Google\Cloud\Metastore\V1beta\CreateServiceRequest;
use Google\Cloud\Metastore\V1beta\DeleteBackupRequest;
use Google\Cloud\Metastore\V1beta\DeleteServiceRequest;
use Google\Cloud\Metastore\V1beta\ExportMetadataRequest;
use Google\Cloud\Metastore\V1beta\GetBackupRequest;
use Google\Cloud\Metastore\V1beta\GetMetadataImportRequest;
use Google\Cloud\Metastore\V1beta\GetServiceRequest;
use Google\Cloud\Metastore\V1beta\ListBackupsRequest;
use Google\Cloud\Metastore\V1beta\ListMetadataImportsRequest;
use Google\Cloud\Metastore\V1beta\ListServicesRequest;
use Google\Cloud\Metastore\V1beta\MetadataExport;
use Google\Cloud\Metastore\V1beta\MetadataImport;
use Google\Cloud\Metastore\V1beta\MoveTableToDatabaseRequest;
use Google\Cloud\Metastore\V1beta\MoveTableToDatabaseResponse;
use Google\Cloud\Metastore\V1beta\QueryMetadataRequest;
use Google\Cloud\Metastore\V1beta\QueryMetadataResponse;
use Google\Cloud\Metastore\V1beta\RemoveIamPolicyRequest;
use Google\Cloud\Metastore\V1beta\RemoveIamPolicyResponse;
use Google\Cloud\Metastore\V1beta\Restore;
use Google\Cloud\Metastore\V1beta\RestoreServiceRequest;
use Google\Cloud\Metastore\V1beta\Service;
use Google\Cloud\Metastore\V1beta\UpdateMetadataImportRequest;
use Google\Cloud\Metastore\V1beta\UpdateServiceRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Configures and manages metastore services.
 * Metastore services are fully managed, highly available, autoscaled,
 * autohealing, OSS-native deployments of technical metadata management
 * software. Each metastore service exposes a network endpoint through which
 * metadata queries are served. Metadata queries can originate from a variety
 * of sources, including Apache Hive, Apache Presto, and Apache Spark.
 *
 * The Dataproc Metastore API defines the following resource model:
 *
 * * The service works with a collection of Google Cloud projects, named:
 * `/projects/*`
 * * Each project has a collection of available locations, named: `/locations/*`
 * (a location must refer to a Google Cloud `region`)
 * * Each location has a collection of services, named: `/services/*`
 * * Dataproc Metastore services are resources with names of the form:
 *
 * `/projects/{project_number}/locations/{location_id}/services/{service_id}`.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @method PromiseInterface<OperationResponse> alterMetadataResourceLocationAsync(AlterMetadataResourceLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createBackupAsync(CreateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createMetadataImportAsync(CreateMetadataImportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createServiceAsync(CreateServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBackupAsync(DeleteBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServiceAsync(DeleteServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportMetadataAsync(ExportMetadataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Backup> getBackupAsync(GetBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MetadataImport> getMetadataImportAsync(GetMetadataImportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Service> getServiceAsync(GetServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupsAsync(ListBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMetadataImportsAsync(ListMetadataImportsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServicesAsync(ListServicesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> moveTableToDatabaseAsync(MoveTableToDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> queryMetadataAsync(QueryMetadataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RemoveIamPolicyResponse> removeIamPolicyAsync(RemoveIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> restoreServiceAsync(RestoreServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateMetadataImportAsync(UpdateMetadataImportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateServiceAsync(UpdateServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class DataprocMetastoreClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.metastore.v1beta.DataprocMetastore';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'metastore.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'metastore.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/dataproc_metastore_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/dataproc_metastore_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/dataproc_metastore_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/dataproc_metastore_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     *
     * @experimental
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     *
     * @experimental
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $service
     * @param string $backup
     *
     * @return string The formatted backup resource.
     *
     * @experimental
     */
    public static function backupName(string $project, string $location, string $service, string $backup): string
    {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'location' => $location,
            'service' => $service,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a lake
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     *
     * @return string The formatted lake resource.
     *
     * @experimental
     */
    public static function lakeName(string $project, string $location, string $lake): string
    {
        return self::getPathTemplate('lake')->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     *
     * @experimental
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * metadata_import resource.
     *
     * @param string $project
     * @param string $location
     * @param string $service
     * @param string $metadataImport
     *
     * @return string The formatted metadata_import resource.
     *
     * @experimental
     */
    public static function metadataImportName(
        string $project,
        string $location,
        string $service,
        string $metadataImport
    ): string {
        return self::getPathTemplate('metadataImport')->render([
            'project' => $project,
            'location' => $location,
            'service' => $service,
            'metadata_import' => $metadataImport,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     *
     * @experimental
     */
    public static function networkName(string $project, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $service
     *
     * @return string The formatted service resource.
     *
     * @experimental
     */
    public static function serviceName(string $project, string $location, string $service): string
    {
        return self::getPathTemplate('service')->render([
            'project' => $project,
            'location' => $location,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subnetwork
     * resource.
     *
     * @param string $project
     * @param string $region
     * @param string $subnetwork
     *
     * @return string The formatted subnetwork resource.
     *
     * @experimental
     */
    public static function subnetworkName(string $project, string $region, string $subnetwork): string
    {
        return self::getPathTemplate('subnetwork')->render([
            'project' => $project,
            'region' => $region,
            'subnetwork' => $subnetwork,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/locations/{location}/services/{service}/backups/{backup}
     * - lake: projects/{project}/locations/{location}/lakes/{lake}
     * - location: projects/{project}/locations/{location}
     * - metadataImport: projects/{project}/locations/{location}/services/{service}/metadataImports/{metadata_import}
     * - network: projects/{project}/global/networks/{network}
     * - service: projects/{project}/locations/{location}/services/{service}
     * - subnetwork: projects/{project}/regions/{region}/subnetworks/{subnetwork}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'metastore.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Metastore\V1beta\DataprocMetastoreClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new DataprocMetastoreClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Alter metadata resource location. The metadata resource can be a database,
     * table, or partition. This functionality only updates the parent directory
     * for the respective metadata resource and does not transfer any existing
     * data to the new location.
     *
     * The async variant is
     * {@see DataprocMetastoreClient::alterMetadataResourceLocationAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/alter_metadata_resource_location.php
     *
     * @param AlterMetadataResourceLocationRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<AlterMetadataResourceLocationResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function alterMetadataResourceLocation(
        AlterMetadataResourceLocationRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('AlterMetadataResourceLocation', $request, $callOptions)->wait();
    }

    /**
     * Creates a new backup in a given project and location.
     *
     * The async variant is {@see DataprocMetastoreClient::createBackupAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/create_backup.php
     *
     * @param CreateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Backup>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createBackup(CreateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackup', $request, $callOptions)->wait();
    }

    /**
     * Creates a new MetadataImport in a given project and location.
     *
     * The async variant is {@see DataprocMetastoreClient::createMetadataImportAsync()}
     * .
     *
     * @example samples/V1beta/DataprocMetastoreClient/create_metadata_import.php
     *
     * @param CreateMetadataImportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<MetadataImport>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createMetadataImport(
        CreateMetadataImportRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateMetadataImport', $request, $callOptions)->wait();
    }

    /**
     * Creates a metastore service in a project and location.
     *
     * The async variant is {@see DataprocMetastoreClient::createServiceAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/create_service.php
     *
     * @param CreateServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Service>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createService(CreateServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateService', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single backup.
     *
     * The async variant is {@see DataprocMetastoreClient::deleteBackupAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/delete_backup.php
     *
     * @param DeleteBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteBackup(DeleteBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single service.
     *
     * The async variant is {@see DataprocMetastoreClient::deleteServiceAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/delete_service.php
     *
     * @param DeleteServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteService(DeleteServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteService', $request, $callOptions)->wait();
    }

    /**
     * Exports metadata from a service.
     *
     * The async variant is {@see DataprocMetastoreClient::exportMetadataAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/export_metadata.php
     *
     * @param ExportMetadataRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<MetadataExport>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function exportMetadata(ExportMetadataRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportMetadata', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single backup.
     *
     * The async variant is {@see DataprocMetastoreClient::getBackupAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/get_backup.php
     *
     * @param GetBackupRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getBackup(GetBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('GetBackup', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single import.
     *
     * The async variant is {@see DataprocMetastoreClient::getMetadataImportAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/get_metadata_import.php
     *
     * @param GetMetadataImportRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MetadataImport
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getMetadataImport(GetMetadataImportRequest $request, array $callOptions = []): MetadataImport
    {
        return $this->startApiCall('GetMetadataImport', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a single service.
     *
     * The async variant is {@see DataprocMetastoreClient::getServiceAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/get_service.php
     *
     * @param GetServiceRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Service
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getService(GetServiceRequest $request, array $callOptions = []): Service
    {
        return $this->startApiCall('GetService', $request, $callOptions)->wait();
    }

    /**
     * Lists backups in a service.
     *
     * The async variant is {@see DataprocMetastoreClient::listBackupsAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/list_backups.php
     *
     * @param ListBackupsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listBackups(ListBackupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackups', $request, $callOptions);
    }

    /**
     * Lists imports in a service.
     *
     * The async variant is {@see DataprocMetastoreClient::listMetadataImportsAsync()}
     * .
     *
     * @example samples/V1beta/DataprocMetastoreClient/list_metadata_imports.php
     *
     * @param ListMetadataImportsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listMetadataImports(ListMetadataImportsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMetadataImports', $request, $callOptions);
    }

    /**
     * Lists services in a project and location.
     *
     * The async variant is {@see DataprocMetastoreClient::listServicesAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/list_services.php
     *
     * @param ListServicesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listServices(ListServicesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListServices', $request, $callOptions);
    }

    /**
     * Move a table to another database.
     *
     * The async variant is {@see DataprocMetastoreClient::moveTableToDatabaseAsync()}
     * .
     *
     * @example samples/V1beta/DataprocMetastoreClient/move_table_to_database.php
     *
     * @param MoveTableToDatabaseRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<MoveTableToDatabaseResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function moveTableToDatabase(MoveTableToDatabaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('MoveTableToDatabase', $request, $callOptions)->wait();
    }

    /**
     * Query DPMS metadata.
     *
     * The async variant is {@see DataprocMetastoreClient::queryMetadataAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/query_metadata.php
     *
     * @param QueryMetadataRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<QueryMetadataResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function queryMetadata(QueryMetadataRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('QueryMetadata', $request, $callOptions)->wait();
    }

    /**
     * Removes the attached IAM policies for a resource
     *
     * The async variant is {@see DataprocMetastoreClient::removeIamPolicyAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/remove_iam_policy.php
     *
     * @param RemoveIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RemoveIamPolicyResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function removeIamPolicy(RemoveIamPolicyRequest $request, array $callOptions = []): RemoveIamPolicyResponse
    {
        return $this->startApiCall('RemoveIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Restores a service from a backup.
     *
     * The async variant is {@see DataprocMetastoreClient::restoreServiceAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/restore_service.php
     *
     * @param RestoreServiceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Restore>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function restoreService(RestoreServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreService', $request, $callOptions)->wait();
    }

    /**
     * Updates a single import.
     * Only the description field of MetadataImport is supported to be updated.
     *
     * The async variant is {@see DataprocMetastoreClient::updateMetadataImportAsync()}
     * .
     *
     * @example samples/V1beta/DataprocMetastoreClient/update_metadata_import.php
     *
     * @param UpdateMetadataImportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<MetadataImport>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateMetadataImport(
        UpdateMetadataImportRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateMetadataImport', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single service.
     *
     * The async variant is {@see DataprocMetastoreClient::updateServiceAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/update_service.php
     *
     * @param UpdateServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Service>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateService(UpdateServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateService', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see DataprocMetastoreClient::getLocationAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see DataprocMetastoreClient::listLocationsAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see DataprocMetastoreClient::getIamPolicyAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see DataprocMetastoreClient::setIamPolicyAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see DataprocMetastoreClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1beta/DataprocMetastoreClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
