<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/metastore/v1alpha/metastore_federation.proto

namespace Google\Cloud\Metastore\V1alpha;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a federation of multiple backend metastores.
 *
 * Generated from protobuf message <code>google.cloud.metastore.v1alpha.Federation</code>
 */
class Federation extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. The relative resource name of the federation, of the
     * form:
     * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $name = '';
    /**
     * Output only. The time when the metastore federation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time when the metastore federation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * User-defined labels for the metastore federation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Immutable. The Apache Hive metastore version of the federation. All backend
     * metastore versions must be compatible with the federation version.
     *
     * Generated from protobuf field <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $version = '';
    /**
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     *
     * Generated from protobuf field <code>map<int32, .google.cloud.metastore.v1alpha.BackendMetastore> backend_metastores = 6;</code>
     */
    private $backend_metastores;
    /**
     * Output only. The federation endpoint.
     *
     * Generated from protobuf field <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $endpoint_uri = '';
    /**
     * Output only. The current state of the federation.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1alpha.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. Additional information about the current state of the
     * metastore federation, if available.
     *
     * Generated from protobuf field <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state_message = '';
    /**
     * Output only. The globally unique resource identifier of the metastore
     * federation.
     *
     * Generated from protobuf field <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. The relative resource name of the federation, of the
     *           form:
     *           projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the metastore federation was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time when the metastore federation was last updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User-defined labels for the metastore federation.
     *     @type string $version
     *           Immutable. The Apache Hive metastore version of the federation. All backend
     *           metastore versions must be compatible with the federation version.
     *     @type array|\Google\Protobuf\Internal\MapField $backend_metastores
     *           A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     *           federation service serves metadata at query time. The map key represents
     *           the order in which `BackendMetastore`s should be evaluated to resolve
     *           database names at query time and should be greater than or equal to zero. A
     *           `BackendMetastore` with a lower number will be evaluated before a
     *           `BackendMetastore` with a higher number.
     *     @type string $endpoint_uri
     *           Output only. The federation endpoint.
     *     @type int $state
     *           Output only. The current state of the federation.
     *     @type string $state_message
     *           Output only. Additional information about the current state of the
     *           metastore federation, if available.
     *     @type string $uid
     *           Output only. The globally unique resource identifier of the metastore
     *           federation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Metastore\V1Alpha\MetastoreFederation::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. The relative resource name of the federation, of the
     * form:
     * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. The relative resource name of the federation, of the
     * form:
     * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The time when the metastore federation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the metastore federation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the metastore federation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time when the metastore federation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * User-defined labels for the metastore federation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User-defined labels for the metastore federation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Immutable. The Apache Hive metastore version of the federation. All backend
     * metastore versions must be compatible with the federation version.
     *
     * Generated from protobuf field <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * Immutable. The Apache Hive metastore version of the federation. All backend
     * metastore versions must be compatible with the federation version.
     *
     * Generated from protobuf field <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->version = $var;

        return $this;
    }

    /**
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     *
     * Generated from protobuf field <code>map<int32, .google.cloud.metastore.v1alpha.BackendMetastore> backend_metastores = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getBackendMetastores()
    {
        return $this->backend_metastores;
    }

    /**
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     *
     * Generated from protobuf field <code>map<int32, .google.cloud.metastore.v1alpha.BackendMetastore> backend_metastores = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setBackendMetastores($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::INT32, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Metastore\V1alpha\BackendMetastore::class);
        $this->backend_metastores = $arr;

        return $this;
    }

    /**
     * Output only. The federation endpoint.
     *
     * Generated from protobuf field <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEndpointUri()
    {
        return $this->endpoint_uri;
    }

    /**
     * Output only. The federation endpoint.
     *
     * Generated from protobuf field <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEndpointUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint_uri = $var;

        return $this;
    }

    /**
     * Output only. The current state of the federation.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1alpha.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the federation.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1alpha.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Metastore\V1alpha\Federation\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Additional information about the current state of the
     * metastore federation, if available.
     *
     * Generated from protobuf field <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStateMessage()
    {
        return $this->state_message;
    }

    /**
     * Output only. Additional information about the current state of the
     * metastore federation, if available.
     *
     * Generated from protobuf field <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStateMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->state_message = $var;

        return $this;
    }

    /**
     * Output only. The globally unique resource identifier of the metastore
     * federation.
     *
     * Generated from protobuf field <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. The globally unique resource identifier of the metastore
     * federation.
     *
     * Generated from protobuf field <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

}

