<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/databasecenter/v1beta/maintenance.proto

namespace Google\Cloud\DatabaseCenter\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Maintenance window for the database resource. It specifies preferred time
 * and day of the week and phase in some cases, when the maintenance can start.
 *
 * Generated from protobuf message <code>google.cloud.databasecenter.v1beta.ResourceMaintenanceSchedule</code>
 */
class ResourceMaintenanceSchedule extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Preferred time to start the maintenance operation on the
     * specified day.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $start_time = null;
    /**
     * Optional. Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY,
     * etc.
     *
     * Generated from protobuf field <code>.google.type.DayOfWeek day = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $day = 0;
    /**
     * Optional. Phase of the maintenance window. This is to capture order of
     * maintenance. For example, for Cloud SQL resources, this can be used to
     * capture if the maintenance window is in Week1, Week2, Week5, etc. Non
     * production resources are usually part of early phase.
     * For more details, refer to Cloud SQL resources -
     * https://cloud.google.com/sql/docs/mysql/maintenance
     *
     * Generated from protobuf field <code>.google.cloud.databasecenter.v1beta.Phase phase = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $phase = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Type\TimeOfDay $start_time
     *           Optional. Preferred time to start the maintenance operation on the
     *           specified day.
     *     @type int $day
     *           Optional. Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY,
     *           etc.
     *     @type int $phase
     *           Optional. Phase of the maintenance window. This is to capture order of
     *           maintenance. For example, for Cloud SQL resources, this can be used to
     *           capture if the maintenance window is in Week1, Week2, Week5, etc. Non
     *           production resources are usually part of early phase.
     *           For more details, refer to Cloud SQL resources -
     *           https://cloud.google.com/sql/docs/mysql/maintenance
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Databasecenter\V1Beta\Maintenance::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Preferred time to start the maintenance operation on the
     * specified day.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Type\TimeOfDay|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Optional. Preferred time to start the maintenance operation on the
     * specified day.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Type\TimeOfDay $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\TimeOfDay::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Optional. Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY,
     * etc.
     *
     * Generated from protobuf field <code>.google.type.DayOfWeek day = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDay()
    {
        return $this->day;
    }

    /**
     * Optional. Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY,
     * etc.
     *
     * Generated from protobuf field <code>.google.type.DayOfWeek day = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDay($var)
    {
        GPBUtil::checkEnum($var, \Google\Type\DayOfWeek::class);
        $this->day = $var;

        return $this;
    }

    /**
     * Optional. Phase of the maintenance window. This is to capture order of
     * maintenance. For example, for Cloud SQL resources, this can be used to
     * capture if the maintenance window is in Week1, Week2, Week5, etc. Non
     * production resources are usually part of early phase.
     * For more details, refer to Cloud SQL resources -
     * https://cloud.google.com/sql/docs/mysql/maintenance
     *
     * Generated from protobuf field <code>.google.cloud.databasecenter.v1beta.Phase phase = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPhase()
    {
        return $this->phase;
    }

    /**
     * Optional. Phase of the maintenance window. This is to capture order of
     * maintenance. For example, for Cloud SQL resources, this can be used to
     * capture if the maintenance window is in Week1, Week2, Week5, etc. Non
     * production resources are usually part of early phase.
     * For more details, refer to Cloud SQL resources -
     * https://cloud.google.com/sql/docs/mysql/maintenance
     *
     * Generated from protobuf field <code>.google.cloud.databasecenter.v1beta.Phase phase = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPhase($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DatabaseCenter\V1beta\Phase::class);
        $this->phase = $var;

        return $this;
    }

}

