<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datacatalog/v1/dataplex_spec.proto

namespace Google\Cloud\DataCatalog\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * External table registered by Dataplex.
 * Dataplex publishes data discovered from an asset into multiple other systems
 * (BigQuery, DPMS) in form of tables. We call them "external tables". External
 * tables are also synced into the Data Catalog.
 * This message contains pointers to
 * those external tables (fully qualified name, resource name et cetera) within
 * the Data Catalog.
 *
 * Generated from protobuf message <code>google.cloud.datacatalog.v1.DataplexExternalTable</code>
 */
class DataplexExternalTable extends \Google\Protobuf\Internal\Message
{
    /**
     * Service in which the external table is registered.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.IntegratedSystem system = 1;</code>
     */
    protected $system = 0;
    /**
     * Fully qualified name (FQN) of the external table.
     *
     * Generated from protobuf field <code>string fully_qualified_name = 28;</code>
     */
    protected $fully_qualified_name = '';
    /**
     * Google Cloud resource name of the external table.
     *
     * Generated from protobuf field <code>string google_cloud_resource = 3;</code>
     */
    protected $google_cloud_resource = '';
    /**
     * Name of the Data Catalog entry representing the external table.
     *
     * Generated from protobuf field <code>string data_catalog_entry = 4;</code>
     */
    protected $data_catalog_entry = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $system
     *           Service in which the external table is registered.
     *     @type string $fully_qualified_name
     *           Fully qualified name (FQN) of the external table.
     *     @type string $google_cloud_resource
     *           Google Cloud resource name of the external table.
     *     @type string $data_catalog_entry
     *           Name of the Data Catalog entry representing the external table.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datacatalog\V1\DataplexSpec::initOnce();
        parent::__construct($data);
    }

    /**
     * Service in which the external table is registered.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.IntegratedSystem system = 1;</code>
     * @return int
     */
    public function getSystem()
    {
        return $this->system;
    }

    /**
     * Service in which the external table is registered.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.IntegratedSystem system = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setSystem($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DataCatalog\V1\IntegratedSystem::class);
        $this->system = $var;

        return $this;
    }

    /**
     * Fully qualified name (FQN) of the external table.
     *
     * Generated from protobuf field <code>string fully_qualified_name = 28;</code>
     * @return string
     */
    public function getFullyQualifiedName()
    {
        return $this->fully_qualified_name;
    }

    /**
     * Fully qualified name (FQN) of the external table.
     *
     * Generated from protobuf field <code>string fully_qualified_name = 28;</code>
     * @param string $var
     * @return $this
     */
    public function setFullyQualifiedName($var)
    {
        GPBUtil::checkString($var, True);
        $this->fully_qualified_name = $var;

        return $this;
    }

    /**
     * Google Cloud resource name of the external table.
     *
     * Generated from protobuf field <code>string google_cloud_resource = 3;</code>
     * @return string
     */
    public function getGoogleCloudResource()
    {
        return $this->google_cloud_resource;
    }

    /**
     * Google Cloud resource name of the external table.
     *
     * Generated from protobuf field <code>string google_cloud_resource = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleCloudResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_cloud_resource = $var;

        return $this;
    }

    /**
     * Name of the Data Catalog entry representing the external table.
     *
     * Generated from protobuf field <code>string data_catalog_entry = 4;</code>
     * @return string
     */
    public function getDataCatalogEntry()
    {
        return $this->data_catalog_entry;
    }

    /**
     * Name of the Data Catalog entry representing the external table.
     *
     * Generated from protobuf field <code>string data_catalog_entry = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDataCatalogEntry($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_catalog_entry = $var;

        return $this;
    }

}

