<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * TopologyManager defines the configuration options for Topology Manager
 * feature. See
 * https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/
 *
 * Generated from protobuf message <code>google.container.v1.TopologyManager</code>
 */
class TopologyManager extends \Google\Protobuf\Internal\Message
{
    /**
     * Configures the strategy for resource alignment.
     * Allowed values are:
     * * none: the default policy, and does not perform any topology alignment.
     * * restricted: the topology manager stores the preferred NUMA node affinity
     * for the container, and will reject the pod if the affinity if not
     * preferred.
     * * best-effort: the topology manager stores the preferred NUMA node affinity
     * for the container. If the affinity is not preferred, the topology manager
     * will admit the pod to the node anyway.
     * * single-numa-node: the topology manager determines if the single NUMA node
     * affinity is possible. If it is, Topology Manager will store this and the
     * Hint Providers can then use this information when making the resource
     * allocation decision. If, however, this is not possible then the
     * Topology Manager will reject the pod from the node. This will result in a
     * pod in a Terminated state with a pod admission failure.
     * The default policy value is 'none' if unspecified.
     * Details about each strategy can be found
     * [here](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-policies).
     *
     * Generated from protobuf field <code>string policy = 1;</code>
     */
    protected $policy = '';
    /**
     * The Topology Manager aligns resources in following scopes:
     * * container
     * * pod
     * The default scope is 'container' if unspecified.
     * See
     * https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-scopes
     *
     * Generated from protobuf field <code>string scope = 2;</code>
     */
    protected $scope = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $policy
     *           Configures the strategy for resource alignment.
     *           Allowed values are:
     *           * none: the default policy, and does not perform any topology alignment.
     *           * restricted: the topology manager stores the preferred NUMA node affinity
     *           for the container, and will reject the pod if the affinity if not
     *           preferred.
     *           * best-effort: the topology manager stores the preferred NUMA node affinity
     *           for the container. If the affinity is not preferred, the topology manager
     *           will admit the pod to the node anyway.
     *           * single-numa-node: the topology manager determines if the single NUMA node
     *           affinity is possible. If it is, Topology Manager will store this and the
     *           Hint Providers can then use this information when making the resource
     *           allocation decision. If, however, this is not possible then the
     *           Topology Manager will reject the pod from the node. This will result in a
     *           pod in a Terminated state with a pod admission failure.
     *           The default policy value is 'none' if unspecified.
     *           Details about each strategy can be found
     *           [here](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-policies).
     *     @type string $scope
     *           The Topology Manager aligns resources in following scopes:
     *           * container
     *           * pod
     *           The default scope is 'container' if unspecified.
     *           See
     *           https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-scopes
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Configures the strategy for resource alignment.
     * Allowed values are:
     * * none: the default policy, and does not perform any topology alignment.
     * * restricted: the topology manager stores the preferred NUMA node affinity
     * for the container, and will reject the pod if the affinity if not
     * preferred.
     * * best-effort: the topology manager stores the preferred NUMA node affinity
     * for the container. If the affinity is not preferred, the topology manager
     * will admit the pod to the node anyway.
     * * single-numa-node: the topology manager determines if the single NUMA node
     * affinity is possible. If it is, Topology Manager will store this and the
     * Hint Providers can then use this information when making the resource
     * allocation decision. If, however, this is not possible then the
     * Topology Manager will reject the pod from the node. This will result in a
     * pod in a Terminated state with a pod admission failure.
     * The default policy value is 'none' if unspecified.
     * Details about each strategy can be found
     * [here](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-policies).
     *
     * Generated from protobuf field <code>string policy = 1;</code>
     * @return string
     */
    public function getPolicy()
    {
        return $this->policy;
    }

    /**
     * Configures the strategy for resource alignment.
     * Allowed values are:
     * * none: the default policy, and does not perform any topology alignment.
     * * restricted: the topology manager stores the preferred NUMA node affinity
     * for the container, and will reject the pod if the affinity if not
     * preferred.
     * * best-effort: the topology manager stores the preferred NUMA node affinity
     * for the container. If the affinity is not preferred, the topology manager
     * will admit the pod to the node anyway.
     * * single-numa-node: the topology manager determines if the single NUMA node
     * affinity is possible. If it is, Topology Manager will store this and the
     * Hint Providers can then use this information when making the resource
     * allocation decision. If, however, this is not possible then the
     * Topology Manager will reject the pod from the node. This will result in a
     * pod in a Terminated state with a pod admission failure.
     * The default policy value is 'none' if unspecified.
     * Details about each strategy can be found
     * [here](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-policies).
     *
     * Generated from protobuf field <code>string policy = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->policy = $var;

        return $this;
    }

    /**
     * The Topology Manager aligns resources in following scopes:
     * * container
     * * pod
     * The default scope is 'container' if unspecified.
     * See
     * https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-scopes
     *
     * Generated from protobuf field <code>string scope = 2;</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * The Topology Manager aligns resources in following scopes:
     * * container
     * * pod
     * The default scope is 'container' if unspecified.
     * See
     * https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-scopes
     *
     * Generated from protobuf field <code>string scope = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

}

