<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A specification of the desired way to instantiate a disk in the instance
 * template when its created from a source instance.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.DiskInstantiationConfig</code>
 */
class DiskInstantiationConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies whether the disk will be auto-deleted when the instance is
     * deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>optional bool auto_delete = 464761403;</code>
     */
    protected $auto_delete = null;
    /**
     * The custom source image to be used to restore this disk when instantiating
     * this instance template.
     *
     * Generated from protobuf field <code>optional string custom_image = 184123149;</code>
     */
    protected $custom_image = null;
    /**
     * Specifies the device name of the disk to which the configurations apply to.
     *
     * Generated from protobuf field <code>optional string device_name = 67541716;</code>
     */
    protected $device_name = null;
    /**
     * Specifies whether to include the disk and what image to use. Possible
     * values are:
     *      - source-image: to use the same image that was used to
     *      create the source instance's corresponding disk. Applicable to the boot
     *      disk and additional read-write disks.
     *      - source-image-family: to use the same image family that
     *      was used to create the source instance's corresponding disk. Applicable
     *      to the boot disk and additional read-write disks.
     *      - custom-image: to use a user-provided image url for disk
     *      creation. Applicable to the boot disk and additional read-write
     *      disks.
     *    - attach-read-only: to attach a read-only
     *      disk. Applicable to read-only disks.
     *      - do-not-include: to exclude a disk from the template.
     *      Applicable to additional read-write disks, local SSDs, and read-only
     *      disks.
     * Check the InstantiateFrom enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string instantiate_from = 393383903;</code>
     */
    protected $instantiate_from = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $auto_delete
     *           Specifies whether the disk will be auto-deleted when the instance is
     *           deleted (but not when the disk is detached from the instance).
     *     @type string $custom_image
     *           The custom source image to be used to restore this disk when instantiating
     *           this instance template.
     *     @type string $device_name
     *           Specifies the device name of the disk to which the configurations apply to.
     *     @type string $instantiate_from
     *           Specifies whether to include the disk and what image to use. Possible
     *           values are:
     *                - source-image: to use the same image that was used to
     *                create the source instance's corresponding disk. Applicable to the boot
     *                disk and additional read-write disks.
     *                - source-image-family: to use the same image family that
     *                was used to create the source instance's corresponding disk. Applicable
     *                to the boot disk and additional read-write disks.
     *                - custom-image: to use a user-provided image url for disk
     *                creation. Applicable to the boot disk and additional read-write
     *                disks.
     *              - attach-read-only: to attach a read-only
     *                disk. Applicable to read-only disks.
     *                - do-not-include: to exclude a disk from the template.
     *                Applicable to additional read-write disks, local SSDs, and read-only
     *                disks.
     *           Check the InstantiateFrom enum for the list of possible values.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies whether the disk will be auto-deleted when the instance is
     * deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>optional bool auto_delete = 464761403;</code>
     * @return bool
     */
    public function getAutoDelete()
    {
        return isset($this->auto_delete) ? $this->auto_delete : false;
    }

    public function hasAutoDelete()
    {
        return isset($this->auto_delete);
    }

    public function clearAutoDelete()
    {
        unset($this->auto_delete);
    }

    /**
     * Specifies whether the disk will be auto-deleted when the instance is
     * deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>optional bool auto_delete = 464761403;</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoDelete($var)
    {
        GPBUtil::checkBool($var);
        $this->auto_delete = $var;

        return $this;
    }

    /**
     * The custom source image to be used to restore this disk when instantiating
     * this instance template.
     *
     * Generated from protobuf field <code>optional string custom_image = 184123149;</code>
     * @return string
     */
    public function getCustomImage()
    {
        return isset($this->custom_image) ? $this->custom_image : '';
    }

    public function hasCustomImage()
    {
        return isset($this->custom_image);
    }

    public function clearCustomImage()
    {
        unset($this->custom_image);
    }

    /**
     * The custom source image to be used to restore this disk when instantiating
     * this instance template.
     *
     * Generated from protobuf field <code>optional string custom_image = 184123149;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_image = $var;

        return $this;
    }

    /**
     * Specifies the device name of the disk to which the configurations apply to.
     *
     * Generated from protobuf field <code>optional string device_name = 67541716;</code>
     * @return string
     */
    public function getDeviceName()
    {
        return isset($this->device_name) ? $this->device_name : '';
    }

    public function hasDeviceName()
    {
        return isset($this->device_name);
    }

    public function clearDeviceName()
    {
        unset($this->device_name);
    }

    /**
     * Specifies the device name of the disk to which the configurations apply to.
     *
     * Generated from protobuf field <code>optional string device_name = 67541716;</code>
     * @param string $var
     * @return $this
     */
    public function setDeviceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->device_name = $var;

        return $this;
    }

    /**
     * Specifies whether to include the disk and what image to use. Possible
     * values are:
     *      - source-image: to use the same image that was used to
     *      create the source instance's corresponding disk. Applicable to the boot
     *      disk and additional read-write disks.
     *      - source-image-family: to use the same image family that
     *      was used to create the source instance's corresponding disk. Applicable
     *      to the boot disk and additional read-write disks.
     *      - custom-image: to use a user-provided image url for disk
     *      creation. Applicable to the boot disk and additional read-write
     *      disks.
     *    - attach-read-only: to attach a read-only
     *      disk. Applicable to read-only disks.
     *      - do-not-include: to exclude a disk from the template.
     *      Applicable to additional read-write disks, local SSDs, and read-only
     *      disks.
     * Check the InstantiateFrom enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string instantiate_from = 393383903;</code>
     * @return string
     */
    public function getInstantiateFrom()
    {
        return isset($this->instantiate_from) ? $this->instantiate_from : '';
    }

    public function hasInstantiateFrom()
    {
        return isset($this->instantiate_from);
    }

    public function clearInstantiateFrom()
    {
        unset($this->instantiate_from);
    }

    /**
     * Specifies whether to include the disk and what image to use. Possible
     * values are:
     *      - source-image: to use the same image that was used to
     *      create the source instance's corresponding disk. Applicable to the boot
     *      disk and additional read-write disks.
     *      - source-image-family: to use the same image family that
     *      was used to create the source instance's corresponding disk. Applicable
     *      to the boot disk and additional read-write disks.
     *      - custom-image: to use a user-provided image url for disk
     *      creation. Applicable to the boot disk and additional read-write
     *      disks.
     *    - attach-read-only: to attach a read-only
     *      disk. Applicable to read-only disks.
     *      - do-not-include: to exclude a disk from the template.
     *      Applicable to additional read-write disks, local SSDs, and read-only
     *      disks.
     * Check the InstantiateFrom enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string instantiate_from = 393383903;</code>
     * @param string $var
     * @return $this
     */
    public function setInstantiateFrom($var)
    {
        GPBUtil::checkString($var, True);
        $this->instantiate_from = $var;

        return $this;
    }

}

