<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1\AutoscalerStatusDetails;

use UnexpectedValueException;

/**
 * The type of error, warning, or notice returned. Current set of possible
 * values:
 *    - ALL_INSTANCES_UNHEALTHY (WARNING):
 *      All instances in the instance group are unhealthy (not in RUNNING
 *      state).
 *    - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR):
 *      There is no backend service attached to the instance group.
 *    - CAPPED_AT_MAX_NUM_REPLICAS (WARNING):
 *      Autoscaler recommends a size greater than maxNumReplicas.
 *    - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING):
 *      The custom metric samples are not exported often enough to be
 *      a credible base for autoscaling.
 *    - CUSTOM_METRIC_INVALID (ERROR):
 *      The custom metric that was specified does not exist or does not have
 *      the necessary labels.
 *    - MIN_EQUALS_MAX (WARNING):
 *      The minNumReplicas is equal to maxNumReplicas. This means the
 *      autoscaler cannot add or remove instances from the instance group.
 *    - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING):
 *      The autoscaler did not receive any data from the custom metric
 *      configured for autoscaling.
 *    - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING):
 *      The autoscaler is configured to scale based on a load balancing signal
 *      but the instance group has not received any requests from the load
 *      balancer.
 *    - MODE_OFF (WARNING):
 *      Autoscaling is turned off. The number of instances in the group won't
 *      change automatically. The autoscaling configuration is preserved.
 *    - MODE_ONLY_UP (WARNING):
 *      Autoscaling is in the "Autoscale only out" mode. The autoscaler can add
 *      instances but not remove any.
 *    - MORE_THAN_ONE_BACKEND_SERVICE (ERROR):
 *      The instance group cannot be autoscaled because it has more than one
 *      backend service attached to it.
 *    - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR):
 *      There is insufficient quota for the necessary resources, such as CPU or
 *      number of instances.
 *    - REGION_RESOURCE_STOCKOUT (ERROR):
 *      Shown only for regional autoscalers: there is a resource stockout in
 *      the chosen region.
 *    - SCALING_TARGET_DOES_NOT_EXIST (ERROR):
 *      The target to be scaled does not exist.
 *    - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION
 *      (ERROR): Autoscaling does not work with an HTTP/S load balancer that
 *      has been configured for maxRate.
 *    - ZONE_RESOURCE_STOCKOUT (ERROR):
 *      For zonal autoscalers: there is a resource stockout in the chosen zone.
 *      For regional autoscalers: in at least one of the zones you're using
 *      there is a resource stockout.
 * New values might be added in the future. Some of the values might not be
 * available in all API versions.
 *
 * Protobuf type <code>google.cloud.compute.v1.AutoscalerStatusDetails.Type</code>
 */
class Type
{
    /**
     * A value indicating that the enum field is not set.
     *
     * Generated from protobuf enum <code>UNDEFINED_TYPE = 0;</code>
     */
    const UNDEFINED_TYPE = 0;
    /**
     * All instances in the instance group are unhealthy (not in RUNNING state).
     *
     * Generated from protobuf enum <code>ALL_INSTANCES_UNHEALTHY = 404965477;</code>
     */
    const ALL_INSTANCES_UNHEALTHY = 404965477;
    /**
     * There is no backend service attached to the instance group.
     *
     * Generated from protobuf enum <code>BACKEND_SERVICE_DOES_NOT_EXIST = 191417626;</code>
     */
    const BACKEND_SERVICE_DOES_NOT_EXIST = 191417626;
    /**
     * Autoscaler recommends a size greater than maxNumReplicas.
     *
     * Generated from protobuf enum <code>CAPPED_AT_MAX_NUM_REPLICAS = 518617;</code>
     */
    const CAPPED_AT_MAX_NUM_REPLICAS = 518617;
    /**
     * The custom metric samples are not exported often enough to be a credible
     * base for autoscaling.
     *
     * Generated from protobuf enum <code>CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 328964659;</code>
     */
    const CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 328964659;
    /**
     * The custom metric that was specified does not exist or does not have the
     * necessary labels.
     *
     * Generated from protobuf enum <code>CUSTOM_METRIC_INVALID = 204430550;</code>
     */
    const CUSTOM_METRIC_INVALID = 204430550;
    /**
     * The minNumReplicas is equal to maxNumReplicas. This means the autoscaler
     * cannot add or remove instances from the instance group.
     *
     * Generated from protobuf enum <code>MIN_EQUALS_MAX = 2821361;</code>
     */
    const MIN_EQUALS_MAX = 2821361;
    /**
     * The autoscaler did not receive any data from the custom metric configured
     * for autoscaling.
     *
     * Generated from protobuf enum <code>MISSING_CUSTOM_METRIC_DATA_POINTS = 94885086;</code>
     */
    const MISSING_CUSTOM_METRIC_DATA_POINTS = 94885086;
    /**
     * The autoscaler is configured to scale based on a load balancing signal
     * but the instance group has not received any requests from the load
     * balancer.
     *
     * Generated from protobuf enum <code>MISSING_LOAD_BALANCING_DATA_POINTS = 509858898;</code>
     */
    const MISSING_LOAD_BALANCING_DATA_POINTS = 509858898;
    /**
     * Autoscaling is turned off. The number of instances in the group won't
     * change automatically. The autoscaling configuration is preserved.
     *
     * Generated from protobuf enum <code>MODE_OFF = 164169907;</code>
     */
    const MODE_OFF = 164169907;
    /**
     * Autoscaling is in the "Autoscale only scale out" mode.
     * Instances in the group will be only added.
     *
     * Generated from protobuf enum <code>MODE_ONLY_SCALE_OUT = 3840994;</code>
     */
    const MODE_ONLY_SCALE_OUT = 3840994;
    /**
     * Autoscaling is in the "Autoscale only out" mode. Instances in the group
     * will be only added.
     *
     * Generated from protobuf enum <code>MODE_ONLY_UP = 100969842;</code>
     */
    const MODE_ONLY_UP = 100969842;
    /**
     * The instance group cannot be autoscaled because it has more than one
     * backend service attached to it.
     *
     * Generated from protobuf enum <code>MORE_THAN_ONE_BACKEND_SERVICE = 151922141;</code>
     */
    const MORE_THAN_ONE_BACKEND_SERVICE = 151922141;
    /**
     * There is insufficient quota for the necessary resources, such as CPU or
     * number of instances.
     *
     * Generated from protobuf enum <code>NOT_ENOUGH_QUOTA_AVAILABLE = 403101631;</code>
     */
    const NOT_ENOUGH_QUOTA_AVAILABLE = 403101631;
    /**
     * Showed only for regional autoscalers: there is a resource stockout in
     * the chosen region.
     *
     * Generated from protobuf enum <code>REGION_RESOURCE_STOCKOUT = 528622846;</code>
     */
    const REGION_RESOURCE_STOCKOUT = 528622846;
    /**
     * The target to be scaled does not exist.
     *
     * Generated from protobuf enum <code>SCALING_TARGET_DOES_NOT_EXIST = 122636699;</code>
     */
    const SCALING_TARGET_DOES_NOT_EXIST = 122636699;
    /**
     * For some scaling schedules minRequiredReplicas is greater than
     * maxNumReplicas. Autoscaler always recommends at most maxNumReplicas
     * instances.
     *
     * Generated from protobuf enum <code>SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX = 29275586;</code>
     */
    const SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX = 29275586;
    /**
     * For some scaling schedules minRequiredReplicas is less than
     * minNumReplicas. Autoscaler always recommends at least minNumReplicas
     * instances.
     *
     * Generated from protobuf enum <code>SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN = 398287669;</code>
     */
    const SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN = 398287669;
    /**
     * Generated from protobuf enum <code>UNKNOWN = 433141802;</code>
     */
    const UNKNOWN = 433141802;
    /**
     * Autoscaling does not work with an HTTP/S load balancer that has been
     * configured for maxRate.
     *
     * Generated from protobuf enum <code>UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 330845009;</code>
     */
    const UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 330845009;
    /**
     * For zonal autoscalers: there is a resource stockout in the chosen zone.
     * For regional autoscalers: in at least one of the zones you're using there
     * is a resource stockout.
     *
     * Generated from protobuf enum <code>ZONE_RESOURCE_STOCKOUT = 210200502;</code>
     */
    const ZONE_RESOURCE_STOCKOUT = 210200502;

    private static $valueToName = [
        self::UNDEFINED_TYPE => 'UNDEFINED_TYPE',
        self::ALL_INSTANCES_UNHEALTHY => 'ALL_INSTANCES_UNHEALTHY',
        self::BACKEND_SERVICE_DOES_NOT_EXIST => 'BACKEND_SERVICE_DOES_NOT_EXIST',
        self::CAPPED_AT_MAX_NUM_REPLICAS => 'CAPPED_AT_MAX_NUM_REPLICAS',
        self::CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE => 'CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE',
        self::CUSTOM_METRIC_INVALID => 'CUSTOM_METRIC_INVALID',
        self::MIN_EQUALS_MAX => 'MIN_EQUALS_MAX',
        self::MISSING_CUSTOM_METRIC_DATA_POINTS => 'MISSING_CUSTOM_METRIC_DATA_POINTS',
        self::MISSING_LOAD_BALANCING_DATA_POINTS => 'MISSING_LOAD_BALANCING_DATA_POINTS',
        self::MODE_OFF => 'MODE_OFF',
        self::MODE_ONLY_SCALE_OUT => 'MODE_ONLY_SCALE_OUT',
        self::MODE_ONLY_UP => 'MODE_ONLY_UP',
        self::MORE_THAN_ONE_BACKEND_SERVICE => 'MORE_THAN_ONE_BACKEND_SERVICE',
        self::NOT_ENOUGH_QUOTA_AVAILABLE => 'NOT_ENOUGH_QUOTA_AVAILABLE',
        self::REGION_RESOURCE_STOCKOUT => 'REGION_RESOURCE_STOCKOUT',
        self::SCALING_TARGET_DOES_NOT_EXIST => 'SCALING_TARGET_DOES_NOT_EXIST',
        self::SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX => 'SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX',
        self::SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN => 'SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN',
        self::UNKNOWN => 'UNKNOWN',
        self::UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION => 'UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION',
        self::ZONE_RESOURCE_STOCKOUT => 'ZONE_RESOURCE_STOCKOUT',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


