<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/backupdr/v1/protection_summary.proto

namespace Google\Cloud\BackupDR\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ResourceBackupConfig represents a resource along with its backup
 * configurations.
 *
 * Generated from protobuf message <code>google.cloud.backupdr.v1.ResourceBackupConfig</code>
 */
class ResourceBackupConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the ResourceBackupConfig.
     * Format:
     * projects/{project}/locations/{location}/resourceBackupConfigs/{uid}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The unique identifier of the resource backup config.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     */
    protected $uid = '';
    /**
     * Output only. The [full resource
     * name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * of the cloud resource that this configuration applies to. Supported
     * resource types are
     * [ResourceBackupConfig.ResourceType][google.cloud.backupdr.v1.ResourceBackupConfig.ResourceType].
     *
     * Generated from protobuf field <code>string target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $target_resource = '';
    /**
     * Output only. The human friendly name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $target_resource_display_name = '';
    /**
     * Output only. The type of the target resource.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.ResourceBackupConfig.ResourceType target_resource_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $target_resource_type = 0;
    /**
     * Labels associated with the target resource.
     *
     * Generated from protobuf field <code>map<string, string> target_resource_labels = 6;</code>
     */
    private $target_resource_labels;
    /**
     * Backup configurations applying to the target resource, including those
     * targeting its related/child resources. For example, backup configuration
     * applicable to Compute Engine disks will be populated in this field for a
     * Compute Engine VM which has the disk associated.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.BackupConfigDetails backup_configs_details = 7;</code>
     */
    private $backup_configs_details;
    /**
     * Output only. Whether the target resource is configured for backup. This is
     * true if the backup_configs_details is not empty.
     *
     * Generated from protobuf field <code>bool backup_configured = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $backup_configured = false;
    /**
     * Output only. Whether the target resource is protected by a backup vault.
     * This is true if the backup_configs_details is not empty and any of the
     * [ResourceBackupConfig.backup_configs_details][google.cloud.backupdr.v1.ResourceBackupConfig.backup_configs_details]
     * has a backup configuration with
     * [BackupConfigDetails.backup_vault][google.cloud.backupdr.v1.BackupConfigDetails.backup_vault]
     * set. set.
     *
     * Generated from protobuf field <code>bool vaulted = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $vaulted = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the ResourceBackupConfig.
     *           Format:
     *           projects/{project}/locations/{location}/resourceBackupConfigs/{uid}
     *     @type string $uid
     *           Output only. The unique identifier of the resource backup config.
     *     @type string $target_resource
     *           Output only. The [full resource
     *           name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     *           of the cloud resource that this configuration applies to. Supported
     *           resource types are
     *           [ResourceBackupConfig.ResourceType][google.cloud.backupdr.v1.ResourceBackupConfig.ResourceType].
     *     @type string $target_resource_display_name
     *           Output only. The human friendly name of the target resource.
     *     @type int $target_resource_type
     *           Output only. The type of the target resource.
     *     @type array|\Google\Protobuf\Internal\MapField $target_resource_labels
     *           Labels associated with the target resource.
     *     @type array<\Google\Cloud\BackupDR\V1\BackupConfigDetails>|\Google\Protobuf\Internal\RepeatedField $backup_configs_details
     *           Backup configurations applying to the target resource, including those
     *           targeting its related/child resources. For example, backup configuration
     *           applicable to Compute Engine disks will be populated in this field for a
     *           Compute Engine VM which has the disk associated.
     *     @type bool $backup_configured
     *           Output only. Whether the target resource is configured for backup. This is
     *           true if the backup_configs_details is not empty.
     *     @type bool $vaulted
     *           Output only. Whether the target resource is protected by a backup vault.
     *           This is true if the backup_configs_details is not empty and any of the
     *           [ResourceBackupConfig.backup_configs_details][google.cloud.backupdr.v1.ResourceBackupConfig.backup_configs_details]
     *           has a backup configuration with
     *           [BackupConfigDetails.backup_vault][google.cloud.backupdr.v1.BackupConfigDetails.backup_vault]
     *           set. set.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Backupdr\V1\ProtectionSummary::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the ResourceBackupConfig.
     * Format:
     * projects/{project}/locations/{location}/resourceBackupConfigs/{uid}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the ResourceBackupConfig.
     * Format:
     * projects/{project}/locations/{location}/resourceBackupConfigs/{uid}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The unique identifier of the resource backup config.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. The unique identifier of the resource backup config.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. The [full resource
     * name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * of the cloud resource that this configuration applies to. Supported
     * resource types are
     * [ResourceBackupConfig.ResourceType][google.cloud.backupdr.v1.ResourceBackupConfig.ResourceType].
     *
     * Generated from protobuf field <code>string target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTargetResource()
    {
        return $this->target_resource;
    }

    /**
     * Output only. The [full resource
     * name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * of the cloud resource that this configuration applies to. Supported
     * resource types are
     * [ResourceBackupConfig.ResourceType][google.cloud.backupdr.v1.ResourceBackupConfig.ResourceType].
     *
     * Generated from protobuf field <code>string target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_resource = $var;

        return $this;
    }

    /**
     * Output only. The human friendly name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTargetResourceDisplayName()
    {
        return $this->target_resource_display_name;
    }

    /**
     * Output only. The human friendly name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetResourceDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_resource_display_name = $var;

        return $this;
    }

    /**
     * Output only. The type of the target resource.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.ResourceBackupConfig.ResourceType target_resource_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getTargetResourceType()
    {
        return $this->target_resource_type;
    }

    /**
     * Output only. The type of the target resource.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.ResourceBackupConfig.ResourceType target_resource_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setTargetResourceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BackupDR\V1\ResourceBackupConfig\ResourceType::class);
        $this->target_resource_type = $var;

        return $this;
    }

    /**
     * Labels associated with the target resource.
     *
     * Generated from protobuf field <code>map<string, string> target_resource_labels = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getTargetResourceLabels()
    {
        return $this->target_resource_labels;
    }

    /**
     * Labels associated with the target resource.
     *
     * Generated from protobuf field <code>map<string, string> target_resource_labels = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setTargetResourceLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->target_resource_labels = $arr;

        return $this;
    }

    /**
     * Backup configurations applying to the target resource, including those
     * targeting its related/child resources. For example, backup configuration
     * applicable to Compute Engine disks will be populated in this field for a
     * Compute Engine VM which has the disk associated.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.BackupConfigDetails backup_configs_details = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBackupConfigsDetails()
    {
        return $this->backup_configs_details;
    }

    /**
     * Backup configurations applying to the target resource, including those
     * targeting its related/child resources. For example, backup configuration
     * applicable to Compute Engine disks will be populated in this field for a
     * Compute Engine VM which has the disk associated.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.BackupConfigDetails backup_configs_details = 7;</code>
     * @param array<\Google\Cloud\BackupDR\V1\BackupConfigDetails>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBackupConfigsDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BackupDR\V1\BackupConfigDetails::class);
        $this->backup_configs_details = $arr;

        return $this;
    }

    /**
     * Output only. Whether the target resource is configured for backup. This is
     * true if the backup_configs_details is not empty.
     *
     * Generated from protobuf field <code>bool backup_configured = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getBackupConfigured()
    {
        return $this->backup_configured;
    }

    /**
     * Output only. Whether the target resource is configured for backup. This is
     * true if the backup_configs_details is not empty.
     *
     * Generated from protobuf field <code>bool backup_configured = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setBackupConfigured($var)
    {
        GPBUtil::checkBool($var);
        $this->backup_configured = $var;

        return $this;
    }

    /**
     * Output only. Whether the target resource is protected by a backup vault.
     * This is true if the backup_configs_details is not empty and any of the
     * [ResourceBackupConfig.backup_configs_details][google.cloud.backupdr.v1.ResourceBackupConfig.backup_configs_details]
     * has a backup configuration with
     * [BackupConfigDetails.backup_vault][google.cloud.backupdr.v1.BackupConfigDetails.backup_vault]
     * set. set.
     *
     * Generated from protobuf field <code>bool vaulted = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getVaulted()
    {
        return $this->vaulted;
    }

    /**
     * Output only. Whether the target resource is protected by a backup vault.
     * This is true if the backup_configs_details is not empty and any of the
     * [ResourceBackupConfig.backup_configs_details][google.cloud.backupdr.v1.ResourceBackupConfig.backup_configs_details]
     * has a backup configuration with
     * [BackupConfigDetails.backup_vault][google.cloud.backupdr.v1.BackupConfigDetails.backup_vault]
     * set. set.
     *
     * Generated from protobuf field <code>bool vaulted = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setVaulted($var)
    {
        GPBUtil::checkBool($var);
        $this->vaulted = $var;

        return $this;
    }

}

