<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/reviews/v1beta/productreviews_common.proto

namespace Google\Shopping\Merchant\Reviews\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Attributes.
 *
 * Generated from protobuf message <code>google.shopping.merchant.reviews.v1beta.ProductReviewAttributes</code>
 */
class ProductReviewAttributes extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The name of the aggregator of the product reviews.
     * A publisher may use a reviews aggregator to manage reviews and provide
     * the feeds. This element indicates the use of an aggregator and contains
     * information about the aggregator.
     *
     * Generated from protobuf field <code>optional string aggregator_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $aggregator_name = null;
    /**
     * Optional. The name of the subclient of the product reviews.
     * The subclient is an identifier of the product review source.
     * It should be equivalent to the directory provided in the file data source
     * path.
     *
     * Generated from protobuf field <code>optional string subclient_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $subclient_name = null;
    /**
     * Optional. The name of the publisher of the product reviews.
     * The information about the publisher, which may be a retailer,
     * manufacturer, reviews service company, or any entity that publishes
     * product reviews.
     *
     * Generated from protobuf field <code>optional string publisher_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $publisher_name = null;
    /**
     * Optional. A link to the company favicon of the publisher. The image
     * dimensions should be favicon size: 16x16 pixels. The image format should be
     * GIF, JPG or PNG.
     *
     * Generated from protobuf field <code>optional string publisher_favicon = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $publisher_favicon = null;
    /**
     * Optional. The author of the product review.
     * A permanent, unique identifier for the author of the review in the
     * publisher's system.
     *
     * Generated from protobuf field <code>optional string reviewer_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $reviewer_id = null;
    /**
     * Optional. Set to true if the reviewer should remain anonymous.
     *
     * Generated from protobuf field <code>optional bool reviewer_is_anonymous = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $reviewer_is_anonymous = null;
    /**
     * Optional. The name of the reviewer of the product review.
     *
     * Generated from protobuf field <code>optional string reviewer_username = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $reviewer_username = null;
    /**
     * Optional. The language of the review defined by BCP-47 language code.
     *
     * Generated from protobuf field <code>optional string review_language = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $review_language = null;
    /**
     * Optional. The country of the review defined by ISO 3166-1 Alpha-2 Country
     * Code.
     *
     * Generated from protobuf field <code>optional string review_country = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $review_country = null;
    /**
     * Required. The timestamp indicating when the review was written.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp review_time = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $review_time = null;
    /**
     * Optional. The title of the review.
     *
     * Generated from protobuf field <code>optional string title = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $title = null;
    /**
     * Required. The content of the review.
     *
     * Generated from protobuf field <code>optional string content = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $content = null;
    /**
     * Optional. Contains the advantages based on the opinion of the reviewer.
     * Omit boilerplate text like "pro:" unless it was written by the reviewer.
     *
     * Generated from protobuf field <code>repeated string pros = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $pros;
    /**
     * Optional. Contains the disadvantages based on the opinion of the reviewer.
     * Omit boilerplate text like "con:" unless it was written by the reviewer.
     *
     * Generated from protobuf field <code>repeated string cons = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $cons;
    /**
     * Optional. The URI of the review landing page.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.ReviewLink review_link = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $review_link = null;
    /**
     * Optional. A URI to an image of the reviewed product created by the review
     * author. The URI does not have to end with an image file extension.
     *
     * Generated from protobuf field <code>repeated string reviewer_image_links = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $reviewer_image_links;
    /**
     * Optional. Contains the ratings associated with the review.
     * The minimum possible number for the rating. This should be the worst
     * possible rating and should not be a value for no rating.
     *
     * Generated from protobuf field <code>optional int64 min_rating = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $min_rating = null;
    /**
     * Optional. The maximum possible number for the rating. The value of the max
     * rating must be greater than the value of the min attribute.
     *
     * Generated from protobuf field <code>optional int64 max_rating = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $max_rating = null;
    /**
     * Optional. The reviewer's overall rating of the product.
     *
     * Generated from protobuf field <code>optional double rating = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $rating = null;
    /**
     * Optional. Descriptive name of a product.
     *
     * Generated from protobuf field <code>repeated string product_names = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $product_names;
    /**
     * Optional. The URI of the product. This URI can have the same value as the
     * `review_link` element, if the review URI and the product URI are the
     * same.
     *
     * Generated from protobuf field <code>repeated string product_links = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $product_links;
    /**
     * Optional. Contains ASINs (Amazon Standard Identification Numbers)
     * associated with a product.
     *
     * Generated from protobuf field <code>repeated string asins = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $asins;
    /**
     * Optional. Contains GTINs (global trade item numbers) associated with a
     * product. Sub-types of GTINs (e.g. UPC, EAN, ISBN, JAN) are supported.
     *
     * Generated from protobuf field <code>repeated string gtins = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $gtins;
    /**
     * Optional. Contains MPNs (manufacturer part numbers) associated with a
     * product.
     *
     * Generated from protobuf field <code>repeated string mpns = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $mpns;
    /**
     * Optional. Contains SKUs (stock keeping units) associated with a product.
     * Often this matches the product Offer Id in the product feed.
     *
     * Generated from protobuf field <code>repeated string skus = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $skus;
    /**
     * Optional. Contains brand names associated with a product.
     *
     * Generated from protobuf field <code>repeated string brands = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $brands;
    /**
     * Optional. Indicates whether the review is marked as spam in the publisher's
     * system.
     *
     * Generated from protobuf field <code>optional bool is_spam = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $is_spam = null;
    /**
     * Optional. The method used to collect the review.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.CollectionMethod collection_method = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $collection_method = 0;
    /**
     * Optional. A permanent, unique identifier for the transaction associated
     * with the review in the publisher's system. This ID can be used to indicate
     * that multiple reviews are associated with the same transaction.
     *
     * Generated from protobuf field <code>string transaction_id = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $transaction_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $aggregator_name
     *           Optional. The name of the aggregator of the product reviews.
     *           A publisher may use a reviews aggregator to manage reviews and provide
     *           the feeds. This element indicates the use of an aggregator and contains
     *           information about the aggregator.
     *     @type string $subclient_name
     *           Optional. The name of the subclient of the product reviews.
     *           The subclient is an identifier of the product review source.
     *           It should be equivalent to the directory provided in the file data source
     *           path.
     *     @type string $publisher_name
     *           Optional. The name of the publisher of the product reviews.
     *           The information about the publisher, which may be a retailer,
     *           manufacturer, reviews service company, or any entity that publishes
     *           product reviews.
     *     @type string $publisher_favicon
     *           Optional. A link to the company favicon of the publisher. The image
     *           dimensions should be favicon size: 16x16 pixels. The image format should be
     *           GIF, JPG or PNG.
     *     @type string $reviewer_id
     *           Optional. The author of the product review.
     *           A permanent, unique identifier for the author of the review in the
     *           publisher's system.
     *     @type bool $reviewer_is_anonymous
     *           Optional. Set to true if the reviewer should remain anonymous.
     *     @type string $reviewer_username
     *           Optional. The name of the reviewer of the product review.
     *     @type string $review_language
     *           Optional. The language of the review defined by BCP-47 language code.
     *     @type string $review_country
     *           Optional. The country of the review defined by ISO 3166-1 Alpha-2 Country
     *           Code.
     *     @type \Google\Protobuf\Timestamp $review_time
     *           Required. The timestamp indicating when the review was written.
     *     @type string $title
     *           Optional. The title of the review.
     *     @type string $content
     *           Required. The content of the review.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $pros
     *           Optional. Contains the advantages based on the opinion of the reviewer.
     *           Omit boilerplate text like "pro:" unless it was written by the reviewer.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $cons
     *           Optional. Contains the disadvantages based on the opinion of the reviewer.
     *           Omit boilerplate text like "con:" unless it was written by the reviewer.
     *     @type \Google\Shopping\Merchant\Reviews\V1beta\ProductReviewAttributes\ReviewLink $review_link
     *           Optional. The URI of the review landing page.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $reviewer_image_links
     *           Optional. A URI to an image of the reviewed product created by the review
     *           author. The URI does not have to end with an image file extension.
     *     @type int|string $min_rating
     *           Optional. Contains the ratings associated with the review.
     *           The minimum possible number for the rating. This should be the worst
     *           possible rating and should not be a value for no rating.
     *     @type int|string $max_rating
     *           Optional. The maximum possible number for the rating. The value of the max
     *           rating must be greater than the value of the min attribute.
     *     @type float $rating
     *           Optional. The reviewer's overall rating of the product.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $product_names
     *           Optional. Descriptive name of a product.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $product_links
     *           Optional. The URI of the product. This URI can have the same value as the
     *           `review_link` element, if the review URI and the product URI are the
     *           same.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $asins
     *           Optional. Contains ASINs (Amazon Standard Identification Numbers)
     *           associated with a product.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $gtins
     *           Optional. Contains GTINs (global trade item numbers) associated with a
     *           product. Sub-types of GTINs (e.g. UPC, EAN, ISBN, JAN) are supported.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $mpns
     *           Optional. Contains MPNs (manufacturer part numbers) associated with a
     *           product.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $skus
     *           Optional. Contains SKUs (stock keeping units) associated with a product.
     *           Often this matches the product Offer Id in the product feed.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $brands
     *           Optional. Contains brand names associated with a product.
     *     @type bool $is_spam
     *           Optional. Indicates whether the review is marked as spam in the publisher's
     *           system.
     *     @type int $collection_method
     *           Optional. The method used to collect the review.
     *     @type string $transaction_id
     *           Optional. A permanent, unique identifier for the transaction associated
     *           with the review in the publisher's system. This ID can be used to indicate
     *           that multiple reviews are associated with the same transaction.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Reviews\V1Beta\ProductreviewsCommon::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The name of the aggregator of the product reviews.
     * A publisher may use a reviews aggregator to manage reviews and provide
     * the feeds. This element indicates the use of an aggregator and contains
     * information about the aggregator.
     *
     * Generated from protobuf field <code>optional string aggregator_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAggregatorName()
    {
        return isset($this->aggregator_name) ? $this->aggregator_name : '';
    }

    public function hasAggregatorName()
    {
        return isset($this->aggregator_name);
    }

    public function clearAggregatorName()
    {
        unset($this->aggregator_name);
    }

    /**
     * Optional. The name of the aggregator of the product reviews.
     * A publisher may use a reviews aggregator to manage reviews and provide
     * the feeds. This element indicates the use of an aggregator and contains
     * information about the aggregator.
     *
     * Generated from protobuf field <code>optional string aggregator_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAggregatorName($var)
    {
        GPBUtil::checkString($var, True);
        $this->aggregator_name = $var;

        return $this;
    }

    /**
     * Optional. The name of the subclient of the product reviews.
     * The subclient is an identifier of the product review source.
     * It should be equivalent to the directory provided in the file data source
     * path.
     *
     * Generated from protobuf field <code>optional string subclient_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSubclientName()
    {
        return isset($this->subclient_name) ? $this->subclient_name : '';
    }

    public function hasSubclientName()
    {
        return isset($this->subclient_name);
    }

    public function clearSubclientName()
    {
        unset($this->subclient_name);
    }

    /**
     * Optional. The name of the subclient of the product reviews.
     * The subclient is an identifier of the product review source.
     * It should be equivalent to the directory provided in the file data source
     * path.
     *
     * Generated from protobuf field <code>optional string subclient_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSubclientName($var)
    {
        GPBUtil::checkString($var, True);
        $this->subclient_name = $var;

        return $this;
    }

    /**
     * Optional. The name of the publisher of the product reviews.
     * The information about the publisher, which may be a retailer,
     * manufacturer, reviews service company, or any entity that publishes
     * product reviews.
     *
     * Generated from protobuf field <code>optional string publisher_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPublisherName()
    {
        return isset($this->publisher_name) ? $this->publisher_name : '';
    }

    public function hasPublisherName()
    {
        return isset($this->publisher_name);
    }

    public function clearPublisherName()
    {
        unset($this->publisher_name);
    }

    /**
     * Optional. The name of the publisher of the product reviews.
     * The information about the publisher, which may be a retailer,
     * manufacturer, reviews service company, or any entity that publishes
     * product reviews.
     *
     * Generated from protobuf field <code>optional string publisher_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPublisherName($var)
    {
        GPBUtil::checkString($var, True);
        $this->publisher_name = $var;

        return $this;
    }

    /**
     * Optional. A link to the company favicon of the publisher. The image
     * dimensions should be favicon size: 16x16 pixels. The image format should be
     * GIF, JPG or PNG.
     *
     * Generated from protobuf field <code>optional string publisher_favicon = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPublisherFavicon()
    {
        return isset($this->publisher_favicon) ? $this->publisher_favicon : '';
    }

    public function hasPublisherFavicon()
    {
        return isset($this->publisher_favicon);
    }

    public function clearPublisherFavicon()
    {
        unset($this->publisher_favicon);
    }

    /**
     * Optional. A link to the company favicon of the publisher. The image
     * dimensions should be favicon size: 16x16 pixels. The image format should be
     * GIF, JPG or PNG.
     *
     * Generated from protobuf field <code>optional string publisher_favicon = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPublisherFavicon($var)
    {
        GPBUtil::checkString($var, True);
        $this->publisher_favicon = $var;

        return $this;
    }

    /**
     * Optional. The author of the product review.
     * A permanent, unique identifier for the author of the review in the
     * publisher's system.
     *
     * Generated from protobuf field <code>optional string reviewer_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getReviewerId()
    {
        return isset($this->reviewer_id) ? $this->reviewer_id : '';
    }

    public function hasReviewerId()
    {
        return isset($this->reviewer_id);
    }

    public function clearReviewerId()
    {
        unset($this->reviewer_id);
    }

    /**
     * Optional. The author of the product review.
     * A permanent, unique identifier for the author of the review in the
     * publisher's system.
     *
     * Generated from protobuf field <code>optional string reviewer_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setReviewerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->reviewer_id = $var;

        return $this;
    }

    /**
     * Optional. Set to true if the reviewer should remain anonymous.
     *
     * Generated from protobuf field <code>optional bool reviewer_is_anonymous = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getReviewerIsAnonymous()
    {
        return isset($this->reviewer_is_anonymous) ? $this->reviewer_is_anonymous : false;
    }

    public function hasReviewerIsAnonymous()
    {
        return isset($this->reviewer_is_anonymous);
    }

    public function clearReviewerIsAnonymous()
    {
        unset($this->reviewer_is_anonymous);
    }

    /**
     * Optional. Set to true if the reviewer should remain anonymous.
     *
     * Generated from protobuf field <code>optional bool reviewer_is_anonymous = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setReviewerIsAnonymous($var)
    {
        GPBUtil::checkBool($var);
        $this->reviewer_is_anonymous = $var;

        return $this;
    }

    /**
     * Optional. The name of the reviewer of the product review.
     *
     * Generated from protobuf field <code>optional string reviewer_username = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getReviewerUsername()
    {
        return isset($this->reviewer_username) ? $this->reviewer_username : '';
    }

    public function hasReviewerUsername()
    {
        return isset($this->reviewer_username);
    }

    public function clearReviewerUsername()
    {
        unset($this->reviewer_username);
    }

    /**
     * Optional. The name of the reviewer of the product review.
     *
     * Generated from protobuf field <code>optional string reviewer_username = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setReviewerUsername($var)
    {
        GPBUtil::checkString($var, True);
        $this->reviewer_username = $var;

        return $this;
    }

    /**
     * Optional. The language of the review defined by BCP-47 language code.
     *
     * Generated from protobuf field <code>optional string review_language = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getReviewLanguage()
    {
        return isset($this->review_language) ? $this->review_language : '';
    }

    public function hasReviewLanguage()
    {
        return isset($this->review_language);
    }

    public function clearReviewLanguage()
    {
        unset($this->review_language);
    }

    /**
     * Optional. The language of the review defined by BCP-47 language code.
     *
     * Generated from protobuf field <code>optional string review_language = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setReviewLanguage($var)
    {
        GPBUtil::checkString($var, True);
        $this->review_language = $var;

        return $this;
    }

    /**
     * Optional. The country of the review defined by ISO 3166-1 Alpha-2 Country
     * Code.
     *
     * Generated from protobuf field <code>optional string review_country = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getReviewCountry()
    {
        return isset($this->review_country) ? $this->review_country : '';
    }

    public function hasReviewCountry()
    {
        return isset($this->review_country);
    }

    public function clearReviewCountry()
    {
        unset($this->review_country);
    }

    /**
     * Optional. The country of the review defined by ISO 3166-1 Alpha-2 Country
     * Code.
     *
     * Generated from protobuf field <code>optional string review_country = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setReviewCountry($var)
    {
        GPBUtil::checkString($var, True);
        $this->review_country = $var;

        return $this;
    }

    /**
     * Required. The timestamp indicating when the review was written.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp review_time = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getReviewTime()
    {
        return $this->review_time;
    }

    public function hasReviewTime()
    {
        return isset($this->review_time);
    }

    public function clearReviewTime()
    {
        unset($this->review_time);
    }

    /**
     * Required. The timestamp indicating when the review was written.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp review_time = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setReviewTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->review_time = $var;

        return $this;
    }

    /**
     * Optional. The title of the review.
     *
     * Generated from protobuf field <code>optional string title = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getTitle()
    {
        return isset($this->title) ? $this->title : '';
    }

    public function hasTitle()
    {
        return isset($this->title);
    }

    public function clearTitle()
    {
        unset($this->title);
    }

    /**
     * Optional. The title of the review.
     *
     * Generated from protobuf field <code>optional string title = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * Required. The content of the review.
     *
     * Generated from protobuf field <code>optional string content = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getContent()
    {
        return isset($this->content) ? $this->content : '';
    }

    public function hasContent()
    {
        return isset($this->content);
    }

    public function clearContent()
    {
        unset($this->content);
    }

    /**
     * Required. The content of the review.
     *
     * Generated from protobuf field <code>optional string content = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setContent($var)
    {
        GPBUtil::checkString($var, True);
        $this->content = $var;

        return $this;
    }

    /**
     * Optional. Contains the advantages based on the opinion of the reviewer.
     * Omit boilerplate text like "pro:" unless it was written by the reviewer.
     *
     * Generated from protobuf field <code>repeated string pros = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPros()
    {
        return $this->pros;
    }

    /**
     * Optional. Contains the advantages based on the opinion of the reviewer.
     * Omit boilerplate text like "pro:" unless it was written by the reviewer.
     *
     * Generated from protobuf field <code>repeated string pros = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPros($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->pros = $arr;

        return $this;
    }

    /**
     * Optional. Contains the disadvantages based on the opinion of the reviewer.
     * Omit boilerplate text like "con:" unless it was written by the reviewer.
     *
     * Generated from protobuf field <code>repeated string cons = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCons()
    {
        return $this->cons;
    }

    /**
     * Optional. Contains the disadvantages based on the opinion of the reviewer.
     * Omit boilerplate text like "con:" unless it was written by the reviewer.
     *
     * Generated from protobuf field <code>repeated string cons = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCons($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->cons = $arr;

        return $this;
    }

    /**
     * Optional. The URI of the review landing page.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.ReviewLink review_link = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Merchant\Reviews\V1beta\ProductReviewAttributes\ReviewLink|null
     */
    public function getReviewLink()
    {
        return $this->review_link;
    }

    public function hasReviewLink()
    {
        return isset($this->review_link);
    }

    public function clearReviewLink()
    {
        unset($this->review_link);
    }

    /**
     * Optional. The URI of the review landing page.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.ReviewLink review_link = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Merchant\Reviews\V1beta\ProductReviewAttributes\ReviewLink $var
     * @return $this
     */
    public function setReviewLink($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Reviews\V1beta\ProductReviewAttributes\ReviewLink::class);
        $this->review_link = $var;

        return $this;
    }

    /**
     * Optional. A URI to an image of the reviewed product created by the review
     * author. The URI does not have to end with an image file extension.
     *
     * Generated from protobuf field <code>repeated string reviewer_image_links = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReviewerImageLinks()
    {
        return $this->reviewer_image_links;
    }

    /**
     * Optional. A URI to an image of the reviewed product created by the review
     * author. The URI does not have to end with an image file extension.
     *
     * Generated from protobuf field <code>repeated string reviewer_image_links = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReviewerImageLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->reviewer_image_links = $arr;

        return $this;
    }

    /**
     * Optional. Contains the ratings associated with the review.
     * The minimum possible number for the rating. This should be the worst
     * possible rating and should not be a value for no rating.
     *
     * Generated from protobuf field <code>optional int64 min_rating = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getMinRating()
    {
        return isset($this->min_rating) ? $this->min_rating : 0;
    }

    public function hasMinRating()
    {
        return isset($this->min_rating);
    }

    public function clearMinRating()
    {
        unset($this->min_rating);
    }

    /**
     * Optional. Contains the ratings associated with the review.
     * The minimum possible number for the rating. This should be the worst
     * possible rating and should not be a value for no rating.
     *
     * Generated from protobuf field <code>optional int64 min_rating = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMinRating($var)
    {
        GPBUtil::checkInt64($var);
        $this->min_rating = $var;

        return $this;
    }

    /**
     * Optional. The maximum possible number for the rating. The value of the max
     * rating must be greater than the value of the min attribute.
     *
     * Generated from protobuf field <code>optional int64 max_rating = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getMaxRating()
    {
        return isset($this->max_rating) ? $this->max_rating : 0;
    }

    public function hasMaxRating()
    {
        return isset($this->max_rating);
    }

    public function clearMaxRating()
    {
        unset($this->max_rating);
    }

    /**
     * Optional. The maximum possible number for the rating. The value of the max
     * rating must be greater than the value of the min attribute.
     *
     * Generated from protobuf field <code>optional int64 max_rating = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMaxRating($var)
    {
        GPBUtil::checkInt64($var);
        $this->max_rating = $var;

        return $this;
    }

    /**
     * Optional. The reviewer's overall rating of the product.
     *
     * Generated from protobuf field <code>optional double rating = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getRating()
    {
        return isset($this->rating) ? $this->rating : 0.0;
    }

    public function hasRating()
    {
        return isset($this->rating);
    }

    public function clearRating()
    {
        unset($this->rating);
    }

    /**
     * Optional. The reviewer's overall rating of the product.
     *
     * Generated from protobuf field <code>optional double rating = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setRating($var)
    {
        GPBUtil::checkDouble($var);
        $this->rating = $var;

        return $this;
    }

    /**
     * Optional. Descriptive name of a product.
     *
     * Generated from protobuf field <code>repeated string product_names = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductNames()
    {
        return $this->product_names;
    }

    /**
     * Optional. Descriptive name of a product.
     *
     * Generated from protobuf field <code>repeated string product_names = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->product_names = $arr;

        return $this;
    }

    /**
     * Optional. The URI of the product. This URI can have the same value as the
     * `review_link` element, if the review URI and the product URI are the
     * same.
     *
     * Generated from protobuf field <code>repeated string product_links = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductLinks()
    {
        return $this->product_links;
    }

    /**
     * Optional. The URI of the product. This URI can have the same value as the
     * `review_link` element, if the review URI and the product URI are the
     * same.
     *
     * Generated from protobuf field <code>repeated string product_links = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->product_links = $arr;

        return $this;
    }

    /**
     * Optional. Contains ASINs (Amazon Standard Identification Numbers)
     * associated with a product.
     *
     * Generated from protobuf field <code>repeated string asins = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAsins()
    {
        return $this->asins;
    }

    /**
     * Optional. Contains ASINs (Amazon Standard Identification Numbers)
     * associated with a product.
     *
     * Generated from protobuf field <code>repeated string asins = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAsins($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->asins = $arr;

        return $this;
    }

    /**
     * Optional. Contains GTINs (global trade item numbers) associated with a
     * product. Sub-types of GTINs (e.g. UPC, EAN, ISBN, JAN) are supported.
     *
     * Generated from protobuf field <code>repeated string gtins = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGtins()
    {
        return $this->gtins;
    }

    /**
     * Optional. Contains GTINs (global trade item numbers) associated with a
     * product. Sub-types of GTINs (e.g. UPC, EAN, ISBN, JAN) are supported.
     *
     * Generated from protobuf field <code>repeated string gtins = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGtins($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->gtins = $arr;

        return $this;
    }

    /**
     * Optional. Contains MPNs (manufacturer part numbers) associated with a
     * product.
     *
     * Generated from protobuf field <code>repeated string mpns = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMpns()
    {
        return $this->mpns;
    }

    /**
     * Optional. Contains MPNs (manufacturer part numbers) associated with a
     * product.
     *
     * Generated from protobuf field <code>repeated string mpns = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMpns($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->mpns = $arr;

        return $this;
    }

    /**
     * Optional. Contains SKUs (stock keeping units) associated with a product.
     * Often this matches the product Offer Id in the product feed.
     *
     * Generated from protobuf field <code>repeated string skus = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSkus()
    {
        return $this->skus;
    }

    /**
     * Optional. Contains SKUs (stock keeping units) associated with a product.
     * Often this matches the product Offer Id in the product feed.
     *
     * Generated from protobuf field <code>repeated string skus = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSkus($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->skus = $arr;

        return $this;
    }

    /**
     * Optional. Contains brand names associated with a product.
     *
     * Generated from protobuf field <code>repeated string brands = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBrands()
    {
        return $this->brands;
    }

    /**
     * Optional. Contains brand names associated with a product.
     *
     * Generated from protobuf field <code>repeated string brands = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBrands($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->brands = $arr;

        return $this;
    }

    /**
     * Optional. Indicates whether the review is marked as spam in the publisher's
     * system.
     *
     * Generated from protobuf field <code>optional bool is_spam = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIsSpam()
    {
        return isset($this->is_spam) ? $this->is_spam : false;
    }

    public function hasIsSpam()
    {
        return isset($this->is_spam);
    }

    public function clearIsSpam()
    {
        unset($this->is_spam);
    }

    /**
     * Optional. Indicates whether the review is marked as spam in the publisher's
     * system.
     *
     * Generated from protobuf field <code>optional bool is_spam = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsSpam($var)
    {
        GPBUtil::checkBool($var);
        $this->is_spam = $var;

        return $this;
    }

    /**
     * Optional. The method used to collect the review.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.CollectionMethod collection_method = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getCollectionMethod()
    {
        return $this->collection_method;
    }

    /**
     * Optional. The method used to collect the review.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.CollectionMethod collection_method = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setCollectionMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reviews\V1beta\ProductReviewAttributes\CollectionMethod::class);
        $this->collection_method = $var;

        return $this;
    }

    /**
     * Optional. A permanent, unique identifier for the transaction associated
     * with the review in the publisher's system. This ID can be used to indicate
     * that multiple reviews are associated with the same transaction.
     *
     * Generated from protobuf field <code>string transaction_id = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getTransactionId()
    {
        return $this->transaction_id;
    }

    /**
     * Optional. A permanent, unique identifier for the transaction associated
     * with the review in the publisher's system. This ID can be used to indicate
     * that multiple reviews are associated with the same transaction.
     *
     * Generated from protobuf field <code>string transaction_id = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setTransactionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->transaction_id = $var;

        return $this;
    }

}

