<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/catalog.proto

namespace Google\Cloud\Dataplex\V1\MetadataJob\ExportJobSpec;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Scope of the export job.
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.MetadataJob.ExportJobSpec.ExportJobScope</code>
 */
class ExportJobScope extends \Google\Protobuf\Internal\Message
{
    /**
     * Indicating if it is an organization level export job.
     * - When set to true, exports all entries from entry groups and projects
     * sharing the same organization id of the Metadata Job. Only projects and
     * entry groups in the VPC-SC perimeter will be exported. The projects and
     * entry groups are ignored.
     * - When set to false, one of the projects or entry groups must be
     * specified.
     * - Default to false.
     *
     * Generated from protobuf field <code>bool organization_level = 1;</code>
     */
    protected $organization_level = false;
    /**
     * The projects that are in the scope of the export job. Can either be
     * project numbers or project IDs. If specified, only the entries from the
     * specified projects will be exported. The projects must be in the same
     * organization and in the VPC-SC perimeter. Either projects or
     * entry_groups can be specified when organization_level_export is set to
     * false.
     * Must follow the format: "projects/<project_id_or_number>"
     *
     * Generated from protobuf field <code>repeated string projects = 2 [(.google.api.resource_reference) = {</code>
     */
    private $projects;
    /**
     * The entry groups that are in scope for the export job. Optional. If
     * specified, only entries in the specified entry groups will be exported
     * by the job. Must be in the VPC-SC perimeter of the job. The location of
     * the entry groups must be the same as the job. Either projects or
     * entry_groups can be specified when organization_level_export is set to
     * false. Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/entryGroups/<entry_group_id>"
     *
     * Generated from protobuf field <code>repeated string entry_groups = 3 [(.google.api.resource_reference) = {</code>
     */
    private $entry_groups;
    /**
     * If specified, only entries of the specified types will be
     * affected by the job.
     * Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/entryTypes/<entry_type_id>"
     *
     * Generated from protobuf field <code>repeated string entry_types = 4 [(.google.api.resource_reference) = {</code>
     */
    private $entry_types;
    /**
     * The aspect types that are in scope for the export job.
     * Optional. If specified, only aspects of the specified types will be
     * affected by the job.
     * Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/aspectTypes/<aspect_type_id>"
     *
     * Generated from protobuf field <code>repeated string aspect_types = 5 [(.google.api.resource_reference) = {</code>
     */
    private $aspect_types;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $organization_level
     *           Indicating if it is an organization level export job.
     *           - When set to true, exports all entries from entry groups and projects
     *           sharing the same organization id of the Metadata Job. Only projects and
     *           entry groups in the VPC-SC perimeter will be exported. The projects and
     *           entry groups are ignored.
     *           - When set to false, one of the projects or entry groups must be
     *           specified.
     *           - Default to false.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $projects
     *           The projects that are in the scope of the export job. Can either be
     *           project numbers or project IDs. If specified, only the entries from the
     *           specified projects will be exported. The projects must be in the same
     *           organization and in the VPC-SC perimeter. Either projects or
     *           entry_groups can be specified when organization_level_export is set to
     *           false.
     *           Must follow the format: "projects/<project_id_or_number>"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $entry_groups
     *           The entry groups that are in scope for the export job. Optional. If
     *           specified, only entries in the specified entry groups will be exported
     *           by the job. Must be in the VPC-SC perimeter of the job. The location of
     *           the entry groups must be the same as the job. Either projects or
     *           entry_groups can be specified when organization_level_export is set to
     *           false. Must follow the format:
     *           "projects/<project_id_or_number>/locations/<location>/entryGroups/<entry_group_id>"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $entry_types
     *           If specified, only entries of the specified types will be
     *           affected by the job.
     *           Must follow the format:
     *           "projects/<project_id_or_number>/locations/<location>/entryTypes/<entry_type_id>"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $aspect_types
     *           The aspect types that are in scope for the export job.
     *           Optional. If specified, only aspects of the specified types will be
     *           affected by the job.
     *           Must follow the format:
     *           "projects/<project_id_or_number>/locations/<location>/aspectTypes/<aspect_type_id>"
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\Catalog::initOnce();
        parent::__construct($data);
    }

    /**
     * Indicating if it is an organization level export job.
     * - When set to true, exports all entries from entry groups and projects
     * sharing the same organization id of the Metadata Job. Only projects and
     * entry groups in the VPC-SC perimeter will be exported. The projects and
     * entry groups are ignored.
     * - When set to false, one of the projects or entry groups must be
     * specified.
     * - Default to false.
     *
     * Generated from protobuf field <code>bool organization_level = 1;</code>
     * @return bool
     */
    public function getOrganizationLevel()
    {
        return $this->organization_level;
    }

    /**
     * Indicating if it is an organization level export job.
     * - When set to true, exports all entries from entry groups and projects
     * sharing the same organization id of the Metadata Job. Only projects and
     * entry groups in the VPC-SC perimeter will be exported. The projects and
     * entry groups are ignored.
     * - When set to false, one of the projects or entry groups must be
     * specified.
     * - Default to false.
     *
     * Generated from protobuf field <code>bool organization_level = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setOrganizationLevel($var)
    {
        GPBUtil::checkBool($var);
        $this->organization_level = $var;

        return $this;
    }

    /**
     * The projects that are in the scope of the export job. Can either be
     * project numbers or project IDs. If specified, only the entries from the
     * specified projects will be exported. The projects must be in the same
     * organization and in the VPC-SC perimeter. Either projects or
     * entry_groups can be specified when organization_level_export is set to
     * false.
     * Must follow the format: "projects/<project_id_or_number>"
     *
     * Generated from protobuf field <code>repeated string projects = 2 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProjects()
    {
        return $this->projects;
    }

    /**
     * The projects that are in the scope of the export job. Can either be
     * project numbers or project IDs. If specified, only the entries from the
     * specified projects will be exported. The projects must be in the same
     * organization and in the VPC-SC perimeter. Either projects or
     * entry_groups can be specified when organization_level_export is set to
     * false.
     * Must follow the format: "projects/<project_id_or_number>"
     *
     * Generated from protobuf field <code>repeated string projects = 2 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProjects($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->projects = $arr;

        return $this;
    }

    /**
     * The entry groups that are in scope for the export job. Optional. If
     * specified, only entries in the specified entry groups will be exported
     * by the job. Must be in the VPC-SC perimeter of the job. The location of
     * the entry groups must be the same as the job. Either projects or
     * entry_groups can be specified when organization_level_export is set to
     * false. Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/entryGroups/<entry_group_id>"
     *
     * Generated from protobuf field <code>repeated string entry_groups = 3 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntryGroups()
    {
        return $this->entry_groups;
    }

    /**
     * The entry groups that are in scope for the export job. Optional. If
     * specified, only entries in the specified entry groups will be exported
     * by the job. Must be in the VPC-SC perimeter of the job. The location of
     * the entry groups must be the same as the job. Either projects or
     * entry_groups can be specified when organization_level_export is set to
     * false. Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/entryGroups/<entry_group_id>"
     *
     * Generated from protobuf field <code>repeated string entry_groups = 3 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntryGroups($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->entry_groups = $arr;

        return $this;
    }

    /**
     * If specified, only entries of the specified types will be
     * affected by the job.
     * Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/entryTypes/<entry_type_id>"
     *
     * Generated from protobuf field <code>repeated string entry_types = 4 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntryTypes()
    {
        return $this->entry_types;
    }

    /**
     * If specified, only entries of the specified types will be
     * affected by the job.
     * Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/entryTypes/<entry_type_id>"
     *
     * Generated from protobuf field <code>repeated string entry_types = 4 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntryTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->entry_types = $arr;

        return $this;
    }

    /**
     * The aspect types that are in scope for the export job.
     * Optional. If specified, only aspects of the specified types will be
     * affected by the job.
     * Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/aspectTypes/<aspect_type_id>"
     *
     * Generated from protobuf field <code>repeated string aspect_types = 5 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAspectTypes()
    {
        return $this->aspect_types;
    }

    /**
     * The aspect types that are in scope for the export job.
     * Optional. If specified, only aspects of the specified types will be
     * affected by the job.
     * Must follow the format:
     * "projects/<project_id_or_number>/locations/<location>/aspectTypes/<aspect_type_id>"
     *
     * Generated from protobuf field <code>repeated string aspect_types = 5 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAspectTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->aspect_types = $arr;

        return $this;
    }

}


