<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an Interconnect resource. An Interconnect resource is a dedicated connection between the Google Cloud network and your on-premises network. For more information, read the Dedicated Interconnect Overview.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Interconnect</code>
 */
class Interconnect extends \Google\Protobuf\Internal\Message
{
    /**
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     */
    private $admin_enabled = null;
    /**
     * [Output only] List of features available for this Interconnect connection, which can take one of the following values: - IF_MACSEC If present then the Interconnect connection is provisioned on MACsec capable hardware ports. If not present then the Interconnect connection is provisioned on non-MACsec capable ports and MACsec isn't supported and enabling MACsec fails.
     * Check the AvailableFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string available_features = 496344307;</code>
     */
    private $available_features;
    /**
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;</code>
     */
    private $circuit_infos;
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = null;
    /**
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>optional string customer_name = 3665484;</code>
     */
    private $customer_name = null;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    private $description = null;
    /**
     * [Output Only] A list of outages expected for this Interconnect.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;</code>
     */
    private $expected_outages;
    /**
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>optional string google_ip_address = 443105954;</code>
     */
    private $google_ip_address = null;
    /**
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     *
     * Generated from protobuf field <code>optional string google_reference_id = 534944469;</code>
     */
    private $google_reference_id = null;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    private $id = null;
    /**
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     *
     * Generated from protobuf field <code>repeated string interconnect_attachments = 425388415;</code>
     */
    private $interconnect_attachments;
    /**
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string interconnect_type = 515165259;</code>
     */
    private $interconnect_type = null;
    /**
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    private $kind = null;
    /**
     * A fingerprint for the labels being applied to this Interconnect, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an Interconnect.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     */
    private $label_fingerprint = null;
    /**
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     */
    private $labels;
    /**
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string link_type = 523207775;</code>
     */
    private $link_type = null;
    /**
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     *
     * Generated from protobuf field <code>optional string location = 290430901;</code>
     */
    private $location = null;
    /**
     * Configuration that enables Media Access Control security (MACsec) on the Cloud Interconnect connection between Google and your on-premises router.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectMacsec macsec = 528867490;</code>
     */
    private $macsec = null;
    /**
     * Enable or disable MACsec on this Interconnect connection. MACsec enablement fails if the MACsec object is not specified.
     *
     * Generated from protobuf field <code>optional bool macsec_enabled = 194203812;</code>
     */
    private $macsec_enabled = null;
    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    private $name = null;
    /**
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     *
     * Generated from protobuf field <code>optional string noc_contact_email = 14072832;</code>
     */
    private $noc_contact_email = null;
    /**
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string operational_status = 201070847;</code>
     */
    private $operational_status = null;
    /**
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>optional string peer_ip_address = 207735769;</code>
     */
    private $peer_ip_address = null;
    /**
     * [Output Only] Number of links actually provisioned in this interconnect.
     *
     * Generated from protobuf field <code>optional int32 provisioned_link_count = 410888565;</code>
     */
    private $provisioned_link_count = null;
    /**
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     *
     * Generated from protobuf field <code>optional string remote_location = 324388750;</code>
     */
    private $remote_location = null;
    /**
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string requested_features = 461240814;</code>
     */
    private $requested_features;
    /**
     * Target number of physical links in the link bundle, as requested by the customer.
     *
     * Generated from protobuf field <code>optional int32 requested_link_count = 45051387;</code>
     */
    private $requested_link_count = null;
    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     */
    private $satisfies_pzs = null;
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    private $self_link = null;
    /**
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string state = 109757585;</code>
     */
    private $state = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $admin_enabled
     *           Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $available_features
     *           [Output only] List of features available for this Interconnect connection, which can take one of the following values: - IF_MACSEC If present then the Interconnect connection is provisioned on MACsec capable hardware ports. If not present then the Interconnect connection is provisioned on non-MACsec capable ports and MACsec isn't supported and enabling MACsec fails.
     *           Check the AvailableFeatures enum for the list of possible values.
     *     @type array<\Google\Cloud\Compute\V1\InterconnectCircuitInfo>|\Google\Protobuf\Internal\RepeatedField $circuit_infos
     *           [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $customer_name
     *           Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type array<\Google\Cloud\Compute\V1\InterconnectOutageNotification>|\Google\Protobuf\Internal\RepeatedField $expected_outages
     *           [Output Only] A list of outages expected for this Interconnect.
     *     @type string $google_ip_address
     *           [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     *     @type string $google_reference_id
     *           [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     *     @type int|string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $interconnect_attachments
     *           [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     *     @type string $interconnect_type
     *           Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     *           Check the InterconnectType enum for the list of possible values.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     *     @type string $label_fingerprint
     *           A fingerprint for the labels being applied to this Interconnect, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an Interconnect.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     *     @type string $link_type
     *           Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     *           Check the LinkType enum for the list of possible values.
     *     @type string $location
     *           URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     *     @type \Google\Cloud\Compute\V1\InterconnectMacsec $macsec
     *           Configuration that enables Media Access Control security (MACsec) on the Cloud Interconnect connection between Google and your on-premises router.
     *     @type bool $macsec_enabled
     *           Enable or disable MACsec on this Interconnect connection. MACsec enablement fails if the MACsec object is not specified.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $noc_contact_email
     *           Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     *     @type string $operational_status
     *           [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *           Check the OperationalStatus enum for the list of possible values.
     *     @type string $peer_ip_address
     *           [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     *     @type int $provisioned_link_count
     *           [Output Only] Number of links actually provisioned in this interconnect.
     *     @type string $remote_location
     *           Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $requested_features
     *           Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     *           Check the RequestedFeatures enum for the list of possible values.
     *     @type int $requested_link_count
     *           Target number of physical links in the link bundle, as requested by the customer.
     *     @type bool $satisfies_pzs
     *           [Output Only] Reserved for future use.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type string $state
     *           [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *           Check the State enum for the list of possible values.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     * @return bool
     */
    public function getAdminEnabled()
    {
        return isset($this->admin_enabled) ? $this->admin_enabled : false;
    }

    public function hasAdminEnabled()
    {
        return isset($this->admin_enabled);
    }

    public function clearAdminEnabled()
    {
        unset($this->admin_enabled);
    }

    /**
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     * @param bool $var
     * @return $this
     */
    public function setAdminEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->admin_enabled = $var;

        return $this;
    }

    /**
     * [Output only] List of features available for this Interconnect connection, which can take one of the following values: - IF_MACSEC If present then the Interconnect connection is provisioned on MACsec capable hardware ports. If not present then the Interconnect connection is provisioned on non-MACsec capable ports and MACsec isn't supported and enabling MACsec fails.
     * Check the AvailableFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string available_features = 496344307;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAvailableFeatures()
    {
        return $this->available_features;
    }

    /**
     * [Output only] List of features available for this Interconnect connection, which can take one of the following values: - IF_MACSEC If present then the Interconnect connection is provisioned on MACsec capable hardware ports. If not present then the Interconnect connection is provisioned on non-MACsec capable ports and MACsec isn't supported and enabling MACsec fails.
     * Check the AvailableFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string available_features = 496344307;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAvailableFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->available_features = $arr;

        return $this;
    }

    /**
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCircuitInfos()
    {
        return $this->circuit_infos;
    }

    /**
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;</code>
     * @param array<\Google\Cloud\Compute\V1\InterconnectCircuitInfo>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCircuitInfos($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\InterconnectCircuitInfo::class);
        $this->circuit_infos = $arr;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>optional string customer_name = 3665484;</code>
     * @return string
     */
    public function getCustomerName()
    {
        return isset($this->customer_name) ? $this->customer_name : '';
    }

    public function hasCustomerName()
    {
        return isset($this->customer_name);
    }

    public function clearCustomerName()
    {
        unset($this->customer_name);
    }

    /**
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>optional string customer_name = 3665484;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerName($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_name = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] A list of outages expected for this Interconnect.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExpectedOutages()
    {
        return $this->expected_outages;
    }

    /**
     * [Output Only] A list of outages expected for this Interconnect.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;</code>
     * @param array<\Google\Cloud\Compute\V1\InterconnectOutageNotification>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExpectedOutages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\InterconnectOutageNotification::class);
        $this->expected_outages = $arr;

        return $this;
    }

    /**
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>optional string google_ip_address = 443105954;</code>
     * @return string
     */
    public function getGoogleIpAddress()
    {
        return isset($this->google_ip_address) ? $this->google_ip_address : '';
    }

    public function hasGoogleIpAddress()
    {
        return isset($this->google_ip_address);
    }

    public function clearGoogleIpAddress()
    {
        unset($this->google_ip_address);
    }

    /**
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>optional string google_ip_address = 443105954;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_ip_address = $var;

        return $this;
    }

    /**
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     *
     * Generated from protobuf field <code>optional string google_reference_id = 534944469;</code>
     * @return string
     */
    public function getGoogleReferenceId()
    {
        return isset($this->google_reference_id) ? $this->google_reference_id : '';
    }

    public function hasGoogleReferenceId()
    {
        return isset($this->google_reference_id);
    }

    public function clearGoogleReferenceId()
    {
        unset($this->google_reference_id);
    }

    /**
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     *
     * Generated from protobuf field <code>optional string google_reference_id = 534944469;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleReferenceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_reference_id = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     *
     * Generated from protobuf field <code>repeated string interconnect_attachments = 425388415;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInterconnectAttachments()
    {
        return $this->interconnect_attachments;
    }

    /**
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     *
     * Generated from protobuf field <code>repeated string interconnect_attachments = 425388415;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInterconnectAttachments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->interconnect_attachments = $arr;

        return $this;
    }

    /**
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string interconnect_type = 515165259;</code>
     * @return string
     */
    public function getInterconnectType()
    {
        return isset($this->interconnect_type) ? $this->interconnect_type : '';
    }

    public function hasInterconnectType()
    {
        return isset($this->interconnect_type);
    }

    public function clearInterconnectType()
    {
        unset($this->interconnect_type);
    }

    /**
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string interconnect_type = 515165259;</code>
     * @param string $var
     * @return $this
     */
    public function setInterconnectType($var)
    {
        GPBUtil::checkString($var, True);
        $this->interconnect_type = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A fingerprint for the labels being applied to this Interconnect, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an Interconnect.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return isset($this->label_fingerprint) ? $this->label_fingerprint : '';
    }

    public function hasLabelFingerprint()
    {
        return isset($this->label_fingerprint);
    }

    public function clearLabelFingerprint()
    {
        unset($this->label_fingerprint);
    }

    /**
     * A fingerprint for the labels being applied to this Interconnect, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an Interconnect.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string link_type = 523207775;</code>
     * @return string
     */
    public function getLinkType()
    {
        return isset($this->link_type) ? $this->link_type : '';
    }

    public function hasLinkType()
    {
        return isset($this->link_type);
    }

    public function clearLinkType()
    {
        unset($this->link_type);
    }

    /**
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string link_type = 523207775;</code>
     * @param string $var
     * @return $this
     */
    public function setLinkType($var)
    {
        GPBUtil::checkString($var, True);
        $this->link_type = $var;

        return $this;
    }

    /**
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     *
     * Generated from protobuf field <code>optional string location = 290430901;</code>
     * @return string
     */
    public function getLocation()
    {
        return isset($this->location) ? $this->location : '';
    }

    public function hasLocation()
    {
        return isset($this->location);
    }

    public function clearLocation()
    {
        unset($this->location);
    }

    /**
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     *
     * Generated from protobuf field <code>optional string location = 290430901;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * Configuration that enables Media Access Control security (MACsec) on the Cloud Interconnect connection between Google and your on-premises router.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectMacsec macsec = 528867490;</code>
     * @return \Google\Cloud\Compute\V1\InterconnectMacsec|null
     */
    public function getMacsec()
    {
        return $this->macsec;
    }

    public function hasMacsec()
    {
        return isset($this->macsec);
    }

    public function clearMacsec()
    {
        unset($this->macsec);
    }

    /**
     * Configuration that enables Media Access Control security (MACsec) on the Cloud Interconnect connection between Google and your on-premises router.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectMacsec macsec = 528867490;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectMacsec $var
     * @return $this
     */
    public function setMacsec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InterconnectMacsec::class);
        $this->macsec = $var;

        return $this;
    }

    /**
     * Enable or disable MACsec on this Interconnect connection. MACsec enablement fails if the MACsec object is not specified.
     *
     * Generated from protobuf field <code>optional bool macsec_enabled = 194203812;</code>
     * @return bool
     */
    public function getMacsecEnabled()
    {
        return isset($this->macsec_enabled) ? $this->macsec_enabled : false;
    }

    public function hasMacsecEnabled()
    {
        return isset($this->macsec_enabled);
    }

    public function clearMacsecEnabled()
    {
        unset($this->macsec_enabled);
    }

    /**
     * Enable or disable MACsec on this Interconnect connection. MACsec enablement fails if the MACsec object is not specified.
     *
     * Generated from protobuf field <code>optional bool macsec_enabled = 194203812;</code>
     * @param bool $var
     * @return $this
     */
    public function setMacsecEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->macsec_enabled = $var;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     *
     * Generated from protobuf field <code>optional string noc_contact_email = 14072832;</code>
     * @return string
     */
    public function getNocContactEmail()
    {
        return isset($this->noc_contact_email) ? $this->noc_contact_email : '';
    }

    public function hasNocContactEmail()
    {
        return isset($this->noc_contact_email);
    }

    public function clearNocContactEmail()
    {
        unset($this->noc_contact_email);
    }

    /**
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     *
     * Generated from protobuf field <code>optional string noc_contact_email = 14072832;</code>
     * @param string $var
     * @return $this
     */
    public function setNocContactEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->noc_contact_email = $var;

        return $this;
    }

    /**
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string operational_status = 201070847;</code>
     * @return string
     */
    public function getOperationalStatus()
    {
        return isset($this->operational_status) ? $this->operational_status : '';
    }

    public function hasOperationalStatus()
    {
        return isset($this->operational_status);
    }

    public function clearOperationalStatus()
    {
        unset($this->operational_status);
    }

    /**
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string operational_status = 201070847;</code>
     * @param string $var
     * @return $this
     */
    public function setOperationalStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->operational_status = $var;

        return $this;
    }

    /**
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>optional string peer_ip_address = 207735769;</code>
     * @return string
     */
    public function getPeerIpAddress()
    {
        return isset($this->peer_ip_address) ? $this->peer_ip_address : '';
    }

    public function hasPeerIpAddress()
    {
        return isset($this->peer_ip_address);
    }

    public function clearPeerIpAddress()
    {
        unset($this->peer_ip_address);
    }

    /**
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>optional string peer_ip_address = 207735769;</code>
     * @param string $var
     * @return $this
     */
    public function setPeerIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->peer_ip_address = $var;

        return $this;
    }

    /**
     * [Output Only] Number of links actually provisioned in this interconnect.
     *
     * Generated from protobuf field <code>optional int32 provisioned_link_count = 410888565;</code>
     * @return int
     */
    public function getProvisionedLinkCount()
    {
        return isset($this->provisioned_link_count) ? $this->provisioned_link_count : 0;
    }

    public function hasProvisionedLinkCount()
    {
        return isset($this->provisioned_link_count);
    }

    public function clearProvisionedLinkCount()
    {
        unset($this->provisioned_link_count);
    }

    /**
     * [Output Only] Number of links actually provisioned in this interconnect.
     *
     * Generated from protobuf field <code>optional int32 provisioned_link_count = 410888565;</code>
     * @param int $var
     * @return $this
     */
    public function setProvisionedLinkCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->provisioned_link_count = $var;

        return $this;
    }

    /**
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     *
     * Generated from protobuf field <code>optional string remote_location = 324388750;</code>
     * @return string
     */
    public function getRemoteLocation()
    {
        return isset($this->remote_location) ? $this->remote_location : '';
    }

    public function hasRemoteLocation()
    {
        return isset($this->remote_location);
    }

    public function clearRemoteLocation()
    {
        unset($this->remote_location);
    }

    /**
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     *
     * Generated from protobuf field <code>optional string remote_location = 324388750;</code>
     * @param string $var
     * @return $this
     */
    public function setRemoteLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->remote_location = $var;

        return $this;
    }

    /**
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string requested_features = 461240814;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRequestedFeatures()
    {
        return $this->requested_features;
    }

    /**
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string requested_features = 461240814;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRequestedFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->requested_features = $arr;

        return $this;
    }

    /**
     * Target number of physical links in the link bundle, as requested by the customer.
     *
     * Generated from protobuf field <code>optional int32 requested_link_count = 45051387;</code>
     * @return int
     */
    public function getRequestedLinkCount()
    {
        return isset($this->requested_link_count) ? $this->requested_link_count : 0;
    }

    public function hasRequestedLinkCount()
    {
        return isset($this->requested_link_count);
    }

    public function clearRequestedLinkCount()
    {
        unset($this->requested_link_count);
    }

    /**
     * Target number of physical links in the link bundle, as requested by the customer.
     *
     * Generated from protobuf field <code>optional int32 requested_link_count = 45051387;</code>
     * @param int $var
     * @return $this
     */
    public function setRequestedLinkCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->requested_link_count = $var;

        return $this;
    }

    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : false;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string state = 109757585;</code>
     * @return string
     */
    public function getState()
    {
        return isset($this->state) ? $this->state : '';
    }

    public function hasState()
    {
        return isset($this->state);
    }

    public function clearState()
    {
        unset($this->state);
    }

    /**
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string state = 109757585;</code>
     * @param string $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkString($var, True);
        $this->state = $var;

        return $this;
    }

}

