<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

namespace Google\Cloud\BigQuery\AnalyticsHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A subscription represents a subscribers' access to a particular set of
 * published data. It contains references to associated listings,
 * data exchanges, and linked datasets.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.analyticshub.v1.Subscription</code>
 */
class Subscription extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the subscription.
     * e.g. `projects/myproject/locations/US/subscriptions/123`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. Timestamp when the subscription was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $creation_time = null;
    /**
     * Output only. Timestamp when the subscription was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_modify_time = null;
    /**
     * Output only. Organization of the project this subscription belongs to.
     *
     * Generated from protobuf field <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $organization_id = '';
    /**
     * Output only. Display name of the project of this subscription.
     *
     * Generated from protobuf field <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $organization_display_name = '';
    /**
     * Output only. Current state of the subscription.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/US/dataExchanges/456/listings/789
     * ->
     * projects/123/datasets/my_dataset
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource> linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $linked_dataset_map;
    /**
     * Output only. Email of the subscriber.
     *
     * Generated from protobuf field <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $subscriber_contact = '';
    /**
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $linked_resources;
    /**
     * Output only. Listing shared asset type.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $resource_type = 0;
    /**
     * Output only. By default, false.
     * If true, the Subscriber agreed to the email sharing mandate
     * that is enabled for DataExchange/Listing.
     *
     * Generated from protobuf field <code>optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $log_linked_dataset_query_user_email = null;
    protected $resource_name;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $listing
     *           Output only. Resource name of the source Listing.
     *           e.g. projects/123/locations/US/dataExchanges/456/listings/789
     *     @type string $data_exchange
     *           Output only. Resource name of the source Data Exchange.
     *           e.g. projects/123/locations/US/dataExchanges/456
     *     @type string $name
     *           Output only. The resource name of the subscription.
     *           e.g. `projects/myproject/locations/US/subscriptions/123`.
     *     @type \Google\Protobuf\Timestamp $creation_time
     *           Output only. Timestamp when the subscription was created.
     *     @type \Google\Protobuf\Timestamp $last_modify_time
     *           Output only. Timestamp when the subscription was last modified.
     *     @type string $organization_id
     *           Output only. Organization of the project this subscription belongs to.
     *     @type string $organization_display_name
     *           Output only. Display name of the project of this subscription.
     *     @type int $state
     *           Output only. Current state of the subscription.
     *     @type array|\Google\Protobuf\Internal\MapField $linked_dataset_map
     *           Output only. Map of listing resource names to associated linked resource,
     *           e.g. projects/123/locations/US/dataExchanges/456/listings/789
     *           ->
     *           projects/123/datasets/my_dataset
     *           For listing-level subscriptions, this is a map of size 1.
     *           Only contains values if state == STATE_ACTIVE.
     *     @type string $subscriber_contact
     *           Output only. Email of the subscriber.
     *     @type array<\Google\Cloud\BigQuery\AnalyticsHub\V1\Subscription\LinkedResource>|\Google\Protobuf\Internal\RepeatedField $linked_resources
     *           Output only. Linked resources created in the subscription. Only contains
     *           values if state = STATE_ACTIVE.
     *     @type int $resource_type
     *           Output only. Listing shared asset type.
     *     @type bool $log_linked_dataset_query_user_email
     *           Output only. By default, false.
     *           If true, the Subscriber agreed to the email sharing mandate
     *           that is enabled for DataExchange/Listing.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Analyticshub\V1\Analyticshub::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Resource name of the source Listing.
     * e.g. projects/123/locations/US/dataExchanges/456/listings/789
     *
     * Generated from protobuf field <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getListing()
    {
        return $this->readOneof(5);
    }

    public function hasListing()
    {
        return $this->hasOneof(5);
    }

    /**
     * Output only. Resource name of the source Listing.
     * e.g. projects/123/locations/US/dataExchanges/456/listings/789
     *
     * Generated from protobuf field <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setListing($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Output only. Resource name of the source Data Exchange.
     * e.g. projects/123/locations/US/dataExchanges/456
     *
     * Generated from protobuf field <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDataExchange()
    {
        return $this->readOneof(6);
    }

    public function hasDataExchange()
    {
        return $this->hasOneof(6);
    }

    /**
     * Output only. Resource name of the source Data Exchange.
     * e.g. projects/123/locations/US/dataExchanges/456
     *
     * Generated from protobuf field <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDataExchange($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Output only. The resource name of the subscription.
     * e.g. `projects/myproject/locations/US/subscriptions/123`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the subscription.
     * e.g. `projects/myproject/locations/US/subscriptions/123`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when the subscription was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreationTime()
    {
        return $this->creation_time;
    }

    public function hasCreationTime()
    {
        return isset($this->creation_time);
    }

    public function clearCreationTime()
    {
        unset($this->creation_time);
    }

    /**
     * Output only. Timestamp when the subscription was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->creation_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when the subscription was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastModifyTime()
    {
        return $this->last_modify_time;
    }

    public function hasLastModifyTime()
    {
        return isset($this->last_modify_time);
    }

    public function clearLastModifyTime()
    {
        unset($this->last_modify_time);
    }

    /**
     * Output only. Timestamp when the subscription was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastModifyTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_modify_time = $var;

        return $this;
    }

    /**
     * Output only. Organization of the project this subscription belongs to.
     *
     * Generated from protobuf field <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOrganizationId()
    {
        return $this->organization_id;
    }

    /**
     * Output only. Organization of the project this subscription belongs to.
     *
     * Generated from protobuf field <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOrganizationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->organization_id = $var;

        return $this;
    }

    /**
     * Output only. Display name of the project of this subscription.
     *
     * Generated from protobuf field <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOrganizationDisplayName()
    {
        return $this->organization_display_name;
    }

    /**
     * Output only. Display name of the project of this subscription.
     *
     * Generated from protobuf field <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOrganizationDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->organization_display_name = $var;

        return $this;
    }

    /**
     * Output only. Current state of the subscription.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. Current state of the subscription.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\AnalyticsHub\V1\Subscription\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/US/dataExchanges/456/listings/789
     * ->
     * projects/123/datasets/my_dataset
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource> linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLinkedDatasetMap()
    {
        return $this->linked_dataset_map;
    }

    /**
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/US/dataExchanges/456/listings/789
     * ->
     * projects/123/datasets/my_dataset
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource> linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLinkedDatasetMap($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BigQuery\AnalyticsHub\V1\Subscription\LinkedResource::class);
        $this->linked_dataset_map = $arr;

        return $this;
    }

    /**
     * Output only. Email of the subscriber.
     *
     * Generated from protobuf field <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSubscriberContact()
    {
        return $this->subscriber_contact;
    }

    /**
     * Output only. Email of the subscriber.
     *
     * Generated from protobuf field <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSubscriberContact($var)
    {
        GPBUtil::checkString($var, True);
        $this->subscriber_contact = $var;

        return $this;
    }

    /**
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLinkedResources()
    {
        return $this->linked_resources;
    }

    /**
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\BigQuery\AnalyticsHub\V1\Subscription\LinkedResource>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLinkedResources($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BigQuery\AnalyticsHub\V1\Subscription\LinkedResource::class);
        $this->linked_resources = $arr;

        return $this;
    }

    /**
     * Output only. Listing shared asset type.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getResourceType()
    {
        return $this->resource_type;
    }

    /**
     * Output only. Listing shared asset type.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setResourceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\AnalyticsHub\V1\SharedResourceType::class);
        $this->resource_type = $var;

        return $this;
    }

    /**
     * Output only. By default, false.
     * If true, the Subscriber agreed to the email sharing mandate
     * that is enabled for DataExchange/Listing.
     *
     * Generated from protobuf field <code>optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getLogLinkedDatasetQueryUserEmail()
    {
        return isset($this->log_linked_dataset_query_user_email) ? $this->log_linked_dataset_query_user_email : false;
    }

    public function hasLogLinkedDatasetQueryUserEmail()
    {
        return isset($this->log_linked_dataset_query_user_email);
    }

    public function clearLogLinkedDatasetQueryUserEmail()
    {
        unset($this->log_linked_dataset_query_user_email);
    }

    /**
     * Output only. By default, false.
     * If true, the Subscriber agreed to the email sharing mandate
     * that is enabled for DataExchange/Listing.
     *
     * Generated from protobuf field <code>optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setLogLinkedDatasetQueryUserEmail($var)
    {
        GPBUtil::checkBool($var);
        $this->log_linked_dataset_query_user_email = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getResourceName()
    {
        return $this->whichOneof("resource_name");
    }

}

