<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/ad_unit_messages.proto

namespace Google\Ads\AdManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The AdUnit resource.
 *
 * Generated from protobuf message <code>google.ads.admanager.v1.AdUnit</code>
 */
class AdUnit extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the AdUnit.
     * Format: `networks/{network_code}/adUnits/{ad_unit_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. AdUnit ID.
     *
     * Generated from protobuf field <code>int64 ad_unit_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $ad_unit_id = 0;
    /**
     * Required. Immutable. The AdUnit's parent. Every ad unit has a parent except
     * for the root ad unit, which is created by Google. Format:
     * "networks/{network_code}/adUnits/{ad_unit_id}"
     *
     * Generated from protobuf field <code>string parent_ad_unit = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $parent_ad_unit = '';
    /**
     * Output only. The path to this AdUnit in the ad unit hierarchy represented
     * as a list from the root to this ad unit's parent. For root ad units, this
     * list is empty.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AdUnitParent parent_path = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $parent_path;
    /**
     * Required. The display name of the ad unit. Its maximum length is 255
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Immutable. A string used to uniquely identify the ad unit for the purposes
     * of serving the ad. This attribute is optional and can be set during ad unit
     * creation. If it is not provided, it will be assigned by Google based on the
     * ad unit ID.
     *
     * Generated from protobuf field <code>string ad_unit_code = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $ad_unit_code = '';
    /**
     * Output only. The status of this ad unit.  It defaults to ACTIVE.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.AdUnitStatusEnum.AdUnitStatus status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $status = 0;
    /**
     * Optional. The target window directly applied to this AdUnit.
     * If this field is not set, this AdUnit uses the target window specified in
     * effectiveTargetWindow.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.TargetWindowEnum.TargetWindow applied_target_window = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $applied_target_window = 0;
    /**
     * Output only. Non-empty default. The target window of this AdUnit. This
     * value is inherited from ancestor AdUnits and defaults to TOP if no AdUnit
     * in the hierarchy specifies it.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.TargetWindowEnum.TargetWindow effective_target_window = 45 [(.google.api.field_behavior) = NON_EMPTY_DEFAULT, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $effective_target_window = 0;
    /**
     * Optional. The resource names of Teams directly applied to this AdUnit.
     * Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string applied_teams = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $applied_teams;
    /**
     * Output only. The resource names of all Teams that this AdUnit is on as well
     * as those inherited from parent AdUnits. Format:
     * "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string teams = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $teams;
    /**
     * Optional. A description of the ad unit. The maximum length is 65,535
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. If this field is set to true, then the AdUnit will not be
     * implicitly targeted when its parent is. Traffickers must explicitly
     * target such an AdUnit or else no line items will serve to it. This
     * feature is only available for Ad Manager 360 accounts.
     *
     * Generated from protobuf field <code>bool explicitly_targeted = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $explicitly_targeted = false;
    /**
     * Output only. This field is set to true if the ad unit has any children.
     *
     * Generated from protobuf field <code>bool has_children = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $has_children = false;
    /**
     * Output only. The time this AdUnit was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. The sizes that can be served inside this ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AdUnitSize ad_unit_sizes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $ad_unit_sizes;
    /**
     * Optional. Determines what set top box video on demand channel this ad unit
     * corresponds to in an external set top box ad campaign system.
     *
     * Generated from protobuf field <code>string external_set_top_box_channel_id = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $external_set_top_box_channel_id = '';
    /**
     * Optional. The duration after which an Ad Unit will automatically refresh.
     * This is only valid for ad units in mobile apps. If not set, the ad unit
     * will not refresh.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration refresh_delay = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $refresh_delay = null;
    /**
     * Optional. The set of labels applied directly to this ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel applied_labels = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $applied_labels;
    /**
     * Output only. Contains the set of labels applied directly to the ad unit as
     * well as those inherited from the parent ad units. If a label has been
     * negated, only the negated label is returned. This field is readonly and is
     * assigned by Google.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel effective_applied_labels = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $effective_applied_labels;
    /**
     * Optional. The set of label frequency caps applied directly to this ad unit.
     * There is a limit of 10 label frequency caps per ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.LabelFrequencyCap applied_label_frequency_caps = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $applied_label_frequency_caps;
    /**
     * Output only. The label frequency caps applied directly to the ad unit as
     * well as those inherited from parent ad units.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.LabelFrequencyCap effective_label_frequency_caps = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $effective_label_frequency_caps;
    /**
     * Optional. The smart size mode for this ad unit. This attribute is optional
     * and defaults to SmartSizeMode.NONE for fixed sizes.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.SmartSizeModeEnum.SmartSizeMode smart_size_mode = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $smart_size_mode = 0;
    /**
     * Optional. The value of AdSense enabled directly applied to this ad unit.
     * This attribute is optional and if not specified this ad unit will inherit
     * the value of effectiveAdsenseEnabled from its ancestors.
     *
     * Generated from protobuf field <code>optional bool applied_adsense_enabled = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $applied_adsense_enabled = null;
    /**
     * Output only. Specifies whether or not the AdUnit is enabled for serving ads
     * from the AdSense content network. This attribute defaults to the ad unit's
     * parent or ancestor's setting if one has been set. If no ancestor of the ad
     * unit has set appliedAdsenseEnabled, the attribute is defaulted to true.
     *
     * Generated from protobuf field <code>bool effective_adsense_enabled = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $effective_adsense_enabled = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the AdUnit.
     *           Format: `networks/{network_code}/adUnits/{ad_unit_id}`
     *     @type int|string $ad_unit_id
     *           Output only. AdUnit ID.
     *     @type string $parent_ad_unit
     *           Required. Immutable. The AdUnit's parent. Every ad unit has a parent except
     *           for the root ad unit, which is created by Google. Format:
     *           "networks/{network_code}/adUnits/{ad_unit_id}"
     *     @type array<\Google\Ads\AdManager\V1\AdUnitParent>|\Google\Protobuf\Internal\RepeatedField $parent_path
     *           Output only. The path to this AdUnit in the ad unit hierarchy represented
     *           as a list from the root to this ad unit's parent. For root ad units, this
     *           list is empty.
     *     @type string $display_name
     *           Required. The display name of the ad unit. Its maximum length is 255
     *           characters.
     *     @type string $ad_unit_code
     *           Immutable. A string used to uniquely identify the ad unit for the purposes
     *           of serving the ad. This attribute is optional and can be set during ad unit
     *           creation. If it is not provided, it will be assigned by Google based on the
     *           ad unit ID.
     *     @type int $status
     *           Output only. The status of this ad unit.  It defaults to ACTIVE.
     *     @type int $applied_target_window
     *           Optional. The target window directly applied to this AdUnit.
     *           If this field is not set, this AdUnit uses the target window specified in
     *           effectiveTargetWindow.
     *     @type int $effective_target_window
     *           Output only. Non-empty default. The target window of this AdUnit. This
     *           value is inherited from ancestor AdUnits and defaults to TOP if no AdUnit
     *           in the hierarchy specifies it.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $applied_teams
     *           Optional. The resource names of Teams directly applied to this AdUnit.
     *           Format: "networks/{network_code}/teams/{team_id}"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $teams
     *           Output only. The resource names of all Teams that this AdUnit is on as well
     *           as those inherited from parent AdUnits. Format:
     *           "networks/{network_code}/teams/{team_id}"
     *     @type string $description
     *           Optional. A description of the ad unit. The maximum length is 65,535
     *           characters.
     *     @type bool $explicitly_targeted
     *           Optional. If this field is set to true, then the AdUnit will not be
     *           implicitly targeted when its parent is. Traffickers must explicitly
     *           target such an AdUnit or else no line items will serve to it. This
     *           feature is only available for Ad Manager 360 accounts.
     *     @type bool $has_children
     *           Output only. This field is set to true if the ad unit has any children.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time this AdUnit was last modified.
     *     @type array<\Google\Ads\AdManager\V1\AdUnitSize>|\Google\Protobuf\Internal\RepeatedField $ad_unit_sizes
     *           Optional. The sizes that can be served inside this ad unit.
     *     @type string $external_set_top_box_channel_id
     *           Optional. Determines what set top box video on demand channel this ad unit
     *           corresponds to in an external set top box ad campaign system.
     *     @type \Google\Protobuf\Duration $refresh_delay
     *           Optional. The duration after which an Ad Unit will automatically refresh.
     *           This is only valid for ad units in mobile apps. If not set, the ad unit
     *           will not refresh.
     *     @type array<\Google\Ads\AdManager\V1\AppliedLabel>|\Google\Protobuf\Internal\RepeatedField $applied_labels
     *           Optional. The set of labels applied directly to this ad unit.
     *     @type array<\Google\Ads\AdManager\V1\AppliedLabel>|\Google\Protobuf\Internal\RepeatedField $effective_applied_labels
     *           Output only. Contains the set of labels applied directly to the ad unit as
     *           well as those inherited from the parent ad units. If a label has been
     *           negated, only the negated label is returned. This field is readonly and is
     *           assigned by Google.
     *     @type array<\Google\Ads\AdManager\V1\LabelFrequencyCap>|\Google\Protobuf\Internal\RepeatedField $applied_label_frequency_caps
     *           Optional. The set of label frequency caps applied directly to this ad unit.
     *           There is a limit of 10 label frequency caps per ad unit.
     *     @type array<\Google\Ads\AdManager\V1\LabelFrequencyCap>|\Google\Protobuf\Internal\RepeatedField $effective_label_frequency_caps
     *           Output only. The label frequency caps applied directly to the ad unit as
     *           well as those inherited from parent ad units.
     *     @type int $smart_size_mode
     *           Optional. The smart size mode for this ad unit. This attribute is optional
     *           and defaults to SmartSizeMode.NONE for fixed sizes.
     *     @type bool $applied_adsense_enabled
     *           Optional. The value of AdSense enabled directly applied to this ad unit.
     *           This attribute is optional and if not specified this ad unit will inherit
     *           the value of effectiveAdsenseEnabled from its ancestors.
     *     @type bool $effective_adsense_enabled
     *           Output only. Specifies whether or not the AdUnit is enabled for serving ads
     *           from the AdSense content network. This attribute defaults to the ad unit's
     *           parent or ancestor's setting if one has been set. If no ancestor of the ad
     *           unit has set appliedAdsenseEnabled, the attribute is defaulted to true.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\Admanager\V1\AdUnitMessages::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the AdUnit.
     * Format: `networks/{network_code}/adUnits/{ad_unit_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the AdUnit.
     * Format: `networks/{network_code}/adUnits/{ad_unit_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. AdUnit ID.
     *
     * Generated from protobuf field <code>int64 ad_unit_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getAdUnitId()
    {
        return $this->ad_unit_id;
    }

    /**
     * Output only. AdUnit ID.
     *
     * Generated from protobuf field <code>int64 ad_unit_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setAdUnitId($var)
    {
        GPBUtil::checkInt64($var);
        $this->ad_unit_id = $var;

        return $this;
    }

    /**
     * Required. Immutable. The AdUnit's parent. Every ad unit has a parent except
     * for the root ad unit, which is created by Google. Format:
     * "networks/{network_code}/adUnits/{ad_unit_id}"
     *
     * Generated from protobuf field <code>string parent_ad_unit = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParentAdUnit()
    {
        return $this->parent_ad_unit;
    }

    /**
     * Required. Immutable. The AdUnit's parent. Every ad unit has a parent except
     * for the root ad unit, which is created by Google. Format:
     * "networks/{network_code}/adUnits/{ad_unit_id}"
     *
     * Generated from protobuf field <code>string parent_ad_unit = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParentAdUnit($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent_ad_unit = $var;

        return $this;
    }

    /**
     * Output only. The path to this AdUnit in the ad unit hierarchy represented
     * as a list from the root to this ad unit's parent. For root ad units, this
     * list is empty.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AdUnitParent parent_path = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getParentPath()
    {
        return $this->parent_path;
    }

    /**
     * Output only. The path to this AdUnit in the ad unit hierarchy represented
     * as a list from the root to this ad unit's parent. For root ad units, this
     * list is empty.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AdUnitParent parent_path = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\AdManager\V1\AdUnitParent>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setParentPath($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\AdUnitParent::class);
        $this->parent_path = $arr;

        return $this;
    }

    /**
     * Required. The display name of the ad unit. Its maximum length is 255
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The display name of the ad unit. Its maximum length is 255
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Immutable. A string used to uniquely identify the ad unit for the purposes
     * of serving the ad. This attribute is optional and can be set during ad unit
     * creation. If it is not provided, it will be assigned by Google based on the
     * ad unit ID.
     *
     * Generated from protobuf field <code>string ad_unit_code = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getAdUnitCode()
    {
        return $this->ad_unit_code;
    }

    /**
     * Immutable. A string used to uniquely identify the ad unit for the purposes
     * of serving the ad. This attribute is optional and can be set during ad unit
     * creation. If it is not provided, it will be assigned by Google based on the
     * ad unit ID.
     *
     * Generated from protobuf field <code>string ad_unit_code = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setAdUnitCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->ad_unit_code = $var;

        return $this;
    }

    /**
     * Output only. The status of this ad unit.  It defaults to ACTIVE.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.AdUnitStatusEnum.AdUnitStatus status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Output only. The status of this ad unit.  It defaults to ACTIVE.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.AdUnitStatusEnum.AdUnitStatus status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\AdManager\V1\AdUnitStatusEnum\AdUnitStatus::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Optional. The target window directly applied to this AdUnit.
     * If this field is not set, this AdUnit uses the target window specified in
     * effectiveTargetWindow.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.TargetWindowEnum.TargetWindow applied_target_window = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAppliedTargetWindow()
    {
        return $this->applied_target_window;
    }

    /**
     * Optional. The target window directly applied to this AdUnit.
     * If this field is not set, this AdUnit uses the target window specified in
     * effectiveTargetWindow.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.TargetWindowEnum.TargetWindow applied_target_window = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAppliedTargetWindow($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\AdManager\V1\TargetWindowEnum\TargetWindow::class);
        $this->applied_target_window = $var;

        return $this;
    }

    /**
     * Output only. Non-empty default. The target window of this AdUnit. This
     * value is inherited from ancestor AdUnits and defaults to TOP if no AdUnit
     * in the hierarchy specifies it.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.TargetWindowEnum.TargetWindow effective_target_window = 45 [(.google.api.field_behavior) = NON_EMPTY_DEFAULT, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getEffectiveTargetWindow()
    {
        return $this->effective_target_window;
    }

    /**
     * Output only. Non-empty default. The target window of this AdUnit. This
     * value is inherited from ancestor AdUnits and defaults to TOP if no AdUnit
     * in the hierarchy specifies it.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.TargetWindowEnum.TargetWindow effective_target_window = 45 [(.google.api.field_behavior) = NON_EMPTY_DEFAULT, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setEffectiveTargetWindow($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\AdManager\V1\TargetWindowEnum\TargetWindow::class);
        $this->effective_target_window = $var;

        return $this;
    }

    /**
     * Optional. The resource names of Teams directly applied to this AdUnit.
     * Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string applied_teams = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAppliedTeams()
    {
        return $this->applied_teams;
    }

    /**
     * Optional. The resource names of Teams directly applied to this AdUnit.
     * Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string applied_teams = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAppliedTeams($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->applied_teams = $arr;

        return $this;
    }

    /**
     * Output only. The resource names of all Teams that this AdUnit is on as well
     * as those inherited from parent AdUnits. Format:
     * "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string teams = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTeams()
    {
        return $this->teams;
    }

    /**
     * Output only. The resource names of all Teams that this AdUnit is on as well
     * as those inherited from parent AdUnits. Format:
     * "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string teams = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTeams($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->teams = $arr;

        return $this;
    }

    /**
     * Optional. A description of the ad unit. The maximum length is 65,535
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A description of the ad unit. The maximum length is 65,535
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. If this field is set to true, then the AdUnit will not be
     * implicitly targeted when its parent is. Traffickers must explicitly
     * target such an AdUnit or else no line items will serve to it. This
     * feature is only available for Ad Manager 360 accounts.
     *
     * Generated from protobuf field <code>bool explicitly_targeted = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getExplicitlyTargeted()
    {
        return $this->explicitly_targeted;
    }

    /**
     * Optional. If this field is set to true, then the AdUnit will not be
     * implicitly targeted when its parent is. Traffickers must explicitly
     * target such an AdUnit or else no line items will serve to it. This
     * feature is only available for Ad Manager 360 accounts.
     *
     * Generated from protobuf field <code>bool explicitly_targeted = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setExplicitlyTargeted($var)
    {
        GPBUtil::checkBool($var);
        $this->explicitly_targeted = $var;

        return $this;
    }

    /**
     * Output only. This field is set to true if the ad unit has any children.
     *
     * Generated from protobuf field <code>bool has_children = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getHasChildren()
    {
        return $this->has_children;
    }

    /**
     * Output only. This field is set to true if the ad unit has any children.
     *
     * Generated from protobuf field <code>bool has_children = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setHasChildren($var)
    {
        GPBUtil::checkBool($var);
        $this->has_children = $var;

        return $this;
    }

    /**
     * Output only. The time this AdUnit was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time this AdUnit was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. The sizes that can be served inside this ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AdUnitSize ad_unit_sizes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdUnitSizes()
    {
        return $this->ad_unit_sizes;
    }

    /**
     * Optional. The sizes that can be served inside this ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AdUnitSize ad_unit_sizes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\AdManager\V1\AdUnitSize>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdUnitSizes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\AdUnitSize::class);
        $this->ad_unit_sizes = $arr;

        return $this;
    }

    /**
     * Optional. Determines what set top box video on demand channel this ad unit
     * corresponds to in an external set top box ad campaign system.
     *
     * Generated from protobuf field <code>string external_set_top_box_channel_id = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getExternalSetTopBoxChannelId()
    {
        return $this->external_set_top_box_channel_id;
    }

    /**
     * Optional. Determines what set top box video on demand channel this ad unit
     * corresponds to in an external set top box ad campaign system.
     *
     * Generated from protobuf field <code>string external_set_top_box_channel_id = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setExternalSetTopBoxChannelId($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_set_top_box_channel_id = $var;

        return $this;
    }

    /**
     * Optional. The duration after which an Ad Unit will automatically refresh.
     * This is only valid for ad units in mobile apps. If not set, the ad unit
     * will not refresh.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration refresh_delay = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getRefreshDelay()
    {
        return $this->refresh_delay;
    }

    public function hasRefreshDelay()
    {
        return isset($this->refresh_delay);
    }

    public function clearRefreshDelay()
    {
        unset($this->refresh_delay);
    }

    /**
     * Optional. The duration after which an Ad Unit will automatically refresh.
     * This is only valid for ad units in mobile apps. If not set, the ad unit
     * will not refresh.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration refresh_delay = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setRefreshDelay($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->refresh_delay = $var;

        return $this;
    }

    /**
     * Optional. The set of labels applied directly to this ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel applied_labels = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAppliedLabels()
    {
        return $this->applied_labels;
    }

    /**
     * Optional. The set of labels applied directly to this ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel applied_labels = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\AdManager\V1\AppliedLabel>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAppliedLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\AppliedLabel::class);
        $this->applied_labels = $arr;

        return $this;
    }

    /**
     * Output only. Contains the set of labels applied directly to the ad unit as
     * well as those inherited from the parent ad units. If a label has been
     * negated, only the negated label is returned. This field is readonly and is
     * assigned by Google.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel effective_applied_labels = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEffectiveAppliedLabels()
    {
        return $this->effective_applied_labels;
    }

    /**
     * Output only. Contains the set of labels applied directly to the ad unit as
     * well as those inherited from the parent ad units. If a label has been
     * negated, only the negated label is returned. This field is readonly and is
     * assigned by Google.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel effective_applied_labels = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\AdManager\V1\AppliedLabel>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEffectiveAppliedLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\AppliedLabel::class);
        $this->effective_applied_labels = $arr;

        return $this;
    }

    /**
     * Optional. The set of label frequency caps applied directly to this ad unit.
     * There is a limit of 10 label frequency caps per ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.LabelFrequencyCap applied_label_frequency_caps = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAppliedLabelFrequencyCaps()
    {
        return $this->applied_label_frequency_caps;
    }

    /**
     * Optional. The set of label frequency caps applied directly to this ad unit.
     * There is a limit of 10 label frequency caps per ad unit.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.LabelFrequencyCap applied_label_frequency_caps = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\AdManager\V1\LabelFrequencyCap>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAppliedLabelFrequencyCaps($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\LabelFrequencyCap::class);
        $this->applied_label_frequency_caps = $arr;

        return $this;
    }

    /**
     * Output only. The label frequency caps applied directly to the ad unit as
     * well as those inherited from parent ad units.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.LabelFrequencyCap effective_label_frequency_caps = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEffectiveLabelFrequencyCaps()
    {
        return $this->effective_label_frequency_caps;
    }

    /**
     * Output only. The label frequency caps applied directly to the ad unit as
     * well as those inherited from parent ad units.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.LabelFrequencyCap effective_label_frequency_caps = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\AdManager\V1\LabelFrequencyCap>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEffectiveLabelFrequencyCaps($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\LabelFrequencyCap::class);
        $this->effective_label_frequency_caps = $arr;

        return $this;
    }

    /**
     * Optional. The smart size mode for this ad unit. This attribute is optional
     * and defaults to SmartSizeMode.NONE for fixed sizes.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.SmartSizeModeEnum.SmartSizeMode smart_size_mode = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getSmartSizeMode()
    {
        return $this->smart_size_mode;
    }

    /**
     * Optional. The smart size mode for this ad unit. This attribute is optional
     * and defaults to SmartSizeMode.NONE for fixed sizes.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.SmartSizeModeEnum.SmartSizeMode smart_size_mode = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setSmartSizeMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\AdManager\V1\SmartSizeModeEnum\SmartSizeMode::class);
        $this->smart_size_mode = $var;

        return $this;
    }

    /**
     * Optional. The value of AdSense enabled directly applied to this ad unit.
     * This attribute is optional and if not specified this ad unit will inherit
     * the value of effectiveAdsenseEnabled from its ancestors.
     *
     * Generated from protobuf field <code>optional bool applied_adsense_enabled = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAppliedAdsenseEnabled()
    {
        return isset($this->applied_adsense_enabled) ? $this->applied_adsense_enabled : false;
    }

    public function hasAppliedAdsenseEnabled()
    {
        return isset($this->applied_adsense_enabled);
    }

    public function clearAppliedAdsenseEnabled()
    {
        unset($this->applied_adsense_enabled);
    }

    /**
     * Optional. The value of AdSense enabled directly applied to this ad unit.
     * This attribute is optional and if not specified this ad unit will inherit
     * the value of effectiveAdsenseEnabled from its ancestors.
     *
     * Generated from protobuf field <code>optional bool applied_adsense_enabled = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAppliedAdsenseEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->applied_adsense_enabled = $var;

        return $this;
    }

    /**
     * Output only. Specifies whether or not the AdUnit is enabled for serving ads
     * from the AdSense content network. This attribute defaults to the ad unit's
     * parent or ancestor's setting if one has been set. If no ancestor of the ad
     * unit has set appliedAdsenseEnabled, the attribute is defaulted to true.
     *
     * Generated from protobuf field <code>bool effective_adsense_enabled = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getEffectiveAdsenseEnabled()
    {
        return $this->effective_adsense_enabled;
    }

    /**
     * Output only. Specifies whether or not the AdUnit is enabled for serving ads
     * from the AdSense content network. This attribute defaults to the ad unit's
     * parent or ancestor's setting if one has been set. If no ancestor of the ad
     * unit has set appliedAdsenseEnabled, the attribute is defaulted to true.
     *
     * Generated from protobuf field <code>bool effective_adsense_enabled = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setEffectiveAdsenseEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->effective_adsense_enabled = $var;

        return $this;
    }

}

