<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/gkebackup/v1/restore.proto

namespace Google\Cloud\GkeBackup\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents both a request to Restore some portion of a Backup into
 * a target GKE cluster and a record of the restore operation itself.
 *
 * Generated from protobuf message <code>google.cloud.gkebackup.v1.Restore</code>
 */
class Restore extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The full name of the Restore resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;&#47;restores/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $uid = '';
    /**
     * Output only. The timestamp when this Restore resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The timestamp when this Restore resource was last
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * User specified descriptive string for this Restore.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     */
    private $description = '';
    /**
     * Required. Immutable. A reference to the
     * [Backup][google.cloud.gkebackup.v1.Backup] used as the source from which
     * this Restore will restore. Note that this Backup must be a sub-resource of
     * the RestorePlan's
     * [backup_plan][google.cloud.gkebackup.v1.RestorePlan.backup_plan]. Format:
     * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;`.
     *
     * Generated from protobuf field <code>string backup = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $backup = '';
    /**
     * Output only. The target cluster into which this Restore will restore data.
     * Valid formats:
     *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * Inherited from parent RestorePlan's
     * [cluster][google.cloud.gkebackup.v1.RestorePlan.cluster] value.
     *
     * Generated from protobuf field <code>string cluster = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $cluster = '';
    /**
     * Output only. Configuration of the Restore.  Inherited from parent
     * RestorePlan's
     * [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $restore_config = null;
    /**
     * A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     */
    private $labels;
    /**
     * Output only. The current state of the Restore.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Restore.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Human-readable description of why the Restore is in its
     * current state.
     *
     * Generated from protobuf field <code>string state_reason = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state_reason = '';
    /**
     * Output only. Timestamp of when the restore operation completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $complete_time = null;
    /**
     * Output only. Number of resources restored during the restore execution.
     *
     * Generated from protobuf field <code>int32 resources_restored_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $resources_restored_count = 0;
    /**
     * Output only. Number of resources excluded during the restore execution.
     *
     * Generated from protobuf field <code>int32 resources_excluded_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $resources_excluded_count = 0;
    /**
     * Output only. Number of resources that failed to be restored during the
     * restore execution.
     *
     * Generated from protobuf field <code>int32 resources_failed_count = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $resources_failed_count = 0;
    /**
     * Output only. Number of volumes restored during the restore execution.
     *
     * Generated from protobuf field <code>int32 volumes_restored_count = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $volumes_restored_count = 0;
    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a restore from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform restore updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetRestore`,
     * and systems are expected to put that etag in the request to
     * `UpdateRestore` or `DeleteRestore` to ensure that their change will be
     * applied to the same version of the resource.
     *
     * Generated from protobuf field <code>string etag = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The full name of the Restore resource.
     *           Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;&#47;restores/&#42;`
     *     @type string $uid
     *           Output only. Server generated global unique identifier of
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when this Restore resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when this Restore resource was last
     *           updated.
     *     @type string $description
     *           User specified descriptive string for this Restore.
     *     @type string $backup
     *           Required. Immutable. A reference to the
     *           [Backup][google.cloud.gkebackup.v1.Backup] used as the source from which
     *           this Restore will restore. Note that this Backup must be a sub-resource of
     *           the RestorePlan's
     *           [backup_plan][google.cloud.gkebackup.v1.RestorePlan.backup_plan]. Format:
     *           `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;`.
     *     @type string $cluster
     *           Output only. The target cluster into which this Restore will restore data.
     *           Valid formats:
     *             - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *             - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     *           Inherited from parent RestorePlan's
     *           [cluster][google.cloud.gkebackup.v1.RestorePlan.cluster] value.
     *     @type \Google\Cloud\GkeBackup\V1\RestoreConfig $restore_config
     *           Output only. Configuration of the Restore.  Inherited from parent
     *           RestorePlan's
     *           [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           A set of custom labels supplied by user.
     *     @type int $state
     *           Output only. The current state of the Restore.
     *     @type string $state_reason
     *           Output only. Human-readable description of why the Restore is in its
     *           current state.
     *     @type \Google\Protobuf\Timestamp $complete_time
     *           Output only. Timestamp of when the restore operation completed.
     *     @type int $resources_restored_count
     *           Output only. Number of resources restored during the restore execution.
     *     @type int $resources_excluded_count
     *           Output only. Number of resources excluded during the restore execution.
     *     @type int $resources_failed_count
     *           Output only. Number of resources that failed to be restored during the
     *           restore execution.
     *     @type int $volumes_restored_count
     *           Output only. Number of volumes restored during the restore execution.
     *     @type string $etag
     *           Output only. `etag` is used for optimistic concurrency control as a way to
     *           help prevent simultaneous updates of a restore from overwriting each other.
     *           It is strongly suggested that systems make use of the `etag` in the
     *           read-modify-write cycle to perform restore updates in order to avoid
     *           race conditions: An `etag` is returned in the response to `GetRestore`,
     *           and systems are expected to put that etag in the request to
     *           `UpdateRestore` or `DeleteRestore` to ensure that their change will be
     *           applied to the same version of the resource.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Gkebackup\V1\Restore::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The full name of the Restore resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;&#47;restores/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The full name of the Restore resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;&#47;restores/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when this Restore resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when this Restore resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when this Restore resource was last
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when this Restore resource was last
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * User specified descriptive string for this Restore.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User specified descriptive string for this Restore.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Required. Immutable. A reference to the
     * [Backup][google.cloud.gkebackup.v1.Backup] used as the source from which
     * this Restore will restore. Note that this Backup must be a sub-resource of
     * the RestorePlan's
     * [backup_plan][google.cloud.gkebackup.v1.RestorePlan.backup_plan]. Format:
     * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;`.
     *
     * Generated from protobuf field <code>string backup = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBackup()
    {
        return $this->backup;
    }

    /**
     * Required. Immutable. A reference to the
     * [Backup][google.cloud.gkebackup.v1.Backup] used as the source from which
     * this Restore will restore. Note that this Backup must be a sub-resource of
     * the RestorePlan's
     * [backup_plan][google.cloud.gkebackup.v1.RestorePlan.backup_plan]. Format:
     * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;`.
     *
     * Generated from protobuf field <code>string backup = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBackup($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup = $var;

        return $this;
    }

    /**
     * Output only. The target cluster into which this Restore will restore data.
     * Valid formats:
     *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * Inherited from parent RestorePlan's
     * [cluster][google.cloud.gkebackup.v1.RestorePlan.cluster] value.
     *
     * Generated from protobuf field <code>string cluster = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCluster()
    {
        return $this->cluster;
    }

    /**
     * Output only. The target cluster into which this Restore will restore data.
     * Valid formats:
     *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * Inherited from parent RestorePlan's
     * [cluster][google.cloud.gkebackup.v1.RestorePlan.cluster] value.
     *
     * Generated from protobuf field <code>string cluster = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCluster($var)
    {
        GPBUtil::checkString($var, True);
        $this->cluster = $var;

        return $this;
    }

    /**
     * Output only. Configuration of the Restore.  Inherited from parent
     * RestorePlan's
     * [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\GkeBackup\V1\RestoreConfig|null
     */
    public function getRestoreConfig()
    {
        return $this->restore_config;
    }

    public function hasRestoreConfig()
    {
        return isset($this->restore_config);
    }

    public function clearRestoreConfig()
    {
        unset($this->restore_config);
    }

    /**
     * Output only. Configuration of the Restore.  Inherited from parent
     * RestorePlan's
     * [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\GkeBackup\V1\RestoreConfig $var
     * @return $this
     */
    public function setRestoreConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\GkeBackup\V1\RestoreConfig::class);
        $this->restore_config = $var;

        return $this;
    }

    /**
     * A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The current state of the Restore.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Restore.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the Restore.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Restore.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\GkeBackup\V1\Restore\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Human-readable description of why the Restore is in its
     * current state.
     *
     * Generated from protobuf field <code>string state_reason = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStateReason()
    {
        return $this->state_reason;
    }

    /**
     * Output only. Human-readable description of why the Restore is in its
     * current state.
     *
     * Generated from protobuf field <code>string state_reason = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStateReason($var)
    {
        GPBUtil::checkString($var, True);
        $this->state_reason = $var;

        return $this;
    }

    /**
     * Output only. Timestamp of when the restore operation completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCompleteTime()
    {
        return $this->complete_time;
    }

    public function hasCompleteTime()
    {
        return isset($this->complete_time);
    }

    public function clearCompleteTime()
    {
        unset($this->complete_time);
    }

    /**
     * Output only. Timestamp of when the restore operation completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCompleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->complete_time = $var;

        return $this;
    }

    /**
     * Output only. Number of resources restored during the restore execution.
     *
     * Generated from protobuf field <code>int32 resources_restored_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getResourcesRestoredCount()
    {
        return $this->resources_restored_count;
    }

    /**
     * Output only. Number of resources restored during the restore execution.
     *
     * Generated from protobuf field <code>int32 resources_restored_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setResourcesRestoredCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->resources_restored_count = $var;

        return $this;
    }

    /**
     * Output only. Number of resources excluded during the restore execution.
     *
     * Generated from protobuf field <code>int32 resources_excluded_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getResourcesExcludedCount()
    {
        return $this->resources_excluded_count;
    }

    /**
     * Output only. Number of resources excluded during the restore execution.
     *
     * Generated from protobuf field <code>int32 resources_excluded_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setResourcesExcludedCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->resources_excluded_count = $var;

        return $this;
    }

    /**
     * Output only. Number of resources that failed to be restored during the
     * restore execution.
     *
     * Generated from protobuf field <code>int32 resources_failed_count = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getResourcesFailedCount()
    {
        return $this->resources_failed_count;
    }

    /**
     * Output only. Number of resources that failed to be restored during the
     * restore execution.
     *
     * Generated from protobuf field <code>int32 resources_failed_count = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setResourcesFailedCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->resources_failed_count = $var;

        return $this;
    }

    /**
     * Output only. Number of volumes restored during the restore execution.
     *
     * Generated from protobuf field <code>int32 volumes_restored_count = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getVolumesRestoredCount()
    {
        return $this->volumes_restored_count;
    }

    /**
     * Output only. Number of volumes restored during the restore execution.
     *
     * Generated from protobuf field <code>int32 volumes_restored_count = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setVolumesRestoredCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->volumes_restored_count = $var;

        return $this;
    }

    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a restore from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform restore updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetRestore`,
     * and systems are expected to put that etag in the request to
     * `UpdateRestore` or `DeleteRestore` to ensure that their change will be
     * applied to the same version of the resource.
     *
     * Generated from protobuf field <code>string etag = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a restore from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform restore updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetRestore`,
     * and systems are expected to put that etag in the request to
     * `UpdateRestore` or `DeleteRestore` to ensure that their change will be
     * applied to the same version of the resource.
     *
     * Generated from protobuf field <code>string etag = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

