<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/user_event.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * UserEvent captures all metadata information Discovery Engine API needs to
 * know about how end users interact with customers' website.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.UserEvent</code>
 */
class UserEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. User event type. Allowed values are:
     * Generic values:
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home > Men > Jeans
     * Retail-related values:
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     * Media-related values:
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $event_type = '';
    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     *
     * Generated from protobuf field <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $user_pseudo_id = '';
    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    protected $event_time = null;
    /**
     * Information about the end user.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     */
    protected $user_info = null;
    /**
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * can be populated from the HTTP request.
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
     *
     * Generated from protobuf field <code>bool direct_user_request = 5;</code>
     */
    protected $direct_user_request = false;
    /**
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the session_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * as prefix.
     *
     * Generated from protobuf field <code>string session_id = 6;</code>
     */
    protected $session_id = '';
    /**
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     */
    protected $page_info = null;
    /**
     * Token to attribute an API response to user action(s) to trigger the event.
     * Highly recommended for user events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be one of:
     * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 8;</code>
     */
    protected $attribution_token = '';
    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     * One example is for `search` events, the associated
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     * a filter expression in
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     * Similarly, for `view-item-list` events that are generated from a
     * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     * field may be populated directly from
     * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *
     * Generated from protobuf field <code>string filter = 9;</code>
     */
    protected $filter = '';
    /**
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    private $documents;
    /**
     * Panel metadata associated with this user event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     */
    protected $panel = null;
    /**
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     * This field should be set for `search` event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     */
    protected $search_info = null;
    /**
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     */
    protected $completion_info = null;
    /**
     * The transaction metadata (if any) associated with this user event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     */
    protected $transaction_info = null;
    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     *
     * Generated from protobuf field <code>repeated string tag_ids = 15;</code>
     */
    private $tag_ids;
    /**
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     *
     * Generated from protobuf field <code>repeated string promotion_ids = 16;</code>
     */
    private $promotion_ids;
    /**
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.discoveryengine.v1.CustomAttribute> attributes = 17;</code>
     */
    private $attributes;
    /**
     * Media-specific info.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     */
    protected $media_info = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $event_type
     *           Required. User event type. Allowed values are:
     *           Generic values:
     *           * `search`: Search for Documents.
     *           * `view-item`: Detailed page view of a Document.
     *           * `view-item-list`: View of a panel or ordered list of Documents.
     *           * `view-home-page`: View of the home page.
     *           * `view-category-page`: View of a category page, e.g. Home > Men > Jeans
     *           Retail-related values:
     *           * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     *           * `purchase`: Purchase an item(s)
     *           Media-related values:
     *           * `media-play`: Start/resume watching a video, playing a song, etc.
     *           * `media-complete`: Finished or stopped midway through a video, song, etc.
     *     @type string $user_pseudo_id
     *           Required. A unique identifier for tracking visitors.
     *           For example, this could be implemented with an HTTP cookie, which should be
     *           able to uniquely identify a visitor on a single device. This unique
     *           identifier should not change if the visitor log in/out of the website.
     *           Do not set the field to the same fixed ID for different users. This mixes
     *           the event history of those users together, which results in degraded model
     *           quality.
     *           The field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *           The field should not contain PII or user-data. We recommend to use Google
     *           Analytics [Client
     *           ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     *           for this field.
     *     @type \Google\Protobuf\Timestamp $event_time
     *           Only required for
     *           [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     *           method. Timestamp of when the user event happened.
     *     @type \Google\Cloud\DiscoveryEngine\V1\UserInfo $user_info
     *           Information about the end user.
     *     @type bool $direct_user_request
     *           Should set to true if the request is made directly from the end user, in
     *           which case the
     *           [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     *           can be populated from the HTTP request.
     *           This flag should be set only if the API request is made directly from the
     *           end user such as a mobile app (and not if a gateway or a server is
     *           processing and pushing the user events).
     *           This should not be set when using the JavaScript tag in
     *           [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
     *     @type string $session_id
     *           A unique identifier for tracking a visitor session with a length limit of
     *           128 bytes. A session is an aggregation of an end user behavior in a time
     *           span.
     *           A general guideline to populate the session_id:
     *           1. If user has no activity for 30 min, a new session_id should be assigned.
     *           2. The session_id should be unique across users, suggest use uuid or add
     *           [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     *           as prefix.
     *     @type \Google\Cloud\DiscoveryEngine\V1\PageInfo $page_info
     *           Page metadata such as categories and other critical information for certain
     *           event types such as `view-category-page`.
     *     @type string $attribution_token
     *           Token to attribute an API response to user action(s) to trigger the event.
     *           Highly recommended for user events that are the result of
     *           [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     *           This field enables accurate attribution of recommendation model
     *           performance.
     *           The value must be one of:
     *           * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     *           [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     *           * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     *           [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     *           This token enables us to accurately attribute page view or conversion
     *           completion back to the event and the particular predict response containing
     *           this clicked/purchased product. If user clicks on product K in the
     *           recommendation results, pass
     *           [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     *           as a URL parameter to product K's page. When recording events on product
     *           K's page, log the
     *           [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     *           to this field.
     *     @type string $filter
     *           The filter syntax consists of an expression language for constructing a
     *           predicate from one or more fields of the documents being filtered.
     *           One example is for `search` events, the associated
     *           [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     *           a filter expression in
     *           [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     *           conforming to https://google.aip.dev/160#filtering.
     *           Similarly, for `view-item-list` events that are generated from a
     *           [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     *           field may be populated directly from
     *           [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     *           conforming to https://google.aip.dev/160#filtering.
     *           The value must be a UTF-8 encoded string with a length limit of 1,000
     *           characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *     @type array<\Google\Cloud\DiscoveryEngine\V1\DocumentInfo>|\Google\Protobuf\Internal\RepeatedField $documents
     *           List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     *           with this user event.
     *           This field is optional except for the following event types:
     *           * `view-item`
     *           * `add-to-cart`
     *           * `purchase`
     *           * `media-play`
     *           * `media-complete`
     *           In a `search` event, this field represents the documents returned to the
     *           end user on the current page (the end user may have not finished browsing
     *           the whole page yet). When a new page is returned to the end user, after
     *           pagination/filtering/ordering even for the same query, a new `search` event
     *           with different
     *           [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     *           is desired.
     *     @type \Google\Cloud\DiscoveryEngine\V1\PanelInfo $panel
     *           Panel metadata associated with this user event.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchInfo $search_info
     *           [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     *           details related to the event.
     *           This field should be set for `search` event.
     *     @type \Google\Cloud\DiscoveryEngine\V1\CompletionInfo $completion_info
     *           [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     *           details related to the event.
     *           This field should be set for `search` event when autocomplete function is
     *           enabled and the user clicks a suggestion for search.
     *     @type \Google\Cloud\DiscoveryEngine\V1\TransactionInfo $transaction_info
     *           The transaction metadata (if any) associated with this user event.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tag_ids
     *           A list of identifiers for the independent experiment groups this user event
     *           belongs to. This is used to distinguish between user events associated with
     *           different experiment setups on the customer end.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $promotion_ids
     *           The promotion IDs if this is an event associated with promotions.
     *           Currently, this field is restricted to at most one ID.
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Extra user event features to include in the recommendation model.
     *           These attributes must NOT contain data that needs to be parsed or processed
     *           further, e.g. JSON or other encodings.
     *           If you provide custom attributes for ingested user events, also include
     *           them in the user events that you associate with prediction requests. Custom
     *           attribute formatting must be consistent between imported events and events
     *           provided with prediction requests. This lets the Discovery Engine API use
     *           those custom attributes when training models and serving predictions, which
     *           helps improve recommendation quality.
     *           This field needs to pass all below criteria, otherwise an
     *           `INVALID_ARGUMENT` error is returned:
     *           * The key must be a UTF-8 encoded string with a length limit of 5,000
     *             characters.
     *           * For text attributes, at most 400 values are allowed. Empty values are not
     *             allowed. Each value must be a UTF-8 encoded string with a length limit of
     *             256 characters.
     *           * For number attributes, at most 400 values are allowed.
     *           For product recommendations, an example of extra user information is
     *           `traffic_channel`, which is how a user arrives at the site. Users can
     *           arrive
     *           at the site by coming to the site directly, coming through Google
     *           search, or in other ways.
     *     @type \Google\Cloud\DiscoveryEngine\V1\MediaInfo $media_info
     *           Media-specific info.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\UserEvent::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. User event type. Allowed values are:
     * Generic values:
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home > Men > Jeans
     * Retail-related values:
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     * Media-related values:
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getEventType()
    {
        return $this->event_type;
    }

    /**
     * Required. User event type. Allowed values are:
     * Generic values:
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home > Men > Jeans
     * Retail-related values:
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     * Media-related values:
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setEventType($var)
    {
        GPBUtil::checkString($var, True);
        $this->event_type = $var;

        return $this;
    }

    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     *
     * Generated from protobuf field <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getUserPseudoId()
    {
        return $this->user_pseudo_id;
    }

    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     *
     * Generated from protobuf field <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setUserPseudoId($var)
    {
        GPBUtil::checkString($var, True);
        $this->user_pseudo_id = $var;

        return $this;
    }

    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTime()
    {
        return $this->event_time;
    }

    public function hasEventTime()
    {
        return isset($this->event_time);
    }

    public function clearEventTime()
    {
        unset($this->event_time);
    }

    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_time = $var;

        return $this;
    }

    /**
     * Information about the end user.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\UserInfo|null
     */
    public function getUserInfo()
    {
        return $this->user_info;
    }

    public function hasUserInfo()
    {
        return isset($this->user_info);
    }

    public function clearUserInfo()
    {
        unset($this->user_info);
    }

    /**
     * Information about the end user.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\UserInfo $var
     * @return $this
     */
    public function setUserInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\UserInfo::class);
        $this->user_info = $var;

        return $this;
    }

    /**
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * can be populated from the HTTP request.
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
     *
     * Generated from protobuf field <code>bool direct_user_request = 5;</code>
     * @return bool
     */
    public function getDirectUserRequest()
    {
        return $this->direct_user_request;
    }

    /**
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * can be populated from the HTTP request.
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
     *
     * Generated from protobuf field <code>bool direct_user_request = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setDirectUserRequest($var)
    {
        GPBUtil::checkBool($var);
        $this->direct_user_request = $var;

        return $this;
    }

    /**
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the session_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * as prefix.
     *
     * Generated from protobuf field <code>string session_id = 6;</code>
     * @return string
     */
    public function getSessionId()
    {
        return $this->session_id;
    }

    /**
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the session_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * as prefix.
     *
     * Generated from protobuf field <code>string session_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setSessionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->session_id = $var;

        return $this;
    }

    /**
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\PageInfo|null
     */
    public function getPageInfo()
    {
        return $this->page_info;
    }

    public function hasPageInfo()
    {
        return isset($this->page_info);
    }

    public function clearPageInfo()
    {
        unset($this->page_info);
    }

    /**
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\PageInfo $var
     * @return $this
     */
    public function setPageInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\PageInfo::class);
        $this->page_info = $var;

        return $this;
    }

    /**
     * Token to attribute an API response to user action(s) to trigger the event.
     * Highly recommended for user events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be one of:
     * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 8;</code>
     * @return string
     */
    public function getAttributionToken()
    {
        return $this->attribution_token;
    }

    /**
     * Token to attribute an API response to user action(s) to trigger the event.
     * Highly recommended for user events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be one of:
     * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setAttributionToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->attribution_token = $var;

        return $this;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     * One example is for `search` events, the associated
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     * a filter expression in
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     * Similarly, for `view-item-list` events that are generated from a
     * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     * field may be populated directly from
     * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *
     * Generated from protobuf field <code>string filter = 9;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     * One example is for `search` events, the associated
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     * a filter expression in
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     * Similarly, for `view-item-list` events that are generated from a
     * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     * field may be populated directly from
     * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *
     * Generated from protobuf field <code>string filter = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDocuments()
    {
        return $this->documents;
    }

    /**
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     * @param array<\Google\Cloud\DiscoveryEngine\V1\DocumentInfo>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDocuments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DiscoveryEngine\V1\DocumentInfo::class);
        $this->documents = $arr;

        return $this;
    }

    /**
     * Panel metadata associated with this user event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\PanelInfo|null
     */
    public function getPanel()
    {
        return $this->panel;
    }

    public function hasPanel()
    {
        return isset($this->panel);
    }

    public function clearPanel()
    {
        unset($this->panel);
    }

    /**
     * Panel metadata associated with this user event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\PanelInfo $var
     * @return $this
     */
    public function setPanel($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\PanelInfo::class);
        $this->panel = $var;

        return $this;
    }

    /**
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     * This field should be set for `search` event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchInfo|null
     */
    public function getSearchInfo()
    {
        return $this->search_info;
    }

    public function hasSearchInfo()
    {
        return isset($this->search_info);
    }

    public function clearSearchInfo()
    {
        unset($this->search_info);
    }

    /**
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     * This field should be set for `search` event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchInfo $var
     * @return $this
     */
    public function setSearchInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchInfo::class);
        $this->search_info = $var;

        return $this;
    }

    /**
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\CompletionInfo|null
     */
    public function getCompletionInfo()
    {
        return $this->completion_info;
    }

    public function hasCompletionInfo()
    {
        return isset($this->completion_info);
    }

    public function clearCompletionInfo()
    {
        unset($this->completion_info);
    }

    /**
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\CompletionInfo $var
     * @return $this
     */
    public function setCompletionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\CompletionInfo::class);
        $this->completion_info = $var;

        return $this;
    }

    /**
     * The transaction metadata (if any) associated with this user event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\TransactionInfo|null
     */
    public function getTransactionInfo()
    {
        return $this->transaction_info;
    }

    public function hasTransactionInfo()
    {
        return isset($this->transaction_info);
    }

    public function clearTransactionInfo()
    {
        unset($this->transaction_info);
    }

    /**
     * The transaction metadata (if any) associated with this user event.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\TransactionInfo $var
     * @return $this
     */
    public function setTransactionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\TransactionInfo::class);
        $this->transaction_info = $var;

        return $this;
    }

    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     *
     * Generated from protobuf field <code>repeated string tag_ids = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTagIds()
    {
        return $this->tag_ids;
    }

    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     *
     * Generated from protobuf field <code>repeated string tag_ids = 15;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTagIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tag_ids = $arr;

        return $this;
    }

    /**
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     *
     * Generated from protobuf field <code>repeated string promotion_ids = 16;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPromotionIds()
    {
        return $this->promotion_ids;
    }

    /**
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     *
     * Generated from protobuf field <code>repeated string promotion_ids = 16;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPromotionIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->promotion_ids = $arr;

        return $this;
    }

    /**
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.discoveryengine.v1.CustomAttribute> attributes = 17;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.discoveryengine.v1.CustomAttribute> attributes = 17;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DiscoveryEngine\V1\CustomAttribute::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * Media-specific info.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\MediaInfo|null
     */
    public function getMediaInfo()
    {
        return $this->media_info;
    }

    public function hasMediaInfo()
    {
        return isset($this->media_info);
    }

    public function clearMediaInfo()
    {
        unset($this->media_info);
    }

    /**
     * Media-specific info.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\MediaInfo $var
     * @return $this
     */
    public function setMediaInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\MediaInfo::class);
        $this->media_info = $var;

        return $this;
    }

}

