<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/message.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A message in a Google Chat space.
 *
 * Generated from protobuf message <code>google.chat.v1.Message</code>
 */
class Message extends \Google\Protobuf\Internal\Message
{
    /**
     * Resource name of the message.
     * Format: `spaces/{space}/messages/{message}`
     * Where `{space}` is the ID of the space where the message is posted and
     * `{message}` is a system-assigned ID for the message. For example,
     * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     * If you set a custom ID when you create a message, you can use this ID to
     * specify the message in a request by replacing `{message}` with the value
     * from the `clientAssignedMessageId` field. For example,
     * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     * a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     *
     * Generated from protobuf field <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $sender = null;
    /**
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_update_time = null;
    /**
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delete_time = null;
    /**
     * Plain-text body of the message. The first link to an image, video, or web
     * page generates a
     * [preview chip](https://developers.google.com/workspace/chat/preview-links).
     * You can also [&#64;mention a Google Chat
     * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     * or everyone in the space.
     * To learn about creating text messages, see [Send a text
     * message](https://developers.google.com/workspace/chat/create-messages#create-text-messages).
     *
     * Generated from protobuf field <code>string text = 4;</code>
     */
    protected $text = '';
    /**
     * Output only. Contains the message `text` with markups added to communicate
     * formatting. This field might not capture all formatting visible in the UI,
     * but includes the following:
     * * [Markup
     * syntax](https://developers.google.com/workspace/chat/format-messages)
     * for bold, italic, strikethrough, monospace, monospace block, and bulleted
     * list.
     * * [User
     * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     * using the format `<users/{user}>`.
     * * Custom hyperlinks using the format `<{url}|{rendered_text}>` where the
     * first string is the URL and the second is the rendered text—for example,
     * `<http://example.com|custom text>`.
     * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     * face emoji.
     * For more information, see [View text formatting sent in a
     * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     *
     * Generated from protobuf field <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $formatted_text = '';
    /**
     * Deprecated: Use `cards_v2` instead.
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
     * @deprecated
     */
    private $cards;
    /**
     * An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     * To learn about cards and how to create them, see [Send card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.CardWithId cards_v2 = 22;</code>
     */
    private $cards_v2;
    /**
     * Output only. Annotations associated with the `text` in this message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $annotations;
    /**
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     *
     * Generated from protobuf field <code>.google.chat.v1.Thread thread = 11;</code>
     */
    protected $thread = null;
    /**
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 12;</code>
     */
    protected $space = null;
    /**
     * A plain-text description of the message's cards, used when the actual cards
     * can't be displayed—for example, mobile notifications.
     *
     * Generated from protobuf field <code>string fallback_text = 13;</code>
     */
    protected $fallback_text = '';
    /**
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     *
     * Generated from protobuf field <code>.google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $action_response = null;
    /**
     * Output only. Plain-text body of the message with all Chat app mentions
     * stripped out.
     *
     * Generated from protobuf field <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $argument_text = '';
    /**
     * Output only. Slash command information, if applicable.
     *
     * Generated from protobuf field <code>.google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $slash_command = null;
    /**
     * User-uploaded attachment.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Attachment attachment = 18;</code>
     */
    private $attachment;
    /**
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     *
     * Generated from protobuf field <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $matched_url = null;
    /**
     * Output only. When `true`, the message is a response in a reply thread. When
     * `false`, the message is visible in the space's top-level conversation as
     * either the first message of a thread or a message with no threaded replies.
     * If the space doesn't support reply in threads, this field is always
     * `false`.
     *
     * Generated from protobuf field <code>bool thread_reply = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $thread_reply = false;
    /**
     * Optional. A custom ID for the message. You can use field to identify a
     * message, or to get, delete, or update a message. To set a custom ID,
     * specify the
     * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     * field when you create the message. For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     *
     * Generated from protobuf field <code>string client_assigned_message_id = 32;</code>
     */
    protected $client_assigned_message_id = '';
    /**
     * Output only. The list of emoji reaction summaries on the message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $emoji_reaction_summaries;
    /**
     * Immutable. Input for creating a message, otherwise output only. The user
     * that can view the message. When set, the message is private and only
     * visible to the specified user and the Chat app. Link previews and
     * attachments aren't supported for private messages.
     * Only Chat apps can send private messages. If your Chat app [authenticates
     * as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * to send a message, the message can't be private and must omit this field.
     * For details, see [Send private messages to Google Chat
     * users](https://developers.google.com/workspace/chat/private-messages).
     *
     * Generated from protobuf field <code>.google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $private_message_viewer = null;
    /**
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     *
     * Generated from protobuf field <code>.google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $deletion_metadata = null;
    /**
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $quoted_message_metadata = null;
    /**
     * Output only. GIF images that are attached to the message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $attached_gifs;
    /**
     * One or more interactive widgets that appear at the bottom of a message.
     * You can add accessory widgets to messages that contain text, cards, or both
     * text and cards. Not supported for messages that contain dialogs. For
     * details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44;</code>
     */
    private $accessory_widgets;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Resource name of the message.
     *           Format: `spaces/{space}/messages/{message}`
     *           Where `{space}` is the ID of the space where the message is posted and
     *           `{message}` is a system-assigned ID for the message. For example,
     *           `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     *           If you set a custom ID when you create a message, you can use this ID to
     *           specify the message in a request by replacing `{message}` with the value
     *           from the `clientAssignedMessageId` field. For example,
     *           `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     *           a
     *           message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     *     @type \Google\Apps\Chat\V1\User $sender
     *           Output only. The user who created the message.
     *           If your Chat app [authenticates as a
     *           user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     *           the output populates the
     *           [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     *           `name` and `type`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Optional. Immutable. For spaces created in Chat, the time at which the
     *           message was created. This field is output only, except when used in import
     *           mode spaces.
     *           For import mode spaces, set this field to the historical timestamp at which
     *           the message was created in the source in order to preserve the original
     *           creation time.
     *     @type \Google\Protobuf\Timestamp $last_update_time
     *           Output only. The time at which the message was last edited by a user. If
     *           the message has never been edited, this field is empty.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. The time at which the message was deleted in
     *           Google Chat. If the message is never deleted, this field is empty.
     *     @type string $text
     *           Plain-text body of the message. The first link to an image, video, or web
     *           page generates a
     *           [preview chip](https://developers.google.com/workspace/chat/preview-links).
     *           You can also [&#64;mention a Google Chat
     *           user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     *           or everyone in the space.
     *           To learn about creating text messages, see [Send a text
     *           message](https://developers.google.com/workspace/chat/create-messages#create-text-messages).
     *     @type string $formatted_text
     *           Output only. Contains the message `text` with markups added to communicate
     *           formatting. This field might not capture all formatting visible in the UI,
     *           but includes the following:
     *           * [Markup
     *           syntax](https://developers.google.com/workspace/chat/format-messages)
     *           for bold, italic, strikethrough, monospace, monospace block, and bulleted
     *           list.
     *           * [User
     *           mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     *           using the format `<users/{user}>`.
     *           * Custom hyperlinks using the format `<{url}|{rendered_text}>` where the
     *           first string is the URL and the second is the rendered text—for example,
     *           `<http://example.com|custom text>`.
     *           * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     *           This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     *           face emoji.
     *           For more information, see [View text formatting sent in a
     *           message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     *     @type array<\Google\Apps\Chat\V1\ContextualAddOnMarkup\Card>|\Google\Protobuf\Internal\RepeatedField $cards
     *           Deprecated: Use `cards_v2` instead.
     *           Rich, formatted, and interactive cards that you can use to display UI
     *           elements such as: formatted texts, buttons, and clickable images. Cards are
     *           normally displayed below the plain-text body of the message. `cards` and
     *           `cards_v2` can have a maximum size of 32 KB.
     *     @type array<\Google\Apps\Chat\V1\CardWithId>|\Google\Protobuf\Internal\RepeatedField $cards_v2
     *           An array of
     *           [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *           Only Chat apps can create cards. If your Chat app [authenticates as a
     *           user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     *           the messages can't contain cards.
     *           To learn about cards and how to create them, see [Send card
     *           messages](https://developers.google.com/workspace/chat/create-messages#create).
     *           [Card builder](https://addons.gsuite.google.com/uikit/builder)
     *     @type array<\Google\Apps\Chat\V1\Annotation>|\Google\Protobuf\Internal\RepeatedField $annotations
     *           Output only. Annotations associated with the `text` in this message.
     *     @type \Google\Apps\Chat\V1\Thread $thread
     *           The thread the message belongs to. For example usage, see
     *           [Start or reply to a message
     *           thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     *     @type \Google\Apps\Chat\V1\Space $space
     *           If your Chat app [authenticates as a
     *           user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     *           the output populates the
     *           [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     *           `name`.
     *     @type string $fallback_text
     *           A plain-text description of the message's cards, used when the actual cards
     *           can't be displayed—for example, mobile notifications.
     *     @type \Google\Apps\Chat\V1\ActionResponse $action_response
     *           Input only. Parameters that a Chat app can use to configure how its
     *           response is posted.
     *     @type string $argument_text
     *           Output only. Plain-text body of the message with all Chat app mentions
     *           stripped out.
     *     @type \Google\Apps\Chat\V1\SlashCommand $slash_command
     *           Output only. Slash command information, if applicable.
     *     @type array<\Google\Apps\Chat\V1\Attachment>|\Google\Protobuf\Internal\RepeatedField $attachment
     *           User-uploaded attachment.
     *     @type \Google\Apps\Chat\V1\MatchedUrl $matched_url
     *           Output only. A URL in `spaces.messages.text` that matches a link preview
     *           pattern. For more information, see [Preview
     *           links](https://developers.google.com/workspace/chat/preview-links).
     *     @type bool $thread_reply
     *           Output only. When `true`, the message is a response in a reply thread. When
     *           `false`, the message is visible in the space's top-level conversation as
     *           either the first message of a thread or a message with no threaded replies.
     *           If the space doesn't support reply in threads, this field is always
     *           `false`.
     *     @type string $client_assigned_message_id
     *           Optional. A custom ID for the message. You can use field to identify a
     *           message, or to get, delete, or update a message. To set a custom ID,
     *           specify the
     *           [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     *           field when you create the message. For details, see [Name a
     *           message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     *     @type array<\Google\Apps\Chat\V1\EmojiReactionSummary>|\Google\Protobuf\Internal\RepeatedField $emoji_reaction_summaries
     *           Output only. The list of emoji reaction summaries on the message.
     *     @type \Google\Apps\Chat\V1\User $private_message_viewer
     *           Immutable. Input for creating a message, otherwise output only. The user
     *           that can view the message. When set, the message is private and only
     *           visible to the specified user and the Chat app. Link previews and
     *           attachments aren't supported for private messages.
     *           Only Chat apps can send private messages. If your Chat app [authenticates
     *           as a
     *           user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *           to send a message, the message can't be private and must omit this field.
     *           For details, see [Send private messages to Google Chat
     *           users](https://developers.google.com/workspace/chat/private-messages).
     *     @type \Google\Apps\Chat\V1\DeletionMetadata $deletion_metadata
     *           Output only. Information about a deleted message. A message is deleted when
     *           `delete_time` is set.
     *     @type \Google\Apps\Chat\V1\QuotedMessageMetadata $quoted_message_metadata
     *           Output only. Information about a message that's quoted by a Google Chat
     *           user in a space. Google Chat users can quote a message to reply to it.
     *     @type array<\Google\Apps\Chat\V1\AttachedGif>|\Google\Protobuf\Internal\RepeatedField $attached_gifs
     *           Output only. GIF images that are attached to the message.
     *     @type array<\Google\Apps\Chat\V1\AccessoryWidget>|\Google\Protobuf\Internal\RepeatedField $accessory_widgets
     *           One or more interactive widgets that appear at the bottom of a message.
     *           You can add accessory widgets to messages that contain text, cards, or both
     *           text and cards. Not supported for messages that contain dialogs. For
     *           details, see [Add interactive widgets at the bottom of a
     *           message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *           Creating a message with accessory widgets requires [app
     *           authentication]
     *           (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name of the message.
     * Format: `spaces/{space}/messages/{message}`
     * Where `{space}` is the ID of the space where the message is posted and
     * `{message}` is a system-assigned ID for the message. For example,
     * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     * If you set a custom ID when you create a message, you can use this ID to
     * specify the message in a request by replacing `{message}` with the value
     * from the `clientAssignedMessageId` field. For example,
     * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     * a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Resource name of the message.
     * Format: `spaces/{space}/messages/{message}`
     * Where `{space}` is the ID of the space where the message is posted and
     * `{message}` is a system-assigned ID for the message. For example,
     * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     * If you set a custom ID when you create a message, you can use this ID to
     * specify the message in a request by replacing `{message}` with the value
     * from the `clientAssignedMessageId` field. For example,
     * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     * a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     *
     * Generated from protobuf field <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\User|null
     */
    public function getSender()
    {
        return $this->sender;
    }

    public function hasSender()
    {
        return isset($this->sender);
    }

    public function clearSender()
    {
        unset($this->sender);
    }

    /**
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     *
     * Generated from protobuf field <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\User $var
     * @return $this
     */
    public function setSender($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\User::class);
        $this->sender = $var;

        return $this;
    }

    /**
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastUpdateTime()
    {
        return $this->last_update_time;
    }

    public function hasLastUpdateTime()
    {
        return isset($this->last_update_time);
    }

    public function clearLastUpdateTime()
    {
        unset($this->last_update_time);
    }

    /**
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_update_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Plain-text body of the message. The first link to an image, video, or web
     * page generates a
     * [preview chip](https://developers.google.com/workspace/chat/preview-links).
     * You can also [&#64;mention a Google Chat
     * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     * or everyone in the space.
     * To learn about creating text messages, see [Send a text
     * message](https://developers.google.com/workspace/chat/create-messages#create-text-messages).
     *
     * Generated from protobuf field <code>string text = 4;</code>
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * Plain-text body of the message. The first link to an image, video, or web
     * page generates a
     * [preview chip](https://developers.google.com/workspace/chat/preview-links).
     * You can also [&#64;mention a Google Chat
     * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     * or everyone in the space.
     * To learn about creating text messages, see [Send a text
     * message](https://developers.google.com/workspace/chat/create-messages#create-text-messages).
     *
     * Generated from protobuf field <code>string text = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkString($var, True);
        $this->text = $var;

        return $this;
    }

    /**
     * Output only. Contains the message `text` with markups added to communicate
     * formatting. This field might not capture all formatting visible in the UI,
     * but includes the following:
     * * [Markup
     * syntax](https://developers.google.com/workspace/chat/format-messages)
     * for bold, italic, strikethrough, monospace, monospace block, and bulleted
     * list.
     * * [User
     * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     * using the format `<users/{user}>`.
     * * Custom hyperlinks using the format `<{url}|{rendered_text}>` where the
     * first string is the URL and the second is the rendered text—for example,
     * `<http://example.com|custom text>`.
     * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     * face emoji.
     * For more information, see [View text formatting sent in a
     * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     *
     * Generated from protobuf field <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getFormattedText()
    {
        return $this->formatted_text;
    }

    /**
     * Output only. Contains the message `text` with markups added to communicate
     * formatting. This field might not capture all formatting visible in the UI,
     * but includes the following:
     * * [Markup
     * syntax](https://developers.google.com/workspace/chat/format-messages)
     * for bold, italic, strikethrough, monospace, monospace block, and bulleted
     * list.
     * * [User
     * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     * using the format `<users/{user}>`.
     * * Custom hyperlinks using the format `<{url}|{rendered_text}>` where the
     * first string is the URL and the second is the rendered text—for example,
     * `<http://example.com|custom text>`.
     * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     * face emoji.
     * For more information, see [View text formatting sent in a
     * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     *
     * Generated from protobuf field <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setFormattedText($var)
    {
        GPBUtil::checkString($var, True);
        $this->formatted_text = $var;

        return $this;
    }

    /**
     * Deprecated: Use `cards_v2` instead.
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getCards()
    {
        @trigger_error('cards is deprecated.', E_USER_DEPRECATED);
        return $this->cards;
    }

    /**
     * Deprecated: Use `cards_v2` instead.
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
     * @param array<\Google\Apps\Chat\V1\ContextualAddOnMarkup\Card>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setCards($var)
    {
        @trigger_error('cards is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Chat\V1\ContextualAddOnMarkup\Card::class);
        $this->cards = $arr;

        return $this;
    }

    /**
     * An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     * To learn about cards and how to create them, see [Send card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.CardWithId cards_v2 = 22;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCardsV2()
    {
        return $this->cards_v2;
    }

    /**
     * An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     * To learn about cards and how to create them, see [Send card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.CardWithId cards_v2 = 22;</code>
     * @param array<\Google\Apps\Chat\V1\CardWithId>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCardsV2($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Chat\V1\CardWithId::class);
        $this->cards_v2 = $arr;

        return $this;
    }

    /**
     * Output only. Annotations associated with the `text` in this message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Output only. Annotations associated with the `text` in this message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Apps\Chat\V1\Annotation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Chat\V1\Annotation::class);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     *
     * Generated from protobuf field <code>.google.chat.v1.Thread thread = 11;</code>
     * @return \Google\Apps\Chat\V1\Thread|null
     */
    public function getThread()
    {
        return $this->thread;
    }

    public function hasThread()
    {
        return isset($this->thread);
    }

    public function clearThread()
    {
        unset($this->thread);
    }

    /**
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     *
     * Generated from protobuf field <code>.google.chat.v1.Thread thread = 11;</code>
     * @param \Google\Apps\Chat\V1\Thread $var
     * @return $this
     */
    public function setThread($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Thread::class);
        $this->thread = $var;

        return $this;
    }

    /**
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 12;</code>
     * @return \Google\Apps\Chat\V1\Space|null
     */
    public function getSpace()
    {
        return $this->space;
    }

    public function hasSpace()
    {
        return isset($this->space);
    }

    public function clearSpace()
    {
        unset($this->space);
    }

    /**
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 12;</code>
     * @param \Google\Apps\Chat\V1\Space $var
     * @return $this
     */
    public function setSpace($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space::class);
        $this->space = $var;

        return $this;
    }

    /**
     * A plain-text description of the message's cards, used when the actual cards
     * can't be displayed—for example, mobile notifications.
     *
     * Generated from protobuf field <code>string fallback_text = 13;</code>
     * @return string
     */
    public function getFallbackText()
    {
        return $this->fallback_text;
    }

    /**
     * A plain-text description of the message's cards, used when the actual cards
     * can't be displayed—for example, mobile notifications.
     *
     * Generated from protobuf field <code>string fallback_text = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setFallbackText($var)
    {
        GPBUtil::checkString($var, True);
        $this->fallback_text = $var;

        return $this;
    }

    /**
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     *
     * Generated from protobuf field <code>.google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\ActionResponse|null
     */
    public function getActionResponse()
    {
        return $this->action_response;
    }

    public function hasActionResponse()
    {
        return isset($this->action_response);
    }

    public function clearActionResponse()
    {
        unset($this->action_response);
    }

    /**
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     *
     * Generated from protobuf field <code>.google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\ActionResponse $var
     * @return $this
     */
    public function setActionResponse($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\ActionResponse::class);
        $this->action_response = $var;

        return $this;
    }

    /**
     * Output only. Plain-text body of the message with all Chat app mentions
     * stripped out.
     *
     * Generated from protobuf field <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getArgumentText()
    {
        return $this->argument_text;
    }

    /**
     * Output only. Plain-text body of the message with all Chat app mentions
     * stripped out.
     *
     * Generated from protobuf field <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setArgumentText($var)
    {
        GPBUtil::checkString($var, True);
        $this->argument_text = $var;

        return $this;
    }

    /**
     * Output only. Slash command information, if applicable.
     *
     * Generated from protobuf field <code>.google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\SlashCommand|null
     */
    public function getSlashCommand()
    {
        return $this->slash_command;
    }

    public function hasSlashCommand()
    {
        return isset($this->slash_command);
    }

    public function clearSlashCommand()
    {
        unset($this->slash_command);
    }

    /**
     * Output only. Slash command information, if applicable.
     *
     * Generated from protobuf field <code>.google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\SlashCommand $var
     * @return $this
     */
    public function setSlashCommand($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\SlashCommand::class);
        $this->slash_command = $var;

        return $this;
    }

    /**
     * User-uploaded attachment.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Attachment attachment = 18;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAttachment()
    {
        return $this->attachment;
    }

    /**
     * User-uploaded attachment.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Attachment attachment = 18;</code>
     * @param array<\Google\Apps\Chat\V1\Attachment>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAttachment($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Chat\V1\Attachment::class);
        $this->attachment = $arr;

        return $this;
    }

    /**
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     *
     * Generated from protobuf field <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\MatchedUrl|null
     */
    public function getMatchedUrl()
    {
        return $this->matched_url;
    }

    public function hasMatchedUrl()
    {
        return isset($this->matched_url);
    }

    public function clearMatchedUrl()
    {
        unset($this->matched_url);
    }

    /**
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     *
     * Generated from protobuf field <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\MatchedUrl $var
     * @return $this
     */
    public function setMatchedUrl($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\MatchedUrl::class);
        $this->matched_url = $var;

        return $this;
    }

    /**
     * Output only. When `true`, the message is a response in a reply thread. When
     * `false`, the message is visible in the space's top-level conversation as
     * either the first message of a thread or a message with no threaded replies.
     * If the space doesn't support reply in threads, this field is always
     * `false`.
     *
     * Generated from protobuf field <code>bool thread_reply = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getThreadReply()
    {
        return $this->thread_reply;
    }

    /**
     * Output only. When `true`, the message is a response in a reply thread. When
     * `false`, the message is visible in the space's top-level conversation as
     * either the first message of a thread or a message with no threaded replies.
     * If the space doesn't support reply in threads, this field is always
     * `false`.
     *
     * Generated from protobuf field <code>bool thread_reply = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setThreadReply($var)
    {
        GPBUtil::checkBool($var);
        $this->thread_reply = $var;

        return $this;
    }

    /**
     * Optional. A custom ID for the message. You can use field to identify a
     * message, or to get, delete, or update a message. To set a custom ID,
     * specify the
     * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     * field when you create the message. For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     *
     * Generated from protobuf field <code>string client_assigned_message_id = 32;</code>
     * @return string
     */
    public function getClientAssignedMessageId()
    {
        return $this->client_assigned_message_id;
    }

    /**
     * Optional. A custom ID for the message. You can use field to identify a
     * message, or to get, delete, or update a message. To set a custom ID,
     * specify the
     * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     * field when you create the message. For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     *
     * Generated from protobuf field <code>string client_assigned_message_id = 32;</code>
     * @param string $var
     * @return $this
     */
    public function setClientAssignedMessageId($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_assigned_message_id = $var;

        return $this;
    }

    /**
     * Output only. The list of emoji reaction summaries on the message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEmojiReactionSummaries()
    {
        return $this->emoji_reaction_summaries;
    }

    /**
     * Output only. The list of emoji reaction summaries on the message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Apps\Chat\V1\EmojiReactionSummary>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEmojiReactionSummaries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Chat\V1\EmojiReactionSummary::class);
        $this->emoji_reaction_summaries = $arr;

        return $this;
    }

    /**
     * Immutable. Input for creating a message, otherwise output only. The user
     * that can view the message. When set, the message is private and only
     * visible to the specified user and the Chat app. Link previews and
     * attachments aren't supported for private messages.
     * Only Chat apps can send private messages. If your Chat app [authenticates
     * as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * to send a message, the message can't be private and must omit this field.
     * For details, see [Send private messages to Google Chat
     * users](https://developers.google.com/workspace/chat/private-messages).
     *
     * Generated from protobuf field <code>.google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Apps\Chat\V1\User|null
     */
    public function getPrivateMessageViewer()
    {
        return $this->private_message_viewer;
    }

    public function hasPrivateMessageViewer()
    {
        return isset($this->private_message_viewer);
    }

    public function clearPrivateMessageViewer()
    {
        unset($this->private_message_viewer);
    }

    /**
     * Immutable. Input for creating a message, otherwise output only. The user
     * that can view the message. When set, the message is private and only
     * visible to the specified user and the Chat app. Link previews and
     * attachments aren't supported for private messages.
     * Only Chat apps can send private messages. If your Chat app [authenticates
     * as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * to send a message, the message can't be private and must omit this field.
     * For details, see [Send private messages to Google Chat
     * users](https://developers.google.com/workspace/chat/private-messages).
     *
     * Generated from protobuf field <code>.google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Apps\Chat\V1\User $var
     * @return $this
     */
    public function setPrivateMessageViewer($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\User::class);
        $this->private_message_viewer = $var;

        return $this;
    }

    /**
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     *
     * Generated from protobuf field <code>.google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\DeletionMetadata|null
     */
    public function getDeletionMetadata()
    {
        return $this->deletion_metadata;
    }

    public function hasDeletionMetadata()
    {
        return isset($this->deletion_metadata);
    }

    public function clearDeletionMetadata()
    {
        unset($this->deletion_metadata);
    }

    /**
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     *
     * Generated from protobuf field <code>.google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\DeletionMetadata $var
     * @return $this
     */
    public function setDeletionMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\DeletionMetadata::class);
        $this->deletion_metadata = $var;

        return $this;
    }

    /**
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\QuotedMessageMetadata|null
     */
    public function getQuotedMessageMetadata()
    {
        return $this->quoted_message_metadata;
    }

    public function hasQuotedMessageMetadata()
    {
        return isset($this->quoted_message_metadata);
    }

    public function clearQuotedMessageMetadata()
    {
        unset($this->quoted_message_metadata);
    }

    /**
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     *
     * Generated from protobuf field <code>.google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\QuotedMessageMetadata $var
     * @return $this
     */
    public function setQuotedMessageMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\QuotedMessageMetadata::class);
        $this->quoted_message_metadata = $var;

        return $this;
    }

    /**
     * Output only. GIF images that are attached to the message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAttachedGifs()
    {
        return $this->attached_gifs;
    }

    /**
     * Output only. GIF images that are attached to the message.
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Apps\Chat\V1\AttachedGif>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAttachedGifs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Chat\V1\AttachedGif::class);
        $this->attached_gifs = $arr;

        return $this;
    }

    /**
     * One or more interactive widgets that appear at the bottom of a message.
     * You can add accessory widgets to messages that contain text, cards, or both
     * text and cards. Not supported for messages that contain dialogs. For
     * details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAccessoryWidgets()
    {
        return $this->accessory_widgets;
    }

    /**
     * One or more interactive widgets that appear at the bottom of a message.
     * You can add accessory widgets to messages that contain text, cards, or both
     * text and cards. Not supported for messages that contain dialogs. For
     * details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44;</code>
     * @param array<\Google\Apps\Chat\V1\AccessoryWidget>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAccessoryWidgets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Chat\V1\AccessoryWidget::class);
        $this->accessory_widgets = $arr;

        return $this;
    }

}

