<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v2/cloud_speech.proto

namespace Google\Cloud\Speech\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for the
 * [CreateRecognizer][google.cloud.speech.v2.Speech.CreateRecognizer] method.
 *
 * Generated from protobuf message <code>google.cloud.speech.v2.CreateRecognizerRequest</code>
 */
class CreateRecognizerRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The Recognizer to create.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.Recognizer recognizer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $recognizer = null;
    /**
     * If set, validate the request and preview the Recognizer, but do not
     * actually create it.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     */
    private $validate_only = false;
    /**
     * The ID to use for the Recognizer, which will become the final component of
     * the Recognizer's resource name.
     * This value should be 4-63 characters, and valid characters
     * are /[a-z][0-9]-/.
     *
     * Generated from protobuf field <code>string recognizer_id = 3;</code>
     */
    private $recognizer_id = '';
    /**
     * Required. The project and location where this Recognizer will be created.
     * The expected format is `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';

    /**
     * @param string                             $parent       Required. The project and location where this Recognizer will be created.
     *                                                         The expected format is `projects/{project}/locations/{location}`. Please see
     *                                                         {@see SpeechClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\Speech\V2\Recognizer $recognizer   Required. The Recognizer to create.
     * @param string                             $recognizerId The ID to use for the Recognizer, which will become the final component of
     *                                                         the Recognizer's resource name.
     *
     *                                                         This value should be 4-63 characters, and valid characters
     *                                                         are /[a-z][0-9]-/.
     *
     * @return \Google\Cloud\Speech\V2\CreateRecognizerRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Speech\V2\Recognizer $recognizer, string $recognizerId): self
    {
        return (new self())
            ->setParent($parent)
            ->setRecognizer($recognizer)
            ->setRecognizerId($recognizerId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Speech\V2\Recognizer $recognizer
     *           Required. The Recognizer to create.
     *     @type bool $validate_only
     *           If set, validate the request and preview the Recognizer, but do not
     *           actually create it.
     *     @type string $recognizer_id
     *           The ID to use for the Recognizer, which will become the final component of
     *           the Recognizer's resource name.
     *           This value should be 4-63 characters, and valid characters
     *           are /[a-z][0-9]-/.
     *     @type string $parent
     *           Required. The project and location where this Recognizer will be created.
     *           The expected format is `projects/{project}/locations/{location}`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V2\CloudSpeech::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The Recognizer to create.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.Recognizer recognizer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Speech\V2\Recognizer|null
     */
    public function getRecognizer()
    {
        return $this->recognizer;
    }

    public function hasRecognizer()
    {
        return isset($this->recognizer);
    }

    public function clearRecognizer()
    {
        unset($this->recognizer);
    }

    /**
     * Required. The Recognizer to create.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.Recognizer recognizer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Speech\V2\Recognizer $var
     * @return $this
     */
    public function setRecognizer($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\Recognizer::class);
        $this->recognizer = $var;

        return $this;
    }

    /**
     * If set, validate the request and preview the Recognizer, but do not
     * actually create it.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * If set, validate the request and preview the Recognizer, but do not
     * actually create it.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

    /**
     * The ID to use for the Recognizer, which will become the final component of
     * the Recognizer's resource name.
     * This value should be 4-63 characters, and valid characters
     * are /[a-z][0-9]-/.
     *
     * Generated from protobuf field <code>string recognizer_id = 3;</code>
     * @return string
     */
    public function getRecognizerId()
    {
        return $this->recognizer_id;
    }

    /**
     * The ID to use for the Recognizer, which will become the final component of
     * the Recognizer's resource name.
     * This value should be 4-63 characters, and valid characters
     * are /[a-z][0-9]-/.
     *
     * Generated from protobuf field <code>string recognizer_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setRecognizerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->recognizer_id = $var;

        return $this;
    }

    /**
     * Required. The project and location where this Recognizer will be created.
     * The expected format is `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The project and location where this Recognizer will be created.
     * The expected format is `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

}

