<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/notebooks/v1/instance.proto

namespace Google\Cloud\Notebooks\V1\Instance;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An instance-attached disk resource.
 *
 * Generated from protobuf message <code>google.cloud.notebooks.v1.Instance.Disk</code>
 */
class Disk extends \Google\Protobuf\Internal\Message
{
    /**
     * Indicates whether the disk will be auto-deleted when the instance is
     * deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>bool auto_delete = 1;</code>
     */
    protected $auto_delete = false;
    /**
     * Indicates that this is a boot disk. The virtual machine will use the
     * first partition of the disk for its root filesystem.
     *
     * Generated from protobuf field <code>bool boot = 2;</code>
     */
    protected $boot = false;
    /**
     * Indicates a unique device name of your choice that is reflected into the
     * `/dev/disk/by-id/google-*` tree of a Linux operating system running
     * within the instance. This name can be used to reference the device for
     * mounting, resizing, and so on, from within the instance.
     * If not specified, the server chooses a default device name to apply to
     * this disk, in the form persistent-disk-x, where x is a number assigned by
     * Google Compute Engine.This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>string device_name = 3;</code>
     */
    protected $device_name = '';
    /**
     * Indicates the size of the disk in base-2 GB.
     *
     * Generated from protobuf field <code>int64 disk_size_gb = 4;</code>
     */
    protected $disk_size_gb = 0;
    /**
     * Indicates a list of features to enable on the guest operating system.
     * Applicable only for bootable images. Read  Enabling guest operating
     * system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.notebooks.v1.Instance.Disk.GuestOsFeature guest_os_features = 5;</code>
     */
    private $guest_os_features;
    /**
     * A zero-based index to this disk, where 0 is reserved for the
     * boot disk. If you have many disks attached to an instance, each disk
     * would have a unique index number.
     *
     * Generated from protobuf field <code>int64 index = 6;</code>
     */
    protected $index = 0;
    /**
     * Indicates the disk interface to use for attaching this disk, which is
     * either SCSI or NVME. The default is SCSI. Persistent disks must always
     * use SCSI and the request will fail if you attempt to attach a persistent
     * disk in any other format than SCSI. Local SSDs can use either NVME or
     * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD
     * performance.
     * Valid values:
     * * `NVME`
     * * `SCSI`
     *
     * Generated from protobuf field <code>string interface = 7;</code>
     */
    protected $interface = '';
    /**
     * Type of the resource. Always compute#attachedDisk for attached
     * disks.
     *
     * Generated from protobuf field <code>string kind = 8;</code>
     */
    protected $kind = '';
    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     * A License represents billing and aggregate usage data for public
     * and marketplace images.
     *
     * Generated from protobuf field <code>repeated string licenses = 9;</code>
     */
    private $licenses;
    /**
     * The mode in which to attach this disk, either `READ_WRITE` or
     * `READ_ONLY`. If not specified, the default is to attach the disk in
     * `READ_WRITE` mode. Valid values:
     * * `READ_ONLY`
     * * `READ_WRITE`
     *
     * Generated from protobuf field <code>string mode = 10;</code>
     */
    protected $mode = '';
    /**
     * Indicates a valid partial or full URL to an existing Persistent Disk
     * resource.
     *
     * Generated from protobuf field <code>string source = 11;</code>
     */
    protected $source = '';
    /**
     * Indicates the type of the disk, either `SCRATCH` or `PERSISTENT`.
     * Valid values:
     * * `PERSISTENT`
     * * `SCRATCH`
     *
     * Generated from protobuf field <code>string type = 12;</code>
     */
    protected $type = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $auto_delete
     *           Indicates whether the disk will be auto-deleted when the instance is
     *           deleted (but not when the disk is detached from the instance).
     *     @type bool $boot
     *           Indicates that this is a boot disk. The virtual machine will use the
     *           first partition of the disk for its root filesystem.
     *     @type string $device_name
     *           Indicates a unique device name of your choice that is reflected into the
     *           `/dev/disk/by-id/google-*` tree of a Linux operating system running
     *           within the instance. This name can be used to reference the device for
     *           mounting, resizing, and so on, from within the instance.
     *           If not specified, the server chooses a default device name to apply to
     *           this disk, in the form persistent-disk-x, where x is a number assigned by
     *           Google Compute Engine.This field is only applicable for persistent disks.
     *     @type int|string $disk_size_gb
     *           Indicates the size of the disk in base-2 GB.
     *     @type array<\Google\Cloud\Notebooks\V1\Instance\Disk\GuestOsFeature>|\Google\Protobuf\Internal\RepeatedField $guest_os_features
     *           Indicates a list of features to enable on the guest operating system.
     *           Applicable only for bootable images. Read  Enabling guest operating
     *           system features to see a list of available options.
     *     @type int|string $index
     *           A zero-based index to this disk, where 0 is reserved for the
     *           boot disk. If you have many disks attached to an instance, each disk
     *           would have a unique index number.
     *     @type string $interface
     *           Indicates the disk interface to use for attaching this disk, which is
     *           either SCSI or NVME. The default is SCSI. Persistent disks must always
     *           use SCSI and the request will fail if you attempt to attach a persistent
     *           disk in any other format than SCSI. Local SSDs can use either NVME or
     *           SCSI. For performance characteristics of SCSI over NVMe, see Local SSD
     *           performance.
     *           Valid values:
     *           * `NVME`
     *           * `SCSI`
     *     @type string $kind
     *           Type of the resource. Always compute#attachedDisk for attached
     *           disks.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $licenses
     *           A list of publicly visible licenses. Reserved for Google's use.
     *           A License represents billing and aggregate usage data for public
     *           and marketplace images.
     *     @type string $mode
     *           The mode in which to attach this disk, either `READ_WRITE` or
     *           `READ_ONLY`. If not specified, the default is to attach the disk in
     *           `READ_WRITE` mode. Valid values:
     *           * `READ_ONLY`
     *           * `READ_WRITE`
     *     @type string $source
     *           Indicates a valid partial or full URL to an existing Persistent Disk
     *           resource.
     *     @type string $type
     *           Indicates the type of the disk, either `SCRATCH` or `PERSISTENT`.
     *           Valid values:
     *           * `PERSISTENT`
     *           * `SCRATCH`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Notebooks\V1\Instance::initOnce();
        parent::__construct($data);
    }

    /**
     * Indicates whether the disk will be auto-deleted when the instance is
     * deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>bool auto_delete = 1;</code>
     * @return bool
     */
    public function getAutoDelete()
    {
        return $this->auto_delete;
    }

    /**
     * Indicates whether the disk will be auto-deleted when the instance is
     * deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>bool auto_delete = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoDelete($var)
    {
        GPBUtil::checkBool($var);
        $this->auto_delete = $var;

        return $this;
    }

    /**
     * Indicates that this is a boot disk. The virtual machine will use the
     * first partition of the disk for its root filesystem.
     *
     * Generated from protobuf field <code>bool boot = 2;</code>
     * @return bool
     */
    public function getBoot()
    {
        return $this->boot;
    }

    /**
     * Indicates that this is a boot disk. The virtual machine will use the
     * first partition of the disk for its root filesystem.
     *
     * Generated from protobuf field <code>bool boot = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setBoot($var)
    {
        GPBUtil::checkBool($var);
        $this->boot = $var;

        return $this;
    }

    /**
     * Indicates a unique device name of your choice that is reflected into the
     * `/dev/disk/by-id/google-*` tree of a Linux operating system running
     * within the instance. This name can be used to reference the device for
     * mounting, resizing, and so on, from within the instance.
     * If not specified, the server chooses a default device name to apply to
     * this disk, in the form persistent-disk-x, where x is a number assigned by
     * Google Compute Engine.This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>string device_name = 3;</code>
     * @return string
     */
    public function getDeviceName()
    {
        return $this->device_name;
    }

    /**
     * Indicates a unique device name of your choice that is reflected into the
     * `/dev/disk/by-id/google-*` tree of a Linux operating system running
     * within the instance. This name can be used to reference the device for
     * mounting, resizing, and so on, from within the instance.
     * If not specified, the server chooses a default device name to apply to
     * this disk, in the form persistent-disk-x, where x is a number assigned by
     * Google Compute Engine.This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>string device_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDeviceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->device_name = $var;

        return $this;
    }

    /**
     * Indicates the size of the disk in base-2 GB.
     *
     * Generated from protobuf field <code>int64 disk_size_gb = 4;</code>
     * @return int|string
     */
    public function getDiskSizeGb()
    {
        return $this->disk_size_gb;
    }

    /**
     * Indicates the size of the disk in base-2 GB.
     *
     * Generated from protobuf field <code>int64 disk_size_gb = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkInt64($var);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * Indicates a list of features to enable on the guest operating system.
     * Applicable only for bootable images. Read  Enabling guest operating
     * system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.notebooks.v1.Instance.Disk.GuestOsFeature guest_os_features = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestOsFeatures()
    {
        return $this->guest_os_features;
    }

    /**
     * Indicates a list of features to enable on the guest operating system.
     * Applicable only for bootable images. Read  Enabling guest operating
     * system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.notebooks.v1.Instance.Disk.GuestOsFeature guest_os_features = 5;</code>
     * @param array<\Google\Cloud\Notebooks\V1\Instance\Disk\GuestOsFeature>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestOsFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Notebooks\V1\Instance\Disk\GuestOsFeature::class);
        $this->guest_os_features = $arr;

        return $this;
    }

    /**
     * A zero-based index to this disk, where 0 is reserved for the
     * boot disk. If you have many disks attached to an instance, each disk
     * would have a unique index number.
     *
     * Generated from protobuf field <code>int64 index = 6;</code>
     * @return int|string
     */
    public function getIndex()
    {
        return $this->index;
    }

    /**
     * A zero-based index to this disk, where 0 is reserved for the
     * boot disk. If you have many disks attached to an instance, each disk
     * would have a unique index number.
     *
     * Generated from protobuf field <code>int64 index = 6;</code>
     * @param int|string $var
     * @return $this
     */
    public function setIndex($var)
    {
        GPBUtil::checkInt64($var);
        $this->index = $var;

        return $this;
    }

    /**
     * Indicates the disk interface to use for attaching this disk, which is
     * either SCSI or NVME. The default is SCSI. Persistent disks must always
     * use SCSI and the request will fail if you attempt to attach a persistent
     * disk in any other format than SCSI. Local SSDs can use either NVME or
     * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD
     * performance.
     * Valid values:
     * * `NVME`
     * * `SCSI`
     *
     * Generated from protobuf field <code>string interface = 7;</code>
     * @return string
     */
    public function getInterface()
    {
        return $this->interface;
    }

    /**
     * Indicates the disk interface to use for attaching this disk, which is
     * either SCSI or NVME. The default is SCSI. Persistent disks must always
     * use SCSI and the request will fail if you attempt to attach a persistent
     * disk in any other format than SCSI. Local SSDs can use either NVME or
     * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD
     * performance.
     * Valid values:
     * * `NVME`
     * * `SCSI`
     *
     * Generated from protobuf field <code>string interface = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setInterface($var)
    {
        GPBUtil::checkString($var, True);
        $this->interface = $var;

        return $this;
    }

    /**
     * Type of the resource. Always compute#attachedDisk for attached
     * disks.
     *
     * Generated from protobuf field <code>string kind = 8;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * Type of the resource. Always compute#attachedDisk for attached
     * disks.
     *
     * Generated from protobuf field <code>string kind = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     * A License represents billing and aggregate usage data for public
     * and marketplace images.
     *
     * Generated from protobuf field <code>repeated string licenses = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenses()
    {
        return $this->licenses;
    }

    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     * A License represents billing and aggregate usage data for public
     * and marketplace images.
     *
     * Generated from protobuf field <code>repeated string licenses = 9;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->licenses = $arr;

        return $this;
    }

    /**
     * The mode in which to attach this disk, either `READ_WRITE` or
     * `READ_ONLY`. If not specified, the default is to attach the disk in
     * `READ_WRITE` mode. Valid values:
     * * `READ_ONLY`
     * * `READ_WRITE`
     *
     * Generated from protobuf field <code>string mode = 10;</code>
     * @return string
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * The mode in which to attach this disk, either `READ_WRITE` or
     * `READ_ONLY`. If not specified, the default is to attach the disk in
     * `READ_WRITE` mode. Valid values:
     * * `READ_ONLY`
     * * `READ_WRITE`
     *
     * Generated from protobuf field <code>string mode = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setMode($var)
    {
        GPBUtil::checkString($var, True);
        $this->mode = $var;

        return $this;
    }

    /**
     * Indicates a valid partial or full URL to an existing Persistent Disk
     * resource.
     *
     * Generated from protobuf field <code>string source = 11;</code>
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * Indicates a valid partial or full URL to an existing Persistent Disk
     * resource.
     *
     * Generated from protobuf field <code>string source = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setSource($var)
    {
        GPBUtil::checkString($var, True);
        $this->source = $var;

        return $this;
    }

    /**
     * Indicates the type of the disk, either `SCRATCH` or `PERSISTENT`.
     * Valid values:
     * * `PERSISTENT`
     * * `SCRATCH`
     *
     * Generated from protobuf field <code>string type = 12;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Indicates the type of the disk, either `SCRATCH` or `PERSISTENT`.
     * Valid values:
     * * `PERSISTENT`
     * * `SCRATCH`
     *
     * Generated from protobuf field <code>string type = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

}


