<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/connection/v1/connection.proto

namespace Google\Cloud\BigQuery\Connection\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration parameters to establish connection with an external data
 * source, except the credential attributes.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.connection.v1.Connection</code>
 */
class Connection extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the connection in the form of:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * User provided display name for the connection.
     *
     * Generated from protobuf field <code>string friendly_name = 2;</code>
     */
    protected $friendly_name = '';
    /**
     * User provided description.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    protected $description = '';
    /**
     * Output only. The creation timestamp of the connection.
     *
     * Generated from protobuf field <code>int64 creation_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $creation_time = 0;
    /**
     * Output only. The last update timestamp of the connection.
     *
     * Generated from protobuf field <code>int64 last_modified_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_modified_time = 0;
    /**
     * Output only. True, if credential is configured for this connection.
     *
     * Generated from protobuf field <code>bool has_credential = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $has_credential = false;
    protected $properties;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the connection in the form of:
     *           `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     *     @type string $friendly_name
     *           User provided display name for the connection.
     *     @type string $description
     *           User provided description.
     *     @type \Google\Cloud\BigQuery\Connection\V1\CloudSqlProperties $cloud_sql
     *           Cloud SQL properties.
     *     @type \Google\Cloud\BigQuery\Connection\V1\AwsProperties $aws
     *           Amazon Web Services (AWS) properties.
     *     @type \Google\Cloud\BigQuery\Connection\V1\AzureProperties $azure
     *           Azure properties.
     *     @type \Google\Cloud\BigQuery\Connection\V1\CloudSpannerProperties $cloud_spanner
     *           Cloud Spanner properties.
     *     @type \Google\Cloud\BigQuery\Connection\V1\CloudResourceProperties $cloud_resource
     *           Cloud Resource properties.
     *     @type \Google\Cloud\BigQuery\Connection\V1\SparkProperties $spark
     *           Spark properties.
     *     @type \Google\Cloud\BigQuery\Connection\V1\SalesforceDataCloudProperties $salesforce_data_cloud
     *           Optional. Salesforce DataCloud properties. This field is intended for
     *           use only by Salesforce partner projects. This field contains properties
     *           for your Salesforce DataCloud connection.
     *     @type int|string $creation_time
     *           Output only. The creation timestamp of the connection.
     *     @type int|string $last_modified_time
     *           Output only. The last update timestamp of the connection.
     *     @type bool $has_credential
     *           Output only. True, if credential is configured for this connection.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Connection\V1\Connection::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the connection in the form of:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the connection in the form of:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * User provided display name for the connection.
     *
     * Generated from protobuf field <code>string friendly_name = 2;</code>
     * @return string
     */
    public function getFriendlyName()
    {
        return $this->friendly_name;
    }

    /**
     * User provided display name for the connection.
     *
     * Generated from protobuf field <code>string friendly_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setFriendlyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->friendly_name = $var;

        return $this;
    }

    /**
     * User provided description.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User provided description.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Cloud SQL properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.CloudSqlProperties cloud_sql = 4;</code>
     * @return \Google\Cloud\BigQuery\Connection\V1\CloudSqlProperties|null
     */
    public function getCloudSql()
    {
        return $this->readOneof(4);
    }

    public function hasCloudSql()
    {
        return $this->hasOneof(4);
    }

    /**
     * Cloud SQL properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.CloudSqlProperties cloud_sql = 4;</code>
     * @param \Google\Cloud\BigQuery\Connection\V1\CloudSqlProperties $var
     * @return $this
     */
    public function setCloudSql($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Connection\V1\CloudSqlProperties::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Amazon Web Services (AWS) properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.AwsProperties aws = 8;</code>
     * @return \Google\Cloud\BigQuery\Connection\V1\AwsProperties|null
     */
    public function getAws()
    {
        return $this->readOneof(8);
    }

    public function hasAws()
    {
        return $this->hasOneof(8);
    }

    /**
     * Amazon Web Services (AWS) properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.AwsProperties aws = 8;</code>
     * @param \Google\Cloud\BigQuery\Connection\V1\AwsProperties $var
     * @return $this
     */
    public function setAws($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Connection\V1\AwsProperties::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Azure properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.AzureProperties azure = 11;</code>
     * @return \Google\Cloud\BigQuery\Connection\V1\AzureProperties|null
     */
    public function getAzure()
    {
        return $this->readOneof(11);
    }

    public function hasAzure()
    {
        return $this->hasOneof(11);
    }

    /**
     * Azure properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.AzureProperties azure = 11;</code>
     * @param \Google\Cloud\BigQuery\Connection\V1\AzureProperties $var
     * @return $this
     */
    public function setAzure($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Connection\V1\AzureProperties::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Cloud Spanner properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.CloudSpannerProperties cloud_spanner = 21;</code>
     * @return \Google\Cloud\BigQuery\Connection\V1\CloudSpannerProperties|null
     */
    public function getCloudSpanner()
    {
        return $this->readOneof(21);
    }

    public function hasCloudSpanner()
    {
        return $this->hasOneof(21);
    }

    /**
     * Cloud Spanner properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.CloudSpannerProperties cloud_spanner = 21;</code>
     * @param \Google\Cloud\BigQuery\Connection\V1\CloudSpannerProperties $var
     * @return $this
     */
    public function setCloudSpanner($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Connection\V1\CloudSpannerProperties::class);
        $this->writeOneof(21, $var);

        return $this;
    }

    /**
     * Cloud Resource properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.CloudResourceProperties cloud_resource = 22;</code>
     * @return \Google\Cloud\BigQuery\Connection\V1\CloudResourceProperties|null
     */
    public function getCloudResource()
    {
        return $this->readOneof(22);
    }

    public function hasCloudResource()
    {
        return $this->hasOneof(22);
    }

    /**
     * Cloud Resource properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.CloudResourceProperties cloud_resource = 22;</code>
     * @param \Google\Cloud\BigQuery\Connection\V1\CloudResourceProperties $var
     * @return $this
     */
    public function setCloudResource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Connection\V1\CloudResourceProperties::class);
        $this->writeOneof(22, $var);

        return $this;
    }

    /**
     * Spark properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.SparkProperties spark = 23;</code>
     * @return \Google\Cloud\BigQuery\Connection\V1\SparkProperties|null
     */
    public function getSpark()
    {
        return $this->readOneof(23);
    }

    public function hasSpark()
    {
        return $this->hasOneof(23);
    }

    /**
     * Spark properties.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.SparkProperties spark = 23;</code>
     * @param \Google\Cloud\BigQuery\Connection\V1\SparkProperties $var
     * @return $this
     */
    public function setSpark($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Connection\V1\SparkProperties::class);
        $this->writeOneof(23, $var);

        return $this;
    }

    /**
     * Optional. Salesforce DataCloud properties. This field is intended for
     * use only by Salesforce partner projects. This field contains properties
     * for your Salesforce DataCloud connection.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.SalesforceDataCloudProperties salesforce_data_cloud = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\BigQuery\Connection\V1\SalesforceDataCloudProperties|null
     */
    public function getSalesforceDataCloud()
    {
        return $this->readOneof(24);
    }

    public function hasSalesforceDataCloud()
    {
        return $this->hasOneof(24);
    }

    /**
     * Optional. Salesforce DataCloud properties. This field is intended for
     * use only by Salesforce partner projects. This field contains properties
     * for your Salesforce DataCloud connection.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.connection.v1.SalesforceDataCloudProperties salesforce_data_cloud = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\BigQuery\Connection\V1\SalesforceDataCloudProperties $var
     * @return $this
     */
    public function setSalesforceDataCloud($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Connection\V1\SalesforceDataCloudProperties::class);
        $this->writeOneof(24, $var);

        return $this;
    }

    /**
     * Output only. The creation timestamp of the connection.
     *
     * Generated from protobuf field <code>int64 creation_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getCreationTime()
    {
        return $this->creation_time;
    }

    /**
     * Output only. The creation timestamp of the connection.
     *
     * Generated from protobuf field <code>int64 creation_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setCreationTime($var)
    {
        GPBUtil::checkInt64($var);
        $this->creation_time = $var;

        return $this;
    }

    /**
     * Output only. The last update timestamp of the connection.
     *
     * Generated from protobuf field <code>int64 last_modified_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getLastModifiedTime()
    {
        return $this->last_modified_time;
    }

    /**
     * Output only. The last update timestamp of the connection.
     *
     * Generated from protobuf field <code>int64 last_modified_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setLastModifiedTime($var)
    {
        GPBUtil::checkInt64($var);
        $this->last_modified_time = $var;

        return $this;
    }

    /**
     * Output only. True, if credential is configured for this connection.
     *
     * Generated from protobuf field <code>bool has_credential = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getHasCredential()
    {
        return $this->has_credential;
    }

    /**
     * Output only. True, if credential is configured for this connection.
     *
     * Generated from protobuf field <code>bool has_credential = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setHasCredential($var)
    {
        GPBUtil::checkBool($var);
        $this->has_credential = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getProperties()
    {
        return $this->whichOneof("properties");
    }

}

