<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/card/v1/card.proto

namespace Google\Apps\Card\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A text, icon, or text and icon button that users can click. For an example in
 * Google Chat apps, see
 * [Add a
 * button](https://developers.google.com/workspace/chat/design-interactive-card-dialog#add_a_button).
 * To make an image a clickable button, specify an
 * [`Image`][google.apps.card.v1.Image] (not an
 * [`ImageComponent`][google.apps.card.v1.ImageComponent]) and set an
 * `onClick` action.
 * [Google Workspace
 * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
 *
 * Generated from protobuf message <code>google.apps.card.v1.Button</code>
 */
class Button extends \Google\Protobuf\Internal\Message
{
    /**
     * The text displayed inside the button.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     */
    protected $text = '';
    /**
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    protected $icon = null;
    /**
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     * If unset, the image background is white and the font color is blue.
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     * For example, the following color represents a half transparent red:
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.type.Color color = 3;</code>
     */
    protected $color = null;
    /**
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    protected $on_click = null;
    /**
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     */
    protected $disabled = false;
    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 6;</code>
     */
    protected $alt_text = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $text
     *           The text displayed inside the button.
     *     @type \Google\Apps\Card\V1\Icon $icon
     *           The icon image. If both `icon` and `text` are set, then the icon appears
     *           before the text.
     *     @type \Google\Type\Color $color
     *           If set, the button is filled with a solid background color and the font
     *           color changes to maintain contrast with the background color. For example,
     *           setting a blue background likely results in white text.
     *           If unset, the image background is white and the font color is blue.
     *           For red, green, and blue, the value of each field is a `float` number that
     *           you can express in either of two ways: as a number between 0 and 255
     *           divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     *           the absence of a color and 1 or 255/255 represent the full presence of that
     *           color on the RGB scale.
     *           Optionally set `alpha`, which sets a level of transparency using this
     *           equation:
     *           ```
     *           pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     *           ```
     *           For `alpha`, a value of `1` corresponds with a solid color, and a value of
     *           `0` corresponds with a completely transparent color.
     *           For example, the following color represents a half transparent red:
     *           ```
     *           "color": {
     *              "red": 1,
     *              "green": 0,
     *              "blue": 0,
     *              "alpha": 0.5
     *           }
     *           ```
     *     @type \Google\Apps\Card\V1\OnClick $on_click
     *           Required. The action to perform when a user clicks the button, such as
     *           opening a hyperlink or running a custom function.
     *     @type bool $disabled
     *           If `true`, the button is displayed in an inactive state and doesn't respond
     *           to user actions.
     *     @type string $alt_text
     *           The alternative text that's used for accessibility.
     *           Set descriptive text that lets users know what the button does. For
     *           example, if a button opens a hyperlink, you might write: "Opens a new
     *           browser tab and navigates to the Google Chat developer documentation at
     *           https://developers.google.com/workspace/chat".
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Card\V1\Card::initOnce();
        parent::__construct($data);
    }

    /**
     * The text displayed inside the button.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * The text displayed inside the button.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkString($var, True);
        $this->text = $var;

        return $this;
    }

    /**
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 2;</code>
     * @return \Google\Apps\Card\V1\Icon|null
     */
    public function getIcon()
    {
        return $this->icon;
    }

    public function hasIcon()
    {
        return isset($this->icon);
    }

    public function clearIcon()
    {
        unset($this->icon);
    }

    /**
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 2;</code>
     * @param \Google\Apps\Card\V1\Icon $var
     * @return $this
     */
    public function setIcon($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Icon::class);
        $this->icon = $var;

        return $this;
    }

    /**
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     * If unset, the image background is white and the font color is blue.
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     * For example, the following color represents a half transparent red:
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.type.Color color = 3;</code>
     * @return \Google\Type\Color|null
     */
    public function getColor()
    {
        return $this->color;
    }

    public function hasColor()
    {
        return isset($this->color);
    }

    public function clearColor()
    {
        unset($this->color);
    }

    /**
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     * If unset, the image background is white and the font color is blue.
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     * For example, the following color represents a half transparent red:
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.type.Color color = 3;</code>
     * @param \Google\Type\Color $var
     * @return $this
     */
    public function setColor($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Color::class);
        $this->color = $var;

        return $this;
    }

    /**
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     * @return \Google\Apps\Card\V1\OnClick|null
     */
    public function getOnClick()
    {
        return $this->on_click;
    }

    public function hasOnClick()
    {
        return isset($this->on_click);
    }

    public function clearOnClick()
    {
        unset($this->on_click);
    }

    /**
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     * @param \Google\Apps\Card\V1\OnClick $var
     * @return $this
     */
    public function setOnClick($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\OnClick::class);
        $this->on_click = $var;

        return $this;
    }

    /**
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     * @return bool
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->disabled = $var;

        return $this;
    }

    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 6;</code>
     * @return string
     */
    public function getAltText()
    {
        return $this->alt_text;
    }

    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setAltText($var)
    {
        GPBUtil::checkString($var, True);
        $this->alt_text = $var;

        return $this;
    }

}

