<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/common.proto

namespace Google\Cloud\Retail\V2\Rule;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Pins one or more specified products to a specific position in the
 * results.
 * * Rule Condition:
 *   Must specify non-empty
 *   [Condition.query_terms][google.cloud.retail.v2.Condition.query_terms]
 *   (for search only) or
 *   [Condition.page_categories][google.cloud.retail.v2.Condition.page_categories]
 *   (for browse only), but can't specify both.
 * * Action Input: mapping of `[pin_position, product_id]` pairs (pin position
 * uses 1-based indexing).
 * * Action Result: Will pin products with matching ids to the position
 * specified in the final result order.
 * Example: Suppose the query is `shoes`, the
 * [Condition.query_terms][google.cloud.retail.v2.Condition.query_terms] is
 * `shoes` and the pin_map has `{1, "pid1"}`, then product with `pid1` will be
 * pinned to the top position in the final results.
 * If multiple PinActions are matched to a single request the actions will
 * be processed from most to least recently updated.
 * Pins to positions larger than the max allowed page size of 120 are not
 * allowed.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.Rule.PinAction</code>
 */
class PinAction extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. A map of positions to product_ids.
     * Partial matches per action are allowed, if a certain position in the map
     * is already filled that `[position, product_id]` pair will be ignored
     * but the rest may still be applied. This case will only occur if multiple
     * pin actions are matched to a single request, as the map guarantees that
     * pin positions are unique within the same action.
     * Duplicate product_ids are not permitted within a single pin map.
     * The max size of this map is 120, equivalent to the max [request page
     * size](https://cloud.google.com/retail/docs/reference/rest/v2/projects.locations.catalogs.placements/search#request-body).
     *
     * Generated from protobuf field <code>map<int64, string> pin_map = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $pin_map;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array|\Google\Protobuf\Internal\MapField $pin_map
     *           Required. A map of positions to product_ids.
     *           Partial matches per action are allowed, if a certain position in the map
     *           is already filled that `[position, product_id]` pair will be ignored
     *           but the rest may still be applied. This case will only occur if multiple
     *           pin actions are matched to a single request, as the map guarantees that
     *           pin positions are unique within the same action.
     *           Duplicate product_ids are not permitted within a single pin map.
     *           The max size of this map is 120, equivalent to the max [request page
     *           size](https://cloud.google.com/retail/docs/reference/rest/v2/projects.locations.catalogs.placements/search#request-body).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\Common::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. A map of positions to product_ids.
     * Partial matches per action are allowed, if a certain position in the map
     * is already filled that `[position, product_id]` pair will be ignored
     * but the rest may still be applied. This case will only occur if multiple
     * pin actions are matched to a single request, as the map guarantees that
     * pin positions are unique within the same action.
     * Duplicate product_ids are not permitted within a single pin map.
     * The max size of this map is 120, equivalent to the max [request page
     * size](https://cloud.google.com/retail/docs/reference/rest/v2/projects.locations.catalogs.placements/search#request-body).
     *
     * Generated from protobuf field <code>map<int64, string> pin_map = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getPinMap()
    {
        return $this->pin_map;
    }

    /**
     * Required. A map of positions to product_ids.
     * Partial matches per action are allowed, if a certain position in the map
     * is already filled that `[position, product_id]` pair will be ignored
     * but the rest may still be applied. This case will only occur if multiple
     * pin actions are matched to a single request, as the map guarantees that
     * pin positions are unique within the same action.
     * Duplicate product_ids are not permitted within a single pin map.
     * The max size of this map is 120, equivalent to the max [request page
     * size](https://cloud.google.com/retail/docs/reference/rest/v2/projects.locations.catalogs.placements/search#request-body).
     *
     * Generated from protobuf field <code>map<int64, string> pin_map = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setPinMap($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::INT64, \Google\Protobuf\Internal\GPBType::STRING);
        $this->pin_map = $arr;

        return $this;
    }

}


