<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/iam/v3/policy_binding_resources.proto

namespace Google\Cloud\Iam\V3\PolicyBinding;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Target is the full resource name of the resource to which the policy will
 * be bound. Immutable once set.
 *
 * Generated from protobuf message <code>google.iam.v3.PolicyBinding.Target</code>
 */
class Target extends \Google\Protobuf\Internal\Message
{
    protected $target;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $principal_set
     *           Immutable. Full Resource Name used for principal access boundary policy
     *           bindings. The principal set must be directly parented by the policy
     *           binding's parent or same as the parent if the target is a
     *           project/folder/organization.
     *           Examples:
     *           * For binding's parented by an organization:
     *             * Organization:
     *             `//cloudresourcemanager.googleapis.com/organizations/ORGANIZATION_ID`
     *             * Workforce Identity:
     *             `//iam.googleapis.com/locations/global/workforcePools/WORKFORCE_POOL_ID`
     *             * Workspace Identity:
     *             `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
     *           * For binding's parented by a folder:
     *             * Folder:
     *             `//cloudresourcemanager.googleapis.com/folders/FOLDER_ID`
     *           * For binding's parented by a project:
     *             * Project:
     *               * `//cloudresourcemanager.googleapis.com/projects/PROJECT_NUMBER`
     *               * `//cloudresourcemanager.googleapis.com/projects/PROJECT_ID`
     *             * Workload Identity Pool:
     *             `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/LOCATION/workloadIdentityPools/WORKLOAD_POOL_ID`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Iam\V3\PolicyBindingResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. Full Resource Name used for principal access boundary policy
     * bindings. The principal set must be directly parented by the policy
     * binding's parent or same as the parent if the target is a
     * project/folder/organization.
     * Examples:
     * * For binding's parented by an organization:
     *   * Organization:
     *   `//cloudresourcemanager.googleapis.com/organizations/ORGANIZATION_ID`
     *   * Workforce Identity:
     *   `//iam.googleapis.com/locations/global/workforcePools/WORKFORCE_POOL_ID`
     *   * Workspace Identity:
     *   `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
     * * For binding's parented by a folder:
     *   * Folder:
     *   `//cloudresourcemanager.googleapis.com/folders/FOLDER_ID`
     * * For binding's parented by a project:
     *   * Project:
     *     * `//cloudresourcemanager.googleapis.com/projects/PROJECT_NUMBER`
     *     * `//cloudresourcemanager.googleapis.com/projects/PROJECT_ID`
     *   * Workload Identity Pool:
     *   `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/LOCATION/workloadIdentityPools/WORKLOAD_POOL_ID`
     *
     * Generated from protobuf field <code>string principal_set = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getPrincipalSet()
    {
        return $this->readOneof(1);
    }

    public function hasPrincipalSet()
    {
        return $this->hasOneof(1);
    }

    /**
     * Immutable. Full Resource Name used for principal access boundary policy
     * bindings. The principal set must be directly parented by the policy
     * binding's parent or same as the parent if the target is a
     * project/folder/organization.
     * Examples:
     * * For binding's parented by an organization:
     *   * Organization:
     *   `//cloudresourcemanager.googleapis.com/organizations/ORGANIZATION_ID`
     *   * Workforce Identity:
     *   `//iam.googleapis.com/locations/global/workforcePools/WORKFORCE_POOL_ID`
     *   * Workspace Identity:
     *   `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
     * * For binding's parented by a folder:
     *   * Folder:
     *   `//cloudresourcemanager.googleapis.com/folders/FOLDER_ID`
     * * For binding's parented by a project:
     *   * Project:
     *     * `//cloudresourcemanager.googleapis.com/projects/PROJECT_NUMBER`
     *     * `//cloudresourcemanager.googleapis.com/projects/PROJECT_ID`
     *   * Workload Identity Pool:
     *   `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/LOCATION/workloadIdentityPools/WORKLOAD_POOL_ID`
     *
     * Generated from protobuf field <code>string principal_set = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setPrincipalSet($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->whichOneof("target");
    }

}


