<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/conversation.proto

namespace Google\Cloud\Dialogflow\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request message for
 * [Conversations.SearchKnowledge][google.cloud.dialogflow.v2.Conversations.SearchKnowledge].
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.v2.SearchKnowledgeRequest</code>
 */
class SearchKnowledgeRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource contains the conversation profile
     * Format: 'projects/<Project ID>' or `projects/<Project
     * ID>/locations/<Location ID>`.
     *
     * Generated from protobuf field <code>string parent = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $parent = '';
    /**
     * Required. The natural language text query for knowledge search.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.TextInput query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $query = null;
    /**
     * Required. The conversation profile used to configure the search.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/conversationProfiles/<Conversation Profile ID>`.
     *
     * Generated from protobuf field <code>string conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $conversation_profile = '';
    /**
     * Required. The ID of the search session.
     * The session_id can be combined with Dialogflow V3 Agent ID retrieved from
     * conversation profile or on its own to identify a search session. The search
     * history of the same session will impact the search result. It's up to the
     * API caller to choose an appropriate `Session ID`. It can be a random number
     * or some type of session identifiers (preferably hashed). The length must
     * not exceed 36 characters.
     *
     * Generated from protobuf field <code>string session_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $session_id = '';
    /**
     * Optional. The conversation (between human agent and end user) where the
     * search request is triggered. Format: `projects/<Project
     * ID>/locations/<Location ID>/conversations/<Conversation ID>`.
     *
     * Generated from protobuf field <code>string conversation = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $conversation = '';
    /**
     * Optional. The name of the latest conversation message when the request is
     * triggered.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/conversations/<Conversation ID>/messages/<Message ID>`.
     *
     * Generated from protobuf field <code>string latest_message = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $latest_message = '';
    /**
     * Optional. The source of the query in the request.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SearchKnowledgeRequest.QuerySource query_source = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $query_source = 0;
    /**
     * Optional. Information about the end-user to improve the relevance and
     * accuracy of generative answers.
     * This will be interpreted and used by a language model, so, for good
     * results, the data should be self-descriptive, and in a simple structure.
     * Example:
     * ```json
     * {
     *   "subscription plan": "Business Premium Plus",
     *   "devices owned": [
     *     {"model": "Google Pixel 7"},
     *     {"model": "Google Pixel Tablet"}
     *   ]
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct end_user_metadata = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $end_user_metadata = null;
    /**
     * Optional. Configuration specific to search queries with data stores.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig search_config = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $search_config = null;
    /**
     * Optional. Whether to search the query exactly without query rewrite.
     *
     * Generated from protobuf field <code>bool exact_search = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $exact_search = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource contains the conversation profile
     *           Format: 'projects/<Project ID>' or `projects/<Project
     *           ID>/locations/<Location ID>`.
     *     @type \Google\Cloud\Dialogflow\V2\TextInput $query
     *           Required. The natural language text query for knowledge search.
     *     @type string $conversation_profile
     *           Required. The conversation profile used to configure the search.
     *           Format: `projects/<Project ID>/locations/<Location
     *           ID>/conversationProfiles/<Conversation Profile ID>`.
     *     @type string $session_id
     *           Required. The ID of the search session.
     *           The session_id can be combined with Dialogflow V3 Agent ID retrieved from
     *           conversation profile or on its own to identify a search session. The search
     *           history of the same session will impact the search result. It's up to the
     *           API caller to choose an appropriate `Session ID`. It can be a random number
     *           or some type of session identifiers (preferably hashed). The length must
     *           not exceed 36 characters.
     *     @type string $conversation
     *           Optional. The conversation (between human agent and end user) where the
     *           search request is triggered. Format: `projects/<Project
     *           ID>/locations/<Location ID>/conversations/<Conversation ID>`.
     *     @type string $latest_message
     *           Optional. The name of the latest conversation message when the request is
     *           triggered.
     *           Format: `projects/<Project ID>/locations/<Location
     *           ID>/conversations/<Conversation ID>/messages/<Message ID>`.
     *     @type int $query_source
     *           Optional. The source of the query in the request.
     *     @type \Google\Protobuf\Struct $end_user_metadata
     *           Optional. Information about the end-user to improve the relevance and
     *           accuracy of generative answers.
     *           This will be interpreted and used by a language model, so, for good
     *           results, the data should be self-descriptive, and in a simple structure.
     *           Example:
     *           ```json
     *           {
     *             "subscription plan": "Business Premium Plus",
     *             "devices owned": [
     *               {"model": "Google Pixel 7"},
     *               {"model": "Google Pixel Tablet"}
     *             ]
     *           }
     *           ```
     *     @type \Google\Cloud\Dialogflow\V2\SearchKnowledgeRequest\SearchConfig $search_config
     *           Optional. Configuration specific to search queries with data stores.
     *     @type bool $exact_search
     *           Optional. Whether to search the query exactly without query rewrite.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\V2\Conversation::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource contains the conversation profile
     * Format: 'projects/<Project ID>' or `projects/<Project
     * ID>/locations/<Location ID>`.
     *
     * Generated from protobuf field <code>string parent = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource contains the conversation profile
     * Format: 'projects/<Project ID>' or `projects/<Project
     * ID>/locations/<Location ID>`.
     *
     * Generated from protobuf field <code>string parent = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The natural language text query for knowledge search.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.TextInput query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Dialogflow\V2\TextInput|null
     */
    public function getQuery()
    {
        return $this->query;
    }

    public function hasQuery()
    {
        return isset($this->query);
    }

    public function clearQuery()
    {
        unset($this->query);
    }

    /**
     * Required. The natural language text query for knowledge search.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.TextInput query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Dialogflow\V2\TextInput $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\V2\TextInput::class);
        $this->query = $var;

        return $this;
    }

    /**
     * Required. The conversation profile used to configure the search.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/conversationProfiles/<Conversation Profile ID>`.
     *
     * Generated from protobuf field <code>string conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getConversationProfile()
    {
        return $this->conversation_profile;
    }

    /**
     * Required. The conversation profile used to configure the search.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/conversationProfiles/<Conversation Profile ID>`.
     *
     * Generated from protobuf field <code>string conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setConversationProfile($var)
    {
        GPBUtil::checkString($var, True);
        $this->conversation_profile = $var;

        return $this;
    }

    /**
     * Required. The ID of the search session.
     * The session_id can be combined with Dialogflow V3 Agent ID retrieved from
     * conversation profile or on its own to identify a search session. The search
     * history of the same session will impact the search result. It's up to the
     * API caller to choose an appropriate `Session ID`. It can be a random number
     * or some type of session identifiers (preferably hashed). The length must
     * not exceed 36 characters.
     *
     * Generated from protobuf field <code>string session_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getSessionId()
    {
        return $this->session_id;
    }

    /**
     * Required. The ID of the search session.
     * The session_id can be combined with Dialogflow V3 Agent ID retrieved from
     * conversation profile or on its own to identify a search session. The search
     * history of the same session will impact the search result. It's up to the
     * API caller to choose an appropriate `Session ID`. It can be a random number
     * or some type of session identifiers (preferably hashed). The length must
     * not exceed 36 characters.
     *
     * Generated from protobuf field <code>string session_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setSessionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->session_id = $var;

        return $this;
    }

    /**
     * Optional. The conversation (between human agent and end user) where the
     * search request is triggered. Format: `projects/<Project
     * ID>/locations/<Location ID>/conversations/<Conversation ID>`.
     *
     * Generated from protobuf field <code>string conversation = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getConversation()
    {
        return $this->conversation;
    }

    /**
     * Optional. The conversation (between human agent and end user) where the
     * search request is triggered. Format: `projects/<Project
     * ID>/locations/<Location ID>/conversations/<Conversation ID>`.
     *
     * Generated from protobuf field <code>string conversation = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setConversation($var)
    {
        GPBUtil::checkString($var, True);
        $this->conversation = $var;

        return $this;
    }

    /**
     * Optional. The name of the latest conversation message when the request is
     * triggered.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/conversations/<Conversation ID>/messages/<Message ID>`.
     *
     * Generated from protobuf field <code>string latest_message = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getLatestMessage()
    {
        return $this->latest_message;
    }

    /**
     * Optional. The name of the latest conversation message when the request is
     * triggered.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/conversations/<Conversation ID>/messages/<Message ID>`.
     *
     * Generated from protobuf field <code>string latest_message = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setLatestMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->latest_message = $var;

        return $this;
    }

    /**
     * Optional. The source of the query in the request.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SearchKnowledgeRequest.QuerySource query_source = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getQuerySource()
    {
        return $this->query_source;
    }

    /**
     * Optional. The source of the query in the request.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SearchKnowledgeRequest.QuerySource query_source = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setQuerySource($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\V2\SearchKnowledgeRequest\QuerySource::class);
        $this->query_source = $var;

        return $this;
    }

    /**
     * Optional. Information about the end-user to improve the relevance and
     * accuracy of generative answers.
     * This will be interpreted and used by a language model, so, for good
     * results, the data should be self-descriptive, and in a simple structure.
     * Example:
     * ```json
     * {
     *   "subscription plan": "Business Premium Plus",
     *   "devices owned": [
     *     {"model": "Google Pixel 7"},
     *     {"model": "Google Pixel Tablet"}
     *   ]
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct end_user_metadata = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getEndUserMetadata()
    {
        return $this->end_user_metadata;
    }

    public function hasEndUserMetadata()
    {
        return isset($this->end_user_metadata);
    }

    public function clearEndUserMetadata()
    {
        unset($this->end_user_metadata);
    }

    /**
     * Optional. Information about the end-user to improve the relevance and
     * accuracy of generative answers.
     * This will be interpreted and used by a language model, so, for good
     * results, the data should be self-descriptive, and in a simple structure.
     * Example:
     * ```json
     * {
     *   "subscription plan": "Business Premium Plus",
     *   "devices owned": [
     *     {"model": "Google Pixel 7"},
     *     {"model": "Google Pixel Tablet"}
     *   ]
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct end_user_metadata = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setEndUserMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->end_user_metadata = $var;

        return $this;
    }

    /**
     * Optional. Configuration specific to search queries with data stores.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig search_config = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\V2\SearchKnowledgeRequest\SearchConfig|null
     */
    public function getSearchConfig()
    {
        return $this->search_config;
    }

    public function hasSearchConfig()
    {
        return isset($this->search_config);
    }

    public function clearSearchConfig()
    {
        unset($this->search_config);
    }

    /**
     * Optional. Configuration specific to search queries with data stores.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig search_config = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\V2\SearchKnowledgeRequest\SearchConfig $var
     * @return $this
     */
    public function setSearchConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\V2\SearchKnowledgeRequest\SearchConfig::class);
        $this->search_config = $var;

        return $this;
    }

    /**
     * Optional. Whether to search the query exactly without query rewrite.
     *
     * Generated from protobuf field <code>bool exact_search = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getExactSearch()
    {
        return $this->exact_search;
    }

    /**
     * Optional. Whether to search the query exactly without query rewrite.
     *
     * Generated from protobuf field <code>bool exact_search = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setExactSearch($var)
    {
        GPBUtil::checkBool($var);
        $this->exact_search = $var;

        return $this;
    }

}

