<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datastream/v1/datastream_resources.proto

namespace Google\Cloud\Datastream\V1\PostgresqlSslConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message represents the option where Datastream will enforce the encryption
 * and authenticate the server identity as well as the client identity.
 * ca_certificate, client_certificate and client_key must be set if user
 * selects this option.
 *
 * Generated from protobuf message <code>google.cloud.datastream.v1.PostgresqlSslConfig.ServerAndClientVerification</code>
 */
class ServerAndClientVerification extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Input only. PEM-encoded certificate used by the source database
     * to authenticate the client identity (i.e., the Datastream's identity).
     * This certificate is signed by either a root certificate trusted by the
     * server or one or more intermediate certificates (which is stored with the
     * leaf certificate) to link the this certificate to the trusted root
     * certificate.
     *
     * Generated from protobuf field <code>string client_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $client_certificate = '';
    /**
     * Optional. Input only. PEM-encoded private key associated with the client
     * certificate. This value will be used during the SSL/TLS handshake,
     * allowing the PostgreSQL server to authenticate the client's identity,
     * i.e. identity of the Datastream.
     *
     * Generated from protobuf field <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $client_key = '';
    /**
     * Required. Input only. PEM-encoded server root CA certificate.
     *
     * Generated from protobuf field <code>string ca_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $ca_certificate = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $client_certificate
     *           Required. Input only. PEM-encoded certificate used by the source database
     *           to authenticate the client identity (i.e., the Datastream's identity).
     *           This certificate is signed by either a root certificate trusted by the
     *           server or one or more intermediate certificates (which is stored with the
     *           leaf certificate) to link the this certificate to the trusted root
     *           certificate.
     *     @type string $client_key
     *           Optional. Input only. PEM-encoded private key associated with the client
     *           certificate. This value will be used during the SSL/TLS handshake,
     *           allowing the PostgreSQL server to authenticate the client's identity,
     *           i.e. identity of the Datastream.
     *     @type string $ca_certificate
     *           Required. Input only. PEM-encoded server root CA certificate.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datastream\V1\DatastreamResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Input only. PEM-encoded certificate used by the source database
     * to authenticate the client identity (i.e., the Datastream's identity).
     * This certificate is signed by either a root certificate trusted by the
     * server or one or more intermediate certificates (which is stored with the
     * leaf certificate) to link the this certificate to the trusted root
     * certificate.
     *
     * Generated from protobuf field <code>string client_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getClientCertificate()
    {
        return $this->client_certificate;
    }

    /**
     * Required. Input only. PEM-encoded certificate used by the source database
     * to authenticate the client identity (i.e., the Datastream's identity).
     * This certificate is signed by either a root certificate trusted by the
     * server or one or more intermediate certificates (which is stored with the
     * leaf certificate) to link the this certificate to the trusted root
     * certificate.
     *
     * Generated from protobuf field <code>string client_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setClientCertificate($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_certificate = $var;

        return $this;
    }

    /**
     * Optional. Input only. PEM-encoded private key associated with the client
     * certificate. This value will be used during the SSL/TLS handshake,
     * allowing the PostgreSQL server to authenticate the client's identity,
     * i.e. identity of the Datastream.
     *
     * Generated from protobuf field <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getClientKey()
    {
        return $this->client_key;
    }

    /**
     * Optional. Input only. PEM-encoded private key associated with the client
     * certificate. This value will be used during the SSL/TLS handshake,
     * allowing the PostgreSQL server to authenticate the client's identity,
     * i.e. identity of the Datastream.
     *
     * Generated from protobuf field <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setClientKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_key = $var;

        return $this;
    }

    /**
     * Required. Input only. PEM-encoded server root CA certificate.
     *
     * Generated from protobuf field <code>string ca_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCaCertificate()
    {
        return $this->ca_certificate;
    }

    /**
     * Required. Input only. PEM-encoded server root CA certificate.
     *
     * Generated from protobuf field <code>string ca_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCaCertificate($var)
    {
        GPBUtil::checkString($var, True);
        $this->ca_certificate = $var;

        return $this;
    }

}


