<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/catalog.proto

namespace Google\Cloud\Dataplex\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An object that describes the values that you want to set for an entry and its
 * attached aspects when you import metadata. Used when you run a metadata
 * import job. See
 * [CreateMetadataJob][google.cloud.dataplex.v1.CatalogService.CreateMetadataJob].
 * You provide a collection of import items in a metadata import file. For more
 * information about how to create a metadata import file, see [Metadata import
 * file](https://cloud.google.com/dataplex/docs/import-metadata#metadata-import-file).
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.ImportItem</code>
 */
class ImportItem extends \Google\Protobuf\Internal\Message
{
    /**
     * Information about an entry and its attached aspects.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Entry entry = 1;</code>
     */
    protected $entry = null;
    /**
     * The fields to update, in paths that are relative to the `Entry` resource.
     * Separate each field with a comma.
     * In `FULL` entry sync mode, Dataplex includes the paths of all of the fields
     * for an entry that can be modified, including aspects. This means that
     * Dataplex replaces the existing entry with the entry in the metadata import
     * file. All modifiable fields are updated, regardless of the fields that are
     * listed in the update mask, and regardless of whether a field is present
     * in the `entry` object.
     * The `update_mask` field is ignored when an entry is created or re-created.
     * In an aspect-only metadata job (when entry sync mode is `NONE`), set this
     * value to `aspects`.
     * Dataplex also determines which entries and aspects to modify by comparing
     * the values and timestamps that you provide in the metadata import file with
     * the values and timestamps that exist in your project. For more information,
     * see [Comparison
     * logic](https://cloud.google.com/dataplex/docs/import-metadata#data-modification-logic).
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    protected $update_mask = null;
    /**
     * The aspects to modify. Supports the following syntaxes:
     * * `{aspect_type_reference}`: matches aspects that belong to the specified
     * aspect type and are attached directly to the entry.
     * * `{aspect_type_reference}&#64;{path}`: matches aspects that belong to the
     * specified aspect type and path.
     * * `{aspect_type_reference}&#64;*` : matches aspects of the given type for all
     * paths.
     * * `*&#64;path` : matches aspects of all types on the given path.
     * Replace `{aspect_type_reference}` with a reference to the aspect type, in
     * the format
     * `{project_id_or_number}.{location_id}.{aspect_type_id}`.
     * In `FULL` entry sync mode, if you leave this field empty, it is treated as
     * specifying exactly those aspects that are present within the specified
     * entry. Dataplex implicitly adds the keys for all of the required aspects of
     * an entry.
     *
     * Generated from protobuf field <code>repeated string aspect_keys = 3;</code>
     */
    private $aspect_keys;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Dataplex\V1\Entry $entry
     *           Information about an entry and its attached aspects.
     *     @type \Google\Protobuf\FieldMask $update_mask
     *           The fields to update, in paths that are relative to the `Entry` resource.
     *           Separate each field with a comma.
     *           In `FULL` entry sync mode, Dataplex includes the paths of all of the fields
     *           for an entry that can be modified, including aspects. This means that
     *           Dataplex replaces the existing entry with the entry in the metadata import
     *           file. All modifiable fields are updated, regardless of the fields that are
     *           listed in the update mask, and regardless of whether a field is present
     *           in the `entry` object.
     *           The `update_mask` field is ignored when an entry is created or re-created.
     *           In an aspect-only metadata job (when entry sync mode is `NONE`), set this
     *           value to `aspects`.
     *           Dataplex also determines which entries and aspects to modify by comparing
     *           the values and timestamps that you provide in the metadata import file with
     *           the values and timestamps that exist in your project. For more information,
     *           see [Comparison
     *           logic](https://cloud.google.com/dataplex/docs/import-metadata#data-modification-logic).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $aspect_keys
     *           The aspects to modify. Supports the following syntaxes:
     *           * `{aspect_type_reference}`: matches aspects that belong to the specified
     *           aspect type and are attached directly to the entry.
     *           * `{aspect_type_reference}&#64;{path}`: matches aspects that belong to the
     *           specified aspect type and path.
     *           * `{aspect_type_reference}&#64;*` : matches aspects of the given type for all
     *           paths.
     *           * `*&#64;path` : matches aspects of all types on the given path.
     *           Replace `{aspect_type_reference}` with a reference to the aspect type, in
     *           the format
     *           `{project_id_or_number}.{location_id}.{aspect_type_id}`.
     *           In `FULL` entry sync mode, if you leave this field empty, it is treated as
     *           specifying exactly those aspects that are present within the specified
     *           entry. Dataplex implicitly adds the keys for all of the required aspects of
     *           an entry.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\Catalog::initOnce();
        parent::__construct($data);
    }

    /**
     * Information about an entry and its attached aspects.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Entry entry = 1;</code>
     * @return \Google\Cloud\Dataplex\V1\Entry|null
     */
    public function getEntry()
    {
        return $this->entry;
    }

    public function hasEntry()
    {
        return isset($this->entry);
    }

    public function clearEntry()
    {
        unset($this->entry);
    }

    /**
     * Information about an entry and its attached aspects.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Entry entry = 1;</code>
     * @param \Google\Cloud\Dataplex\V1\Entry $var
     * @return $this
     */
    public function setEntry($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Entry::class);
        $this->entry = $var;

        return $this;
    }

    /**
     * The fields to update, in paths that are relative to the `Entry` resource.
     * Separate each field with a comma.
     * In `FULL` entry sync mode, Dataplex includes the paths of all of the fields
     * for an entry that can be modified, including aspects. This means that
     * Dataplex replaces the existing entry with the entry in the metadata import
     * file. All modifiable fields are updated, regardless of the fields that are
     * listed in the update mask, and regardless of whether a field is present
     * in the `entry` object.
     * The `update_mask` field is ignored when an entry is created or re-created.
     * In an aspect-only metadata job (when entry sync mode is `NONE`), set this
     * value to `aspects`.
     * Dataplex also determines which entries and aspects to modify by comparing
     * the values and timestamps that you provide in the metadata import file with
     * the values and timestamps that exist in your project. For more information,
     * see [Comparison
     * logic](https://cloud.google.com/dataplex/docs/import-metadata#data-modification-logic).
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 2;</code>
     * @return \Google\Protobuf\FieldMask|null
     */
    public function getUpdateMask()
    {
        return $this->update_mask;
    }

    public function hasUpdateMask()
    {
        return isset($this->update_mask);
    }

    public function clearUpdateMask()
    {
        unset($this->update_mask);
    }

    /**
     * The fields to update, in paths that are relative to the `Entry` resource.
     * Separate each field with a comma.
     * In `FULL` entry sync mode, Dataplex includes the paths of all of the fields
     * for an entry that can be modified, including aspects. This means that
     * Dataplex replaces the existing entry with the entry in the metadata import
     * file. All modifiable fields are updated, regardless of the fields that are
     * listed in the update mask, and regardless of whether a field is present
     * in the `entry` object.
     * The `update_mask` field is ignored when an entry is created or re-created.
     * In an aspect-only metadata job (when entry sync mode is `NONE`), set this
     * value to `aspects`.
     * Dataplex also determines which entries and aspects to modify by comparing
     * the values and timestamps that you provide in the metadata import file with
     * the values and timestamps that exist in your project. For more information,
     * see [Comparison
     * logic](https://cloud.google.com/dataplex/docs/import-metadata#data-modification-logic).
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 2;</code>
     * @param \Google\Protobuf\FieldMask $var
     * @return $this
     */
    public function setUpdateMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\FieldMask::class);
        $this->update_mask = $var;

        return $this;
    }

    /**
     * The aspects to modify. Supports the following syntaxes:
     * * `{aspect_type_reference}`: matches aspects that belong to the specified
     * aspect type and are attached directly to the entry.
     * * `{aspect_type_reference}&#64;{path}`: matches aspects that belong to the
     * specified aspect type and path.
     * * `{aspect_type_reference}&#64;*` : matches aspects of the given type for all
     * paths.
     * * `*&#64;path` : matches aspects of all types on the given path.
     * Replace `{aspect_type_reference}` with a reference to the aspect type, in
     * the format
     * `{project_id_or_number}.{location_id}.{aspect_type_id}`.
     * In `FULL` entry sync mode, if you leave this field empty, it is treated as
     * specifying exactly those aspects that are present within the specified
     * entry. Dataplex implicitly adds the keys for all of the required aspects of
     * an entry.
     *
     * Generated from protobuf field <code>repeated string aspect_keys = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAspectKeys()
    {
        return $this->aspect_keys;
    }

    /**
     * The aspects to modify. Supports the following syntaxes:
     * * `{aspect_type_reference}`: matches aspects that belong to the specified
     * aspect type and are attached directly to the entry.
     * * `{aspect_type_reference}&#64;{path}`: matches aspects that belong to the
     * specified aspect type and path.
     * * `{aspect_type_reference}&#64;*` : matches aspects of the given type for all
     * paths.
     * * `*&#64;path` : matches aspects of all types on the given path.
     * Replace `{aspect_type_reference}` with a reference to the aspect type, in
     * the format
     * `{project_id_or_number}.{location_id}.{aspect_type_id}`.
     * In `FULL` entry sync mode, if you leave this field empty, it is treated as
     * specifying exactly those aspects that are present within the specified
     * entry. Dataplex implicitly adds the keys for all of the required aspects of
     * an entry.
     *
     * Generated from protobuf field <code>repeated string aspect_keys = 3;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAspectKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->aspect_keys = $arr;

        return $this;
    }

}

