<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/memorystore/v1/memorystore.proto

namespace Google\Cloud\Memorystore\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Memorystore instance.
 *
 * Generated from protobuf message <code>google.cloud.memorystore.v1.Instance</code>
 */
class Instance extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. Unique name of the instance.
     * Format: projects/{project}/locations/{location}/instances/{instance}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. Creation timestamp of the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Latest update timestamp of the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Labels to represent user-provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. Current state of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. Additional information about the state of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.StateInfo state_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state_info = null;
    /**
     * Output only. System assigned, unique identifier for the instance.
     *
     * Generated from protobuf field <code>string uid = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     */
    protected $uid = '';
    /**
     * Optional. Number of replica nodes per shard. If omitted the default is 0
     * replicas.
     *
     * Generated from protobuf field <code>optional int32 replica_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $replica_count = null;
    /**
     * Optional. Immutable. Authorization mode of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.AuthorizationMode authorization_mode = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $authorization_mode = 0;
    /**
     * Optional. Immutable. In-transit encryption mode of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.TransitEncryptionMode transit_encryption_mode = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $transit_encryption_mode = 0;
    /**
     * Optional. Number of shards for the instance.
     *
     * Generated from protobuf field <code>int32 shard_count = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $shard_count = 0;
    /**
     * Output only. Deprecated: Use the endpoints.connections.psc_auto_connection
     * or endpoints.connections.psc_connection values instead.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.DiscoveryEndpoint discovery_endpoints = 12 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @deprecated
     */
    private $discovery_endpoints;
    /**
     * Optional. Machine type for individual nodes of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.NodeType node_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $node_type = 0;
    /**
     * Optional. Persistence configuration of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.PersistenceConfig persistence_config = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $persistence_config = null;
    /**
     * Optional. Engine version of the instance.
     *
     * Generated from protobuf field <code>string engine_version = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $engine_version = '';
    /**
     * Optional. User-provided engine configurations for the instance.
     *
     * Generated from protobuf field <code>map<string, string> engine_configs = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $engine_configs;
    /**
     * Output only. Configuration of individual nodes of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.NodeConfig node_config = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $node_config = null;
    /**
     * Optional. Immutable. Zone distribution configuration of the instance for
     * node allocation.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.ZoneDistributionConfig zone_distribution_config = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $zone_distribution_config = null;
    /**
     * Optional. If set to true deletion of the instance will fail.
     *
     * Generated from protobuf field <code>optional bool deletion_protection_enabled = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $deletion_protection_enabled = null;
    /**
     * Optional. Immutable. Deprecated: Use the
     * endpoints.connections.psc_auto_connection value instead.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.PscAutoConnection psc_auto_connections = 20 [deprecated = true, (.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @deprecated
     */
    private $psc_auto_connections;
    /**
     * Output only. Service attachment details to configure PSC connections.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.PscAttachmentDetail psc_attachment_details = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $psc_attachment_details;
    /**
     * Optional. Endpoints for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.Instance.InstanceEndpoint endpoints = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $endpoints;
    /**
     * Optional. The mode config for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.Mode mode = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $mode = 0;
    /**
     * Optional. Input only. Ondemand maintenance for the instance.
     *
     * Generated from protobuf field <code>optional bool ondemand_maintenance = 28 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $ondemand_maintenance = null;
    /**
     * Optional. The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.MaintenancePolicy maintenance_policy = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $maintenance_policy = null;
    /**
     * Output only. Published maintenance schedule.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.MaintenanceSchedule maintenance_schedule = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $maintenance_schedule = null;
    /**
     * Optional. The config for cross instance replication.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.CrossInstanceReplicationConfig cross_instance_replication_config = 33 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cross_instance_replication_config = null;
    /**
     * Optional. If true, instance endpoints that are created and registered by
     * customers can be deleted asynchronously. That is, such an instance endpoint
     * can be de-registered before the forwarding rules in the instance endpoint
     * are deleted.
     *
     * Generated from protobuf field <code>optional bool async_instance_endpoints_deletion_enabled = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $async_instance_endpoints_deletion_enabled = null;
    /**
     * Output only. The backup collection full resource name. Example:
     * projects/{project}/locations/{location}/backupCollections/{collection}
     *
     * Generated from protobuf field <code>optional string backup_collection = 47 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $backup_collection = null;
    /**
     * Optional. The automated backup config for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.AutomatedBackupConfig automated_backup_config = 48 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $automated_backup_config = null;
    protected $import_sources;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Memorystore\V1\Instance\GcsBackupSource $gcs_source
     *           Optional. Immutable. Backups that stored in Cloud Storage buckets.
     *           The Cloud Storage buckets need to be the same region as the instances.
     *           Read permission is required to import from the provided Cloud Storage
     *           Objects.
     *     @type \Google\Cloud\Memorystore\V1\Instance\ManagedBackupSource $managed_backup_source
     *           Optional. Immutable. Backups that generated and managed by memorystore
     *           service.
     *     @type string $name
     *           Identifier. Unique name of the instance.
     *           Format: projects/{project}/locations/{location}/instances/{instance}
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Creation timestamp of the instance.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Latest update timestamp of the instance.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Labels to represent user-provided metadata.
     *     @type int $state
     *           Output only. Current state of the instance.
     *     @type \Google\Cloud\Memorystore\V1\Instance\StateInfo $state_info
     *           Output only. Additional information about the state of the instance.
     *     @type string $uid
     *           Output only. System assigned, unique identifier for the instance.
     *     @type int $replica_count
     *           Optional. Number of replica nodes per shard. If omitted the default is 0
     *           replicas.
     *     @type int $authorization_mode
     *           Optional. Immutable. Authorization mode of the instance.
     *     @type int $transit_encryption_mode
     *           Optional. Immutable. In-transit encryption mode of the instance.
     *     @type int $shard_count
     *           Optional. Number of shards for the instance.
     *     @type array<\Google\Cloud\Memorystore\V1\DiscoveryEndpoint>|\Google\Protobuf\Internal\RepeatedField $discovery_endpoints
     *           Output only. Deprecated: Use the endpoints.connections.psc_auto_connection
     *           or endpoints.connections.psc_connection values instead.
     *     @type int $node_type
     *           Optional. Machine type for individual nodes of the instance.
     *     @type \Google\Cloud\Memorystore\V1\PersistenceConfig $persistence_config
     *           Optional. Persistence configuration of the instance.
     *     @type string $engine_version
     *           Optional. Engine version of the instance.
     *     @type array|\Google\Protobuf\Internal\MapField $engine_configs
     *           Optional. User-provided engine configurations for the instance.
     *     @type \Google\Cloud\Memorystore\V1\NodeConfig $node_config
     *           Output only. Configuration of individual nodes of the instance.
     *     @type \Google\Cloud\Memorystore\V1\ZoneDistributionConfig $zone_distribution_config
     *           Optional. Immutable. Zone distribution configuration of the instance for
     *           node allocation.
     *     @type bool $deletion_protection_enabled
     *           Optional. If set to true deletion of the instance will fail.
     *     @type array<\Google\Cloud\Memorystore\V1\PscAutoConnection>|\Google\Protobuf\Internal\RepeatedField $psc_auto_connections
     *           Optional. Immutable. Deprecated: Use the
     *           endpoints.connections.psc_auto_connection value instead.
     *     @type array<\Google\Cloud\Memorystore\V1\PscAttachmentDetail>|\Google\Protobuf\Internal\RepeatedField $psc_attachment_details
     *           Output only. Service attachment details to configure PSC connections.
     *     @type array<\Google\Cloud\Memorystore\V1\Instance\InstanceEndpoint>|\Google\Protobuf\Internal\RepeatedField $endpoints
     *           Optional. Endpoints for the instance.
     *     @type int $mode
     *           Optional. The mode config for the instance.
     *     @type bool $ondemand_maintenance
     *           Optional. Input only. Ondemand maintenance for the instance.
     *     @type \Google\Cloud\Memorystore\V1\MaintenancePolicy $maintenance_policy
     *           Optional. The maintenance policy for the instance. If not provided,
     *           the maintenance event will be performed based on Memorystore
     *           internal rollout schedule.
     *     @type \Google\Cloud\Memorystore\V1\MaintenanceSchedule $maintenance_schedule
     *           Output only. Published maintenance schedule.
     *     @type \Google\Cloud\Memorystore\V1\CrossInstanceReplicationConfig $cross_instance_replication_config
     *           Optional. The config for cross instance replication.
     *     @type bool $async_instance_endpoints_deletion_enabled
     *           Optional. If true, instance endpoints that are created and registered by
     *           customers can be deleted asynchronously. That is, such an instance endpoint
     *           can be de-registered before the forwarding rules in the instance endpoint
     *           are deleted.
     *     @type string $backup_collection
     *           Output only. The backup collection full resource name. Example:
     *           projects/{project}/locations/{location}/backupCollections/{collection}
     *     @type \Google\Cloud\Memorystore\V1\AutomatedBackupConfig $automated_backup_config
     *           Optional. The automated backup config for the instance.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Memorystore\V1\Memorystore::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Immutable. Backups that stored in Cloud Storage buckets.
     * The Cloud Storage buckets need to be the same region as the instances.
     * Read permission is required to import from the provided Cloud Storage
     * Objects.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.GcsBackupSource gcs_source = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Cloud\Memorystore\V1\Instance\GcsBackupSource|null
     */
    public function getGcsSource()
    {
        return $this->readOneof(23);
    }

    public function hasGcsSource()
    {
        return $this->hasOneof(23);
    }

    /**
     * Optional. Immutable. Backups that stored in Cloud Storage buckets.
     * The Cloud Storage buckets need to be the same region as the instances.
     * Read permission is required to import from the provided Cloud Storage
     * Objects.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.GcsBackupSource gcs_source = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Cloud\Memorystore\V1\Instance\GcsBackupSource $var
     * @return $this
     */
    public function setGcsSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\Instance\GcsBackupSource::class);
        $this->writeOneof(23, $var);

        return $this;
    }

    /**
     * Optional. Immutable. Backups that generated and managed by memorystore
     * service.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.ManagedBackupSource managed_backup_source = 24 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Cloud\Memorystore\V1\Instance\ManagedBackupSource|null
     */
    public function getManagedBackupSource()
    {
        return $this->readOneof(24);
    }

    public function hasManagedBackupSource()
    {
        return $this->hasOneof(24);
    }

    /**
     * Optional. Immutable. Backups that generated and managed by memorystore
     * service.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.ManagedBackupSource managed_backup_source = 24 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Cloud\Memorystore\V1\Instance\ManagedBackupSource $var
     * @return $this
     */
    public function setManagedBackupSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\Instance\ManagedBackupSource::class);
        $this->writeOneof(24, $var);

        return $this;
    }

    /**
     * Identifier. Unique name of the instance.
     * Format: projects/{project}/locations/{location}/instances/{instance}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. Unique name of the instance.
     * Format: projects/{project}/locations/{location}/instances/{instance}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Creation timestamp of the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Creation timestamp of the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Latest update timestamp of the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Latest update timestamp of the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Labels to represent user-provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Labels to represent user-provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Current state of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. Current state of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Memorystore\V1\Instance\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Additional information about the state of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.StateInfo state_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Memorystore\V1\Instance\StateInfo|null
     */
    public function getStateInfo()
    {
        return $this->state_info;
    }

    public function hasStateInfo()
    {
        return isset($this->state_info);
    }

    public function clearStateInfo()
    {
        unset($this->state_info);
    }

    /**
     * Output only. Additional information about the state of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.StateInfo state_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Memorystore\V1\Instance\StateInfo $var
     * @return $this
     */
    public function setStateInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\Instance\StateInfo::class);
        $this->state_info = $var;

        return $this;
    }

    /**
     * Output only. System assigned, unique identifier for the instance.
     *
     * Generated from protobuf field <code>string uid = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. System assigned, unique identifier for the instance.
     *
     * Generated from protobuf field <code>string uid = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Optional. Number of replica nodes per shard. If omitted the default is 0
     * replicas.
     *
     * Generated from protobuf field <code>optional int32 replica_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getReplicaCount()
    {
        return isset($this->replica_count) ? $this->replica_count : 0;
    }

    public function hasReplicaCount()
    {
        return isset($this->replica_count);
    }

    public function clearReplicaCount()
    {
        unset($this->replica_count);
    }

    /**
     * Optional. Number of replica nodes per shard. If omitted the default is 0
     * replicas.
     *
     * Generated from protobuf field <code>optional int32 replica_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setReplicaCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->replica_count = $var;

        return $this;
    }

    /**
     * Optional. Immutable. Authorization mode of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.AuthorizationMode authorization_mode = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getAuthorizationMode()
    {
        return $this->authorization_mode;
    }

    /**
     * Optional. Immutable. Authorization mode of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.AuthorizationMode authorization_mode = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setAuthorizationMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Memorystore\V1\Instance\AuthorizationMode::class);
        $this->authorization_mode = $var;

        return $this;
    }

    /**
     * Optional. Immutable. In-transit encryption mode of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.TransitEncryptionMode transit_encryption_mode = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getTransitEncryptionMode()
    {
        return $this->transit_encryption_mode;
    }

    /**
     * Optional. Immutable. In-transit encryption mode of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.TransitEncryptionMode transit_encryption_mode = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setTransitEncryptionMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Memorystore\V1\Instance\TransitEncryptionMode::class);
        $this->transit_encryption_mode = $var;

        return $this;
    }

    /**
     * Optional. Number of shards for the instance.
     *
     * Generated from protobuf field <code>int32 shard_count = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getShardCount()
    {
        return $this->shard_count;
    }

    /**
     * Optional. Number of shards for the instance.
     *
     * Generated from protobuf field <code>int32 shard_count = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setShardCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->shard_count = $var;

        return $this;
    }

    /**
     * Output only. Deprecated: Use the endpoints.connections.psc_auto_connection
     * or endpoints.connections.psc_connection values instead.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.DiscoveryEndpoint discovery_endpoints = 12 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getDiscoveryEndpoints()
    {
        @trigger_error('discovery_endpoints is deprecated.', E_USER_DEPRECATED);
        return $this->discovery_endpoints;
    }

    /**
     * Output only. Deprecated: Use the endpoints.connections.psc_auto_connection
     * or endpoints.connections.psc_connection values instead.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.DiscoveryEndpoint discovery_endpoints = 12 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Memorystore\V1\DiscoveryEndpoint>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setDiscoveryEndpoints($var)
    {
        @trigger_error('discovery_endpoints is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Memorystore\V1\DiscoveryEndpoint::class);
        $this->discovery_endpoints = $arr;

        return $this;
    }

    /**
     * Optional. Machine type for individual nodes of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.NodeType node_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getNodeType()
    {
        return $this->node_type;
    }

    /**
     * Optional. Machine type for individual nodes of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.NodeType node_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setNodeType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Memorystore\V1\Instance\NodeType::class);
        $this->node_type = $var;

        return $this;
    }

    /**
     * Optional. Persistence configuration of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.PersistenceConfig persistence_config = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Memorystore\V1\PersistenceConfig|null
     */
    public function getPersistenceConfig()
    {
        return $this->persistence_config;
    }

    public function hasPersistenceConfig()
    {
        return isset($this->persistence_config);
    }

    public function clearPersistenceConfig()
    {
        unset($this->persistence_config);
    }

    /**
     * Optional. Persistence configuration of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.PersistenceConfig persistence_config = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Memorystore\V1\PersistenceConfig $var
     * @return $this
     */
    public function setPersistenceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\PersistenceConfig::class);
        $this->persistence_config = $var;

        return $this;
    }

    /**
     * Optional. Engine version of the instance.
     *
     * Generated from protobuf field <code>string engine_version = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEngineVersion()
    {
        return $this->engine_version;
    }

    /**
     * Optional. Engine version of the instance.
     *
     * Generated from protobuf field <code>string engine_version = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEngineVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->engine_version = $var;

        return $this;
    }

    /**
     * Optional. User-provided engine configurations for the instance.
     *
     * Generated from protobuf field <code>map<string, string> engine_configs = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getEngineConfigs()
    {
        return $this->engine_configs;
    }

    /**
     * Optional. User-provided engine configurations for the instance.
     *
     * Generated from protobuf field <code>map<string, string> engine_configs = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setEngineConfigs($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->engine_configs = $arr;

        return $this;
    }

    /**
     * Output only. Configuration of individual nodes of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.NodeConfig node_config = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Memorystore\V1\NodeConfig|null
     */
    public function getNodeConfig()
    {
        return $this->node_config;
    }

    public function hasNodeConfig()
    {
        return isset($this->node_config);
    }

    public function clearNodeConfig()
    {
        unset($this->node_config);
    }

    /**
     * Output only. Configuration of individual nodes of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.NodeConfig node_config = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Memorystore\V1\NodeConfig $var
     * @return $this
     */
    public function setNodeConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\NodeConfig::class);
        $this->node_config = $var;

        return $this;
    }

    /**
     * Optional. Immutable. Zone distribution configuration of the instance for
     * node allocation.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.ZoneDistributionConfig zone_distribution_config = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Cloud\Memorystore\V1\ZoneDistributionConfig|null
     */
    public function getZoneDistributionConfig()
    {
        return $this->zone_distribution_config;
    }

    public function hasZoneDistributionConfig()
    {
        return isset($this->zone_distribution_config);
    }

    public function clearZoneDistributionConfig()
    {
        unset($this->zone_distribution_config);
    }

    /**
     * Optional. Immutable. Zone distribution configuration of the instance for
     * node allocation.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.ZoneDistributionConfig zone_distribution_config = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Cloud\Memorystore\V1\ZoneDistributionConfig $var
     * @return $this
     */
    public function setZoneDistributionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\ZoneDistributionConfig::class);
        $this->zone_distribution_config = $var;

        return $this;
    }

    /**
     * Optional. If set to true deletion of the instance will fail.
     *
     * Generated from protobuf field <code>optional bool deletion_protection_enabled = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDeletionProtectionEnabled()
    {
        return isset($this->deletion_protection_enabled) ? $this->deletion_protection_enabled : false;
    }

    public function hasDeletionProtectionEnabled()
    {
        return isset($this->deletion_protection_enabled);
    }

    public function clearDeletionProtectionEnabled()
    {
        unset($this->deletion_protection_enabled);
    }

    /**
     * Optional. If set to true deletion of the instance will fail.
     *
     * Generated from protobuf field <code>optional bool deletion_protection_enabled = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDeletionProtectionEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->deletion_protection_enabled = $var;

        return $this;
    }

    /**
     * Optional. Immutable. Deprecated: Use the
     * endpoints.connections.psc_auto_connection value instead.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.PscAutoConnection psc_auto_connections = 20 [deprecated = true, (.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getPscAutoConnections()
    {
        @trigger_error('psc_auto_connections is deprecated.', E_USER_DEPRECATED);
        return $this->psc_auto_connections;
    }

    /**
     * Optional. Immutable. Deprecated: Use the
     * endpoints.connections.psc_auto_connection value instead.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.PscAutoConnection psc_auto_connections = 20 [deprecated = true, (.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array<\Google\Cloud\Memorystore\V1\PscAutoConnection>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setPscAutoConnections($var)
    {
        @trigger_error('psc_auto_connections is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Memorystore\V1\PscAutoConnection::class);
        $this->psc_auto_connections = $arr;

        return $this;
    }

    /**
     * Output only. Service attachment details to configure PSC connections.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.PscAttachmentDetail psc_attachment_details = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPscAttachmentDetails()
    {
        return $this->psc_attachment_details;
    }

    /**
     * Output only. Service attachment details to configure PSC connections.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.PscAttachmentDetail psc_attachment_details = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Memorystore\V1\PscAttachmentDetail>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPscAttachmentDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Memorystore\V1\PscAttachmentDetail::class);
        $this->psc_attachment_details = $arr;

        return $this;
    }

    /**
     * Optional. Endpoints for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.Instance.InstanceEndpoint endpoints = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEndpoints()
    {
        return $this->endpoints;
    }

    /**
     * Optional. Endpoints for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.memorystore.v1.Instance.InstanceEndpoint endpoints = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Memorystore\V1\Instance\InstanceEndpoint>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEndpoints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Memorystore\V1\Instance\InstanceEndpoint::class);
        $this->endpoints = $arr;

        return $this;
    }

    /**
     * Optional. The mode config for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.Mode mode = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * Optional. The mode config for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.Instance.Mode mode = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Memorystore\V1\Instance\Mode::class);
        $this->mode = $var;

        return $this;
    }

    /**
     * Optional. Input only. Ondemand maintenance for the instance.
     *
     * Generated from protobuf field <code>optional bool ondemand_maintenance = 28 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return bool
     */
    public function getOndemandMaintenance()
    {
        return isset($this->ondemand_maintenance) ? $this->ondemand_maintenance : false;
    }

    public function hasOndemandMaintenance()
    {
        return isset($this->ondemand_maintenance);
    }

    public function clearOndemandMaintenance()
    {
        unset($this->ondemand_maintenance);
    }

    /**
     * Optional. Input only. Ondemand maintenance for the instance.
     *
     * Generated from protobuf field <code>optional bool ondemand_maintenance = 28 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setOndemandMaintenance($var)
    {
        GPBUtil::checkBool($var);
        $this->ondemand_maintenance = $var;

        return $this;
    }

    /**
     * Optional. The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.MaintenancePolicy maintenance_policy = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Memorystore\V1\MaintenancePolicy|null
     */
    public function getMaintenancePolicy()
    {
        return $this->maintenance_policy;
    }

    public function hasMaintenancePolicy()
    {
        return isset($this->maintenance_policy);
    }

    public function clearMaintenancePolicy()
    {
        unset($this->maintenance_policy);
    }

    /**
     * Optional. The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.MaintenancePolicy maintenance_policy = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Memorystore\V1\MaintenancePolicy $var
     * @return $this
     */
    public function setMaintenancePolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\MaintenancePolicy::class);
        $this->maintenance_policy = $var;

        return $this;
    }

    /**
     * Output only. Published maintenance schedule.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.MaintenanceSchedule maintenance_schedule = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Memorystore\V1\MaintenanceSchedule|null
     */
    public function getMaintenanceSchedule()
    {
        return $this->maintenance_schedule;
    }

    public function hasMaintenanceSchedule()
    {
        return isset($this->maintenance_schedule);
    }

    public function clearMaintenanceSchedule()
    {
        unset($this->maintenance_schedule);
    }

    /**
     * Output only. Published maintenance schedule.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.MaintenanceSchedule maintenance_schedule = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Memorystore\V1\MaintenanceSchedule $var
     * @return $this
     */
    public function setMaintenanceSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\MaintenanceSchedule::class);
        $this->maintenance_schedule = $var;

        return $this;
    }

    /**
     * Optional. The config for cross instance replication.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.CrossInstanceReplicationConfig cross_instance_replication_config = 33 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Memorystore\V1\CrossInstanceReplicationConfig|null
     */
    public function getCrossInstanceReplicationConfig()
    {
        return $this->cross_instance_replication_config;
    }

    public function hasCrossInstanceReplicationConfig()
    {
        return isset($this->cross_instance_replication_config);
    }

    public function clearCrossInstanceReplicationConfig()
    {
        unset($this->cross_instance_replication_config);
    }

    /**
     * Optional. The config for cross instance replication.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.CrossInstanceReplicationConfig cross_instance_replication_config = 33 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Memorystore\V1\CrossInstanceReplicationConfig $var
     * @return $this
     */
    public function setCrossInstanceReplicationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\CrossInstanceReplicationConfig::class);
        $this->cross_instance_replication_config = $var;

        return $this;
    }

    /**
     * Optional. If true, instance endpoints that are created and registered by
     * customers can be deleted asynchronously. That is, such an instance endpoint
     * can be de-registered before the forwarding rules in the instance endpoint
     * are deleted.
     *
     * Generated from protobuf field <code>optional bool async_instance_endpoints_deletion_enabled = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAsyncInstanceEndpointsDeletionEnabled()
    {
        return isset($this->async_instance_endpoints_deletion_enabled) ? $this->async_instance_endpoints_deletion_enabled : false;
    }

    public function hasAsyncInstanceEndpointsDeletionEnabled()
    {
        return isset($this->async_instance_endpoints_deletion_enabled);
    }

    public function clearAsyncInstanceEndpointsDeletionEnabled()
    {
        unset($this->async_instance_endpoints_deletion_enabled);
    }

    /**
     * Optional. If true, instance endpoints that are created and registered by
     * customers can be deleted asynchronously. That is, such an instance endpoint
     * can be de-registered before the forwarding rules in the instance endpoint
     * are deleted.
     *
     * Generated from protobuf field <code>optional bool async_instance_endpoints_deletion_enabled = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAsyncInstanceEndpointsDeletionEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->async_instance_endpoints_deletion_enabled = $var;

        return $this;
    }

    /**
     * Output only. The backup collection full resource name. Example:
     * projects/{project}/locations/{location}/backupCollections/{collection}
     *
     * Generated from protobuf field <code>optional string backup_collection = 47 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBackupCollection()
    {
        return isset($this->backup_collection) ? $this->backup_collection : '';
    }

    public function hasBackupCollection()
    {
        return isset($this->backup_collection);
    }

    public function clearBackupCollection()
    {
        unset($this->backup_collection);
    }

    /**
     * Output only. The backup collection full resource name. Example:
     * projects/{project}/locations/{location}/backupCollections/{collection}
     *
     * Generated from protobuf field <code>optional string backup_collection = 47 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBackupCollection($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_collection = $var;

        return $this;
    }

    /**
     * Optional. The automated backup config for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.AutomatedBackupConfig automated_backup_config = 48 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Memorystore\V1\AutomatedBackupConfig|null
     */
    public function getAutomatedBackupConfig()
    {
        return $this->automated_backup_config;
    }

    public function hasAutomatedBackupConfig()
    {
        return isset($this->automated_backup_config);
    }

    public function clearAutomatedBackupConfig()
    {
        unset($this->automated_backup_config);
    }

    /**
     * Optional. The automated backup config for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.memorystore.v1.AutomatedBackupConfig automated_backup_config = 48 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Memorystore\V1\AutomatedBackupConfig $var
     * @return $this
     */
    public function setAutomatedBackupConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Memorystore\V1\AutomatedBackupConfig::class);
        $this->automated_backup_config = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getImportSources()
    {
        return $this->whichOneof("import_sources");
    }

}

