<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/analytics/admin/v1alpha/resources.proto

namespace Google\Analytics\Admin\V1alpha;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A resource message representing data sharing settings of a Google Analytics
 * account.
 *
 * Generated from protobuf message <code>google.analytics.admin.v1alpha.DataSharingSettings</code>
 */
class DataSharingSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Resource name.
     * Format: accounts/{account}/dataSharingSettings
     * Example: "accounts/1000/dataSharingSettings"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Allows Google technical support representatives access to your Google
     * Analytics data and account when necessary to provide service and find
     * solutions to technical issues.
     * This field maps to the "Technical support" field in the Google Analytics
     * Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_support_enabled = 2;</code>
     */
    protected $sharing_with_google_support_enabled = false;
    /**
     * Allows Google access to your Google Analytics account data, including
     * account usage and configuration data, product spending, and users
     * associated with your Google Analytics account, so that Google can help you
     * make the most of Google products, providing you with insights, offers,
     * recommendations, and optimization tips across Google Analytics and other
     * Google products for business.
     * This field maps to the "Recommendations for your business" field in the
     * Google Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_assigned_sales_enabled = 3;</code>
     */
    protected $sharing_with_google_assigned_sales_enabled = false;
    /**
     * Deprecated. This field is no longer used and always returns false.
     *
     * Generated from protobuf field <code>bool sharing_with_google_any_sales_enabled = 4 [deprecated = true];</code>
     * @deprecated
     */
    protected $sharing_with_google_any_sales_enabled = false;
    /**
     * Allows Google to use the data to improve other Google products or services.
     * This fields maps to the "Google products & services" field in the Google
     * Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_products_enabled = 5;</code>
     */
    protected $sharing_with_google_products_enabled = false;
    /**
     * Enable features like predictions, modeled data, and benchmarking that can
     * provide you with richer business insights when you contribute aggregated
     * measurement data. The data you share (including information about the
     * property from which it is shared) is aggregated and de-identified before
     * being used to generate business insights.
     * This field maps to the "Modeling contributions & business insights" field
     * in the Google Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_others_enabled = 6;</code>
     */
    protected $sharing_with_others_enabled = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Resource name.
     *           Format: accounts/{account}/dataSharingSettings
     *           Example: "accounts/1000/dataSharingSettings"
     *     @type bool $sharing_with_google_support_enabled
     *           Allows Google technical support representatives access to your Google
     *           Analytics data and account when necessary to provide service and find
     *           solutions to technical issues.
     *           This field maps to the "Technical support" field in the Google Analytics
     *           Admin UI.
     *     @type bool $sharing_with_google_assigned_sales_enabled
     *           Allows Google access to your Google Analytics account data, including
     *           account usage and configuration data, product spending, and users
     *           associated with your Google Analytics account, so that Google can help you
     *           make the most of Google products, providing you with insights, offers,
     *           recommendations, and optimization tips across Google Analytics and other
     *           Google products for business.
     *           This field maps to the "Recommendations for your business" field in the
     *           Google Analytics Admin UI.
     *     @type bool $sharing_with_google_any_sales_enabled
     *           Deprecated. This field is no longer used and always returns false.
     *     @type bool $sharing_with_google_products_enabled
     *           Allows Google to use the data to improve other Google products or services.
     *           This fields maps to the "Google products & services" field in the Google
     *           Analytics Admin UI.
     *     @type bool $sharing_with_others_enabled
     *           Enable features like predictions, modeled data, and benchmarking that can
     *           provide you with richer business insights when you contribute aggregated
     *           measurement data. The data you share (including information about the
     *           property from which it is shared) is aggregated and de-identified before
     *           being used to generate business insights.
     *           This field maps to the "Modeling contributions & business insights" field
     *           in the Google Analytics Admin UI.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Analytics\Admin\V1Alpha\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Resource name.
     * Format: accounts/{account}/dataSharingSettings
     * Example: "accounts/1000/dataSharingSettings"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Resource name.
     * Format: accounts/{account}/dataSharingSettings
     * Example: "accounts/1000/dataSharingSettings"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Allows Google technical support representatives access to your Google
     * Analytics data and account when necessary to provide service and find
     * solutions to technical issues.
     * This field maps to the "Technical support" field in the Google Analytics
     * Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_support_enabled = 2;</code>
     * @return bool
     */
    public function getSharingWithGoogleSupportEnabled()
    {
        return $this->sharing_with_google_support_enabled;
    }

    /**
     * Allows Google technical support representatives access to your Google
     * Analytics data and account when necessary to provide service and find
     * solutions to technical issues.
     * This field maps to the "Technical support" field in the Google Analytics
     * Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_support_enabled = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setSharingWithGoogleSupportEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->sharing_with_google_support_enabled = $var;

        return $this;
    }

    /**
     * Allows Google access to your Google Analytics account data, including
     * account usage and configuration data, product spending, and users
     * associated with your Google Analytics account, so that Google can help you
     * make the most of Google products, providing you with insights, offers,
     * recommendations, and optimization tips across Google Analytics and other
     * Google products for business.
     * This field maps to the "Recommendations for your business" field in the
     * Google Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_assigned_sales_enabled = 3;</code>
     * @return bool
     */
    public function getSharingWithGoogleAssignedSalesEnabled()
    {
        return $this->sharing_with_google_assigned_sales_enabled;
    }

    /**
     * Allows Google access to your Google Analytics account data, including
     * account usage and configuration data, product spending, and users
     * associated with your Google Analytics account, so that Google can help you
     * make the most of Google products, providing you with insights, offers,
     * recommendations, and optimization tips across Google Analytics and other
     * Google products for business.
     * This field maps to the "Recommendations for your business" field in the
     * Google Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_assigned_sales_enabled = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setSharingWithGoogleAssignedSalesEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->sharing_with_google_assigned_sales_enabled = $var;

        return $this;
    }

    /**
     * Deprecated. This field is no longer used and always returns false.
     *
     * Generated from protobuf field <code>bool sharing_with_google_any_sales_enabled = 4 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getSharingWithGoogleAnySalesEnabled()
    {
        @trigger_error('sharing_with_google_any_sales_enabled is deprecated.', E_USER_DEPRECATED);
        return $this->sharing_with_google_any_sales_enabled;
    }

    /**
     * Deprecated. This field is no longer used and always returns false.
     *
     * Generated from protobuf field <code>bool sharing_with_google_any_sales_enabled = 4 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setSharingWithGoogleAnySalesEnabled($var)
    {
        @trigger_error('sharing_with_google_any_sales_enabled is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->sharing_with_google_any_sales_enabled = $var;

        return $this;
    }

    /**
     * Allows Google to use the data to improve other Google products or services.
     * This fields maps to the "Google products & services" field in the Google
     * Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_products_enabled = 5;</code>
     * @return bool
     */
    public function getSharingWithGoogleProductsEnabled()
    {
        return $this->sharing_with_google_products_enabled;
    }

    /**
     * Allows Google to use the data to improve other Google products or services.
     * This fields maps to the "Google products & services" field in the Google
     * Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_google_products_enabled = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setSharingWithGoogleProductsEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->sharing_with_google_products_enabled = $var;

        return $this;
    }

    /**
     * Enable features like predictions, modeled data, and benchmarking that can
     * provide you with richer business insights when you contribute aggregated
     * measurement data. The data you share (including information about the
     * property from which it is shared) is aggregated and de-identified before
     * being used to generate business insights.
     * This field maps to the "Modeling contributions & business insights" field
     * in the Google Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_others_enabled = 6;</code>
     * @return bool
     */
    public function getSharingWithOthersEnabled()
    {
        return $this->sharing_with_others_enabled;
    }

    /**
     * Enable features like predictions, modeled data, and benchmarking that can
     * provide you with richer business insights when you contribute aggregated
     * measurement data. The data you share (including information about the
     * property from which it is shared) is aggregated and de-identified before
     * being used to generate business insights.
     * This field maps to the "Modeling contributions & business insights" field
     * in the Google Analytics Admin UI.
     *
     * Generated from protobuf field <code>bool sharing_with_others_enabled = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setSharingWithOthersEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->sharing_with_others_enabled = $var;

        return $this;
    }

}

