<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/google/googleapis/blob/master/google/storagetransfer/v1/transfer.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\StorageTransfer\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;

use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\StorageTransfer\V1\CreateTransferJobRequest;
use Google\Cloud\StorageTransfer\V1\GetGoogleServiceAccountRequest;
use Google\Cloud\StorageTransfer\V1\GetTransferJobRequest;
use Google\Cloud\StorageTransfer\V1\GoogleServiceAccount;
use Google\Cloud\StorageTransfer\V1\ListTransferJobsRequest;
use Google\Cloud\StorageTransfer\V1\ListTransferJobsResponse;
use Google\Cloud\StorageTransfer\V1\PauseTransferOperationRequest;
use Google\Cloud\StorageTransfer\V1\ResumeTransferOperationRequest;
use Google\Cloud\StorageTransfer\V1\RunTransferJobRequest;
use Google\Cloud\StorageTransfer\V1\TransferJob;
use Google\Cloud\StorageTransfer\V1\TransferOperation;
use Google\Cloud\StorageTransfer\V1\UpdateTransferJobRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Storage Transfer Service and its protos.
 * Transfers data between between Google Cloud Storage buckets or from a data
 * source external to Google to a Cloud Storage bucket.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $storageTransferServiceClient = new StorageTransferServiceClient();
 * try {
 *     $transferJob = new TransferJob();
 *     $response = $storageTransferServiceClient->createTransferJob($transferJob);
 * } finally {
 *     $storageTransferServiceClient->close();
 * }
 * ```
 */
class StorageTransferServiceGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.storagetransfer.v1.StorageTransferService';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'storagetransfer.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/storage_transfer_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/storage_transfer_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/storage_transfer_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/storage_transfer_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'storagetransfer.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a transfer job that runs periodically.
     *
     * Sample code:
     * ```
     * $storageTransferServiceClient = new StorageTransferServiceClient();
     * try {
     *     $transferJob = new TransferJob();
     *     $response = $storageTransferServiceClient->createTransferJob($transferJob);
     * } finally {
     *     $storageTransferServiceClient->close();
     * }
     * ```
     *
     * @param TransferJob $transferJob  Required. The job to create.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\StorageTransfer\V1\TransferJob
     *
     * @throws ApiException if the remote call fails
     */
    public function createTransferJob($transferJob, array $optionalArgs = [])
    {
        $request = new CreateTransferJobRequest();
        $request->setTransferJob($transferJob);
        return $this->startCall(
            'CreateTransferJob',
            TransferJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the Google service account that is used by Storage Transfer
     * Service to access buckets in the project where transfers
     * run or in other projects. Each Google service account is associated
     * with one Google Cloud Platform Console project. Users
     * should add this service account to the Google Cloud Storage bucket
     * ACLs to grant access to Storage Transfer Service. This service
     * account is created and owned by Storage Transfer Service and can
     * only be used by Storage Transfer Service.
     *
     * Sample code:
     * ```
     * $storageTransferServiceClient = new StorageTransferServiceClient();
     * try {
     *     $projectId = 'project_id';
     *     $response = $storageTransferServiceClient->getGoogleServiceAccount($projectId);
     * } finally {
     *     $storageTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. The ID of the Google Cloud Platform Console project that the
     *                             Google service account is associated with.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\StorageTransfer\V1\GoogleServiceAccount
     *
     * @throws ApiException if the remote call fails
     */
    public function getGoogleServiceAccount(
        $projectId,
        array $optionalArgs = []
    ) {
        $request = new GetGoogleServiceAccountRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $requestParamHeaders['project_id'] = $projectId;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetGoogleServiceAccount',
            GoogleServiceAccount::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a transfer job.
     *
     * Sample code:
     * ```
     * $storageTransferServiceClient = new StorageTransferServiceClient();
     * try {
     *     $jobName = 'job_name';
     *     $projectId = 'project_id';
     *     $response = $storageTransferServiceClient->getTransferJob($jobName, $projectId);
     * } finally {
     *     $storageTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $jobName      Required.
     *                             The job to get.
     * @param string $projectId    Required. The ID of the Google Cloud Platform Console project that owns the
     *                             job.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\StorageTransfer\V1\TransferJob
     *
     * @throws ApiException if the remote call fails
     */
    public function getTransferJob(
        $jobName,
        $projectId,
        array $optionalArgs = []
    ) {
        $request = new GetTransferJobRequest();
        $requestParamHeaders = [];
        $request->setJobName($jobName);
        $request->setProjectId($projectId);
        $requestParamHeaders['job_name'] = $jobName;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTransferJob',
            TransferJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists transfer jobs.
     *
     * Sample code:
     * ```
     * $storageTransferServiceClient = new StorageTransferServiceClient();
     * try {
     *     $filter = 'filter';
     *     // Iterate over pages of elements
     *     $pagedResponse = $storageTransferServiceClient->listTransferJobs($filter);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $storageTransferServiceClient->listTransferJobs($filter);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $storageTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $filter       Required. A list of query parameters specified as JSON text in the form of:
     *                             `{"projectId":"my_project_id",
     *                             "jobNames":["jobid1","jobid2",...],
     *                             "jobStatuses":["status1","status2",...]}`
     *
     *                             Since `jobNames` and `jobStatuses` support multiple values, their values
     *                             must be specified with array notation. `projectId` is required.
     *                             `jobNames` and `jobStatuses` are optional.  The valid values for
     *                             `jobStatuses` are case-insensitive:
     *                             [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
     *                             [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
     *                             [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTransferJobs($filter, array $optionalArgs = [])
    {
        $request = new ListTransferJobsRequest();
        $request->setFilter($filter);
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        return $this->getPagedListResponse(
            'ListTransferJobs',
            $optionalArgs,
            ListTransferJobsResponse::class,
            $request
        );
    }

    /**
     * Pauses a transfer operation.
     *
     * Sample code:
     * ```
     * $storageTransferServiceClient = new StorageTransferServiceClient();
     * try {
     *     $name = 'name';
     *     $storageTransferServiceClient->pauseTransferOperation($name);
     * } finally {
     *     $storageTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the transfer operation.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function pauseTransferOperation($name, array $optionalArgs = [])
    {
        $request = new PauseTransferOperationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'PauseTransferOperation',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Resumes a transfer operation that is paused.
     *
     * Sample code:
     * ```
     * $storageTransferServiceClient = new StorageTransferServiceClient();
     * try {
     *     $name = 'name';
     *     $storageTransferServiceClient->resumeTransferOperation($name);
     * } finally {
     *     $storageTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the transfer operation.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function resumeTransferOperation($name, array $optionalArgs = [])
    {
        $request = new ResumeTransferOperationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ResumeTransferOperation',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Attempts to start a new TransferOperation for the current TransferJob. A
     * TransferJob has a maximum of one active TransferOperation. If this method
     * is called while a TransferOperation is active, an error wil be returned.
     *
     * Sample code:
     * ```
     * $storageTransferServiceClient = new StorageTransferServiceClient();
     * try {
     *     $jobName = 'job_name';
     *     $projectId = 'project_id';
     *     $operationResponse = $storageTransferServiceClient->runTransferJob($jobName, $projectId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $storageTransferServiceClient->runTransferJob($jobName, $projectId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $storageTransferServiceClient->resumeOperation($operationName, 'runTransferJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $storageTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $jobName      Required. The name of the transfer job.
     * @param string $projectId    Required. The ID of the Google Cloud Platform Console project that owns the
     *                             transfer job.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function runTransferJob(
        $jobName,
        $projectId,
        array $optionalArgs = []
    ) {
        $request = new RunTransferJobRequest();
        $requestParamHeaders = [];
        $request->setJobName($jobName);
        $request->setProjectId($projectId);
        $requestParamHeaders['job_name'] = $jobName;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'RunTransferJob',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a transfer job. Updating a job's transfer spec does not affect
     * transfer operations that are running already.
     *
     * **Note:** The job's [status][google.storagetransfer.v1.TransferJob.status]
     * field can be modified using this RPC (for example, to set a job's status to
     * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED],
     * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], or
     * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED]).
     *
     * Sample code:
     * ```
     * $storageTransferServiceClient = new StorageTransferServiceClient();
     * try {
     *     $jobName = 'job_name';
     *     $projectId = 'project_id';
     *     $transferJob = new TransferJob();
     *     $response = $storageTransferServiceClient->updateTransferJob($jobName, $projectId, $transferJob);
     * } finally {
     *     $storageTransferServiceClient->close();
     * }
     * ```
     *
     * @param string      $jobName      Required. The name of job to update.
     * @param string      $projectId    Required. The ID of the Google Cloud Platform Console project that owns the
     *                                  job.
     * @param TransferJob $transferJob  Required. The job to update. `transferJob` is expected to specify only
     *                                  four fields:
     *                                  [description][google.storagetransfer.v1.TransferJob.description],
     *                                  [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     *                                  [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     *                                  and [status][google.storagetransfer.v1.TransferJob.status].  An
     *                                  `UpdateTransferJobRequest` that specifies other fields are rejected with
     *                                  the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a
     *                                  job status to
     *                                  [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
     *                                  `storagetransfer.jobs.delete` permissions.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateTransferJobFieldMask
     *           The field mask of the fields in `transferJob` that are to be updated in
     *           this request.  Fields in `transferJob` that can be updated are:
     *           [description][google.storagetransfer.v1.TransferJob.description],
     *           [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     *           [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     *           and [status][google.storagetransfer.v1.TransferJob.status].  To update the
     *           `transfer_spec` of the job, a complete transfer specification must be
     *           provided. An incomplete specification missing any required fields is
     *           rejected with the error
     *           [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\StorageTransfer\V1\TransferJob
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTransferJob(
        $jobName,
        $projectId,
        $transferJob,
        array $optionalArgs = []
    ) {
        $request = new UpdateTransferJobRequest();
        $requestParamHeaders = [];
        $request->setJobName($jobName);
        $request->setProjectId($projectId);
        $request->setTransferJob($transferJob);
        $requestParamHeaders['job_name'] = $jobName;
        if (isset($optionalArgs['updateTransferJobFieldMask'])) {
            $request->setUpdateTransferJobFieldMask(
                $optionalArgs['updateTransferJobFieldMask']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateTransferJob',
            TransferJob::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
