<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/messages.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A structured message reporting an autoscaling decision made by the Dataflow
 * service.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.AutoscalingEvent</code>
 */
class AutoscalingEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * The current number of workers the job has.
     *
     * Generated from protobuf field <code>int64 current_num_workers = 1;</code>
     */
    private $current_num_workers = 0;
    /**
     * The target number of workers the worker pool wants to resize to use.
     *
     * Generated from protobuf field <code>int64 target_num_workers = 2;</code>
     */
    private $target_num_workers = 0;
    /**
     * The type of autoscaling event to report.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.AutoscalingEvent.AutoscalingEventType event_type = 3;</code>
     */
    private $event_type = 0;
    /**
     * A message describing why the system decided to adjust the current
     * number of workers, why it failed, or why the system decided to
     * not make any changes to the number of workers.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.StructuredMessage description = 4;</code>
     */
    private $description = null;
    /**
     * The time this event was emitted to indicate a new target or current
     * num_workers value.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp time = 5;</code>
     */
    private $time = null;
    /**
     * A short and friendly name for the worker pool this event refers to,
     * populated from the value of PoolStageRelation::user_pool_name.
     *
     * Generated from protobuf field <code>string worker_pool = 7;</code>
     */
    private $worker_pool = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $current_num_workers
     *           The current number of workers the job has.
     *     @type int|string $target_num_workers
     *           The target number of workers the worker pool wants to resize to use.
     *     @type int $event_type
     *           The type of autoscaling event to report.
     *     @type \Google\Cloud\Dataflow\V1beta3\StructuredMessage $description
     *           A message describing why the system decided to adjust the current
     *           number of workers, why it failed, or why the system decided to
     *           not make any changes to the number of workers.
     *     @type \Google\Protobuf\Timestamp $time
     *           The time this event was emitted to indicate a new target or current
     *           num_workers value.
     *     @type string $worker_pool
     *           A short and friendly name for the worker pool this event refers to,
     *           populated from the value of PoolStageRelation::user_pool_name.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Messages::initOnce();
        parent::__construct($data);
    }

    /**
     * The current number of workers the job has.
     *
     * Generated from protobuf field <code>int64 current_num_workers = 1;</code>
     * @return int|string
     */
    public function getCurrentNumWorkers()
    {
        return $this->current_num_workers;
    }

    /**
     * The current number of workers the job has.
     *
     * Generated from protobuf field <code>int64 current_num_workers = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setCurrentNumWorkers($var)
    {
        GPBUtil::checkInt64($var);
        $this->current_num_workers = $var;

        return $this;
    }

    /**
     * The target number of workers the worker pool wants to resize to use.
     *
     * Generated from protobuf field <code>int64 target_num_workers = 2;</code>
     * @return int|string
     */
    public function getTargetNumWorkers()
    {
        return $this->target_num_workers;
    }

    /**
     * The target number of workers the worker pool wants to resize to use.
     *
     * Generated from protobuf field <code>int64 target_num_workers = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTargetNumWorkers($var)
    {
        GPBUtil::checkInt64($var);
        $this->target_num_workers = $var;

        return $this;
    }

    /**
     * The type of autoscaling event to report.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.AutoscalingEvent.AutoscalingEventType event_type = 3;</code>
     * @return int
     */
    public function getEventType()
    {
        return $this->event_type;
    }

    /**
     * The type of autoscaling event to report.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.AutoscalingEvent.AutoscalingEventType event_type = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setEventType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataflow\V1beta3\AutoscalingEvent\AutoscalingEventType::class);
        $this->event_type = $var;

        return $this;
    }

    /**
     * A message describing why the system decided to adjust the current
     * number of workers, why it failed, or why the system decided to
     * not make any changes to the number of workers.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.StructuredMessage description = 4;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\StructuredMessage|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * A message describing why the system decided to adjust the current
     * number of workers, why it failed, or why the system decided to
     * not make any changes to the number of workers.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.StructuredMessage description = 4;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\StructuredMessage $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\StructuredMessage::class);
        $this->description = $var;

        return $this;
    }

    /**
     * The time this event was emitted to indicate a new target or current
     * num_workers value.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getTime()
    {
        return isset($this->time) ? $this->time : null;
    }

    public function hasTime()
    {
        return isset($this->time);
    }

    public function clearTime()
    {
        unset($this->time);
    }

    /**
     * The time this event was emitted to indicate a new target or current
     * num_workers value.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->time = $var;

        return $this;
    }

    /**
     * A short and friendly name for the worker pool this event refers to,
     * populated from the value of PoolStageRelation::user_pool_name.
     *
     * Generated from protobuf field <code>string worker_pool = 7;</code>
     * @return string
     */
    public function getWorkerPool()
    {
        return $this->worker_pool;
    }

    /**
     * A short and friendly name for the worker pool this event refers to,
     * populated from the value of PoolStageRelation::user_pool_name.
     *
     * Generated from protobuf field <code>string worker_pool = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setWorkerPool($var)
    {
        GPBUtil::checkString($var, True);
        $this->worker_pool = $var;

        return $this;
    }

}

