<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Backend Service resource.
 * A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly.
 * Backend services in Google Compute Engine can be either regionally or globally scoped.
 * * [Global](/compute/docs/reference/rest/{$api_version}/backendServices) * [Regional](https://cloud.google.com/compute/docs/reference/rest/{$api_version}/regionBackendServices)
 * For more information, see Backend Services.
 * (== resource_for {$api_version}.backendService ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.BackendService</code>
 */
class BackendService extends \Google\Protobuf\Internal\Message
{
    /**
     * Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
     * If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>int32 affinity_cookie_ttl_sec = 369996954;</code>
     */
    private $affinity_cookie_ttl_sec = null;
    /**
     * The list of backends that serve this BackendService.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    private $backends;
    /**
     * Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
     */
    private $cdn_policy = null;
    /**
     * Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    private $circuit_breakers = null;
    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;</code>
     */
    private $connection_draining = null;
    /**
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;</code>
     */
    private $consistent_hash = null;
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = null;
    /**
     * Headers that the HTTP/S load balancer should add to proxied requests.
     *
     * Generated from protobuf field <code>repeated string custom_request_headers = 27977992;</code>
     */
    private $custom_request_headers;
    /**
     * Headers that the HTTP/S load balancer should add to proxied responses.
     *
     * Generated from protobuf field <code>repeated string custom_response_headers = 387539094;</code>
     */
    private $custom_response_headers;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 422937596;</code>
     */
    private $description = null;
    /**
     * If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
     *
     * Generated from protobuf field <code>bool enable_c_d_n = 250733499;</code>
     */
    private $enable_c_d_n = null;
    /**
     * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;</code>
     */
    private $failover_policy = null;
    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a BackendService.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     */
    private $fingerprint = null;
    /**
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     *
     * Generated from protobuf field <code>repeated string health_checks = 448370606;</code>
     */
    private $health_checks;
    /**
     * The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    private $iap = null;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>uint64 id = 3355;</code>
     */
    private $id = null;
    /**
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = null;
    /**
     * Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.LoadBalancingScheme load_balancing_scheme = 363890244;</code>
     */
    private $load_balancing_scheme = null;
    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are:
     * - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
     * - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
     * - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
     * - RANDOM: The load balancer selects a random healthy host.
     * - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
     * - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
     * Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.LocalityLbPolicy locality_lb_policy = 131431487;</code>
     */
    private $locality_lb_policy = null;
    /**
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
     */
    private $log_config = null;
    /**
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
     * If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
     * This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    private $max_stream_duration = null;
    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = null;
    /**
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     *
     * Generated from protobuf field <code>string network = 232872494;</code>
     */
    private $network = null;
    /**
     * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
     */
    private $outlier_detection = null;
    /**
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.
     * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
     *
     * Generated from protobuf field <code>int32 port = 3446913;</code>
     */
    private $port = null;
    /**
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.
     * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
     *
     * Generated from protobuf field <code>string port_name = 41534345;</code>
     */
    private $port_name = null;
    /**
     * The protocol this BackendService uses to communicate with backends.
     * Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
     * Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.Protocol protocol = 84577944;</code>
     */
    private $protocol = null;
    /**
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     */
    private $region = null;
    /**
     * [Output Only] The resource URL for the security policy associated with this backend service.
     *
     * Generated from protobuf field <code>string security_policy = 171082513;</code>
     */
    private $security_policy = null;
    /**
     * This field specifies the security policy that applies to this backend service. This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
     */
    private $security_settings = null;
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 456214797;</code>
     */
    private $self_link = null;
    /**
     * Type of session affinity to use. The default is NONE.
     * When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
     * When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
     * When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.SessionAffinity session_affinity = 463888561;</code>
     */
    private $session_affinity = null;
    /**
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
     *
     * Generated from protobuf field <code>int32 timeout_sec = 79994995;</code>
     */
    private $timeout_sec = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $affinity_cookie_ttl_sec
     *           Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
     *           If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
     *           Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *     @type \Google\Cloud\Compute\V1\Backend[]|\Google\Protobuf\Internal\RepeatedField $backends
     *           The list of backends that serve this BackendService.
     *     @type \Google\Cloud\Compute\V1\BackendServiceCdnPolicy $cdn_policy
     *           Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
     *     @type \Google\Cloud\Compute\V1\CircuitBreakers $circuit_breakers
     *           Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.
     *           This field is applicable to either:
     *           - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     *           - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *           Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *     @type \Google\Cloud\Compute\V1\ConnectionDraining $connection_draining
     *     @type \Google\Cloud\Compute\V1\ConsistentHashLoadBalancerSettings $consistent_hash
     *           Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.
     *           This field is applicable to either:
     *           - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     *           - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *           Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $custom_request_headers
     *           Headers that the HTTP/S load balancer should add to proxied requests.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $custom_response_headers
     *           Headers that the HTTP/S load balancer should add to proxied responses.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type bool $enable_c_d_n
     *           If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
     *     @type \Google\Cloud\Compute\V1\BackendServiceFailoverPolicy $failover_policy
     *           Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
     *     @type string $fingerprint
     *           Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.
     *           To see the latest fingerprint, make a get() request to retrieve a BackendService.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $health_checks
     *           The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     *     @type \Google\Cloud\Compute\V1\BackendServiceIAP $iap
     *           The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
     *     @type int|string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $kind
     *           [Output Only] Type of resource. Always compute#backendService for backend services.
     *     @type int $load_balancing_scheme
     *           Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     *     @type int $locality_lb_policy
     *           The load balancing algorithm used within the scope of the locality. The possible values are:
     *           - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
     *           - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
     *           - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
     *           - RANDOM: The load balancer selects a random healthy host.
     *           - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
     *           - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
     *           This field is applicable to either:
     *           - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     *           - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *           If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
     *           Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *     @type \Google\Cloud\Compute\V1\BackendServiceLogConfig $log_config
     *           This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     *     @type \Google\Cloud\Compute\V1\Duration $max_stream_duration
     *           Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
     *           If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
     *           This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $network
     *           The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     *     @type \Google\Cloud\Compute\V1\OutlierDetection $outlier_detection
     *           Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.
     *           This field is applicable to either:
     *           - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     *           - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *           Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *     @type int $port
     *           Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.
     *           Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
     *     @type string $port_name
     *           A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.
     *           Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
     *     @type int $protocol
     *           The protocol this BackendService uses to communicate with backends.
     *           Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
     *           Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     *     @type string $region
     *           [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *     @type string $security_policy
     *           [Output Only] The resource URL for the security policy associated with this backend service.
     *     @type \Google\Cloud\Compute\V1\SecuritySettings $security_settings
     *           This field specifies the security policy that applies to this backend service. This field is applicable to either:
     *           - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     *           - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type int $session_affinity
     *           Type of session affinity to use. The default is NONE.
     *           When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
     *           When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
     *           When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
     *           Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *     @type int $timeout_sec
     *           The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
     * If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>int32 affinity_cookie_ttl_sec = 369996954;</code>
     * @return int
     */
    public function getAffinityCookieTtlSec()
    {
        return isset($this->affinity_cookie_ttl_sec) ? $this->affinity_cookie_ttl_sec : 0;
    }

    public function hasAffinityCookieTtlSec()
    {
        return isset($this->affinity_cookie_ttl_sec);
    }

    public function clearAffinityCookieTtlSec()
    {
        unset($this->affinity_cookie_ttl_sec);
    }

    /**
     * Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
     * If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>int32 affinity_cookie_ttl_sec = 369996954;</code>
     * @param int $var
     * @return $this
     */
    public function setAffinityCookieTtlSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->affinity_cookie_ttl_sec = $var;

        return $this;
    }

    /**
     * The list of backends that serve this BackendService.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBackends()
    {
        return $this->backends;
    }

    /**
     * The list of backends that serve this BackendService.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     * @param \Google\Cloud\Compute\V1\Backend[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBackends($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\Backend::class);
        $this->backends = $arr;

        return $this;
    }

    /**
     * Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceCdnPolicy|null
     */
    public function getCdnPolicy()
    {
        return isset($this->cdn_policy) ? $this->cdn_policy : null;
    }

    public function hasCdnPolicy()
    {
        return isset($this->cdn_policy);
    }

    public function clearCdnPolicy()
    {
        unset($this->cdn_policy);
    }

    /**
     * Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceCdnPolicy $var
     * @return $this
     */
    public function setCdnPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceCdnPolicy::class);
        $this->cdn_policy = $var;

        return $this;
    }

    /**
     * Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     * @return \Google\Cloud\Compute\V1\CircuitBreakers|null
     */
    public function getCircuitBreakers()
    {
        return isset($this->circuit_breakers) ? $this->circuit_breakers : null;
    }

    public function hasCircuitBreakers()
    {
        return isset($this->circuit_breakers);
    }

    public function clearCircuitBreakers()
    {
        unset($this->circuit_breakers);
    }

    /**
     * Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     * @param \Google\Cloud\Compute\V1\CircuitBreakers $var
     * @return $this
     */
    public function setCircuitBreakers($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CircuitBreakers::class);
        $this->circuit_breakers = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;</code>
     * @return \Google\Cloud\Compute\V1\ConnectionDraining|null
     */
    public function getConnectionDraining()
    {
        return isset($this->connection_draining) ? $this->connection_draining : null;
    }

    public function hasConnectionDraining()
    {
        return isset($this->connection_draining);
    }

    public function clearConnectionDraining()
    {
        unset($this->connection_draining);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;</code>
     * @param \Google\Cloud\Compute\V1\ConnectionDraining $var
     * @return $this
     */
    public function setConnectionDraining($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ConnectionDraining::class);
        $this->connection_draining = $var;

        return $this;
    }

    /**
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;</code>
     * @return \Google\Cloud\Compute\V1\ConsistentHashLoadBalancerSettings|null
     */
    public function getConsistentHash()
    {
        return isset($this->consistent_hash) ? $this->consistent_hash : null;
    }

    public function hasConsistentHash()
    {
        return isset($this->consistent_hash);
    }

    public function clearConsistentHash()
    {
        unset($this->consistent_hash);
    }

    /**
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;</code>
     * @param \Google\Cloud\Compute\V1\ConsistentHashLoadBalancerSettings $var
     * @return $this
     */
    public function setConsistentHash($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ConsistentHashLoadBalancerSettings::class);
        $this->consistent_hash = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * Headers that the HTTP/S load balancer should add to proxied requests.
     *
     * Generated from protobuf field <code>repeated string custom_request_headers = 27977992;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomRequestHeaders()
    {
        return $this->custom_request_headers;
    }

    /**
     * Headers that the HTTP/S load balancer should add to proxied requests.
     *
     * Generated from protobuf field <code>repeated string custom_request_headers = 27977992;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomRequestHeaders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->custom_request_headers = $arr;

        return $this;
    }

    /**
     * Headers that the HTTP/S load balancer should add to proxied responses.
     *
     * Generated from protobuf field <code>repeated string custom_response_headers = 387539094;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomResponseHeaders()
    {
        return $this->custom_response_headers;
    }

    /**
     * Headers that the HTTP/S load balancer should add to proxied responses.
     *
     * Generated from protobuf field <code>repeated string custom_response_headers = 387539094;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomResponseHeaders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->custom_response_headers = $arr;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
     *
     * Generated from protobuf field <code>bool enable_c_d_n = 250733499;</code>
     * @return bool
     */
    public function getEnableCDN()
    {
        return isset($this->enable_c_d_n) ? $this->enable_c_d_n : false;
    }

    public function hasEnableCDN()
    {
        return isset($this->enable_c_d_n);
    }

    public function clearEnableCDN()
    {
        unset($this->enable_c_d_n);
    }

    /**
     * If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
     *
     * Generated from protobuf field <code>bool enable_c_d_n = 250733499;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableCDN($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_c_d_n = $var;

        return $this;
    }

    /**
     * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceFailoverPolicy|null
     */
    public function getFailoverPolicy()
    {
        return isset($this->failover_policy) ? $this->failover_policy : null;
    }

    public function hasFailoverPolicy()
    {
        return isset($this->failover_policy);
    }

    public function clearFailoverPolicy()
    {
        unset($this->failover_policy);
    }

    /**
     * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceFailoverPolicy $var
     * @return $this
     */
    public function setFailoverPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceFailoverPolicy::class);
        $this->failover_policy = $var;

        return $this;
    }

    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a BackendService.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     * @return string
     */
    public function getFingerprint()
    {
        return isset($this->fingerprint) ? $this->fingerprint : '';
    }

    public function hasFingerprint()
    {
        return isset($this->fingerprint);
    }

    public function clearFingerprint()
    {
        unset($this->fingerprint);
    }

    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a BackendService.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     * @param string $var
     * @return $this
     */
    public function setFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->fingerprint = $var;

        return $this;
    }

    /**
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     *
     * Generated from protobuf field <code>repeated string health_checks = 448370606;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHealthChecks()
    {
        return $this->health_checks;
    }

    /**
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     *
     * Generated from protobuf field <code>repeated string health_checks = 448370606;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHealthChecks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->health_checks = $arr;

        return $this;
    }

    /**
     * The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceIAP|null
     */
    public function getIap()
    {
        return isset($this->iap) ? $this->iap : null;
    }

    public function hasIap()
    {
        return isset($this->iap);
    }

    public function clearIap()
    {
        unset($this->iap);
    }

    /**
     * The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceIAP $var
     * @return $this
     */
    public function setIap($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceIAP::class);
        $this->iap = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.LoadBalancingScheme load_balancing_scheme = 363890244;</code>
     * @return int
     */
    public function getLoadBalancingScheme()
    {
        return isset($this->load_balancing_scheme) ? $this->load_balancing_scheme : 0;
    }

    public function hasLoadBalancingScheme()
    {
        return isset($this->load_balancing_scheme);
    }

    public function clearLoadBalancingScheme()
    {
        unset($this->load_balancing_scheme);
    }

    /**
     * Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.LoadBalancingScheme load_balancing_scheme = 363890244;</code>
     * @param int $var
     * @return $this
     */
    public function setLoadBalancingScheme($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\BackendService\LoadBalancingScheme::class);
        $this->load_balancing_scheme = $var;

        return $this;
    }

    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are:
     * - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
     * - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
     * - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
     * - RANDOM: The load balancer selects a random healthy host.
     * - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
     * - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
     * Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.LocalityLbPolicy locality_lb_policy = 131431487;</code>
     * @return int
     */
    public function getLocalityLbPolicy()
    {
        return isset($this->locality_lb_policy) ? $this->locality_lb_policy : 0;
    }

    public function hasLocalityLbPolicy()
    {
        return isset($this->locality_lb_policy);
    }

    public function clearLocalityLbPolicy()
    {
        unset($this->locality_lb_policy);
    }

    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are:
     * - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
     * - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
     * - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
     * - RANDOM: The load balancer selects a random healthy host.
     * - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
     * - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
     * Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.LocalityLbPolicy locality_lb_policy = 131431487;</code>
     * @param int $var
     * @return $this
     */
    public function setLocalityLbPolicy($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\BackendService\LocalityLbPolicy::class);
        $this->locality_lb_policy = $var;

        return $this;
    }

    /**
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceLogConfig|null
     */
    public function getLogConfig()
    {
        return isset($this->log_config) ? $this->log_config : null;
    }

    public function hasLogConfig()
    {
        return isset($this->log_config);
    }

    public function clearLogConfig()
    {
        unset($this->log_config);
    }

    /**
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceLogConfig $var
     * @return $this
     */
    public function setLogConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceLogConfig::class);
        $this->log_config = $var;

        return $this;
    }

    /**
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
     * If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
     * This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     * @return \Google\Cloud\Compute\V1\Duration|null
     */
    public function getMaxStreamDuration()
    {
        return isset($this->max_stream_duration) ? $this->max_stream_duration : null;
    }

    public function hasMaxStreamDuration()
    {
        return isset($this->max_stream_duration);
    }

    public function clearMaxStreamDuration()
    {
        unset($this->max_stream_duration);
    }

    /**
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
     * If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
     * This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     * @param \Google\Cloud\Compute\V1\Duration $var
     * @return $this
     */
    public function setMaxStreamDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Duration::class);
        $this->max_stream_duration = $var;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     *
     * Generated from protobuf field <code>string network = 232872494;</code>
     * @return string
     */
    public function getNetwork()
    {
        return isset($this->network) ? $this->network : '';
    }

    public function hasNetwork()
    {
        return isset($this->network);
    }

    public function clearNetwork()
    {
        unset($this->network);
    }

    /**
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     *
     * Generated from protobuf field <code>string network = 232872494;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
     * @return \Google\Cloud\Compute\V1\OutlierDetection|null
     */
    public function getOutlierDetection()
    {
        return isset($this->outlier_detection) ? $this->outlier_detection : null;
    }

    public function hasOutlierDetection()
    {
        return isset($this->outlier_detection);
    }

    public function clearOutlierDetection()
    {
        unset($this->outlier_detection);
    }

    /**
     * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.
     * This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
     * @param \Google\Cloud\Compute\V1\OutlierDetection $var
     * @return $this
     */
    public function setOutlierDetection($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\OutlierDetection::class);
        $this->outlier_detection = $var;

        return $this;
    }

    /**
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.
     * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
     *
     * Generated from protobuf field <code>int32 port = 3446913;</code>
     * @return int
     */
    public function getPort()
    {
        return isset($this->port) ? $this->port : 0;
    }

    public function hasPort()
    {
        return isset($this->port);
    }

    public function clearPort()
    {
        unset($this->port);
    }

    /**
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.
     * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
     *
     * Generated from protobuf field <code>int32 port = 3446913;</code>
     * @param int $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->port = $var;

        return $this;
    }

    /**
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.
     * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
     *
     * Generated from protobuf field <code>string port_name = 41534345;</code>
     * @return string
     */
    public function getPortName()
    {
        return isset($this->port_name) ? $this->port_name : '';
    }

    public function hasPortName()
    {
        return isset($this->port_name);
    }

    public function clearPortName()
    {
        unset($this->port_name);
    }

    /**
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.
     * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
     *
     * Generated from protobuf field <code>string port_name = 41534345;</code>
     * @param string $var
     * @return $this
     */
    public function setPortName($var)
    {
        GPBUtil::checkString($var, True);
        $this->port_name = $var;

        return $this;
    }

    /**
     * The protocol this BackendService uses to communicate with backends.
     * Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
     * Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.Protocol protocol = 84577944;</code>
     * @return int
     */
    public function getProtocol()
    {
        return isset($this->protocol) ? $this->protocol : 0;
    }

    public function hasProtocol()
    {
        return isset($this->protocol);
    }

    public function clearProtocol()
    {
        unset($this->protocol);
    }

    /**
     * The protocol this BackendService uses to communicate with backends.
     * Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
     * Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.Protocol protocol = 84577944;</code>
     * @param int $var
     * @return $this
     */
    public function setProtocol($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\BackendService\Protocol::class);
        $this->protocol = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : '';
    }

    public function hasRegion()
    {
        return isset($this->region);
    }

    public function clearRegion()
    {
        unset($this->region);
    }

    /**
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * [Output Only] The resource URL for the security policy associated with this backend service.
     *
     * Generated from protobuf field <code>string security_policy = 171082513;</code>
     * @return string
     */
    public function getSecurityPolicy()
    {
        return isset($this->security_policy) ? $this->security_policy : '';
    }

    public function hasSecurityPolicy()
    {
        return isset($this->security_policy);
    }

    public function clearSecurityPolicy()
    {
        unset($this->security_policy);
    }

    /**
     * [Output Only] The resource URL for the security policy associated with this backend service.
     *
     * Generated from protobuf field <code>string security_policy = 171082513;</code>
     * @param string $var
     * @return $this
     */
    public function setSecurityPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->security_policy = $var;

        return $this;
    }

    /**
     * This field specifies the security policy that applies to this backend service. This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
     * @return \Google\Cloud\Compute\V1\SecuritySettings|null
     */
    public function getSecuritySettings()
    {
        return isset($this->security_settings) ? $this->security_settings : null;
    }

    public function hasSecuritySettings()
    {
        return isset($this->security_settings);
    }

    public function clearSecuritySettings()
    {
        unset($this->security_settings);
    }

    /**
     * This field specifies the security policy that applies to this backend service. This field is applicable to either:
     * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
     * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
     * @param \Google\Cloud\Compute\V1\SecuritySettings $var
     * @return $this
     */
    public function setSecuritySettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\SecuritySettings::class);
        $this->security_settings = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Type of session affinity to use. The default is NONE.
     * When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
     * When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
     * When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.SessionAffinity session_affinity = 463888561;</code>
     * @return int
     */
    public function getSessionAffinity()
    {
        return isset($this->session_affinity) ? $this->session_affinity : 0;
    }

    public function hasSessionAffinity()
    {
        return isset($this->session_affinity);
    }

    public function clearSessionAffinity()
    {
        unset($this->session_affinity);
    }

    /**
     * Type of session affinity to use. The default is NONE.
     * When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
     * When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
     * When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
     * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.BackendService.SessionAffinity session_affinity = 463888561;</code>
     * @param int $var
     * @return $this
     */
    public function setSessionAffinity($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\BackendService\SessionAffinity::class);
        $this->session_affinity = $var;

        return $this;
    }

    /**
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
     *
     * Generated from protobuf field <code>int32 timeout_sec = 79994995;</code>
     * @return int
     */
    public function getTimeoutSec()
    {
        return isset($this->timeout_sec) ? $this->timeout_sec : 0;
    }

    public function hasTimeoutSec()
    {
        return isset($this->timeout_sec);
    }

    public function clearTimeoutSec()
    {
        unset($this->timeout_sec);
    }

    /**
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
     *
     * Generated from protobuf field <code>int32 timeout_sec = 79994995;</code>
     * @param int $var
     * @return $this
     */
    public function setTimeoutSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->timeout_sec = $var;

        return $this;
    }

}

