<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/clouddms/v1/clouddms_resources.proto

namespace Google\Cloud\CloudDms\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies connection parameters required specifically for Oracle
 * databases.
 *
 * Generated from protobuf message <code>google.cloud.clouddms.v1.OracleConnectionProfile</code>
 */
class OracleConnectionProfile extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The IP or hostname of the source Oracle database.
     *
     * Generated from protobuf field <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $host = '';
    /**
     * Required. The network port of the source Oracle database.
     *
     * Generated from protobuf field <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $port = 0;
    /**
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     *
     * Generated from protobuf field <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $username = '';
    /**
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     *
     * Generated from protobuf field <code>string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     */
    private $password = '';
    /**
     * Output only. Indicates whether a new password is included in the request.
     *
     * Generated from protobuf field <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $password_set = false;
    /**
     * Required. Database service for the Oracle connection.
     *
     * Generated from protobuf field <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $database_service = '';
    protected $connectivity;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $host
     *           Required. The IP or hostname of the source Oracle database.
     *     @type int $port
     *           Required. The network port of the source Oracle database.
     *     @type string $username
     *           Required. The username that Database Migration Service will use to connect
     *           to the database. The value is encrypted when stored in Database Migration
     *           Service.
     *     @type string $password
     *           Required. Input only. The password for the user that Database Migration
     *           Service will be using to connect to the database. This field is not
     *           returned on request, and the value is encrypted when stored in Database
     *           Migration Service.
     *     @type bool $password_set
     *           Output only. Indicates whether a new password is included in the request.
     *     @type string $database_service
     *           Required. Database service for the Oracle connection.
     *     @type \Google\Cloud\CloudDms\V1\StaticServiceIpConnectivity $static_service_ip_connectivity
     *           Static Service IP connectivity.
     *     @type \Google\Cloud\CloudDms\V1\ForwardSshTunnelConnectivity $forward_ssh_connectivity
     *           Forward SSH tunnel connectivity.
     *     @type \Google\Cloud\CloudDms\V1\PrivateConnectivity $private_connectivity
     *           Private connectivity.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Clouddms\V1\ClouddmsResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The IP or hostname of the source Oracle database.
     *
     * Generated from protobuf field <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * Required. The IP or hostname of the source Oracle database.
     *
     * Generated from protobuf field <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setHost($var)
    {
        GPBUtil::checkString($var, True);
        $this->host = $var;

        return $this;
    }

    /**
     * Required. The network port of the source Oracle database.
     *
     * Generated from protobuf field <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * Required. The network port of the source Oracle database.
     *
     * Generated from protobuf field <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->port = $var;

        return $this;
    }

    /**
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     *
     * Generated from protobuf field <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     *
     * Generated from protobuf field <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setUsername($var)
    {
        GPBUtil::checkString($var, True);
        $this->username = $var;

        return $this;
    }

    /**
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     *
     * Generated from protobuf field <code>string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     *
     * Generated from protobuf field <code>string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPassword($var)
    {
        GPBUtil::checkString($var, True);
        $this->password = $var;

        return $this;
    }

    /**
     * Output only. Indicates whether a new password is included in the request.
     *
     * Generated from protobuf field <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getPasswordSet()
    {
        return $this->password_set;
    }

    /**
     * Output only. Indicates whether a new password is included in the request.
     *
     * Generated from protobuf field <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setPasswordSet($var)
    {
        GPBUtil::checkBool($var);
        $this->password_set = $var;

        return $this;
    }

    /**
     * Required. Database service for the Oracle connection.
     *
     * Generated from protobuf field <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDatabaseService()
    {
        return $this->database_service;
    }

    /**
     * Required. Database service for the Oracle connection.
     *
     * Generated from protobuf field <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabaseService($var)
    {
        GPBUtil::checkString($var, True);
        $this->database_service = $var;

        return $this;
    }

    /**
     * Static Service IP connectivity.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;</code>
     * @return \Google\Cloud\CloudDms\V1\StaticServiceIpConnectivity|null
     */
    public function getStaticServiceIpConnectivity()
    {
        return $this->readOneof(100);
    }

    public function hasStaticServiceIpConnectivity()
    {
        return $this->hasOneof(100);
    }

    /**
     * Static Service IP connectivity.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;</code>
     * @param \Google\Cloud\CloudDms\V1\StaticServiceIpConnectivity $var
     * @return $this
     */
    public function setStaticServiceIpConnectivity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\StaticServiceIpConnectivity::class);
        $this->writeOneof(100, $var);

        return $this;
    }

    /**
     * Forward SSH tunnel connectivity.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;</code>
     * @return \Google\Cloud\CloudDms\V1\ForwardSshTunnelConnectivity|null
     */
    public function getForwardSshConnectivity()
    {
        return $this->readOneof(101);
    }

    public function hasForwardSshConnectivity()
    {
        return $this->hasOneof(101);
    }

    /**
     * Forward SSH tunnel connectivity.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;</code>
     * @param \Google\Cloud\CloudDms\V1\ForwardSshTunnelConnectivity $var
     * @return $this
     */
    public function setForwardSshConnectivity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\ForwardSshTunnelConnectivity::class);
        $this->writeOneof(101, $var);

        return $this;
    }

    /**
     * Private connectivity.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     * @return \Google\Cloud\CloudDms\V1\PrivateConnectivity|null
     */
    public function getPrivateConnectivity()
    {
        return $this->readOneof(102);
    }

    public function hasPrivateConnectivity()
    {
        return $this->hasOneof(102);
    }

    /**
     * Private connectivity.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     * @param \Google\Cloud\CloudDms\V1\PrivateConnectivity $var
     * @return $this
     */
    public function setPrivateConnectivity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\PrivateConnectivity::class);
        $this->writeOneof(102, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getConnectivity()
    {
        return $this->whichOneof("connectivity");
    }

}

