<?php
/*
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataproc/v1/workflow_templates.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dataproc\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataproc\V1\CreateWorkflowTemplateRequest;
use Google\Cloud\Dataproc\V1\DeleteWorkflowTemplateRequest;
use Google\Cloud\Dataproc\V1\GetWorkflowTemplateRequest;
use Google\Cloud\Dataproc\V1\InstantiateInlineWorkflowTemplateRequest;
use Google\Cloud\Dataproc\V1\InstantiateWorkflowTemplateRequest;
use Google\Cloud\Dataproc\V1\ListWorkflowTemplatesRequest;
use Google\Cloud\Dataproc\V1\ListWorkflowTemplatesResponse;
use Google\Cloud\Dataproc\V1\UpdateWorkflowTemplateRequest;
use Google\Cloud\Dataproc\V1\WorkflowMetadata;
use Google\Cloud\Dataproc\V1\WorkflowTemplate;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: The API interface for managing Workflow Templates in the
 * Dataproc API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
 * try {
 *     $formattedParent = $workflowTemplateServiceClient->regionName('[PROJECT]', '[REGION]');
 *     $template = new WorkflowTemplate();
 *     $response = $workflowTemplateServiceClient->createWorkflowTemplate($formattedParent, $template);
 * } finally {
 *     $workflowTemplateServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Dataproc\V1\Client\WorkflowTemplateServiceClient} to use the new
 * surface.
 */
class WorkflowTemplateServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dataproc.v1.WorkflowTemplateService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'dataproc.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $clusterRegionNameTemplate;

    private static $locationNameTemplate;

    private static $nodeGroupNameTemplate;

    private static $projectLocationWorkflowTemplateNameTemplate;

    private static $projectRegionWorkflowTemplateNameTemplate;

    private static $regionNameTemplate;

    private static $serviceNameTemplate;

    private static $workflowTemplateNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/workflow_template_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/workflow_template_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/workflow_template_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/workflow_template_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getClusterRegionNameTemplate()
    {
        if (self::$clusterRegionNameTemplate == null) {
            self::$clusterRegionNameTemplate = new PathTemplate('projects/{project}/regions/{region}/clusters/{cluster}');
        }

        return self::$clusterRegionNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getNodeGroupNameTemplate()
    {
        if (self::$nodeGroupNameTemplate == null) {
            self::$nodeGroupNameTemplate = new PathTemplate('projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{node_group}');
        }

        return self::$nodeGroupNameTemplate;
    }

    private static function getProjectLocationWorkflowTemplateNameTemplate()
    {
        if (self::$projectLocationWorkflowTemplateNameTemplate == null) {
            self::$projectLocationWorkflowTemplateNameTemplate = new PathTemplate('projects/{project}/locations/{location}/workflowTemplates/{workflow_template}');
        }

        return self::$projectLocationWorkflowTemplateNameTemplate;
    }

    private static function getProjectRegionWorkflowTemplateNameTemplate()
    {
        if (self::$projectRegionWorkflowTemplateNameTemplate == null) {
            self::$projectRegionWorkflowTemplateNameTemplate = new PathTemplate('projects/{project}/regions/{region}/workflowTemplates/{workflow_template}');
        }

        return self::$projectRegionWorkflowTemplateNameTemplate;
    }

    private static function getRegionNameTemplate()
    {
        if (self::$regionNameTemplate == null) {
            self::$regionNameTemplate = new PathTemplate('projects/{project}/regions/{region}');
        }

        return self::$regionNameTemplate;
    }

    private static function getServiceNameTemplate()
    {
        if (self::$serviceNameTemplate == null) {
            self::$serviceNameTemplate = new PathTemplate('projects/{project}/locations/{location}/services/{service}');
        }

        return self::$serviceNameTemplate;
    }

    private static function getWorkflowTemplateNameTemplate()
    {
        if (self::$workflowTemplateNameTemplate == null) {
            self::$workflowTemplateNameTemplate = new PathTemplate('projects/{project}/regions/{region}/workflowTemplates/{workflow_template}');
        }

        return self::$workflowTemplateNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'clusterRegion' => self::getClusterRegionNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'nodeGroup' => self::getNodeGroupNameTemplate(),
                'projectLocationWorkflowTemplate' => self::getProjectLocationWorkflowTemplateNameTemplate(),
                'projectRegionWorkflowTemplate' => self::getProjectRegionWorkflowTemplateNameTemplate(),
                'region' => self::getRegionNameTemplate(),
                'service' => self::getServiceNameTemplate(),
                'workflowTemplate' => self::getWorkflowTemplateNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * cluster_region resource.
     *
     * @param string $project
     * @param string $region
     * @param string $cluster
     *
     * @return string The formatted cluster_region resource.
     */
    public static function clusterRegionName($project, $region, $cluster)
    {
        return self::getClusterRegionNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a node_group
     * resource.
     *
     * @param string $project
     * @param string $region
     * @param string $cluster
     * @param string $nodeGroup
     *
     * @return string The formatted node_group resource.
     */
    public static function nodeGroupName($project, $region, $cluster, $nodeGroup)
    {
        return self::getNodeGroupNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'cluster' => $cluster,
            'node_group' => $nodeGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_workflow_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workflowTemplate
     *
     * @return string The formatted project_location_workflow_template resource.
     */
    public static function projectLocationWorkflowTemplateName($project, $location, $workflowTemplate)
    {
        return self::getProjectLocationWorkflowTemplateNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'workflow_template' => $workflowTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_region_workflow_template resource.
     *
     * @param string $project
     * @param string $region
     * @param string $workflowTemplate
     *
     * @return string The formatted project_region_workflow_template resource.
     */
    public static function projectRegionWorkflowTemplateName($project, $region, $workflowTemplate)
    {
        return self::getProjectRegionWorkflowTemplateNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'workflow_template' => $workflowTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a region
     * resource.
     *
     * @param string $project
     * @param string $region
     *
     * @return string The formatted region resource.
     */
    public static function regionName($project, $region)
    {
        return self::getRegionNameTemplate()->render([
            'project' => $project,
            'region' => $region,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName($project, $location, $service)
    {
        return self::getServiceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * workflow_template resource.
     *
     * @param string $project
     * @param string $region
     * @param string $workflowTemplate
     *
     * @return string The formatted workflow_template resource.
     */
    public static function workflowTemplateName($project, $region, $workflowTemplate)
    {
        return self::getWorkflowTemplateNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'workflow_template' => $workflowTemplate,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - clusterRegion: projects/{project}/regions/{region}/clusters/{cluster}
     * - location: projects/{project}/locations/{location}
     * - nodeGroup: projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{node_group}
     * - projectLocationWorkflowTemplate: projects/{project}/locations/{location}/workflowTemplates/{workflow_template}
     * - projectRegionWorkflowTemplate: projects/{project}/regions/{region}/workflowTemplates/{workflow_template}
     * - region: projects/{project}/regions/{region}
     * - service: projects/{project}/locations/{location}/services/{service}
     * - workflowTemplate: projects/{project}/regions/{region}/workflowTemplates/{workflow_template}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataproc.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates new workflow template.
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $formattedParent = $workflowTemplateServiceClient->regionName('[PROJECT]', '[REGION]');
     *     $template = new WorkflowTemplate();
     *     $response = $workflowTemplateServiceClient->createWorkflowTemplate($formattedParent, $template);
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string           $parent       Required. The resource name of the region or location, as described
     *                                       in https://cloud.google.com/apis/design/resource_names.
     *
     *                                       * For `projects.regions.workflowTemplates.create`, the resource name of the
     *                                       region has the following format:
     *                                       `projects/{project_id}/regions/{region}`
     *
     *                                       * For `projects.locations.workflowTemplates.create`, the resource name of
     *                                       the location has the following format:
     *                                       `projects/{project_id}/locations/{location}`
     * @param WorkflowTemplate $template     Required. The Dataproc workflow template to create.
     * @param array            $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataproc\V1\WorkflowTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function createWorkflowTemplate($parent, $template, array $optionalArgs = [])
    {
        $request = new CreateWorkflowTemplateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTemplate($template);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateWorkflowTemplate', WorkflowTemplate::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a workflow template. It does not cancel in-progress workflows.
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $formattedName = $workflowTemplateServiceClient->workflowTemplateName('[PROJECT]', '[REGION]', '[WORKFLOW_TEMPLATE]');
     *     $workflowTemplateServiceClient->deleteWorkflowTemplate($formattedName);
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the workflow template, as described
     *                             in https://cloud.google.com/apis/design/resource_names.
     *
     *                             * For `projects.regions.workflowTemplates.delete`, the resource name
     *                             of the template has the following format:
     *                             `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     *
     *                             * For `projects.locations.workflowTemplates.instantiate`, the resource name
     *                             of the template has the following format:
     *                             `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $version
     *           Optional. The version of workflow template to delete. If specified,
     *           will only delete the template if the current server version matches
     *           specified version.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteWorkflowTemplate($name, array $optionalArgs = [])
    {
        $request = new DeleteWorkflowTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['version'])) {
            $request->setVersion($optionalArgs['version']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteWorkflowTemplate', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieves the latest workflow template.
     *
     * Can retrieve previously instantiated template by specifying optional
     * version parameter.
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $formattedName = $workflowTemplateServiceClient->workflowTemplateName('[PROJECT]', '[REGION]', '[WORKFLOW_TEMPLATE]');
     *     $response = $workflowTemplateServiceClient->getWorkflowTemplate($formattedName);
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the workflow template, as described
     *                             in https://cloud.google.com/apis/design/resource_names.
     *
     *                             * For `projects.regions.workflowTemplates.get`, the resource name of the
     *                             template has the following format:
     *                             `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     *
     *                             * For `projects.locations.workflowTemplates.get`, the resource name of the
     *                             template has the following format:
     *                             `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $version
     *           Optional. The version of workflow template to retrieve. Only previously
     *           instantiated versions can be retrieved.
     *
     *           If unspecified, retrieves the current version.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataproc\V1\WorkflowTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function getWorkflowTemplate($name, array $optionalArgs = [])
    {
        $request = new GetWorkflowTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['version'])) {
            $request->setVersion($optionalArgs['version']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetWorkflowTemplate', WorkflowTemplate::class, $optionalArgs, $request)->wait();
    }

    /**
     * Instantiates a template and begins execution.
     *
     * This method is equivalent to executing the sequence
     * [CreateWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.CreateWorkflowTemplate],
     * [InstantiateWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.InstantiateWorkflowTemplate],
     * [DeleteWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.DeleteWorkflowTemplate].
     *
     * The returned Operation can be used to track execution of
     * workflow by polling
     * [operations.get][google.longrunning.Operations.GetOperation].
     * The Operation will complete when entire workflow is finished.
     *
     * The running workflow can be aborted via
     * [operations.cancel][google.longrunning.Operations.CancelOperation].
     * This will cause any inflight jobs to be cancelled and workflow-owned
     * clusters to be deleted.
     *
     * The [Operation.metadata][google.longrunning.Operation.metadata] will be
     * [WorkflowMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#workflowmetadata).
     * Also see [Using
     * WorkflowMetadata](https://cloud.google.com/dataproc/docs/concepts/workflows/debugging#using_workflowmetadata).
     *
     * On successful completion,
     * [Operation.response][google.longrunning.Operation.response] will be
     * [Empty][google.protobuf.Empty].
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $formattedParent = $workflowTemplateServiceClient->regionName('[PROJECT]', '[REGION]');
     *     $template = new WorkflowTemplate();
     *     $operationResponse = $workflowTemplateServiceClient->instantiateInlineWorkflowTemplate($formattedParent, $template);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $workflowTemplateServiceClient->instantiateInlineWorkflowTemplate($formattedParent, $template);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $workflowTemplateServiceClient->resumeOperation($operationName, 'instantiateInlineWorkflowTemplate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string           $parent       Required. The resource name of the region or location, as described
     *                                       in https://cloud.google.com/apis/design/resource_names.
     *
     *                                       * For `projects.regions.workflowTemplates,instantiateinline`, the resource
     *                                       name of the region has the following format:
     *                                       `projects/{project_id}/regions/{region}`
     *
     *                                       * For `projects.locations.workflowTemplates.instantiateinline`, the
     *                                       resource name of the location has the following format:
     *                                       `projects/{project_id}/locations/{location}`
     * @param WorkflowTemplate $template     Required. The workflow template to instantiate.
     * @param array            $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A tag that prevents multiple concurrent workflow
     *           instances with the same tag from running. This mitigates risk of
     *           concurrent instances started due to retries.
     *
     *           It is recommended to always set this value to a
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     *           The tag must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function instantiateInlineWorkflowTemplate($parent, $template, array $optionalArgs = [])
    {
        $request = new InstantiateInlineWorkflowTemplateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTemplate($template);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('InstantiateInlineWorkflowTemplate', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Instantiates a template and begins execution.
     *
     * The returned Operation can be used to track execution of
     * workflow by polling
     * [operations.get][google.longrunning.Operations.GetOperation].
     * The Operation will complete when entire workflow is finished.
     *
     * The running workflow can be aborted via
     * [operations.cancel][google.longrunning.Operations.CancelOperation].
     * This will cause any inflight jobs to be cancelled and workflow-owned
     * clusters to be deleted.
     *
     * The [Operation.metadata][google.longrunning.Operation.metadata] will be
     * [WorkflowMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#workflowmetadata).
     * Also see [Using
     * WorkflowMetadata](https://cloud.google.com/dataproc/docs/concepts/workflows/debugging#using_workflowmetadata).
     *
     * On successful completion,
     * [Operation.response][google.longrunning.Operation.response] will be
     * [Empty][google.protobuf.Empty].
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $formattedName = $workflowTemplateServiceClient->workflowTemplateName('[PROJECT]', '[REGION]', '[WORKFLOW_TEMPLATE]');
     *     $operationResponse = $workflowTemplateServiceClient->instantiateWorkflowTemplate($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $workflowTemplateServiceClient->instantiateWorkflowTemplate($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $workflowTemplateServiceClient->resumeOperation($operationName, 'instantiateWorkflowTemplate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the workflow template, as described
     *                             in https://cloud.google.com/apis/design/resource_names.
     *
     *                             * For `projects.regions.workflowTemplates.instantiate`, the resource name
     *                             of the template has the following format:
     *                             `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     *
     *                             * For `projects.locations.workflowTemplates.instantiate`, the resource name
     *                             of the template has the following format:
     *                             `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $version
     *           Optional. The version of workflow template to instantiate. If specified,
     *           the workflow will be instantiated only if the current version of
     *           the workflow template has the supplied version.
     *
     *           This option cannot be used to instantiate a previous version of
     *           workflow template.
     *     @type string $requestId
     *           Optional. A tag that prevents multiple concurrent workflow
     *           instances with the same tag from running. This mitigates risk of
     *           concurrent instances started due to retries.
     *
     *           It is recommended to always set this value to a
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     *           The tag must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), and hyphens (-). The maximum length is 40 characters.
     *     @type array $parameters
     *           Optional. Map from parameter names to values that should be used for those
     *           parameters. Values may not exceed 1000 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function instantiateWorkflowTemplate($name, array $optionalArgs = [])
    {
        $request = new InstantiateWorkflowTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['version'])) {
            $request->setVersion($optionalArgs['version']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['parameters'])) {
            $request->setParameters($optionalArgs['parameters']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('InstantiateWorkflowTemplate', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Lists workflows that match the specified filter in the request.
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $formattedParent = $workflowTemplateServiceClient->regionName('[PROJECT]', '[REGION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $workflowTemplateServiceClient->listWorkflowTemplates($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $workflowTemplateServiceClient->listWorkflowTemplates($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the region or location, as described
     *                             in https://cloud.google.com/apis/design/resource_names.
     *
     *                             * For `projects.regions.workflowTemplates,list`, the resource
     *                             name of the region has the following format:
     *                             `projects/{project_id}/regions/{region}`
     *
     *                             * For `projects.locations.workflowTemplates.list`, the
     *                             resource name of the location has the following format:
     *                             `projects/{project_id}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listWorkflowTemplates($parent, array $optionalArgs = [])
    {
        $request = new ListWorkflowTemplatesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListWorkflowTemplates', $optionalArgs, ListWorkflowTemplatesResponse::class, $request);
    }

    /**
     * Updates (replaces) workflow template. The updated template
     * must contain version that matches the current server version.
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $template = new WorkflowTemplate();
     *     $response = $workflowTemplateServiceClient->updateWorkflowTemplate($template);
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param WorkflowTemplate $template     Required. The updated workflow template.
     *
     *                                       The `template.version` field must match the current version.
     * @param array            $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataproc\V1\WorkflowTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function updateWorkflowTemplate($template, array $optionalArgs = [])
    {
        $request = new UpdateWorkflowTemplateRequest();
        $requestParamHeaders = [];
        $request->setTemplate($template);
        $requestParamHeaders['template.name'] = $template->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateWorkflowTemplate', WorkflowTemplate::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $workflowTemplateServiceClient->getIamPolicy($resource);
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetIamPolicy', Policy::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.iam.v1.IAMPolicy')->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $workflowTemplateServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SetIamPolicy', Policy::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.iam.v1.IAMPolicy')->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $workflowTemplateServiceClient = new WorkflowTemplateServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $workflowTemplateServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $workflowTemplateServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions($resource, $permissions, array $optionalArgs = [])
    {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('TestIamPermissions', TestIamPermissionsResponse::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.iam.v1.IAMPolicy')->wait();
    }
}
