<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/endpoint_service.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel].
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.DeployModelRequest</code>
 */
class DeployModelRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the Endpoint resource into which to deploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *
     * Generated from protobuf field <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $endpoint = '';
    /**
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split]
     * must be updated for the DeployedModel to start receiving traffic, either as
     * part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $deployed_model = null;
    /**
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. To refer to the ID of the just being deployed Model, a
     * "0" should be used, and the actual ID of the new DeployedModel will be
     * filled in its place by this method. The traffic percentage values must add
     * up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not
     * updated.
     *
     * Generated from protobuf field <code>map<string, int32> traffic_split = 3;</code>
     */
    private $traffic_split;

    /**
     * @param string                                    $endpoint      Required. The name of the Endpoint resource into which to deploy a Model.
     *                                                                 Format:
     *                                                                 `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *                                                                 Please see {@see EndpointServiceClient::endpointName()} for help formatting this field.
     * @param \Google\Cloud\AIPlatform\V1\DeployedModel $deployedModel Required. The DeployedModel to be created within the Endpoint. Note that
     *                                                                 [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split]
     *                                                                 must be updated for the DeployedModel to start receiving traffic, either as
     *                                                                 part of this call, or via
     *                                                                 [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * @param array                                     $trafficSplit  A map from a DeployedModel's ID to the percentage of this Endpoint's
     *                                                                 traffic that should be forwarded to that DeployedModel.
     *
     *                                                                 If this field is non-empty, then the Endpoint's
     *                                                                 [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     *                                                                 overwritten with it. To refer to the ID of the just being deployed Model, a
     *                                                                 "0" should be used, and the actual ID of the new DeployedModel will be
     *                                                                 filled in its place by this method. The traffic percentage values must add
     *                                                                 up to 100.
     *
     *                                                                 If this field is empty, then the Endpoint's
     *                                                                 [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not
     *                                                                 updated.
     *
     * @return \Google\Cloud\AIPlatform\V1\DeployModelRequest
     *
     * @experimental
     */
    public static function build(string $endpoint, \Google\Cloud\AIPlatform\V1\DeployedModel $deployedModel, array $trafficSplit): self
    {
        return (new self())
            ->setEndpoint($endpoint)
            ->setDeployedModel($deployedModel)
            ->setTrafficSplit($trafficSplit);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $endpoint
     *           Required. The name of the Endpoint resource into which to deploy a Model.
     *           Format:
     *           `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *     @type \Google\Cloud\AIPlatform\V1\DeployedModel $deployed_model
     *           Required. The DeployedModel to be created within the Endpoint. Note that
     *           [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split]
     *           must be updated for the DeployedModel to start receiving traffic, either as
     *           part of this call, or via
     *           [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     *     @type array|\Google\Protobuf\Internal\MapField $traffic_split
     *           A map from a DeployedModel's ID to the percentage of this Endpoint's
     *           traffic that should be forwarded to that DeployedModel.
     *           If this field is non-empty, then the Endpoint's
     *           [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     *           overwritten with it. To refer to the ID of the just being deployed Model, a
     *           "0" should be used, and the actual ID of the new DeployedModel will be
     *           filled in its place by this method. The traffic percentage values must add
     *           up to 100.
     *           If this field is empty, then the Endpoint's
     *           [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not
     *           updated.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\EndpointService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the Endpoint resource into which to deploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *
     * Generated from protobuf field <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * Required. The name of the Endpoint resource into which to deploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *
     * Generated from protobuf field <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint = $var;

        return $this;
    }

    /**
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split]
     * must be updated for the DeployedModel to start receiving traffic, either as
     * part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\AIPlatform\V1\DeployedModel|null
     */
    public function getDeployedModel()
    {
        return $this->deployed_model;
    }

    public function hasDeployedModel()
    {
        return isset($this->deployed_model);
    }

    public function clearDeployedModel()
    {
        unset($this->deployed_model);
    }

    /**
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split]
     * must be updated for the DeployedModel to start receiving traffic, either as
     * part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\AIPlatform\V1\DeployedModel $var
     * @return $this
     */
    public function setDeployedModel($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\DeployedModel::class);
        $this->deployed_model = $var;

        return $this;
    }

    /**
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. To refer to the ID of the just being deployed Model, a
     * "0" should be used, and the actual ID of the new DeployedModel will be
     * filled in its place by this method. The traffic percentage values must add
     * up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not
     * updated.
     *
     * Generated from protobuf field <code>map<string, int32> traffic_split = 3;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getTrafficSplit()
    {
        return $this->traffic_split;
    }

    /**
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. To refer to the ID of the just being deployed Model, a
     * "0" should be used, and the actual ID of the new DeployedModel will be
     * filled in its place by this method. The traffic percentage values must add
     * up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not
     * updated.
     *
     * Generated from protobuf field <code>map<string, int32> traffic_split = 3;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setTrafficSplit($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::INT32);
        $this->traffic_split = $arr;

        return $this;
    }

}

