<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vmwareengine/v1/vmwareengine_resources.proto

namespace Google\Cloud\VmwareEngine\V1\AutoscalingSettings;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Autoscaling policy describes the behavior of the autoscaling
 * with respect to the resource utilization.
 * The scale-out operation is initiated if the utilization
 * exceeds ANY of the respective thresholds.
 * The scale-in operation is initiated if the utilization
 * is below ALL of the respective thresholds.
 *
 * Generated from protobuf message <code>google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy</code>
 */
class AutoscalingPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The canonical identifier of the node type to add or remove.
     * Corresponds to the `NodeType`.
     *
     * Generated from protobuf field <code>string node_type_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $node_type_id = '';
    /**
     * Required. Number of nodes to add to a cluster during a scale-out
     * operation. Must be divisible by 2 for stretched clusters. During a
     * scale-in operation only one node (or 2 for stretched clusters) are
     * removed in a single iteration.
     *
     * Generated from protobuf field <code>int32 scale_out_size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $scale_out_size = 0;
    /**
     * Optional. Utilization thresholds pertaining to CPU utilization.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds cpu_thresholds = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cpu_thresholds = null;
    /**
     * Optional. Utilization thresholds pertaining to amount of granted memory.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds granted_memory_thresholds = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $granted_memory_thresholds = null;
    /**
     * Optional. Utilization thresholds pertaining to amount of consumed memory.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds consumed_memory_thresholds = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $consumed_memory_thresholds = null;
    /**
     * Optional. Utilization thresholds pertaining to amount of consumed
     * storage.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds storage_thresholds = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $storage_thresholds = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $node_type_id
     *           Required. The canonical identifier of the node type to add or remove.
     *           Corresponds to the `NodeType`.
     *     @type int $scale_out_size
     *           Required. Number of nodes to add to a cluster during a scale-out
     *           operation. Must be divisible by 2 for stretched clusters. During a
     *           scale-in operation only one node (or 2 for stretched clusters) are
     *           removed in a single iteration.
     *     @type \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds $cpu_thresholds
     *           Optional. Utilization thresholds pertaining to CPU utilization.
     *     @type \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds $granted_memory_thresholds
     *           Optional. Utilization thresholds pertaining to amount of granted memory.
     *     @type \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds $consumed_memory_thresholds
     *           Optional. Utilization thresholds pertaining to amount of consumed memory.
     *     @type \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds $storage_thresholds
     *           Optional. Utilization thresholds pertaining to amount of consumed
     *           storage.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vmwareengine\V1\VmwareengineResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The canonical identifier of the node type to add or remove.
     * Corresponds to the `NodeType`.
     *
     * Generated from protobuf field <code>string node_type_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getNodeTypeId()
    {
        return $this->node_type_id;
    }

    /**
     * Required. The canonical identifier of the node type to add or remove.
     * Corresponds to the `NodeType`.
     *
     * Generated from protobuf field <code>string node_type_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setNodeTypeId($var)
    {
        GPBUtil::checkString($var, True);
        $this->node_type_id = $var;

        return $this;
    }

    /**
     * Required. Number of nodes to add to a cluster during a scale-out
     * operation. Must be divisible by 2 for stretched clusters. During a
     * scale-in operation only one node (or 2 for stretched clusters) are
     * removed in a single iteration.
     *
     * Generated from protobuf field <code>int32 scale_out_size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getScaleOutSize()
    {
        return $this->scale_out_size;
    }

    /**
     * Required. Number of nodes to add to a cluster during a scale-out
     * operation. Must be divisible by 2 for stretched clusters. During a
     * scale-in operation only one node (or 2 for stretched clusters) are
     * removed in a single iteration.
     *
     * Generated from protobuf field <code>int32 scale_out_size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setScaleOutSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->scale_out_size = $var;

        return $this;
    }

    /**
     * Optional. Utilization thresholds pertaining to CPU utilization.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds cpu_thresholds = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds|null
     */
    public function getCpuThresholds()
    {
        return $this->cpu_thresholds;
    }

    public function hasCpuThresholds()
    {
        return isset($this->cpu_thresholds);
    }

    public function clearCpuThresholds()
    {
        unset($this->cpu_thresholds);
    }

    /**
     * Optional. Utilization thresholds pertaining to CPU utilization.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds cpu_thresholds = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds $var
     * @return $this
     */
    public function setCpuThresholds($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds::class);
        $this->cpu_thresholds = $var;

        return $this;
    }

    /**
     * Optional. Utilization thresholds pertaining to amount of granted memory.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds granted_memory_thresholds = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds|null
     */
    public function getGrantedMemoryThresholds()
    {
        return $this->granted_memory_thresholds;
    }

    public function hasGrantedMemoryThresholds()
    {
        return isset($this->granted_memory_thresholds);
    }

    public function clearGrantedMemoryThresholds()
    {
        unset($this->granted_memory_thresholds);
    }

    /**
     * Optional. Utilization thresholds pertaining to amount of granted memory.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds granted_memory_thresholds = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds $var
     * @return $this
     */
    public function setGrantedMemoryThresholds($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds::class);
        $this->granted_memory_thresholds = $var;

        return $this;
    }

    /**
     * Optional. Utilization thresholds pertaining to amount of consumed memory.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds consumed_memory_thresholds = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds|null
     */
    public function getConsumedMemoryThresholds()
    {
        return $this->consumed_memory_thresholds;
    }

    public function hasConsumedMemoryThresholds()
    {
        return isset($this->consumed_memory_thresholds);
    }

    public function clearConsumedMemoryThresholds()
    {
        unset($this->consumed_memory_thresholds);
    }

    /**
     * Optional. Utilization thresholds pertaining to amount of consumed memory.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds consumed_memory_thresholds = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds $var
     * @return $this
     */
    public function setConsumedMemoryThresholds($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds::class);
        $this->consumed_memory_thresholds = $var;

        return $this;
    }

    /**
     * Optional. Utilization thresholds pertaining to amount of consumed
     * storage.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds storage_thresholds = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds|null
     */
    public function getStorageThresholds()
    {
        return $this->storage_thresholds;
    }

    public function hasStorageThresholds()
    {
        return isset($this->storage_thresholds);
    }

    public function clearStorageThresholds()
    {
        unset($this->storage_thresholds);
    }

    /**
     * Optional. Utilization thresholds pertaining to amount of consumed
     * storage.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds storage_thresholds = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds $var
     * @return $this
     */
    public function setStorageThresholds($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\Thresholds::class);
        $this->storage_thresholds = $var;

        return $this;
    }

}


